<?php
// Session güvenlik ayarları (session başlamadan önce)
if (session_status() === PHP_SESSION_NONE) {
    ini_set('session.gc_maxlifetime', 86400); // 24 saat
    ini_set('session.cookie_lifetime', 86400); // 24 saat
    ini_set('session.cookie_httponly', 1);
    ini_set('session.use_strict_mode', 1);
    ini_set('session.cookie_samesite', 'Lax');
    session_set_cookie_params([
        'lifetime' => 86400, // 24 saat
        'path' => '/',
        'domain' => '',
        'secure' => false, // HTTPS için true yapın
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
    session_start();
}

// Güvenlik helper'larını yükle
require_once 'csrf_helper.php';
require_once 'secure_db_helper.php';

// Admin girişi kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// Session timeout kontrolü (24 saat)
if (isset($_SESSION['admin_last_activity'])) {
    $timeout = 24 * 60 * 60; // 24 saat
    if (time() - $_SESSION['admin_last_activity'] > $timeout) {
        // Session süresi doldu
        session_unset();
        session_destroy();
        header('Location: login.php?timeout=1');
        exit;
    }
}

// Session IP kontrolü (güvenlik için) - Daha esnek hale getirildi
if (isset($_SESSION['admin_ip'])) {
    $current_ip = $_SERVER['REMOTE_ADDR'] ?? '';
    $session_ip = $_SESSION['admin_ip'];
    
    // IP değişikliği kontrolü (sadece tamamen farklı IP'ler için)
    if ($session_ip !== $current_ip && !empty($current_ip)) {
        // Aynı ağ içindeki IP değişikliklerini tolere et
        $session_ip_parts = explode('.', $session_ip);
        $current_ip_parts = explode('.', $current_ip);
        
        // İlk 3 okteti aynıysa (aynı ağ) izin ver
        if (count($session_ip_parts) >= 3 && count($current_ip_parts) >= 3) {
            if ($session_ip_parts[0] !== $current_ip_parts[0] || 
                $session_ip_parts[1] !== $current_ip_parts[1] || 
                $session_ip_parts[2] !== $current_ip_parts[2]) {
                // Tamamen farklı ağ, güvenlik riski
                session_unset();
                session_destroy();
                header('Location: login.php?security=1');
                exit;
            }
        }
    }
}

// User-Agent kontrolü (ek güvenlik)
if (isset($_SESSION['admin_user_agent'])) {
    $current_user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '';
    if ($_SESSION['admin_user_agent'] !== $current_user_agent) {
        // User-Agent değişti, güvenlik riski
        session_unset();
        session_destroy();
        header('Location: login.php?security=1');
        exit;
    }
}

// Last activity güncellemesi
$_SESSION['admin_last_activity'] = time();

// Güvenli veritabanı bağlantısı
require_once '../includes/config.php';
$secureDB = new SecureDBHelper($pdo);

// Rate limiting (basit)
if (!isset($_SESSION['admin_request_count'])) {
    $_SESSION['admin_request_count'] = 0;
    $_SESSION['admin_request_time'] = time();
}

$current_time = time();
if ($current_time - $_SESSION['admin_request_time'] > 60) {
    // 1 dakika geçti, sayacı sıfırla
    $_SESSION['admin_request_count'] = 0;
    $_SESSION['admin_request_time'] = $current_time;
}

$_SESSION['admin_request_count']++;

// Dakikada 100'den fazla istek engelle
if ($_SESSION['admin_request_count'] > 100) {
    header('HTTP/1.1 429 Too Many Requests');
    die('Too many requests. Please slow down.');
}
?>


