<?php
/**
 * Admin Favicon Helper
 * Admin sayfaları için favicon include
 */

if (!function_exists('renderAdminFavicon')) {
    function renderAdminFavicon() {
        // Config'i dahil et
        if (file_exists(__DIR__ . '/../includes/config.php')) {
            require_once __DIR__ . '/../includes/config.php';
        }
        
        global $pdo;
        
        try {
            $stmt = $pdo->prepare('SELECT setting_value FROM settings WHERE setting_key = ?');
            $stmt->execute(['favicon_url']);
            $favicon_url = $stmt->fetchColumn();
            
            if (!empty($favicon_url)) {
                // Relative path'i absolute yap
                if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
                    $favicon_url = '/' . ltrim($favicon_url, '/');
                }
                
                echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
                echo '<link rel="shortcut icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
                echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
                echo '<!-- Admin Favicon: ' . htmlspecialchars($favicon_url) . ' -->' . "\n";
            } else {
                echo '<!-- No favicon configured for admin -->' . "\n";
            }
        } catch (Exception $e) {
            echo '<!-- Favicon error: ' . htmlspecialchars($e->getMessage()) . ' -->' . "\n";
        }
    }
}

// Backward compatibility - direct render
if (!headers_sent()) {
    renderAdminFavicon();
}
?>

