<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once 'admin_auth.php';
require_once __DIR__ . '/../includes/config.php';

$page_title = 'Blog Yönetimi';
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$perPage = 10;
$offset = ($page - 1) * $perPage;

// Arama ve filtreleme
$search = $_GET['search'] ?? '';
$status = $_GET['status'] ?? '';
$category = $_GET['category'] ?? '';

// Blog yazılarını çek
$whereConditions = [];
$params = [];

if (!empty($search)) {
    $whereConditions[] = "(bp.title LIKE ? OR bp.excerpt LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if (!empty($status)) {
    $whereConditions[] = "bp.status = ?";
    $params[] = $status;
}

if (!empty($category)) {
    $whereConditions[] = "bc.slug = ?";
    $params[] = $category;
}

$whereClause = !empty($whereConditions) ? 'WHERE ' . implode(' AND ', $whereConditions) : '';

// Toplam kayıt sayısı
$countSql = "SELECT COUNT(DISTINCT bp.id) as total 
             FROM blog_posts bp 
             LEFT JOIN blog_post_categories bpc ON bp.id = bpc.post_id 
             LEFT JOIN blog_categories bc ON bpc.category_id = bc.id 
             $whereClause";

$countStmt = $pdo->prepare($countSql);
$countStmt->execute($params);
$totalRows = $countStmt->fetch(PDO::FETCH_ASSOC)['total'];
$totalPages = ceil($totalRows / $perPage);

// Blog yazılarını çek
$sql = "SELECT bp.*, u.username as author_name,
               GROUP_CONCAT(DISTINCT bc.name) as categories,
               GROUP_CONCAT(DISTINCT bt.name) as tags
        FROM blog_posts bp 
        LEFT JOIN user u ON bp.author_id = u.id
        LEFT JOIN blog_post_categories bpc ON bp.id = bpc.post_id 
        LEFT JOIN blog_categories bc ON bpc.category_id = bc.id
        LEFT JOIN blog_post_tags bpt ON bp.id = bpt.post_id
        LEFT JOIN blog_tags bt ON bpt.tag_id = bt.id
        $whereClause
        GROUP BY bp.id
        ORDER BY bp.created_at DESC 
        LIMIT $perPage OFFSET $offset";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$posts = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Kategorileri çek (filtreleme için)
$categoriesStmt = $pdo->query("SELECT * FROM blog_categories ORDER BY name");
$categories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);

// Include meta head function
include '../includes/meta_head.php';
?>
<!DOCTYPE html>
<html lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>Blog Management</title>
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet"/>
<script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#1877f2", // A modern, friendly blue
                        "primary-light": "#e7f3ff",
                        background: "#f0f2f5",
                        surface: "#ffffff",
                        "text-primary": "#1c1e21",
                        "text-secondary": "#606770",
                        "line-light": "#e0e0e0",
                    },
                    fontFamily: {
                        display: ["Manrope", "sans-serif"],
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        'soft': '0 4px 12px 0 rgb(0 0 0 / 0.07)',
                        'subtle': '0 1px 2px 0 rgb(0 0 0 / 0.05)',
                    }
                },
            },
        };
    </script>
<style>
        .material-symbols-outlined {
            font-variation-settings: "FILL" 0, "wght" 400, "GRAD" 0, "opsz" 24;
        }
        .active .material-symbols-outlined {
            font-variation-settings: 'FILL' 1;
        }
    </style>
</head>
<body class="bg-background font-display text-text-primary">
<div class="flex min-h-screen">
<?php include 'menu.php'; ?>
<main class="flex-1 p-10 min-w-0">
<?php
$page_title = "Blog Yönetimi";
$page_subtitle = "Blog yazılarınızı ve içeriklerinizi yönetin.";
include 'includes/admin_header.php';
?>

<!-- Add New Blog Post Button -->
<div class="flex justify-end mb-6">
    <a href="blog_add.php" class="inline-flex items-center px-6 py-3 bg-primary text-white rounded-xl hover:bg-primary-dark transition-colors font-semibold shadow-soft">
        <span class="material-symbols-outlined mr-2">add</span>
        Yeni Blog Yazısı Ekle
    </a>
</div>
<!-- Search and Filter Form -->
<form method="GET" class="flex items-center gap-4 bg-surface rounded-xl shadow-soft p-6 mb-6 border border-line-light">
    <div class="flex items-center gap-2 flex-1 min-w-[220px] max-w-md">
        <div class="relative w-full">
            <span class="material-symbols-outlined absolute left-4 top-1/2 -translate-y-1/2 text-text-secondary">search</span>
            <input class="w-full pl-12 pr-4 py-3 bg-background border-none rounded-lg focus:ring-2 focus:ring-primary" name="search" value="<?php echo htmlspecialchars($search); ?>" placeholder="Başlık veya içerik ile ara..." type="text"/>
        </div>
        <button type="submit" class="px-4 py-2 rounded-lg bg-primary text-white font-bold">Ara</button>
    </div>
    <select name="status" class="px-4 py-2 bg-background rounded-lg text-text-secondary font-medium hover:bg-line-light w-44" onchange="this.form.submit()">
        <option value="" <?php echo $status === '' ? 'selected' : ''; ?>>Durum: Tümü</option>
        <option value="draft" <?php echo $status === 'draft' ? 'selected' : ''; ?>>Taslak</option>
        <option value="published" <?php echo $status === 'published' ? 'selected' : ''; ?>>Yayınlandı</option>
        <option value="archived" <?php echo $status === 'archived' ? 'selected' : ''; ?>>Arşivlendi</option>
    </select>
    <select name="category" class="px-4 py-2 bg-background rounded-lg text-text-secondary font-medium hover:bg-line-light w-52" onchange="this.form.submit()">
        <option value="">Kategori: Tümü</option>
        <?php foreach ($categories as $cat): ?>
            <option value="<?php echo $cat['slug']; ?>" <?php echo $category === $cat['slug'] ? 'selected' : ''; ?>>
                <?php echo htmlspecialchars($cat['name']); ?>
            </option>
        <?php endforeach; ?>
    </select>
    <a href="blog.php" class="px-4 py-2 bg-gray-100 hover:bg-gray-200 text-gray-700 rounded-lg font-medium">
        <span class="material-symbols-outlined mr-1">clear</span>
        Clear
    </a>
</form>

<div class="overflow-x-auto bg-white rounded-xl shadow-soft border border-line-light">
<table class="w-full text-left table-fixed min-w-[1200px]">
<thead class="border-b border-line-light">
<tr class="bg-gradient-to-r from-primary/5 to-primary/10 border-b-2 border-primary/20">
    <th class="px-6 py-4 text-sm font-semibold text-text-primary">Yazı</th>
    <th class="px-6 py-4 text-sm font-semibold text-text-primary">Yazar</th>
    <th class="px-6 py-4 text-sm font-semibold text-text-primary">Durum</th>
    <th class="px-6 py-4 text-sm font-semibold text-text-primary">Kategoriler</th>
    <th class="px-6 py-4 text-sm font-semibold text-text-primary">Görüntülenme</th>
    <th class="px-6 py-4 text-sm font-semibold text-text-primary">Oluşturulma</th>
    <th class="px-6 py-4 text-sm font-semibold text-text-primary">İşlemler</th>
</tr>
</thead>
<tbody class="divide-y divide-line-light">
    <?php if (empty($posts)): ?>
        <tr>
            <td colspan="7" class="px-6 py-12 text-center text-text-secondary">
                <span class="material-symbols-outlined text-4xl mb-2 block">article</span>
                Blog yazısı bulunamadı
            </td>
        </tr>
    <?php else: ?>
        <?php foreach ($posts as $post): ?>
            <tr class="hover:bg-primary/5 transition-colors">
                <td class="px-6 py-4">
                    <div class="flex items-center">
                        <?php if ($post['featured_image']): ?>
                            <img src="<?php echo htmlspecialchars($post['featured_image']); ?>" 
                                 alt="<?php echo htmlspecialchars($post['title']); ?>" 
                                 class="w-12 h-12 rounded-lg object-cover mr-3">
                        <?php else: ?>
                            <div class="w-12 h-12 bg-gray-200 rounded-lg flex items-center justify-center mr-3">
                                <span class="material-symbols-outlined text-gray-400">image</span>
                            </div>
                        <?php endif; ?>
                        <div>
                            <div class="text-sm font-medium text-text-primary">
                                <?php echo htmlspecialchars($post['title']); ?>
                            </div>
                            <div class="text-sm text-text-secondary">
                                <?php echo htmlspecialchars(substr(strip_tags($post['excerpt']), 0, 100)); ?>...
                            </div>
                        </div>
                    </div>
                </td>
                <td class="px-6 py-4 text-sm text-text-primary">
                    <?php echo htmlspecialchars($post['author_name']); ?>
                </td>
                <td class="px-6 py-4">
                    <?php
                    $statusColors = [
                        'draft' => 'bg-yellow-100 text-yellow-800',
                        'published' => 'bg-green-100 text-green-800',
                        'archived' => 'bg-gray-100 text-gray-800'
                    ];
                    $statusColor = $statusColors[$post['status']] ?? 'bg-gray-100 text-gray-800';
                    ?>
                    <span class="px-2 py-1 text-xs font-semibold rounded-full <?php echo $statusColor; ?>">
                        <?php 
                        $statusTexts = [
                            'draft' => 'Taslak',
                            'published' => 'Yayınlandı',
                            'archived' => 'Arşivlendi'
                        ];
                        echo $statusTexts[$post['status']] ?? ucfirst($post['status']);
                        ?>
                    </span>
                </td>
                <td class="px-6 py-4 text-sm text-text-primary">
                    <?php echo $post['categories'] ? htmlspecialchars($post['categories']) : 'Kategori yok'; ?>
                </td>
                <td class="px-6 py-4 text-sm text-text-primary">
                    <?php echo number_format($post['views']); ?>
                </td>
                <td class="px-6 py-4 text-sm text-text-primary">
                    <?php echo date('M j, Y', strtotime($post['created_at'])); ?>
                </td>
                <td class="px-6 py-4 text-sm font-medium">
                    <div class="flex items-center space-x-2">
                        <a href="blog_view.php?id=<?php echo $post['id']; ?>" 
                           class="text-blue-600 hover:text-blue-900" title="View">
                            <span class="material-symbols-outlined">visibility</span>
                        </a>
                        <a href="blog_edit.php?id=<?php echo $post['id']; ?>" 
                           class="text-indigo-600 hover:text-indigo-900" title="Edit">
                            <span class="material-symbols-outlined">edit</span>
                        </a>
                        <a href="blog_delete.php?id=<?php echo $post['id']; ?>" 
                           class="text-red-600 hover:text-red-900" title="Delete"
                           onclick="return confirm('Are you sure you want to delete this blog post?')">
                            <span class="material-symbols-outlined">delete</span>
                        </a>
                    </div>
                </td>
            </tr>
        <?php endforeach; ?>
    <?php endif; ?>
</tbody>
</table>
</div>

<!-- Pagination -->
<?php if ($totalPages > 1): ?>
<div class="flex items-center justify-between mt-6">
    <div class="text-sm text-text-secondary">
        Showing <?php echo $offset + 1; ?> to <?php echo min($offset + $perPage, $totalRows); ?> of <?php echo $totalRows; ?> results
    </div>
    <div class="flex items-center space-x-2">
        <?php if ($page > 1): ?>
            <a href="?page=<?php echo ($page - 1); ?>&<?php echo http_build_query(array_filter(['search' => $search, 'status' => $status, 'category' => $category])); ?>" 
               class="px-3 py-2 border border-line-light rounded-lg hover:bg-line-light text-text-secondary">
                Previous
            </a>
        <?php endif; ?>
        
        <?php for ($i = max(1, $page - 2); $i <= min($totalPages, $page + 2); $i++): ?>
            <a href="?page=<?php echo $i; ?>&<?php echo http_build_query(array_filter(['search' => $search, 'status' => $status, 'category' => $category])); ?>" 
               class="px-3 py-2 border border-line-light rounded-lg <?php echo $i == $page ? 'bg-primary text-white border-primary' : 'hover:bg-line-light text-text-secondary'; ?>">
                <?php echo $i; ?>
            </a>
        <?php endfor; ?>
        
        <?php if ($page < $totalPages): ?>
            <a href="?page=<?php echo ($page + 1); ?>&<?php echo http_build_query(array_filter(['search' => $search, 'status' => $status, 'category' => $category])); ?>" 
               class="px-3 py-2 border border-line-light rounded-lg hover:bg-line-light text-text-secondary">
                Next
            </a>
        <?php endif; ?>
    </div>
</div>
<?php endif; ?>
</main>
</div>
</body>
</html>
