<?php
require_once 'admin_auth.php';
require_once '../includes/config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $name = trim($_POST['name']);
    $slug = trim($_POST['slug']);
    $description = trim($_POST['description']);
    $color = trim($_POST['color']);
    
    // Auto-generate slug if empty
    if (empty($slug)) {
        $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $name)));
    }
    
    // Validate required fields
    if (empty($name)) {
        $error_message = "Kategori adı gerekli.";
    } else {
        // Check if slug already exists
        $stmt = $pdo->prepare("SELECT id FROM blog_categories WHERE slug = ?");
        $stmt->execute([$slug]);
        
        if ($stmt->rowCount() > 0) {
            $error_message = "Bu slug ile bir kategori zaten mevcut. Lütfen farklı bir slug seçin.";
        } else {
            // Insert new category
            $stmt = $pdo->prepare("INSERT INTO blog_categories (name, slug, description, color) VALUES (?, ?, ?, ?)");
            
            if ($stmt->execute([$name, $slug, $description, $color])) {
                header("Location: blog_categories.php?success=Kategori başarıyla oluşturuldu");
                exit();
            } else {
                $error_message = "Kategori oluşturulurken hata oluştu. Lütfen tekrar deneyin.";
            }
        }
    }
}
?>

<?php include 'menu.php'; ?>

<style>
    .color-picker {
        width: 50px;
        height: 50px;
        border: none;
        border-radius: 8px;
        cursor: pointer;
        border: 2px solid #e5e7eb;
    }
    .color-picker:hover {
        border-color: #6366f1;
    }
</style>

<div class="flex-1 bg-background min-h-screen">
    <div class="p-8">
        <!-- Header -->
        <div class="flex items-center gap-4 mb-8">
            <a href="blog_categories.php" class="inline-flex items-center justify-center w-10 h-10 bg-surface hover:bg-surface-hover rounded-xl border border-border-light transition-colors">
                <span class="material-symbols-outlined text-text-secondary">arrow_back</span>
            </a>
            <div>
                <h1 class="text-3xl font-bold text-text-primary mb-2">Create New Category</h1>
                <p class="text-text-secondary">Add a new blog category</p>
            </div>
        </div>

        <?php if (isset($error_message)): ?>
            <div class="bg-red-50 border border-red-200 text-red-700 px-6 py-4 rounded-xl mb-6">
                <div class="flex items-center gap-2">
                    <span class="material-symbols-outlined">error</span>
                    <?php echo $error_message; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Form -->
        <form method="POST" class="space-y-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Content -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Category Details -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h2 class="text-xl font-semibold text-text-primary mb-4">Category Details</h2>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="name" class="block text-sm font-medium text-text-primary mb-2">Category Name *</label>
                                <input type="text" id="name" name="name" required 
                                       value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                       placeholder="Enter category name">
                            </div>
                            
                            <div>
                                <label for="slug" class="block text-sm font-medium text-text-primary mb-2">URL Slug</label>
                                <div class="relative">
                                    <span class="absolute left-4 top-1/2 transform -translate-y-1/2 text-text-muted text-sm">/</span>
                                    <input type="text" id="slug" name="slug" 
                                           value="<?php echo isset($_POST['slug']) ? htmlspecialchars($_POST['slug']) : ''; ?>"
                                           class="w-full pl-8 pr-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                           placeholder="auto-generated-from-name">
                                </div>
                                <p class="text-xs text-text-muted mt-1">Leave empty to auto-generate from name</p>
                            </div>
                            
                            <div>
                                <label for="description" class="block text-sm font-medium text-text-primary mb-2">Description</label>
                                <textarea id="description" name="description" rows="4"
                                          class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                          placeholder="Brief description of this category"><?php echo isset($_POST['description']) ? htmlspecialchars($_POST['description']) : ''; ?></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Appearance -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h2 class="text-xl font-semibold text-text-primary mb-4">Appearance</h2>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="color" class="block text-sm font-medium text-text-primary mb-2">Color</label>
                                <div class="flex items-center gap-3">
                                    <input type="color" id="color" name="color" 
                                           value="<?php echo isset($_POST['color']) ? htmlspecialchars($_POST['color']) : '#6366f1'; ?>"
                                           class="color-picker">
                                    <input type="text" id="colorText" 
                                           value="<?php echo isset($_POST['color']) ? htmlspecialchars($_POST['color']) : '#6366f1'; ?>"
                                           class="flex-1 px-3 py-2 border border-border-light rounded-lg focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                           placeholder="#6366f1">
                                </div>
                            </div>
                            
                        </div>
                    </div>

                </div>
            </div>

            <!-- Form Actions -->
            <div class="flex justify-end gap-4 pt-6 border-t border-border-light">
                <a href="blog_categories.php" class="px-6 py-3 text-text-secondary border border-border-light rounded-xl hover:bg-surface transition-colors">
                    Cancel
                </a>
                <button type="submit" class="px-6 py-3 bg-primary text-white rounded-xl hover:bg-primary-dark transition-colors font-semibold">
                    Create Category
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// Color picker synchronization
document.getElementById('color').addEventListener('input', function() {
    document.getElementById('colorText').value = this.value;
});

document.getElementById('colorText').addEventListener('input', function() {
    if (this.value.match(/^#[0-9A-F]{6}$/i)) {
        document.getElementById('color').value = this.value;
    }
});

// Auto-generate slug from name
document.getElementById('name').addEventListener('input', function() {
    const slug = this.value.toLowerCase()
        .replace(/[^a-z0-9\s-]/g, '')
        .replace(/\s+/g, '-')
        .replace(/-+/g, '-')
        .trim('-');
    
    if (document.getElementById('slug').value === '') {
        document.getElementById('slug').value = slug;
    }
});
</script>

</body>
</html>
