<?php
require_once 'admin_auth.php';
require_once '../includes/config.php';

$response = [
    'success' => false,
    'message' => '',
    'redirect' => 'category.php'
];

$category_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($category_id <= 0) {
    $response['message'] = 'Geçersiz kategori ID sağlandı.';
} else {
    try {
        // Check if category exists
        $stmt = $pdo->prepare('SELECT name FROM categories WHERE id = ?');
        $stmt->execute([$category_id]);
        $category = $stmt->fetch();
        
        if (!$category) {
            $response['message'] = 'Kategori bulunamadı.';
        } else {
            // Check if category has associated sites
            $stmt = $pdo->prepare('SELECT COUNT(*) FROM site_submissions WHERE category_id = ?');
            $stmt->execute([$category_id]);
            $site_count = $stmt->fetchColumn();
            
            if ($site_count > 0) {
                $response['message'] = "Kategori '{$category['name']}' silinemez. $site_count site içeriyor. Lütfen önce siteleri taşıyın veya silin.";
                $response['category_name'] = $category['name'];
                $response['site_count'] = $site_count;
            } else {
                // Delete the category
                $stmt = $pdo->prepare('DELETE FROM categories WHERE id = ?');
                if ($stmt->execute([$category_id])) {
                    $response['success'] = true;
                    $response['message'] = "Kategori '{$category['name']}' başarıyla silindi.";
                    $response['category_name'] = $category['name'];
                } else {
                    $response['message'] = 'Kategori silinemedi.';
                }
            }
        }
    } catch (PDOException $e) {
        $response['message'] = 'Veritabanı hatası: ' . $e->getMessage();
    }
}

// AJAX request ise JSON döndür
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// Normal request ise HTML sayfası göster
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Category Deletion - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'display': ['Plus Jakarta Sans', 'sans-serif']
                    },
                    colors: {
                        primary: '#13a4ec',
                        'background-light': '#f6f7f8',
                        'background-dark': '#101c22',
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-background-light font-display min-h-screen flex items-center justify-center">
    <div class="bg-white rounded-lg shadow-lg p-8 max-w-md w-full mx-4">
        <?php if ($response['success']): ?>
            <!-- Success State -->
            <div class="text-center">
                <div class="mb-4">
                    <span class="material-symbols-outlined text-green-500 text-6xl">check_circle</span>
                </div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Category Deleted Successfully</h1>
                <p class="text-gray-600 mb-6"><?php echo htmlspecialchars($response['message']); ?></p>
                
                <div class="bg-gray-50 rounded-lg p-4 mb-6 text-left">
                    <h3 class="font-semibold text-gray-800 mb-2">Deleted Category:</h3>
                    <p class="text-sm text-gray-600">
                        <strong>Name:</strong> <?php echo htmlspecialchars($response['category_name']); ?>
                    </p>
                </div>
                
                <div class="flex gap-3">
                    <a href="category.php" class="flex-1 bg-primary text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition-colors text-center">
                        <span class="material-symbols-outlined text-sm mr-1">arrow_back</span>
                        Back to Categories
                    </a>
                    <a href="dashboard.php" class="flex-1 bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition-colors text-center">
                        <span class="material-symbols-outlined text-sm mr-1">dashboard</span>
                        Dashboard
                    </a>
                </div>
            </div>
        <?php else: ?>
            <!-- Error State -->
            <div class="text-center">
                <div class="mb-4">
                    <span class="material-symbols-outlined text-red-500 text-6xl">error</span>
                </div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Deletion Failed</h1>
                <p class="text-red-600 mb-6"><?php echo htmlspecialchars($response['message']); ?></p>
                
                <?php if (isset($response['site_count']) && $response['site_count'] > 0): ?>
                <div class="bg-yellow-50 rounded-lg p-4 mb-6 text-left">
                    <h3 class="font-semibold text-yellow-800 mb-2">Category contains sites:</h3>
                    <p class="text-sm text-yellow-700">
                        <strong>Category:</strong> <?php echo htmlspecialchars($response['category_name']); ?><br>
                        <strong>Sites:</strong> <?php echo $response['site_count']; ?> site(s)
                    </p>
                    <p class="text-xs text-yellow-600 mt-2">
                        Please move or delete the sites before deleting this category.
                    </p>
                </div>
                <?php endif; ?>
                
                <div class="flex gap-3">
                    <a href="category.php" class="flex-1 bg-primary text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition-colors text-center">
                        <span class="material-symbols-outlined text-sm mr-1">arrow_back</span>
                        Back to Categories
                    </a>
                    <a href="javascript:history.back()" class="flex-1 bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition-colors text-center">
                        <span class="material-symbols-outlined text-sm mr-1">refresh</span>
                        Try Again
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Auto redirect after success -->
    <?php if ($response['success']): ?>
    <script>
        // 3 saniye sonra otomatik olarak category.php'ye yönlendir
        setTimeout(function() {
            window.location.href = 'category.php';
        }, 3000);
        
        // Countdown göster
        let countdown = 3;
        const countdownElement = document.createElement('div');
        countdownElement.className = 'text-center mt-4 text-sm text-gray-500';
        countdownElement.innerHTML = `Redirecting in <span id="countdown">${countdown}</span> seconds...`;
        document.querySelector('.bg-white').appendChild(countdownElement);
        
        const timer = setInterval(function() {
            countdown--;
            document.getElementById('countdown').textContent = countdown;
            if (countdown <= 0) {
                clearInterval(timer);
            }
        }, 1000);
    </script>
    <?php endif; ?>
</body>
</html>

