<?php
include 'admin_auth.php';
include '../includes/config.php';

$success = $error = '';

// Form işleme
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $description = trim($_POST['description'] ?? '');
    $color = trim($_POST['color'] ?? '#38BDF8');
    $icon = trim($_POST['icon'] ?? '');
    
    if (empty($name)) {
        $error = 'Kategori adı gerekli.';
    } else {
        try {
            // Check if name already exists
            $stmt = $pdo->prepare('SELECT id FROM categories WHERE name = ?');
            $stmt->execute([$name]);
            if ($stmt->rowCount() > 0) {
                $error = 'Bu isimde bir kategori zaten mevcut.';
            } else {
                // Generate slug
                $slug = strtolower(preg_replace('/[^a-zA-Z0-9]+/', '-', trim($name)));
                $slug = trim($slug, '-');
                
                // Insert new category
                $stmt = $pdo->prepare('INSERT INTO categories (name, description, color, icon, slug) VALUES (?, ?, ?, ?, ?)');
                if ($stmt->execute([$name, $description, $color, $icon, $slug])) {
                    $category_id = $pdo->lastInsertId();
                    header('Location: category_view.php?id=' . $category_id . '&success=category_created');
                    exit;
                } else {
                    $error = 'Kategori oluşturulamadı.';
                }
            }
        } catch (PDOException $e) {
            $error = 'Veritabanı hatası: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title>Yeni Kategori - Kategori Ekle</title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700;800&display=swap" rel="stylesheet"/>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#1877f2",
                        "primary-light": "#e7f3ff",
                        background: "#f0f2f5",
                        surface: "#ffffff",
                        "text-primary": "#1c1e21",
                        "text-secondary": "#606770",
                        "line-light": "#e0e0e0",
                    },
                    fontFamily: {
                        display: ["Manrope", "sans-serif"],
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        'soft': '0 4px 12px 0 rgb(0 0 0 / 0.07)',
                        'subtle': '0 1px 2px 0 rgb(0 0 0 / 0.05)',
                    }
                },
            },
        };
    </script>
</head>
<body class="bg-background font-display text-text-primary">
    <div class="flex h-screen bg-background">
        <?php include 'menu.php'; ?>
        
        <main class="flex-1 overflow-auto">
            <div class="p-8">
                <!-- Header -->
                <div class="flex items-center justify-between mb-8">
                    <div>
                        <h1 class="text-3xl font-bold text-text-primary">Yeni Kategori</h1>
                        <p class="text-text-secondary mt-1">Siteleri organize etmek için yeni bir kategori oluşturun</p>
                    </div>
                    <div class="flex items-center gap-4">
                        <a href="category.php" class="flex items-center gap-2 bg-gray-600 text-white font-bold py-3 px-5 rounded-lg hover:bg-gray-700 transition-colors">
                            <span class="material-symbols-outlined">arrow_back</span>
                            <span>Kategorilere Dön</span>
                        </a>
                    </div>
                </div>

                <!-- Messages -->
                <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-6">
                    <?php echo htmlspecialchars($success); ?>
                </div>
                <?php endif; ?>
                
                <?php if ($error): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg mb-6">
                    <?php echo htmlspecialchars($error); ?>
                </div>
                <?php endif; ?>

                <!-- Create Form -->
                <div class="bg-surface rounded-xl shadow-soft p-6">
                    <form method="POST" class="space-y-6">
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <!-- Category Name -->
                            <div>
                                <label for="name" class="block text-sm font-medium text-text-secondary mb-2">Kategori Adı *</label>
                                <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($_POST['name'] ?? ''); ?>" required 
                                       class="w-full px-4 py-3 border border-line-light rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                       placeholder="örn., Teknoloji, İş, Sağlık">
                            </div>

                            <!-- Color -->
                            <div>
                                <label for="color" class="block text-sm font-medium text-text-secondary mb-2">Renk</label>
                                <div class="flex items-center gap-3">
                                    <input type="color" id="color" name="color" value="<?php echo htmlspecialchars($_POST['color'] ?? '#38BDF8'); ?>" 
                                           class="w-16 h-12 border border-line-light rounded-lg cursor-pointer">
                                    <input type="text" id="colorText" value="<?php echo htmlspecialchars($_POST['color'] ?? '#38BDF8'); ?>" 
                                           class="flex-1 px-4 py-3 border border-line-light rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                           placeholder="#38BDF8">
                                </div>
                            </div>
                        </div>

                        <!-- Description -->
                        <div>
                            <label for="description" class="block text-sm font-medium text-text-secondary mb-2">Açıklama</label>
                            <textarea id="description" name="description" rows="4" 
                                      class="w-full px-4 py-3 border border-line-light rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                      placeholder="Bu kategoride hangi tür web sitelerinin yer alacağını açıklayın..."><?php echo htmlspecialchars($_POST['description'] ?? ''); ?></textarea>
                        </div>

                        <!-- Icon -->
                        <div>
                            <label for="icon" class="block text-sm font-medium text-text-secondary mb-2">İkon Sınıfı</label>
                            <div class="flex items-center gap-3">
                                <div id="iconPreview" class="w-12 h-12 bg-gray-100 rounded-lg flex items-center justify-center">
                                    <i class="fa-solid fa-folder text-xl" style="color: #38BDF8"></i>
                                </div>
                                <input type="text" id="icon" name="icon" value="<?php echo htmlspecialchars($_POST['icon'] ?? ''); ?>" 
                                       class="flex-1 px-4 py-3 border border-line-light rounded-lg focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent"
                                       placeholder="örn., fa-solid fa-folder">
                            </div>
                            <p class="text-xs text-text-secondary mt-1">Font Awesome ikon sınıflarını kullanın. İkonları <a href="https://fontawesome.com/icons" target="_blank" class="text-primary hover:underline">fontawesome.com</a> adresinde inceleyin</p>
                        </div>

                        <!-- Popular Icon Examples -->
                        <div>
                            <label class="block text-sm font-medium text-text-secondary mb-2">Popüler İkonlar</label>
                            <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-3">
                                <?php
                                $popularIcons = [
                                    'fa-solid fa-briefcase' => 'İş',
                                    'fa-solid fa-graduation-cap' => 'Eğitim',
                                    'fa-solid fa-heart-pulse' => 'Sağlık',
                                    'fa-solid fa-network-wired' => 'Teknoloji',
                                    'fa-solid fa-utensils' => 'Yemek',
                                    'fa-solid fa-building' => 'Emlak',
                                    'fa-solid fa-palette' => 'Sanat',
                                    'fa-solid fa-futbol' => 'Spor',
                                    'fa-solid fa-plane' => 'Seyahat',
                                    'fa-solid fa-shopping-cart' => 'Alışveriş',
                                    'fa-solid fa-newspaper' => 'Haber',
                                    'fa-solid fa-music' => 'Müzik'
                                ];
                                
                                foreach ($popularIcons as $iconClass => $iconName):
                                ?>
                                <button type="button" onclick="selectIcon('<?php echo $iconClass; ?>')" 
                                        class="flex flex-col items-center gap-1 p-3 bg-gray-50 hover:bg-blue-50 rounded-lg transition-colors cursor-pointer border border-transparent hover:border-primary">
                                    <i class="<?php echo $iconClass; ?> text-xl text-gray-600" id="icon-<?php echo str_replace(['fa-solid', 'fa-'], '', $iconClass); ?>"></i>
                                    <span class="text-xs text-gray-600"><?php echo $iconName; ?></span>
                                </button>
                                <?php endforeach; ?>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="flex items-center gap-4 pt-4">
                            <button type="submit" class="bg-primary text-white font-bold py-3 px-6 rounded-lg hover:bg-primary/90 transition-colors">
                                Kategori Oluştur
                            </button>
                            <a href="category.php" class="bg-gray-500 text-white font-bold py-3 px-6 rounded-lg hover:bg-gray-600 transition-colors">
                                İptal
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </main>
    </div>

    <script>
        // Color picker sync
        const colorPicker = document.getElementById('color');
        const colorText = document.getElementById('colorText');
        const iconPreview = document.getElementById('iconPreview');
        const iconInput = document.getElementById('icon');

        // Initialize color text input with color picker value
        if (colorPicker && colorText) {
            colorText.value = colorPicker.value;
        }

        colorPicker.addEventListener('change', function() {
            colorText.value = this.value;
            updateIconPreview();
        });

        colorText.addEventListener('input', function() {
            // Validate hex color format
            if (/^#[0-9A-F]{6}$/i.test(this.value)) {
                colorPicker.value = this.value;
                updateIconPreview();
            } else if (/^[0-9A-F]{6}$/i.test(this.value)) {
                // Add # if missing
                this.value = '#' + this.value;
                colorPicker.value = this.value;
                updateIconPreview();
            }
        });

        // Icon preview update
        if (iconInput) {
            iconInput.addEventListener('input', updateIconPreview);
        }

        function updateIconPreview() {
            if (!iconPreview) return;
            
            const iconClass = iconInput ? (iconInput.value || 'fa-solid fa-folder') : 'fa-solid fa-folder';
            const color = colorText ? (colorText.value || '#38BDF8') : '#38BDF8';
            
            // Update icon preview with current color
            iconPreview.innerHTML = `<i class="${iconClass} text-xl" style="color: ${color}"></i>`;
            
            // Also update the background color of the preview container
            iconPreview.style.backgroundColor = color + '20'; // Add transparency
            
            // Update all popular icon colors
            const popularIcons = document.querySelectorAll('[id^="icon-"]');
            popularIcons.forEach(icon => {
                icon.style.color = color;
            });
        }

        // Icon selection function
        function selectIcon(iconClass) {
            if (iconInput) {
                iconInput.value = iconClass;
                updateIconPreview();
            }
        }

        // Initial preview update
        updateIconPreview();

        // Auto-generate slug preview
        const nameInput = document.getElementById('name');
        if (nameInput) {
            nameInput.addEventListener('input', function() {
                const slug = this.value.toLowerCase()
                    .replace(/[^a-zA-Z0-9\s]/g, '')
                    .replace(/\s+/g, '-')
                    .replace(/^-+|-+$/g, '');
                
                // You could show slug preview here if needed
            });
        }
    </script>
</body>
</html>

