<?php
include 'admin_auth.php';
include '../includes/config.php';

// GET parametresinden category ID'sini al
$category_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($category_id <= 0) {
    header('Location: category.php');
    exit;
}

// Kategori bilgilerini çek
$stmt = $pdo->prepare('SELECT * FROM categories WHERE id = ?');
$stmt->execute([$category_id]);
$category = $stmt->fetch();

if (!$category) {
    header('Location: category.php?error=category_not_found');
    exit;
}

// Success message handling
$success = '';
if (isset($_GET['success'])) {
    switch ($_GET['success']) {
        case 'category_created':
            $success = 'Kategori "' . htmlspecialchars($category['name']) . '" başarıyla oluşturuldu!';
            break;
    }
}

// Bu kategorideki siteleri çek
$stmt = $pdo->prepare('
    SELECT s.*, u.username 
    FROM site_submissions s 
    LEFT JOIN user u ON s.username = u.username 
    WHERE s.category_id = ? 
    ORDER BY s.olusturulma_tarihi DESC
');
$stmt->execute([$category_id]);
$sites = $stmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title>Kategori Detayları - <?php echo htmlspecialchars($category['name']); ?></title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700;800&display=swap" rel="stylesheet"/>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet"/>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#1877f2",
                        "primary-light": "#e7f3ff",
                        background: "#f0f2f5",
                        surface: "#ffffff",
                        "text-primary": "#1c1e21",
                        "text-secondary": "#606770",
                        "line-light": "#e0e0e0",
                    },
                    fontFamily: {
                        display: ["Manrope", "sans-serif"],
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        'soft': '0 4px 12px 0 rgb(0 0 0 / 0.07)',
                        'subtle': '0 1px 2px 0 rgb(0 0 0 / 0.05)',
                    }
                },
            },
        };
    </script>
</head>
<body class="bg-background font-display text-text-primary">
    <div class="flex h-screen bg-background">
        <?php include 'menu.php'; ?>
        
        <main class="flex-1 overflow-auto">
            <div class="p-8">
                <!-- Header -->
                <div class="flex items-center justify-between mb-8">
                    <div>
                        <h1 class="text-3xl font-bold text-text-primary">Kategori Detayları</h1>
                        <p class="text-text-secondary mt-1">Kategori bilgilerini ve bağlı siteleri görüntüleyin</p>
                    </div>
                    <div class="flex items-center gap-4">
                        <a href="category_edit.php?id=<?php echo $category['id']; ?>" class="flex items-center gap-2 bg-blue-600 text-white font-bold py-3 px-5 rounded-lg hover:bg-blue-700 transition-colors">
                            <span class="material-symbols-outlined">edit</span>
                            <span>Kategoriyi Düzenle</span>
                        </a>
                        <a href="category.php" class="flex items-center gap-2 bg-gray-600 text-white font-bold py-3 px-5 rounded-lg hover:bg-gray-700 transition-colors">
                            <span class="material-symbols-outlined">arrow_back</span>
                            <span>Kategorilere Dön</span>
                        </a>
                    </div>
                </div>

                <!-- Success Message -->
                <?php if ($success): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg mb-6 flex items-center gap-3">
                    <span class="material-symbols-outlined">check_circle</span>
                    <span><?php echo $success; ?></span>
                </div>
                <?php endif; ?>

                <!-- Category Info Card -->
                <div class="bg-surface rounded-xl shadow-soft p-6 mb-8">
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
                        <div>
                            <label class="block text-sm font-medium text-text-secondary mb-2">Kategori Adı</label>
                            <p class="text-lg font-semibold text-text-primary"><?php echo htmlspecialchars($category['name']); ?></p>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-text-secondary mb-2">Renk</label>
                            <div class="flex items-center gap-2">
                                <div class="w-6 h-6 rounded-full border border-line-light" style="background-color: <?php echo htmlspecialchars($category['color'] ?? '#38BDF8'); ?>"></div>
                                <span class="text-text-primary"><?php echo htmlspecialchars($category['color'] ?? '#38BDF8'); ?></span>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-text-secondary mb-2">İkon</label>
                            <div class="flex items-center gap-2">
                                <i class="<?php echo htmlspecialchars($category['icon'] ?? 'fa-solid fa-folder'); ?> text-xl" style="color: <?php echo htmlspecialchars($category['color'] ?? '#38BDF8'); ?>"></i>
                                <span class="text-text-primary"><?php echo htmlspecialchars($category['icon'] ?? 'fa-solid fa-folder'); ?></span>
                            </div>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-text-secondary mb-2">Toplam Site</label>
                            <p class="text-lg font-semibold text-text-primary"><?php echo count($sites); ?></p>
                        </div>
                    </div>
                    
                    <?php if (!empty($category['description'])): ?>
                    <div class="mt-6">
                        <label class="block text-sm font-medium text-text-secondary mb-2">Açıklama</label>
                        <p class="text-text-primary"><?php echo htmlspecialchars($category['description']); ?></p>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Sites in this Category -->
                <div class="bg-surface rounded-xl shadow-soft">
                    <div class="p-6 border-b border-line-light">
                        <h2 class="text-xl font-bold text-text-primary">Bu Kategorideki Siteler</h2>
                    </div>
                    
                    <?php if (empty($sites)): ?>
                    <div class="p-12 text-center">
                        <span class="material-symbols-outlined text-6xl text-text-secondary mb-4">web</span>
                        <p class="text-text-secondary text-lg">Bu kategoride site bulunamadı</p>
                    </div>
                    <?php else: ?>
                    <div class="overflow-x-auto">
                        <table class="w-full">
                            <thead class="bg-background">
                                <tr>
                                    <th class="text-left p-4 font-medium text-text-secondary">Site Adı</th>
                                    <th class="text-left p-4 font-medium text-text-secondary">URL</th>
                                    <th class="text-left p-4 font-medium text-text-secondary">Sahip</th>
                                    <th class="text-left p-4 font-medium text-text-secondary">Durum</th>
                                    <th class="text-left p-4 font-medium text-text-secondary">Oluşturulma</th>
                                    <th class="text-center p-4 font-medium text-text-secondary">İşlemler</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($sites as $site): ?>
                                <tr class="border-b border-line-light hover:bg-background/50">
                                    <td class="p-4">
                                        <div class="font-medium text-text-primary"><?php echo htmlspecialchars($site['site_name']); ?></div>
                                        <?php if (!empty($site['short_description'])): ?>
                                        <div class="text-sm text-text-secondary mt-1"><?php echo htmlspecialchars(substr($site['short_description'], 0, 60)) . (strlen($site['short_description']) > 60 ? '...' : ''); ?></div>
                                        <?php endif; ?>
                                    </td>
                                    <td class="p-4">
                                        <a href="<?php echo htmlspecialchars($site['site_url']); ?>" target="_blank" class="text-primary hover:underline">
                                            <?php echo htmlspecialchars(parse_url($site['site_url'], PHP_URL_HOST)); ?>
                                        </a>
                                    </td>
                                    <td class="p-4">
                                        <span class="text-text-primary"><?php echo htmlspecialchars($site['username'] ?? 'Unknown'); ?></span>
                                    </td>
                                    <td class="p-4">
                                        <?php
                                        $statusColors = [
                                            'pending' => 'bg-yellow-100 text-yellow-800',
                                            'approved' => 'bg-green-100 text-green-800',
                                            'rejected' => 'bg-red-100 text-red-800'
                                        ];
                                        $statusColor = $statusColors[$site['status']] ?? 'bg-gray-100 text-gray-800';
                                        ?>
                                        <span class="px-3 py-1 rounded-full text-xs font-medium <?php echo $statusColor; ?>">
                                            <?php echo ucfirst($site['status']); ?>
                                        </span>
                                    </td>
                                    <td class="p-4">
                                        <span class="text-text-secondary"><?php echo date('M j, Y', strtotime($site['olusturulma_tarihi'])); ?></span>
                                    </td>
                                    <td class="p-4">
                                        <div class="flex items-center justify-center gap-2">
                                            <a href="site_view.php?id=<?php echo $site['id']; ?>" class="w-9 h-9 rounded-full bg-green-100 text-green-600 flex items-center justify-center hover:bg-green-200" title="Siteyi Görüntüle">
                                                <span class="material-symbols-outlined text-xl">visibility</span>
                                            </a>
                                            <a href="site_edit_form.php?id=<?php echo $site['id']; ?>" class="w-9 h-9 rounded-full bg-blue-100 text-blue-600 flex items-center justify-center hover:bg-blue-200" title="Siteyi Düzenle">
                                                <span class="material-symbols-outlined text-xl">edit</span>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </main>
    </div>
</body>
</html>

