<?php
/**
 * CSRF Token Helper
 * Admin paneli için CSRF koruması
 */

class CSRFHelper {
    
    /**
     * CSRF token oluştur
     */
    public static function generateToken() {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        
        $token = bin2hex(random_bytes(32));
        $_SESSION['admin_csrf_token'] = $token;
        return $token;
    }
    
    /**
     * CSRF token doğrula
     */
    public static function validateToken($token) {
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        
        if (!isset($_SESSION['admin_csrf_token'])) {
            return false;
        }
        
        return hash_equals($_SESSION['admin_csrf_token'], $token);
    }
    
    /**
     * CSRF token input field oluştur
     */
    public static function getTokenField() {
        $token = self::generateToken();
        return '<input type="hidden" name="csrf_token" value="' . htmlspecialchars($token) . '">';
    }
    
    /**
     * CSRF token kontrolü yap
     */
    public static function checkToken() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $token = $_POST['csrf_token'] ?? '';
            if (!self::validateToken($token)) {
                die('CSRF token validation failed. Security violation detected.');
            }
        }
    }
}
?>




