<?php
// Admin kimlik doğrulama
require_once 'admin_auth.php';
require_once '../includes/config.php';

// Dashboard istatistiklerini al
try {
    // Toplam sayıları al
    $stmt = $pdo->query("SELECT COUNT(*) as total_sites FROM site_submissions WHERE status = 'approved'");
    $total_sites = $stmt->fetchColumn();
    
    $stmt = $pdo->query("SELECT COUNT(*) as pending_sites FROM site_submissions WHERE status = 'pending'");
    $pending_sites = $stmt->fetchColumn();
    
    $stmt = $pdo->query("SELECT COUNT(*) as total_users FROM user WHERE role = 'kullanici'");
    $total_users = $stmt->fetchColumn();
    
    $stmt = $pdo->query("SELECT COUNT(*) as total_categories FROM categories");
    $total_categories = $stmt->fetchColumn();
    
    $stmt = $pdo->query("SELECT COUNT(*) as total_blog_posts FROM blog_posts WHERE status = 'published'");
    $total_blog_posts = $stmt->fetchColumn();
    
    $stmt = $pdo->query("SELECT COUNT(*) as total_pages FROM pages WHERE status = 'published'");
    $total_pages = $stmt->fetchColumn();
    
    // Bugünkü istatistikleri al
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM site_submissions WHERE DATE(olusturulma_tarihi) = CURDATE()");
    $stmt->execute();
    $today_submissions = $stmt->fetchColumn();
    
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM user WHERE DATE(kayit_tarihi) = CURDATE()");
    $stmt->execute();
    $today_users = $stmt->fetchColumn();
    
    // Onay bekleyen gönderimleri al
    $stmt = $pdo->prepare("
        SELECT s.id, s.site_name, s.site_url, s.olusturulma_tarihi, c.name as category_name 
        FROM site_submissions s 
        LEFT JOIN categories c ON s.category_id = c.id 
        WHERE s.status = 'pending' 
        ORDER BY s.olusturulma_tarihi DESC 
        LIMIT 3
    ");
    $stmt->execute();
    $pending_submissions = $stmt->fetchAll();
    
    // Debug: Toplam bekleyen sayısını al
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM site_submissions WHERE status = 'pending'");
    $stmt->execute();
    $total_pending = $stmt->fetchColumn();
    
    // Grafik için aylık istatistikleri al (dinamik dönem)
    $period = $_GET['period'] ?? '6_months';
    $period_days = 0;
    $period_label = 'Son 6 Ay';
    $date_format = '%Y-%m';
    $chart_labels_count = 6;
    
    switch($period) {
        case '1_day':
            $period_days = 1;
            $period_label = 'Son 24 Saat';
            $date_format = '%H:00';
            $chart_labels_count = 24;
            break;
        case '1_week':
            $period_days = 7;
            $period_label = 'Son Hafta';
            $date_format = '%Y-%m-%d';
            $chart_labels_count = 7;
            break;
        case '2_weeks':
            $period_days = 14;
            $period_label = 'Son 2 Hafta';
            $date_format = '%Y-%m-%d';
            $chart_labels_count = 14;
            break;
        case '1_month':
            $period_days = 30;
            $period_label = 'Son Ay';
            $date_format = '%Y-%m-%d';
            $chart_labels_count = 30;
            break;
        case '3_months':
            $period_days = 90;
            $period_label = 'Son 3 Ay';
            $date_format = '%Y-%m';
            $chart_labels_count = 3;
            break;
        case '6_months':
        default:
            $period_days = 180;
            $period_label = 'Son 6 Ay';
            $date_format = '%Y-%m';
            $chart_labels_count = 6;
            break;
        case '1_year':
            $period_days = 365;
            $period_label = 'Son Yıl';
            $date_format = '%Y-%m';
            $chart_labels_count = 12;
            break;
    }
    
    if ($period == '1_day') {
        // Son 24 saat için saatlik veri
        $stmt = $pdo->prepare("
            SELECT 
                DATE_FORMAT(olusturulma_tarihi, '%H') as period_key,
                COUNT(*) as count
            FROM site_submissions 
            WHERE olusturulma_tarihi >= DATE_SUB(NOW(), INTERVAL 1 DAY)
            GROUP BY DATE_FORMAT(olusturulma_tarihi, '%H')
            ORDER BY period_key ASC
        ");
    } else if (in_array($period, ['1_week', '2_weeks', '1_month'])) {
        // Günlük veri
        $stmt = $pdo->prepare("
            SELECT 
                DATE_FORMAT(olusturulma_tarihi, '%Y-%m-%d') as period_key,
                COUNT(*) as count
            FROM site_submissions 
            WHERE olusturulma_tarihi >= DATE_SUB(CURDATE(), INTERVAL $period_days DAY)
            GROUP BY DATE_FORMAT(olusturulma_tarihi, '%Y-%m-%d')
            ORDER BY period_key ASC
        ");
    } else {
        // Aylık veri
        $months_back = $chart_labels_count;
        $stmt = $pdo->prepare("
            SELECT 
                DATE_FORMAT(olusturulma_tarihi, '%Y-%m') as period_key,
                COUNT(*) as count
            FROM site_submissions 
            WHERE olusturulma_tarihi >= DATE_SUB(CURDATE(), INTERVAL $months_back MONTH)
            GROUP BY DATE_FORMAT(olusturulma_tarihi, '%Y-%m')
            ORDER BY period_key ASC
        ");
    }
    
    $stmt->execute();
    $period_sites = $stmt->fetchAll();
    
    // Kullanıcı verileri aynı mantıkla
    if ($period == '1_day') {
        $stmt = $pdo->prepare("
            SELECT 
                DATE_FORMAT(kayit_tarihi, '%H') as period_key,
                COUNT(*) as count
            FROM user 
            WHERE kayit_tarihi >= DATE_SUB(NOW(), INTERVAL 1 DAY)
            AND role = 'kullanici'
            GROUP BY DATE_FORMAT(kayit_tarihi, '%H')
            ORDER BY period_key ASC
        ");
    } else if (in_array($period, ['1_week', '2_weeks', '1_month'])) {
        $stmt = $pdo->prepare("
            SELECT 
                DATE_FORMAT(kayit_tarihi, '%Y-%m-%d') as period_key,
                COUNT(*) as count
            FROM user 
            WHERE kayit_tarihi >= DATE_SUB(CURDATE(), INTERVAL $period_days DAY)
            AND role = 'kullanici'
            GROUP BY DATE_FORMAT(kayit_tarihi, '%Y-%m-%d')
            ORDER BY period_key ASC
        ");
    } else {
        $months_back = $chart_labels_count;
        $stmt = $pdo->prepare("
            SELECT 
                DATE_FORMAT(kayit_tarihi, '%Y-%m') as period_key,
                COUNT(*) as count
            FROM user 
            WHERE kayit_tarihi >= DATE_SUB(CURDATE(), INTERVAL $months_back MONTH)
            AND role = 'kullanici'
            GROUP BY DATE_FORMAT(kayit_tarihi, '%Y-%m')
            ORDER BY period_key ASC
        ");
    }
    
    $stmt->execute();
    $period_users = $stmt->fetchAll();
    
    // Admin bilgilerini al
    $admin_username = $_SESSION['admin_username'] ?? 'Admin';
    
} catch (Exception $e) {
    // Veritabanı hatası durumunda varsayılan değerler
    $total_sites = 0;
    $pending_sites = 0;
    $total_users = 0;
    $total_categories = 0;
    $today_submissions = 0;
    $today_users = 0;
    $pending_submissions = [];
    $monthly_sites = [];
    $monthly_users = [];
    $admin_username = 'Admin';
}

// Grafik verilerini hazırla
$chart_months = [];
$chart_sites = [];
$chart_users = [];

// Döneme göre etiketler oluştur
if ($period == '1_day') {
    // Son 24 saat - saatlik etiketler
    for ($i = 23; $i >= 0; $i--) {
        $hour = date('H', strtotime("-$i hours"));
        $hour_key = $hour;
        $chart_months[] = $hour . ':00';
        
        // Bu saat için veri bul
        $sites_count = 0;
        $users_count = 0;
        
        foreach ($period_sites as $data) {
            if ($data['period_key'] == $hour_key) {
                $sites_count = $data['count'];
                break;
            }
        }
        
        foreach ($period_users as $data) {
            if ($data['period_key'] == $hour_key) {
                $users_count = $data['count'];
                break;
            }
        }
        
        $chart_sites[] = $sites_count;
        $chart_users[] = $users_count;
    }
} else if (in_array($period, ['1_week', '2_weeks', '1_month'])) {
    // Günlük etiketler
    for ($i = $period_days - 1; $i >= 0; $i--) {
        $date = date('Y-m-d', strtotime("-$i days"));
        $date_label = date('M j', strtotime("-$i days"));
        $chart_months[] = $date_label;
        
        // Bu tarih için veri bul
        $sites_count = 0;
        $users_count = 0;
        
        foreach ($period_sites as $data) {
            if ($data['period_key'] == $date) {
                $sites_count = $data['count'];
                break;
            }
        }
        
        foreach ($period_users as $data) {
            if ($data['period_key'] == $date) {
                $users_count = $data['count'];
                break;
            }
        }
        
        $chart_sites[] = $sites_count;
        $chart_users[] = $users_count;
    }
} else {
    // Aylık etiketler
    for ($i = $chart_labels_count - 1; $i >= 0; $i--) {
        $month = date('Y-m', strtotime("-$i months"));
        $month_name = date('M Y', strtotime("-$i months"));
        $chart_months[] = $month_name;
        
        // Bu ay için veri bul
        $sites_count = 0;
        $users_count = 0;
        
        foreach ($period_sites as $data) {
            if ($data['period_key'] == $month) {
                $sites_count = $data['count'];
                break;
            }
        }
        
        foreach ($period_users as $data) {
            if ($data['period_key'] == $month) {
                $users_count = $data['count'];
                break;
            }
        }
        
        $chart_sites[] = $sites_count;
        $chart_users[] = $users_count;
    }
}
?>
<!DOCTYPE html>
<html lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>Admin Paneli</title>
<?php include 'admin_favicon.php'; ?>
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet"/>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#1877f2", // A modern, friendly blue
                        "primary-light": "#e7f3ff",
                        background: "#f0f2f5",
                        surface: "#ffffff",
                        "text-primary": "#1c1e21",
                        "text-secondary": "#606770",
                        "line-light": "#e0e0e0",
                    },
                    fontFamily: {
                        display: ["Manrope", "sans-serif"],
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        'soft': '0 4px 12px 0 rgb(0 0 0 / 0.07)',
                        'subtle': '0 1px 2px 0 rgb(0 0 0 / 0.05)',
                    }
                },
            },
        };
    </script>
<style>
        .material-symbols-outlined {
            font-variation-settings: "FILL" 0, "wght" 400, "GRAD" 0, "opsz" 24;
        }
        .active .material-symbols-outlined {
            font-variation-settings: 'FILL' 1;
        }
    </style>
</head>
<body class="bg-background font-display text-text-primary">
<div class="flex min-h-screen">
<?php include 'menu.php'; ?>
</aside>
<main class="flex-1 p-10">
<?php
$page_title = "Kontrol Paneli";
$page_subtitle = "Dizin sitenizde bugün neler oluyor.";
include 'includes/admin_header.php';
?>
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-6 gap-6 mb-8">
<div class="bg-surface p-6 rounded-xl border border-line-light shadow-soft flex items-center gap-5">
<div class="w-14 h-14 bg-primary-light rounded-full flex items-center justify-center">
<span class="material-symbols-outlined text-primary text-3xl">link</span>
</div>
<div>
<p class="text-base font-semibold text-text-secondary">Toplam Site</p>
<p class="text-3xl font-extrabold text-text-primary mt-1"><?php echo number_format($total_sites); ?></p>
</div>
</div>
<div class="bg-surface p-6 rounded-xl border border-line-light shadow-soft flex items-center gap-5">
<div class="w-14 h-14 bg-green-100 rounded-full flex items-center justify-center">
<span class="material-symbols-outlined text-green-600 text-3xl">add_circle</span>
</div>
<div>
<p class="text-base font-semibold text-text-secondary">Bekleyen Gönderimler</p>
<p class="text-3xl font-extrabold text-text-primary mt-1"><?php echo number_format($pending_sites); ?></p>
<?php if ($today_submissions > 0): ?>
<p class="text-sm text-green-600">+<?php echo $today_submissions; ?> bugün</p>
<?php endif; ?>
</div>
</div>
<div class="bg-surface p-6 rounded-xl border border-line-light shadow-soft flex items-center gap-5">
<div class="w-14 h-14 bg-yellow-100 rounded-full flex items-center justify-center">
<span class="material-symbols-outlined text-yellow-600 text-3xl">person</span>
</div>
<div>
<p class="text-base font-semibold text-text-secondary">Aktif Kullanıcılar</p>
<p class="text-3xl font-extrabold text-text-primary mt-1"><?php echo number_format($total_users); ?></p>
<?php if ($today_users > 0): ?>
<p class="text-sm text-yellow-600">+<?php echo $today_users; ?> bugün</p>
<?php endif; ?>
</div>
</div>
<div class="bg-surface p-6 rounded-xl border border-line-light shadow-soft flex items-center gap-5">
<div class="w-14 h-14 bg-indigo-100 rounded-full flex items-center justify-center">
<span class="material-symbols-outlined text-indigo-600 text-3xl">category</span>
</div>
<div>
<p class="text-base font-semibold text-text-secondary">Toplam Kategori</p>
<p class="text-3xl font-extrabold text-text-primary mt-1"><?php echo number_format($total_categories); ?></p>
</div>
</div>
<div class="bg-surface p-6 rounded-xl border border-line-light shadow-soft flex items-center gap-5">
<div class="w-14 h-14 bg-purple-100 rounded-full flex items-center justify-center">
<span class="material-symbols-outlined text-purple-600 text-3xl">article</span>
</div>
<div>
<p class="text-base font-semibold text-text-secondary">Toplam Blog Yazısı</p>
<p class="text-3xl font-extrabold text-text-primary mt-1"><?php echo number_format($total_blog_posts); ?></p>
</div>
</div>
<div class="bg-surface p-6 rounded-xl border border-line-light shadow-soft flex items-center gap-5">
<div class="w-14 h-14 bg-pink-100 rounded-full flex items-center justify-center">
<span class="material-symbols-outlined text-pink-600 text-3xl">description</span>
</div>
<div>
<p class="text-base font-semibold text-text-secondary">Toplam Sayfa</p>
<p class="text-3xl font-extrabold text-text-primary mt-1"><?php echo number_format($total_pages); ?></p>
</div>
</div>
</div>
<div class="grid grid-cols-5 gap-8">
<div class="col-span-5 lg:col-span-3 bg-surface p-6 rounded-xl border border-line-light shadow-soft">
<div class="flex justify-between items-center mb-4">
<h3 class="text-xl font-bold text-text-primary">Büyüme Genel Bakış</h3>
<div class="flex items-center gap-2">
<select id="periodSelect" onchange="changePeriod()" class="text-sm text-text-secondary bg-surface border border-line-light rounded-lg px-3 py-2 focus:outline-none focus:ring-2 focus:ring-primary">
    <option value="1_day" <?php echo $period == '1_day' ? 'selected' : ''; ?>>Son 24 Saat</option>
    <option value="1_week" <?php echo $period == '1_week' ? 'selected' : ''; ?>>Son Hafta</option>
    <option value="2_weeks" <?php echo $period == '2_weeks' ? 'selected' : ''; ?>>Son 2 Hafta</option>
    <option value="1_month" <?php echo $period == '1_month' ? 'selected' : ''; ?>>Son Ay</option>
    <option value="3_months" <?php echo $period == '3_months' ? 'selected' : ''; ?>>Son 3 Ay</option>
    <option value="6_months" <?php echo $period == '6_months' ? 'selected' : ''; ?>>Son 6 Ay</option>
    <option value="1_year" <?php echo $period == '1_year' ? 'selected' : ''; ?>>Son Yıl</option>
</select>
<span class="material-symbols-outlined text-text-secondary">expand_more</span>
</div>
</div>
<div class="h-80">
<canvas id="growthChart"></canvas>
</div>
</div>
<div class="col-span-5 lg:col-span-2 bg-surface p-6 rounded-xl border border-line-light shadow-soft flex flex-col">
<h3 class="text-xl font-bold text-text-primary mb-4">Bekleyen Onaylar (<?php echo $total_pending; ?>)</h3>
<div class="flex-grow space-y-4">
<?php if (!empty($pending_submissions)): ?>
    <?php foreach ($pending_submissions as $submission): ?>
    <div class="flex items-center justify-between p-3 rounded-lg hover:bg-background">
        <div>
            <p class="font-bold text-text-primary"><?php echo htmlspecialchars($submission['site_name']); ?></p>
            <p class="text-sm text-text-secondary"><?php echo htmlspecialchars($submission['site_url']); ?></p>
            <p class="text-xs text-text-secondary"><?php echo date('M j, Y', strtotime($submission['olusturulma_tarihi'])); ?></p>
        </div>
        <div class="flex items-center gap-2">
            <button onclick="updateSiteStatus(<?php echo $submission['id']; ?>, 'rejected')" class="w-9 h-9 rounded-full bg-red-100 text-red-600 flex items-center justify-center hover:bg-red-200">
                <span class="material-symbols-outlined text-xl">close</span>
            </button>
            <button onclick="updateSiteStatus(<?php echo $submission['id']; ?>, 'approved')" class="w-9 h-9 rounded-full bg-green-100 text-green-600 flex items-center justify-center hover:bg-green-200">
                <span class="material-symbols-outlined text-xl">check</span>
            </button>
        </div>
    </div>
    <?php endforeach; ?>
<?php else: ?>
    <div class="flex items-center justify-center py-8">
        <div class="text-center">
            <span class="material-symbols-outlined text-6xl text-text-secondary mb-4">check_circle</span>
            <p class="text-text-secondary">Bekleyen gönderim yok</p>
        </div>
    </div>
<?php endif; ?>
</div>
<a href="sites.php?status=pending" class="mt-4 w-full bg-primary text-white font-bold py-3 px-4 rounded-lg hover:bg-primary/90 transition-colors text-center block">
    Tüm Siteleri Görüntüle
</a>
</div>
</div>
</main>
</div>
<script>
        const ctx = document.getElementById('growthChart');
        new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($chart_months); ?>,
                datasets: [{
                    label: 'Yeni Siteler',
                    data: <?php echo json_encode($chart_sites); ?>,
                    fill: true,
                    backgroundColor: 'rgba(24, 119, 242, 0.1)',
                    borderColor: '#1877f2',
                    tension: 0.4,
                    pointBackgroundColor: '#ffffff',
                    pointBorderColor: '#1877f2',
                    pointHoverRadius: 7,
                    pointHoverBackgroundColor: '#1877f2',
                    pointHoverBorderColor: '#ffffff',
                    pointRadius: 5,
                    borderWidth: 2,
                }, {
                    label: 'Yeni Kullanıcılar',
                    data: <?php echo json_encode($chart_users); ?>,
                    fill: true,
                    backgroundColor: 'rgba(96, 103, 112, 0.1)',
                    borderColor: '#606770',
                    tension: 0.4,
                    pointBackgroundColor: '#ffffff',
                    pointBorderColor: '#606770',
                    pointHoverRadius: 7,
                    pointHoverBackgroundColor: '#606770',
                    pointHoverBorderColor: '#ffffff',
                    pointRadius: 5,
                    borderWidth: 2,
                    borderDash: [5, 5]
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'top',
                        align: 'end',
                        labels: {
                            usePointStyle: true,
                            boxWidth: 8,
                            font: {
                                family: 'Manrope'
                            }
                        }
                    }
                },
                scales: {
                    y: {
                        beginAtZero: true,
                        grid: {
                            drawBorder: false,
                        },
                        ticks: {
                           font: {
                                family: 'Manrope'
                            }
                        }
                    },
                    x: {
                       grid: {
                            display: false
                       },
                        ticks: {
                           font: {
                                family: 'Manrope'
                            }
                        }
                    }
                }
            }
        });
        
        // Dönem değiştirme fonksiyonu
        function changePeriod() {
            const select = document.getElementById('periodSelect');
            const period = select.value;
            const url = new URL(window.location);
            url.searchParams.set('period', period);
            window.location.href = url.toString();
        }
        
        // Site durumunu güncelleme fonksiyonu
        function updateSiteStatus(siteId, status) {
            console.log('Updating site ID:', siteId, 'to status:', status);
            
            if (confirm('Bu siteyi ' + (status === 'approved' ? 'onaylamak' : 'reddetmek') + ' istediğinizden emin misiniz?')) {
                const button = event.target.closest('button');
                const originalHTML = button.innerHTML;
                
                // Yükleme durumunu göster
                button.innerHTML = '<span class="material-symbols-outlined text-xl animate-spin">refresh</span>';
                button.disabled = true;
                
                fetch('update_site_status.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'site_id=' + siteId + '&status=' + status
                })
                .then(response => {
                    console.log('Response status:', response.status);
                    console.log('Response headers:', response.headers);
                    
                    if (!response.ok) {
                        throw new Error(`HTTP error! status: ${response.status}`);
                    }
                    
                    return response.text().then(text => {
                        console.log('Raw response:', text);
                        try {
                            return JSON.parse(text);
                        } catch (e) {
                            console.error('JSON parse error:', e);
                            throw new Error('Invalid JSON response: ' + text);
                        }
                    });
                })
                .then(data => {
                    console.log('Parsed data:', data);
                    
                    if (data.success) {
                        // Başarı mesajını göster
                        const statusText = status === 'approved' ? 'onaylandı' : 'reddedildi';
                        button.innerHTML = '<span class="material-symbols-outlined text-xl">check</span>';
                        button.classList.remove('bg-red-100', 'text-red-600', 'bg-green-100', 'text-green-600');
                        button.classList.add('bg-green-100', 'text-green-600');
                        
                        // Geçici başarı mesajını göster
                        const messageDiv = document.createElement('div');
                        messageDiv.className = 'fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50';
                        messageDiv.textContent = `Site başarıyla ${statusText}!`;
                        document.body.appendChild(messageDiv);
                        
                        // Kısa gecikme sonrası sayfayı yenile
                        setTimeout(() => {
                            location.reload();
                        }, 1500);
                    } else {
                        alert('Hata: ' + (data.message || 'Bilinmeyen hata oluştu'));
                        button.innerHTML = originalHTML;
                        button.disabled = false;
                    }
                })
                .catch(error => {
                    console.error('Full error details:', error);
                    alert('Site durumu güncellenirken bir hata oluştu:\n' + error.message);
                    button.innerHTML = originalHTML;
                    button.disabled = false;
                });
            }
        }
        
        // Dashboard'u her 5 dakikada bir otomatik yenile
        setTimeout(function() {
            location.reload();
        }, 300000);
        
        // Her 10 dakikada bir session keep-alive ping
        setInterval(function() {
            fetch('session_keepalive.php', {
                method: 'POST',
                credentials: 'same-origin'
            }).catch(error => {
                console.log('Session keepalive failed:', error);
            });
        }, 600000); // 10 dakika
        
        // Sayfa görünürlük API'si - sayfa geri geldiğinde session kontrol et
        document.addEventListener('visibilitychange', function() {
            if (!document.hidden) {
                // Sayfa aktif hale geldi, session kontrolü yap
                fetch('session_keepalive.php', {
                    method: 'POST',
                    credentials: 'same-origin'
                }).then(response => {
                    if (!response.ok) {
                        // Session geçersiz, giriş sayfasına yönlendir
                        window.location.href = 'login.php?timeout=1';
                    }
                }).catch(error => {
                    console.log('Session check failed:', error);
                });
            }
        });
    </script>

</body></html>

