
<?php
// Session güvenlik ayarları (session başlamadan önce)
ini_set('session.gc_maxlifetime', 86400); // 24 saat
ini_set('session.cookie_lifetime', 86400); // 24 saat
ini_set('session.cookie_httponly', 1);
ini_set('session.use_strict_mode', 1);
ini_set('session.cookie_samesite', 'Lax');
session_set_cookie_params([
    'lifetime' => 86400, // 24 saat
    'path' => '/admin/',
    'domain' => '',
    'secure' => false, // HTTPS için true yapın
    'httponly' => true,
    'samesite' => 'Lax'
]);

session_start();

// Eğer zaten admin girişi yapılmışsa dashboard'a yönlendir
if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
    header('Location: dashboard.php');
    exit;
}

require_once '../includes/config.php';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['email-username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    $stmt = $pdo->prepare('SELECT * FROM user WHERE username = ? OR email = ? LIMIT 1');
    $stmt->execute([$username, $username]);
    $user = $stmt->fetch();
    
    if ($user && password_verify($password, $user['password'])) {
        if ($user['role'] === 'admin') {
            // Güvenli session oluştur
            session_regenerate_id(true); // Session hijacking'i önlemek için
            
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['admin_user_id'] = $user['id'];
            $_SESSION['admin_username'] = $user['username'];
            $_SESSION['admin_email'] = $user['email'];
            $_SESSION['admin_login_time'] = time();
            $_SESSION['admin_last_activity'] = time();
            $_SESSION['admin_ip'] = $_SERVER['REMOTE_ADDR'] ?? '';
            $_SESSION['admin_user_agent'] = $_SERVER['HTTP_USER_AGENT'] ?? '';
            
            header('Location: dashboard.php');
            exit;
        } else {
            $error = 'Yetkiniz yok.';
        }
    } else {
        $error = 'Kullanıcı adı veya şifre yanlış.';
    }
}

// URL parametrelerinden gelen mesajlar
if (isset($_GET['timeout'])) {
    $error = 'Oturum süresi doldu. Lütfen tekrar giriş yapın.';
} elseif (isset($_GET['security'])) {
    $error = 'Güvenlik nedeniyle oturum sonlandırıldı. Lütfen tekrar giriş yapın.';
} elseif (isset($_GET['logout'])) {
    $error = 'Başarıyla çıkış yapıldı.';
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport"/>
    <title>Admin Login</title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;700;800&amp;display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet"/>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <script>
        tailwind.config = {
          darkMode: "class",
          theme: {
            extend: {
              colors: {
                primary: "#13a4ec",
                "background-light": "#f6f7f8",
                "background-dark": "#101c22",
              },
              fontFamily: {
                display: ["Plus Jakarta Sans"],
              },
              borderRadius: {
                DEFAULT: "0.5rem",
                lg: "1rem",
                xl: "1.5rem",
                full: "9999px"
              },
            },
          },
        };
      </script>
</head>
<body class="bg-background-light dark:bg-background-dark font-display text-gray-800 dark:text-gray-200">
<div class="relative flex h-auto min-h-screen w-full flex-col items-center justify-center p-4">
<div class="w-full max-w-md">
<div class="flex flex-col items-center mb-8">
<div class="text-primary mb-4">
<svg fill="currentColor" height="64" viewBox="0 0 48 48" width="64" xmlns="http://www.w3.org/2000/svg"><path d="M44 4H30.6666V17.3334H17.3334V30.6666H4V44H44V4Z"></path></svg>
</div>
<h1 class="text-3xl font-extrabold text-gray-900 dark:text-white">Admin Login</h1>
<p class="mt-2 text-center text-sm text-gray-600 dark:text-gray-400">Welcome, please enter your credentials.</p>
</div>
<form class="space-y-6" method="post">
<?php if ($error): ?>
    <div class="mb-4 text-red-600 text-center"><?php echo $error; ?></div>
<?php endif; ?>
<div>
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300 sr-only" for="email-username">Email or Username</label>
<div class="relative rounded-lg shadow-sm">
<div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-4">
<span class="material-symbols-outlined text-gray-400">person</span>
</div>
<input class="block w-full rounded-lg border-gray-300 dark:border-gray-700 bg-white dark:bg-gray-900/50 py-3 pl-12 pr-4 text-gray-900 dark:text-white placeholder-gray-500 dark:placeholder-gray-400 focus:border-primary focus:ring-primary" id="email-username" name="email-username" placeholder="Email or Username" type="text" required />
</div>
</div>
<div>
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300 sr-only" for="password">Password</label>
<div class="relative rounded-lg shadow-sm">
<div class="pointer-events-none absolute inset-y-0 left-0 flex items-center pl-4">
<span class="material-symbols-outlined text-gray-400">lock</span>
</div>
<input class="block w-full rounded-lg border-gray-300 dark:border-gray-700 bg-white dark:bg-gray-900/50 py-3 pl-12 pr-4 text-gray-900 dark:text-white placeholder-gray-500 dark:placeholder-gray-400 focus:border-primary focus:ring-primary" id="password" name="password" placeholder="Password" type="password" required />
</div>
</div>
<div>
<button class="group relative flex w-full justify-center rounded-lg border border-transparent bg-primary py-3 px-4 text-sm font-bold text-white shadow-lg shadow-primary/30 transition-all duration-300 ease-in-out hover:bg-primary/90 focus:outline-none focus:ring-2 focus:ring-primary focus:ring-offset-2 dark:focus:ring-offset-background-dark" type="submit">
<span class="absolute inset-y-0 left-0 flex items-center pl-3">
<span class="material-symbols-outlined h-5 w-5 text-white group-hover:text-white/80">login</span>
</span>
            Log In
          </button>
</div>
</form>
</div>
</div>

</body></html>

