<?php 
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
require_once 'admin_auth.php'; 
?>
<!DOCTYPE html>
<html lang="en"><head>
<meta charset="utf-8"/>
<meta content="width=device-width, initial-scale=1.0" name="viewport"/>
<title>Admin Paneli</title>
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" />
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#6366f1", // Modern indigo
                        "primary-light": "#eef2ff",
                        "primary-dark": "#4f46e5",
                        secondary: "#f97316", // Orange accent
                        background: "#f8fafc",
                        surface: "#ffffff",
                        "surface-hover": "#f1f5f9",
                        "text-primary": "#0f172a",
                        "text-secondary": "#64748b",
                        "text-muted": "#94a3b8",
                        "border-light": "#e2e8f0",
                        "border-medium": "#cbd5e1",
                        success: "#10b981",
                        warning: "#f59e0b",
                        danger: "#ef4444",
                    },
                    fontFamily: {
                        display: ["Inter", "sans-serif"],
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.25rem",
                        "2xl": "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        'soft': '0 4px 6px -1px rgb(0 0 0 / 0.08)',
                        'medium': '0 10px 15px -3px rgb(0 0 0 / 0.08)',
                        'subtle': '0 1px 2px 0 rgb(0 0 0 / 0.04)',
                        'glow': '0 0 0 1px rgb(99 102 241 / 0.3), 0 4px 6px -1px rgb(99 102 241 / 0.1)',
                    }
                },
            },
        };
    </script>
<style>
        .material-symbols-outlined {
            font-variation-settings: "FILL" 0, "wght" 500, "GRAD" 0, "opsz" 24;
        }
        .active .material-symbols-outlined {
            font-variation-settings: 'FILL' 1, "wght" 600;
        }
        .nav-item {
            transition: all 0.2s ease;
        }
        .nav-item:hover {
            transform: translateX(2px);
        }
        .sidebar-gradient {
            background: linear-gradient(135deg, #ffffff 0%, #f8fafc 100%);
            border-right: 1px solid #e2e8f0;
            box-shadow: 4px 0 24px -6px rgba(0, 0, 0, 0.04);
        }
    </style>
</head>
<body class="bg-background font-display flex">
<aside class="w-80 sidebar-gradient p-6 flex flex-col justify-between sticky top-0 h-screen">
<div>
<!-- Logo and Brand -->
<div class="flex items-center gap-4 mb-10 pb-6 border-b border-border-light">
<div class="w-14 h-14 bg-gradient-to-br from-primary to-primary-dark rounded-2xl flex items-center justify-center shadow-glow">
<span class="material-symbols-outlined text-white text-2xl">admin_panel_settings</span>
</div>
<div>
<h1 class="font-bold text-2xl text-text-primary">Admin Panel</h1>
<p class="text-sm text-text-muted">Content Management</p>
</div>
</div>

<!-- Main Navigation -->
<nav class="flex flex-col gap-2">
<div class="text-xs font-semibold text-text-muted uppercase tracking-wider mb-3 px-3">Ana Menü</div>
<?php $current = basename($_SERVER['PHP_SELF']); ?>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='dashboard.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="dashboard.php">
<span class="material-symbols-outlined text-xl">dashboard</span>
<span>Kontrol Paneli</span>
</a>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='sites.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="sites.php">
<span class="material-symbols-outlined text-xl">language</span>
<span>Web Siteleri</span>
</a>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='pages.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="pages.php">
<span class="material-symbols-outlined text-xl">description</span>
<span>Sayfalar</span>
</a>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='menus.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="menus.php">
<span class="material-symbols-outlined text-xl">menu</span>
<span>Menüler</span>
</a>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='category.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="category.php">
<span class="material-symbols-outlined text-xl">category</span>
<span>Kategoriler</span>
</a>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='users.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="users.php">
<span class="material-symbols-outlined text-xl">group</span>
<span>Kullanıcılar</span>
</a>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='blog.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="blog.php">
<span class="material-symbols-outlined text-xl">article</span>
<span>Blog</span>
</a>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='blog_categories.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="blog_categories.php">
<span class="material-symbols-outlined text-xl">category</span>
<span>Blog Kategorileri</span>
</a>

<!-- Security Section -->
<div class="text-xs font-semibold text-text-muted uppercase tracking-wider mb-3 mt-6 px-3">Güvenlik</div>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='recaptcha.php') echo 'bg-primary text-white font-semibold active shadow-soft'; else echo 'hover:bg-surface-hover text-text-secondary font-medium'; ?>" href="recaptcha.php">
<span class="material-symbols-outlined text-xl">verified_user</span>
<span>reCAPTCHA Ayarları</span>
</a>

<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl <?php if($current=='ip_ban.php') echo 'bg-danger text-white font-semibold active shadow-soft'; else echo 'hover:bg-red-50 text-red-600 font-medium'; ?>" href="ip_ban.php">
<span class="material-symbols-outlined text-xl">block</span>
<span>IP Kısıtlamaları</span>
</a>
</nav>
</div>

<!-- Bottom Section -->
<div class="flex flex-col gap-2 pt-6 border-t border-border-light">
<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl hover:bg-surface-hover text-text-secondary font-medium" href="settings.php">
<span class="material-symbols-outlined text-xl">settings</span>
<span>Ayarlar</span>
</a>
<a class="nav-item flex items-center gap-4 px-4 py-3.5 rounded-xl hover:bg-red-50 text-red-600 font-medium" href="logout.php">
<span class="material-symbols-outlined text-xl">logout</span>
<span>Çıkış Yap</span>
</a>
</div>
</aside>

