<?php
require_once 'admin_auth.php';
require_once '../includes/config.php';

// Get menu ID and type
$menu_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$menu_type = $_GET['type'] ?? 'footer';

if ($menu_id <= 0) {
    header("Location: menus.php?type=" . urlencode($menu_type));
    exit();
}

// Fetch menu data
$menu_query = "SELECT * FROM menu_items WHERE id = ?";
$stmt = $conn->prepare($menu_query);
$stmt->bind_param("i", $menu_id);
$stmt->execute();
$menu_result = $stmt->get_result();

if ($menu_result->num_rows == 0) {
    header("Location: menus.php?type=" . urlencode($menu_type));
    exit();
}

$menu = $menu_result->fetch_assoc();
// Override menu_type from URL if provided (for consistency)
if (isset($_GET['type'])) {
    $menu_type = $_GET['type'];
} else {
    $menu_type = $menu['menu_type'] ?? 'footer';
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = trim($_POST['title']);
    $url = trim($_POST['url']);
    $target = $_POST['target'] ?? '_self';
    $sort_order = intval($_POST['sort_order']);
    
    // Validate required fields
    if (empty($title) || empty($url)) {
        $error_message = "Başlık ve URL gerekli alanlardır.";
    } else {
        // Update menu item
        $update_query = "UPDATE menu_items SET title = ?, url = ?, target = ?, sort_order = ?, updated_at = NOW() WHERE id = ?";
        $stmt = $conn->prepare($update_query);
        $stmt->bind_param("sssii", $title, $url, $target, $sort_order, $menu_id);
        
        if ($stmt->execute()) {
            header("Location: menus.php?type=" . urlencode($menu_type) . "&success=Menü öğesi başarıyla güncellendi");
            exit();
        } else {
            $error_message = "Menü öğesi güncellenirken hata oluştu. Lütfen tekrar deneyin.";
        }
    }
} else {
    // Pre-fill form with existing data
    $_POST = $menu;
}
?>

<?php include 'menu.php'; ?>

<div class="flex-1 bg-background min-h-screen">
    <div class="p-8">
        <!-- Header -->
        <div class="flex items-center gap-4 mb-8">
            <a href="menus.php?type=<?php echo urlencode($menu_type); ?>" class="inline-flex items-center justify-center w-10 h-10 bg-surface hover:bg-surface-hover rounded-xl border border-border-light transition-colors">
                <span class="material-symbols-outlined text-text-secondary">arrow_back</span>
            </a>
            <div>
                <h1 class="text-3xl font-bold text-text-primary mb-2">Edit Menu Item</h1>
                <p class="text-text-secondary">Modify menu item: <?php echo htmlspecialchars($menu['title']); ?></p>
            </div>
        </div>

        <?php if (isset($error_message)): ?>
            <div class="bg-red-50 border border-red-200 text-red-700 px-6 py-4 rounded-xl mb-6">
                <div class="flex items-center gap-2">
                    <span class="material-symbols-outlined">error</span>
                    <?php echo $error_message; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Form -->
        <form method="POST" class="space-y-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Content -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Menu Details -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h2 class="text-xl font-semibold text-text-primary mb-4">Menu Item Details</h2>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="title" class="block text-sm font-medium text-text-primary mb-2">Menu Title *</label>
                                <input type="text" id="title" name="title" required 
                                       value="<?php echo htmlspecialchars($_POST['title']); ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                       placeholder="Contact">
                            </div>
                            
                            <div>
                                <label for="url" class="block text-sm font-medium text-text-primary mb-2">URL *</label>
                                <input type="text" id="url" name="url" required
                                       value="<?php echo htmlspecialchars($_POST['url']); ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                       placeholder="/contact or https://example.com">
                                <p class="text-xs text-text-muted mt-1">Internal links: /contact | External links: https://example.com | Pages: /about-us</p>
                            </div>
                        </div>
                    </div>

                    <!-- URL Examples -->
                    <div class="bg-blue-50 border border-blue-200 rounded-2xl p-6">
                        <h3 class="text-lg font-semibold text-blue-800 mb-3">URL Examples</h3>
                        <div class="space-y-2 text-sm text-blue-700">
                            <div><strong>Internal Pages:</strong> /contact, /about-us, /privacy-policy</div>
                            <div><strong>External Links:</strong> https://google.com, https://facebook.com</div>
                            <div><strong>Email Links:</strong> mailto:info@example.com</div>
                            <div><strong>Phone Links:</strong> tel:+1234567890</div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Settings -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h3 class="text-lg font-semibold text-text-primary mb-4">Link Settings</h3>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="target" class="block text-sm font-medium text-text-primary mb-2">Link Target</label>
                                <select id="target" name="target" 
                                        class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors">
                                    <option value="_self" <?php echo ($_POST['target'] == '_self') ? 'selected' : ''; ?>>Same Tab</option>
                                    <option value="_blank" <?php echo ($_POST['target'] == '_blank') ? 'selected' : ''; ?>>New Tab</option>
                                </select>
                            </div>
                            
                            <div>
                                <label for="sort_order" class="block text-sm font-medium text-text-primary mb-2">Sort Order</label>
                                <input type="number" id="sort_order" name="sort_order" min="1"
                                       value="<?php echo $_POST['sort_order']; ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors">
                                <p class="text-xs text-text-muted mt-1">Position in menu (1 = first)</p>
                            </div>
                        </div>
                        
                        <div class="flex flex-col gap-3 mt-6 pt-6 border-t border-border-light">
                            <button type="submit" 
                                    class="w-full bg-primary hover:bg-primary-dark text-white font-semibold py-3 px-4 rounded-xl transition-colors">
                                Update Menu Item
                            </button>
                            <a href="menus.php?type=<?php echo urlencode($menu_type); ?>" 
                               class="w-full text-center bg-surface-hover hover:bg-border-light text-text-secondary font-medium py-3 px-4 rounded-xl transition-colors">
                                Cancel
                            </a>
                        </div>
                    </div>

                    <!-- Menu Info -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h3 class="text-lg font-semibold text-text-primary mb-4">Menu Information</h3>
                        <div class="space-y-3 text-sm">
                            <div class="flex justify-between">
                                <span class="text-text-muted">Created:</span>
                                <span class="text-text-secondary"><?php echo date('M j, Y', strtotime($menu['created_at'])); ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-text-muted">Updated:</span>
                                <span class="text-text-secondary"><?php echo date('M j, Y', strtotime($menu['updated_at'])); ?></span>
                            </div>
                        </div>
                    </div>

                    <!-- Delete Menu -->
                    <div class="bg-red-50 border border-red-200 rounded-2xl p-6">
                        <h3 class="text-lg font-semibold text-red-700 mb-2">Danger Zone</h3>
                        <p class="text-sm text-red-600 mb-4">Once you delete this menu item, there is no going back.</p>
                        <form method="POST" action="menus.php?type=<?php echo urlencode($menu_type); ?>" onsubmit="return confirm('Are you sure you want to delete this menu item? This action cannot be undone.')">
                            <input type="hidden" name="menu_id" value="<?php echo $menu['id']; ?>">
                            <button type="submit" name="delete_menu" 
                                    class="w-full bg-red-600 hover:bg-red-700 text-white font-semibold py-3 px-4 rounded-xl transition-colors">
                                Delete Menu Item
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
// Live preview
document.getElementById('title').addEventListener('input', function() {
    const title = this.value || 'Menu Title';
    document.getElementById('preview-title').textContent = title;
});

document.getElementById('url').addEventListener('input', function() {
    const url = this.value || '#';
    document.getElementById('preview-link').href = url;
});
</script>

</body>
</html>

