<?php
require_once 'admin_auth.php';
require_once '../includes/config.php';

// Get menu type (only footer menu)
$menu_type = 'footer';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = trim($_POST['title']);
    $url = trim($_POST['url']);
    $target = $_POST['target'] ?? '_self';
    $sort_order = intval($_POST['sort_order']);
    $menu_type = 'footer';
    
    // Validate required fields
    if (empty($title) || empty($url)) {
        $error_message = "Başlık ve URL gerekli alanlardır.";
    } else {
        // If sort_order is 0, get the next available order for this menu type
        if ($sort_order == 0) {
            $max_order_query = "SELECT MAX(sort_order) as max_order FROM menu_items WHERE menu_type = ?";
            $stmt = $conn->prepare($max_order_query);
            $stmt->bind_param("s", $menu_type);
            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();
            $sort_order = ($row['max_order'] ?? 0) + 1;
        }
        
        // Insert new menu item
        $insert_query = "INSERT INTO menu_items (title, url, target, sort_order, menu_type, created_at, updated_at) VALUES (?, ?, ?, ?, ?, NOW(), NOW())";
        $stmt = $conn->prepare($insert_query);
        $stmt->bind_param("sssis", $title, $url, $target, $sort_order, $menu_type);
        
        if ($stmt->execute()) {
            header("Location: menus.php?type=" . urlencode($menu_type) . "&success=Menü öğesi başarıyla oluşturuldu");
            exit();
        } else {
            $error_message = "Menü öğesi oluşturulurken hata oluştu. Lütfen tekrar deneyin.";
        }
    }
}
?>

<?php include 'menu.php'; ?>

<div class="flex-1 bg-background min-h-screen">
    <div class="p-8">
        <!-- Header -->
        <div class="flex items-center gap-4 mb-8">
            <a href="menus.php?type=<?php echo urlencode($menu_type); ?>" class="inline-flex items-center justify-center w-10 h-10 bg-surface hover:bg-surface-hover rounded-xl border border-border-light transition-colors">
                <span class="material-symbols-outlined text-text-secondary">arrow_back</span>
            </a>
            <div>
                <h1 class="text-3xl font-bold text-text-primary mb-2">Menü Öğesi Ekle</h1>
                <p class="text-text-secondary">Yeni bir <?php echo ucfirst($menu_type); ?> menü öğesi oluşturun</p>
            </div>
        </div>

        <?php if (isset($error_message)): ?>
            <div class="bg-red-50 border border-red-200 text-red-700 px-6 py-4 rounded-xl mb-6">
                <div class="flex items-center gap-2">
                    <span class="material-symbols-outlined">error</span>
                    <?php echo $error_message; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Form -->
        <form method="POST" class="space-y-6">
            <input type="hidden" name="menu_type" value="footer">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Content -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Menu Details -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h2 class="text-xl font-semibold text-text-primary mb-4">Menü Öğesi Detayları</h2>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="title" class="block text-sm font-medium text-text-primary mb-2">Menü Başlığı *</label>
                                <input type="text" id="title" name="title" required 
                                       value="<?php echo isset($_POST['title']) ? htmlspecialchars($_POST['title']) : ''; ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                       placeholder="İletişim">
                            </div>
                            
                            <div>
                                <label for="url" class="block text-sm font-medium text-text-primary mb-2">URL *</label>
                                <input type="text" id="url" name="url" required
                                       value="<?php echo isset($_POST['url']) ? htmlspecialchars($_POST['url']) : ''; ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                       placeholder="/iletisim veya https://example.com">
                                <p class="text-xs text-text-muted mt-1">İç bağlantılar: /iletisim | Dış bağlantılar: https://example.com | Sayfalar: /hakkimizda</p>
                            </div>
                        </div>
                    </div>

                    <!-- URL Examples -->
                    <div class="bg-blue-50 border border-blue-200 rounded-2xl p-6">
                        <h3 class="text-lg font-semibold text-blue-800 mb-3">URL Örnekleri</h3>
                        <div class="space-y-2 text-sm text-blue-700">
                            <div><strong>İç Sayfalar:</strong> /iletisim, /hakkimizda, /gizlilik-politikasi</div>
                            <div><strong>Dış Bağlantılar:</strong> https://google.com, https://facebook.com</div>
                            <div><strong>E-posta Bağlantıları:</strong> mailto:info@example.com</div>
                            <div><strong>Telefon Bağlantıları:</strong> tel:+1234567890</div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Settings -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h3 class="text-lg font-semibold text-text-primary mb-4">Bağlantı Ayarları</h3>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="target" class="block text-sm font-medium text-text-primary mb-2">Bağlantı Hedefi</label>
                                <select id="target" name="target" 
                                        class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors">
                                    <option value="_self" <?php echo (isset($_POST['target']) && $_POST['target'] == '_self') ? 'selected' : ''; ?>>Aynı Sekme</option>
                                    <option value="_blank" <?php echo (isset($_POST['target']) && $_POST['target'] == '_blank') ? 'selected' : ''; ?>>Yeni Sekme</option>
                                </select>
                            </div>
                            
                            <div>
                                <label for="sort_order" class="block text-sm font-medium text-text-primary mb-2">Sıralama</label>
                                <input type="number" id="sort_order" name="sort_order" min="0"
                                       value="<?php echo isset($_POST['sort_order']) ? $_POST['sort_order'] : '0'; ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                       placeholder="0">
                                <p class="text-xs text-text-muted mt-1">0 = Sona ekle, veya pozisyon belirt</p>
                            </div>
                        </div>
                        
                        <div class="flex flex-col gap-3 mt-6 pt-6 border-t border-border-light">
                            <button type="submit" 
                                    class="w-full bg-primary hover:bg-primary-dark text-white font-semibold py-3 px-4 rounded-xl transition-colors">
                                Menü Öğesi Oluştur
                            </button>
                            <a href="menus.php?type=<?php echo urlencode($menu_type); ?>" 
                               class="w-full text-center bg-surface-hover hover:bg-border-light text-text-secondary font-medium py-3 px-4 rounded-xl transition-colors">
                                İptal
                            </a>
                        </div>
                    </div>

                    <!-- Preview -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h3 class="text-lg font-semibold text-text-primary mb-4">Önizleme</h3>
                        <div class="space-y-3 text-sm">
                            <div class="bg-background p-3 rounded-lg">
                                <div class="text-text-muted mb-1">Footer Menü Öğesi:</div>
                                <a href="#" class="text-text-secondary hover:text-primary transition-colors" id="preview-link">
                                    <span id="preview-title">Menü Başlığı</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
// Live preview
document.getElementById('title').addEventListener('input', function() {
    const title = this.value || 'Menü Başlığı';
    document.getElementById('preview-title').textContent = title;
});

document.getElementById('url').addEventListener('input', function() {
    const url = this.value || '#';
    document.getElementById('preview-link').href = url;
});
</script>

</body>
</html>

