<?php
require_once 'admin_auth.php';
require_once '../includes/config.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = trim($_POST['title']);
    $slug = trim($_POST['slug']);
    $content = $_POST['content'];
    $meta_description = trim($_POST['meta_description']);
    $meta_keywords = trim($_POST['meta_keywords']);
    $status = $_POST['status'];
    $created_at = !empty($_POST['created_at']) ? $_POST['created_at'] : date('Y-m-d H:i:s');
    
    // Auto-generate slug if empty
    if (empty($slug)) {
        $slug = strtolower(trim(preg_replace('/[^A-Za-z0-9-]+/', '-', $title)));
    }
    
    // Validate required fields
    if (empty($title) || empty($content)) {
        $error_message = "Başlık ve içerik gerekli alanlardır.";
    } else {
        // Check if slug already exists
        $stmt = $pdo->prepare("SELECT id FROM pages WHERE slug = ?");
        $stmt->execute([$slug]);
        
        if ($stmt->rowCount() > 0) {
            $error_message = "Bu slug ile bir sayfa zaten mevcut. Lütfen farklı bir slug seçin.";
        } else {
            // Insert new page with custom date
            $stmt = $pdo->prepare("INSERT INTO pages (title, slug, content, meta_description, meta_keywords, status, created_at, updated_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            
            if ($stmt->execute([$title, $slug, $content, $meta_description, $meta_keywords, $status, $created_at, $created_at])) {
                header("Location: pages.php?success=Sayfa başarıyla oluşturuldu");
                exit();
            } else {
                $error_message = "Sayfa oluşturulurken hata oluştu. Lütfen tekrar deneyin.";
            }
        }
    }
}
?>

<?php include 'menu.php'; ?>

<!-- Quill Editor CSS -->
<link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
<style>
    .ql-editor {
        min-height: 350px;
        font-family: 'Inter', system-ui, -apple-system, sans-serif;
        font-size: 14px;
        line-height: 1.6;
    }
    .ql-toolbar {
        border-top: 1px solid #e5e7eb;
        border-left: 1px solid #e5e7eb;
        border-right: 1px solid #e5e7eb;
        border-bottom: none;
        background: #f9fafb;
    }
    .ql-container {
        border-bottom: 1px solid #e5e7eb;
        border-left: 1px solid #e5e7eb;
        border-right: 1px solid #e5e7eb;
        border-top: none;
        font-family: inherit;
    }
</style>

<div class="flex-1 bg-background min-h-screen">
    <div class="p-8">
        <!-- Header -->
        <div class="flex items-center gap-4 mb-8">
            <a href="pages.php" class="inline-flex items-center justify-center w-10 h-10 bg-surface hover:bg-surface-hover rounded-xl border border-border-light transition-colors">
                <span class="material-symbols-outlined text-text-secondary">arrow_back</span>
            </a>
            <div>
                <h1 class="text-3xl font-bold text-text-primary mb-2">Yeni Sayfa Oluştur</h1>
                <p class="text-text-secondary">Web sitenize yeni bir sayfa ekleyin</p>
            </div>
        </div>

        <?php if (isset($error_message)): ?>
            <div class="bg-red-50 border border-red-200 text-red-700 px-6 py-4 rounded-xl mb-6">
                <div class="flex items-center gap-2">
                    <span class="material-symbols-outlined">error</span>
                    <?php echo $error_message; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Form -->
        <form method="POST" class="space-y-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- Main Content -->
                <div class="lg:col-span-2 space-y-6">
                    <!-- Title and Slug -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h2 class="text-xl font-semibold text-text-primary mb-4">Sayfa Detayları</h2>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="title" class="block text-sm font-medium text-text-primary mb-2">Sayfa Başlığı *</label>
                                <input type="text" id="title" name="title" required 
                                       value="<?php echo isset($_POST['title']) ? htmlspecialchars($_POST['title']) : ''; ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                       placeholder="Sayfa başlığını girin">
                            </div>
                            
                            <div>
                                <label for="slug" class="block text-sm font-medium text-text-primary mb-2">URL Adresi</label>
                                <div class="relative">
                                    <span class="absolute left-4 top-1/2 transform -translate-y-1/2 text-text-muted text-sm">/</span>
                                    <input type="text" id="slug" name="slug" 
                                           value="<?php echo isset($_POST['slug']) ? htmlspecialchars($_POST['slug']) : ''; ?>"
                                           class="w-full pl-8 pr-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                           placeholder="auto-generated-from-title">
                                </div>
                                <p class="text-xs text-text-muted mt-1">Boş bırakılırsa başlıktan otomatik oluşturulur</p>
                            </div>
                        </div>
                    </div>

                    <!-- Content -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h2 class="text-xl font-semibold text-text-primary mb-4">Sayfa İçeriği</h2>
                        
                        <div>
                            <label for="content" class="block text-sm font-medium text-text-primary mb-2">İçerik *</label>
                            <div class="border border-border-light rounded-xl overflow-hidden">
                                <div id="quill-editor" style="min-height: 400px;"><?php echo isset($_POST['content']) ? $_POST['content'] : ''; ?></div>
                            </div>
                            <textarea id="content" name="content" style="display: none;" required></textarea>
                            <p class="text-xs text-text-muted mt-1">Biçimlendirme seçenekleri ile zengin metin editörü</p>
                        </div>
                    </div>

                    <!-- SEO Meta -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h2 class="text-xl font-semibold text-text-primary mb-4">SEO Ayarları</h2>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="meta_description" class="block text-sm font-medium text-text-primary mb-2">Meta Açıklama</label>
                                <textarea id="meta_description" name="meta_description" rows="3"
                                          class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                          placeholder="Arama motorları için kısa açıklama (150-160 karakter)"><?php echo isset($_POST['meta_description']) ? htmlspecialchars($_POST['meta_description']) : ''; ?></textarea>
                            </div>
                            
                            <div>
                                <label for="meta_keywords" class="block text-sm font-medium text-text-primary mb-2">Meta Anahtar Kelimeler</label>
                                <input type="text" id="meta_keywords" name="meta_keywords" 
                                       value="<?php echo isset($_POST['meta_keywords']) ? htmlspecialchars($_POST['meta_keywords']) : ''; ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors"
                                       placeholder="anahtar1, anahtar2, anahtar3">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sidebar -->
                <div class="space-y-6">
                    <!-- Publish -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h3 class="text-lg font-semibold text-text-primary mb-4">Yayın Ayarları</h3>
                        
                        <div class="space-y-4">
                            <div>
                                <label for="status" class="block text-sm font-medium text-text-primary mb-2">Durum</label>
                                <select id="status" name="status" 
                                        class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors">
                                    <option value="draft" <?php echo (isset($_POST['status']) && $_POST['status'] == 'draft') ? 'selected' : ''; ?>>Taslak</option>
                                    <option value="published" <?php echo (isset($_POST['status']) && $_POST['status'] == 'published') ? 'selected' : ''; ?>>Yayınlandı</option>
                                </select>
                            </div>
                            
                            <div>
                                <label for="created_at" class="block text-sm font-medium text-text-primary mb-2">Yayın Tarihi</label>
                                <input type="datetime-local" id="created_at" name="created_at" 
                                       value="<?php echo isset($_POST['created_at']) ? $_POST['created_at'] : date('Y-m-d\TH:i'); ?>"
                                       class="w-full px-4 py-3 border border-border-light rounded-xl focus:ring-2 focus:ring-primary focus:border-primary transition-colors">
                                <p class="text-xs text-text-muted mt-1">Boş bırakılırsa mevcut zaman kullanılır</p>
                            </div>
                        </div>
                        
                        <div class="flex flex-col gap-3 mt-6 pt-6 border-t border-border-light">
                            <button type="button" 
                                    id="create-page-btn"
                                    onclick="submitForm()"
                                    class="w-full bg-primary hover:bg-primary-dark text-white font-semibold py-3 px-4 rounded-xl transition-colors">
                                Sayfa Oluştur
                            </button>
                            <a href="pages.php" 
                               class="w-full text-center bg-surface-hover hover:bg-border-light text-text-secondary font-medium py-3 px-4 rounded-xl transition-colors">
                                İptal
                            </a>
                        </div>
                    </div>

                    <!-- Preview -->
                    <div class="bg-surface rounded-2xl shadow-soft border border-border-light p-6">
                        <h3 class="text-lg font-semibold text-text-primary mb-4">Preview Info</h3>
                        <div class="space-y-3 text-sm">
                            <div class="flex justify-between">
                                <span class="text-text-muted">URL:</span>
                                <span class="text-text-secondary" id="preview-url">/page-slug</span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-text-muted">Created:</span>
                                <span class="text-text-secondary"><?php echo date('M j, Y'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Quill Editor JS -->
<script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
<script>
// Initialize Quill editor
var quill = new Quill('#quill-editor', {
    theme: 'snow',
    placeholder: 'Enter your page content here...',
    modules: {
        toolbar: [
            [{ 'header': [1, 2, 3, 4, 5, 6, false] }],
            [{ 'font': [] }],
            [{ 'size': ['small', false, 'large', 'huge'] }],
            ['bold', 'italic', 'underline', 'strike'],
            [{ 'color': [] }, { 'background': [] }],
            [{ 'script': 'sub'}, { 'script': 'super' }],
            ['blockquote', 'code-block'],
            [{ 'list': 'ordered'}, { 'list': 'bullet' }],
            [{ 'indent': '-1'}, { 'indent': '+1' }],
            [{ 'direction': 'rtl' }],
            [{ 'align': [] }],
            ['link', 'image', 'video'],
            ['clean']
        ]
    }
});

// Form submission function
function submitForm() {
    console.log('Submit button clicked!');
    
    var title = document.getElementById('title');
    var content = document.querySelector('#content');
    var createBtn = document.getElementById('create-page-btn');
    var form = document.querySelector('form');
    
    console.log('Elements found:', {
        title: title,
        content: content,
        createBtn: createBtn,
        form: form
    });
    
    // Update content from Quill editor
    if (quill && quill.root) {
        content.value = quill.root.innerHTML;
        console.log('Content updated from Quill:', content.value);
    }
    
    // Validate title
    if (!title.value.trim()) {
        alert('Please enter a page title.');
        title.focus();
        return false;
    }
    
    // Validate content
    if (!content.value || content.value.trim() === '' || content.value.trim() === '<p><br></p>') {
        alert('Please enter some content for the page.');
        if (quill) quill.focus();
        return false;
    }
    
    // Disable button to prevent double submission
    createBtn.disabled = true;
    createBtn.textContent = 'Creating...';
    
    console.log('Form submitting with:', {
        title: title.value,
        content: content.value,
        slug: document.getElementById('slug').value
    });
    
    // Submit the form
    form.submit();
    return true;
}

// Auto-generate slug from title
document.getElementById('title').addEventListener('input', function() {
    if (document.getElementById('slug').value === '') {
        const slug = this.value
            .toLowerCase()
            .replace(/[^a-z0-9\s-]/g, '')
            .replace(/\s+/g, '-')
            .replace(/-+/g, '-')
            .trim('-');
        document.getElementById('slug').value = slug;
        document.getElementById('preview-url').textContent = '/' + slug;
    }
});

document.getElementById('slug').addEventListener('input', function() {
    document.getElementById('preview-url').textContent = '/' + this.value;
});
</script>

</body>
</html>

