<?php
require_once 'admin_auth.php';
require_once '../includes/config.php';

// Sayfa silme işlemi
if (isset($_POST['delete_page']) && isset($_POST['page_id'])) {
    $page_id = intval($_POST['page_id']);
    $delete_query = "DELETE FROM pages WHERE id = ?";
    $stmt = $conn->prepare($delete_query);
    $stmt->bind_param("i", $page_id);
    if ($stmt->execute()) {
        $success_message = "Sayfa başarıyla silindi!";
    } else {
        $error_message = "Sayfa silinirken hata oluştu.";
    }
}

// Tüm sayfaları getir
$pages_query = "SELECT * FROM pages ORDER BY created_at DESC";
$pages_result = $conn->query($pages_query);

// Başarı mesajını kontrol et
if (isset($_GET['success'])) {
    $success_message = $_GET['success'];
}
?>

<?php include 'menu.php'; ?>

<body class="bg-background font-display flex">
<div class="flex-1 bg-background min-h-screen">
    <div class="p-8">
        <?php
        $page_title = "Sayfa Yönetimi";
        $page_subtitle = "Web sitenizin sayfalarını oluşturun ve yönetin";
        include 'includes/admin_header.php';
        ?>
        
        <!-- Action Buttons -->
        <div class="flex gap-3 mb-8">
            <a href="page_new.php" class="inline-flex items-center gap-2 bg-primary hover:bg-primary-dark text-white font-semibold px-6 py-3 rounded-xl shadow-soft transition-all duration-200">
                <span class="material-symbols-outlined text-xl">add</span>
                Yeni Sayfa Ekle
            </a>
        </div>

        <?php if (isset($success_message)): ?>
            <div class="bg-green-50 border border-green-200 text-green-700 px-6 py-4 rounded-xl mb-6">
                <div class="flex items-center gap-2">
                    <span class="material-symbols-outlined">check_circle</span>
                    <?php echo $success_message; ?>
                </div>
            </div>
        <?php endif; ?>

        <?php if (isset($error_message)): ?>
            <div class="bg-red-50 border border-red-200 text-red-700 px-6 py-4 rounded-xl mb-6">
                <div class="flex items-center gap-2">
                    <span class="material-symbols-outlined">error</span>
                    <?php echo $error_message; ?>
                </div>
            </div>
        <?php endif; ?>

        <!-- Pages Table -->
        <div class="bg-surface rounded-2xl shadow-soft border border-border-light overflow-hidden">
            <div class="p-6 border-b border-border-light">
                <h2 class="text-xl font-semibold text-text-primary">Tüm Sayfalar</h2>
            </div>
            
            <?php if ($pages_result && $pages_result->num_rows > 0): ?>
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-background">
                            <tr>
                                <th class="text-left p-4 font-semibold text-text-secondary">Başlık</th>
                                <th class="text-left p-4 font-semibold text-text-secondary">Slug</th>
                                <th class="text-left p-4 font-semibold text-text-secondary">Durum</th>
                                <th class="text-left p-4 font-semibold text-text-secondary">Oluşturulma</th>
                                <th class="text-left p-4 font-semibold text-text-secondary">İşlemler</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while($page = $pages_result->fetch_assoc()): ?>
                                <tr class="border-t border-border-light hover:bg-background transition-colors">
                                    <td class="p-4">
                                        <div class="font-medium text-text-primary"><?php echo htmlspecialchars($page['title']); ?></div>
                                        <?php if ($page['meta_description']): ?>
                                            <div class="text-sm text-text-muted mt-1"><?php echo htmlspecialchars(substr($page['meta_description'], 0, 80)); ?>...</div>
                                        <?php endif; ?>
                                    </td>
                                    <td class="p-4">
                                        <code class="bg-background px-2 py-1 rounded text-sm text-primary"><?php echo htmlspecialchars($page['slug']); ?></code>
                                    </td>
                                    <td class="p-4">
                                        <?php if ($page['status'] == 'published'): ?>
                                            <span class="inline-flex items-center gap-1 bg-green-100 text-green-700 px-2 py-1 rounded-lg text-sm font-medium">
                                                <span class="w-2 h-2 bg-green-500 rounded-full"></span>
                                                Yayınlandı
                                            </span>
                                        <?php else: ?>
                                            <span class="inline-flex items-center gap-1 bg-yellow-100 text-yellow-700 px-2 py-1 rounded-lg text-sm font-medium">
                                                <span class="w-2 h-2 bg-yellow-500 rounded-full"></span>
                                                Taslak
                                            </span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="p-4 text-text-secondary">
                                        <?php echo date('M j, Y', strtotime($page['created_at'])); ?>
                                    </td>
                                    <td class="p-4">
                                        <div class="flex items-center gap-2">
                                            <?php if ($page['status'] == 'published'): ?>
                                                <a href="../<?php echo urlencode($page['slug']); ?>" target="_blank"
                                                   class="inline-flex items-center gap-1 bg-green-50 hover:bg-green-100 text-green-600 px-3 py-2 rounded-lg text-sm font-medium transition-colors">
                                                    <span class="material-symbols-outlined text-base">visibility</span>
                                                    Görüntüle
                                                </a>
                                            <?php endif; ?>
                                            <a href="page_edit.php?id=<?php echo $page['id']; ?>" 
                                               class="inline-flex items-center gap-1 bg-blue-50 hover:bg-blue-100 text-blue-600 px-3 py-2 rounded-lg text-sm font-medium transition-colors">
                                                <span class="material-symbols-outlined text-base">edit</span>
                                                Düzenle
                                            </a>
                                            <form method="POST" class="inline" onsubmit="return confirm('Bu sayfayı silmek istediğinizden emin misiniz?')">
                                                <input type="hidden" name="page_id" value="<?php echo $page['id']; ?>">
                                                <button type="submit" name="delete_page" 
                                                        class="inline-flex items-center gap-1 bg-red-50 hover:bg-red-100 text-red-600 px-3 py-2 rounded-lg text-sm font-medium transition-colors">
                                                    <span class="material-symbols-outlined text-base">delete</span>
                                                    Sil
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="p-12 text-center">
                    <div class="w-16 h-16 bg-background rounded-2xl flex items-center justify-center mx-auto mb-4">
                        <span class="material-symbols-outlined text-2xl text-text-muted">description</span>
                    </div>
                    <h3 class="text-xl font-semibold text-text-primary mb-2">Sayfa bulunamadı</h3>
                    <p class="text-text-secondary mb-6">İlk sayfanızı oluşturarak başlayın</p>
                    <a href="page_new.php" class="inline-flex items-center gap-2 bg-primary hover:bg-primary-dark text-white font-semibold px-6 py-3 rounded-xl shadow-soft transition-all duration-200">
                        <span class="material-symbols-outlined text-xl">add</span>
                        İlk Sayfanızı Oluşturun
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

</body>
</html>

