<?php
require_once 'admin_auth.php';
require_once '../includes/config.php';

$success_message = '';
$error_message = '';

// Ayarları güncelle
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        if (isset($_POST['update_recaptcha'])) {
            $recaptcha_enabled = isset($_POST['recaptcha_enabled']) ? 1 : 0;
            $site_key = trim($_POST['site_key']);
            $secret_key = trim($_POST['secret_key']);
            
            // reCAPTCHA ayarlarını güncelle
            $stmt = $mysqli->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
            
            $stmt->bind_param("ss", $recaptcha_enabled, $temp_key);
            $temp_key = 'recaptcha_enabled';
            $stmt->execute();
            
            $stmt->bind_param("ss", $site_key, $temp_key);
            $temp_key = 'recaptcha_site_key';
            $stmt->execute();
            
            $stmt->bind_param("ss", $secret_key, $temp_key);
            $temp_key = 'recaptcha_secret_key';
            $stmt->execute();
            
            $stmt->close();
            
            $success_message = 'reCAPTCHA ayarları başarıyla güncellendi.';
        }
    } catch (Exception $e) {
        $error_message = 'Hata: ' . $e->getMessage();
    }
}

// Mevcut ayarları al
$settings = [];
$result = $mysqli->query("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('recaptcha_enabled', 'recaptcha_site_key', 'recaptcha_secret_key')");
while ($row = $result->fetch_assoc()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$recaptcha_enabled = isset($settings['recaptcha_enabled']) ? $settings['recaptcha_enabled'] : 0;
$site_key = isset($settings['recaptcha_site_key']) ? $settings['recaptcha_site_key'] : '';
$secret_key = isset($settings['recaptcha_secret_key']) ? $settings['recaptcha_secret_key'] : '';
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>reCAPTCHA Ayarları - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet">
    <style>
        :root {
            --primary: #3b82f6;
            --primary-dark: #1d4ed8;
            --success: #10b981;
            --danger: #ef4444;
            --warning: #f59e0b;
            --surface: #f8fafc;
            --surface-hover: #f1f5f9;
            --text-primary: #1e293b;
            --text-secondary: #64748b;
            --text-muted: #94a3b8;
            --border: #e2e8f0;
        }
        
        body { 
            font-family: 'Inter', system-ui, -apple-system, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
        }
        
        .admin-container {
            background: white;
            border-radius: 24px;
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.1);
        }
        
        .nav-item.active {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
        }
        
        .form-input {
            border: 2px solid var(--border);
            border-radius: 12px;
            padding: 12px 16px;
            transition: all 0.2s ease;
            background: white;
        }
        
        .form-input:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(59, 130, 246, 0.1);
            outline: none;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--primary), var(--primary-dark));
            color: white;
            border-radius: 12px;
            padding: 12px 24px;
            font-weight: 600;
            transition: all 0.2s ease;
            border: none;
        }
        
        .btn-primary:hover {
            transform: translateY(-1px);
            box-shadow: 0 10px 25px rgba(59, 130, 246, 0.3);
        }
        
        .alert-success {
            background: linear-gradient(135deg, #10b981, #059669);
            color: white;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 24px;
        }
        
        .alert-error {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            color: white;
            border-radius: 12px;
            padding: 16px;
            margin-bottom: 24px;
        }
        
        .info-box {
            background: linear-gradient(135deg, #3b82f6, #1d4ed8);
            color: white;
            border-radius: 16px;
            padding: 20px;
            margin-bottom: 24px;
        }
        
        .switch {
            position: relative;
            display: inline-block;
            width: 60px;
            height: 34px;
        }
        
        .switch input {
            opacity: 0;
            width: 0;
            height: 0;
        }
        
        .slider {
            position: absolute;
            cursor: pointer;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: #ccc;
            transition: .4s;
            border-radius: 34px;
        }
        
        .slider:before {
            position: absolute;
            content: "";
            height: 26px;
            width: 26px;
            left: 4px;
            bottom: 4px;
            background-color: white;
            transition: .4s;
            border-radius: 50%;
        }
        
        input:checked + .slider {
            background-color: var(--primary);
        }
        
        input:checked + .slider:before {
            transform: translateX(26px);
        }
    </style>
</head>
<body>
    <div class="min-h-screen p-6">
        <div class="max-w-7xl mx-auto">
            <div class="admin-container overflow-hidden">
                <div class="flex">
                    <!-- Sidebar -->
                    <div class="w-80 bg-surface border-r border-border p-6">
                        <?php include 'menu.php'; ?>
                    </div>
                    
                    <!-- Main Content -->
                    <div class="flex-1 p-8">
                        <!-- Header -->
                        <div class="flex items-center justify-between mb-8">
                            <div>
                                <h1 class="text-3xl font-bold text-text-primary mb-2">reCAPTCHA Ayarları</h1>
                                <p class="text-text-secondary">Google reCAPTCHA v2 ayarlarını yönetin</p>
                            </div>
                            
                            <div class="flex items-center gap-3 bg-surface rounded-xl px-4 py-2">
                                <span class="material-symbols-outlined text-primary">verified_user</span>
                                <span class="text-sm font-medium text-text-secondary">Güvenlik Ayarları</span>
                            </div>
                        </div>
                        
                        <!-- Messages -->
                        <?php if ($success_message): ?>
                            <div class="alert-success flex items-center gap-3">
                                <span class="material-symbols-outlined">check_circle</span>
                                <span><?php echo $success_message; ?></span>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($error_message): ?>
                            <div class="alert-error flex items-center gap-3">
                                <span class="material-symbols-outlined">error</span>
                                <span><?php echo $error_message; ?></span>
                            </div>
                        <?php endif; ?>
                        
                        <!-- Info Box -->
                        <div class="info-box">
                            <div class="flex items-start gap-4">
                                <span class="material-symbols-outlined text-2xl">info</span>
                                <div>
                                    <h3 class="font-semibold text-lg mb-2">Google reCAPTCHA v2 Kurulumu</h3>
                                    <p class="text-sm opacity-90 mb-3">reCAPTCHA kullanmak için Google'dan Site Key ve Secret Key almanız gerekir.</p>
                                    <ol class="text-sm opacity-90 space-y-1">
                                        <li>1. <a href="https://www.google.com/recaptcha/admin/create" target="_blank" class="underline">Google reCAPTCHA</a> sayfasına gidin</li>
                                        <li>2. "Register a new site" seçeneğini tıklayın</li>
                                        <li>3. reCAPTCHA v2 -> "I'm not a robot" Checkbox seçin</li>
                                        <li>4. Domain adresinizi ekleyin</li>
                                        <li>5. Site Key ve Secret Key'i buraya girin</li>
                                    </ol>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Settings Form -->
                        <div class="bg-white rounded-2xl border-2 border-border p-8">
                            <form method="POST" class="space-y-6">
                                <!-- reCAPTCHA Enable/Disable -->
                                <div class="flex items-center justify-between p-6 bg-surface rounded-xl">
                                    <div>
                                        <h3 class="text-lg font-semibold text-text-primary mb-1">reCAPTCHA Aktif</h3>
                                        <p class="text-text-secondary">reCAPTCHA doğrulamasını aktif/pasif yapın</p>
                                    </div>
                                    <label class="switch">
                                        <input type="checkbox" name="recaptcha_enabled" value="1" <?php echo $recaptcha_enabled ? 'checked' : ''; ?>>
                                        <span class="slider"></span>
                                    </label>
                                </div>
                                
                                <!-- Site Key -->
                                <div>
                                    <label class="block text-sm font-semibold text-text-primary mb-3">
                                        <span class="flex items-center gap-2">
                                            <span class="material-symbols-outlined text-lg">key</span>
                                            Site Key (Public Key)
                                        </span>
                                    </label>
                                    <input type="text" 
                                           name="site_key" 
                                           value="<?php echo htmlspecialchars($site_key); ?>" 
                                           class="form-input w-full"
                                           placeholder="6LdRcP0dAAAAAJ..." 
                                           required>
                                    <p class="text-xs text-text-muted mt-2">Bu key formlarda görünür olacak (public)</p>
                                </div>
                                
                                <!-- Secret Key -->
                                <div>
                                    <label class="block text-sm font-semibold text-text-primary mb-3">
                                        <span class="flex items-center gap-2">
                                            <span class="material-symbols-outlined text-lg">security</span>
                                            Secret Key (Private Key)
                                        </span>
                                    </label>
                                    <input type="password" 
                                           name="secret_key" 
                                           value="<?php echo htmlspecialchars($secret_key); ?>" 
                                           class="form-input w-full"
                                           placeholder="6LdRcP0dAAAAAA..." 
                                           required>
                                    <p class="text-xs text-text-muted mt-2">Bu key sunucuda doğrulama için kullanılır (private)</p>
                                </div>
                                
                                <!-- Test Section -->
                                <div class="border-t border-border pt-6">
                                    <h3 class="text-lg font-semibold text-text-primary mb-4">Test ve Kullanım</h3>
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                        <div class="bg-surface p-4 rounded-xl">
                                            <h4 class="font-medium text-text-primary mb-2">Form Entegrasyonu</h4>
                                            <p class="text-sm text-text-secondary">reCAPTCHA aktif olduğunda tüm formlarda otomatik olarak görünecek</p>
                                        </div>
                                        <div class="bg-surface p-4 rounded-xl">
                                            <h4 class="font-medium text-text-primary mb-2">Güvenlik Seviyesi</h4>
                                            <p class="text-sm text-text-secondary">Bot saldırılarını engeller ve spam koruması sağlar</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Submit Button -->
                                <div class="flex justify-end pt-6 border-t border-border">
                                    <button type="submit" name="update_recaptcha" class="btn-primary flex items-center gap-2">
                                        <span class="material-symbols-outlined">save</span>
                                        Ayarları Kaydet
                                    </button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>

