<?php
/**
 * Admin Security Test
 * Güvenlik özelliklerini test etmek için
 */

require_once 'admin_auth.php';
require_once '../includes/config.php';

$tests = [];
$passed = 0;
$total = 0;

// Test 1: CSRF Token Generation
$total++;
try {
    $token = CSRFHelper::generateToken();
    if (!empty($token) && strlen($token) === 64) {
        $tests[] = ['name' => 'CSRF Token Generation', 'status' => 'PASS', 'message' => 'Token generated successfully'];
        $passed++;
    } else {
        $tests[] = ['name' => 'CSRF Token Generation', 'status' => 'FAIL', 'message' => 'Invalid token format'];
    }
} catch (Exception $e) {
    $tests[] = ['name' => 'CSRF Token Generation', 'status' => 'FAIL', 'message' => $e->getMessage()];
}

// Test 2: CSRF Token Validation
$total++;
try {
    $token = CSRFHelper::generateToken();
    if (CSRFHelper::validateToken($token)) {
        $tests[] = ['name' => 'CSRF Token Validation', 'status' => 'PASS', 'message' => 'Token validation works'];
        $passed++;
    } else {
        $tests[] = ['name' => 'CSRF Token Validation', 'status' => 'FAIL', 'message' => 'Token validation failed'];
    }
} catch (Exception $e) {
    $tests[] = ['name' => 'CSRF Token Validation', 'status' => 'FAIL', 'message' => $e->getMessage()];
}

// Test 3: Secure Database Helper
$total++;
try {
    $secureDB = new SecureDBHelper($pdo);
    $result = $secureDB->secureSelect('categories', 'COUNT(*) as count');
    if (is_array($result) && count($result) > 0) {
        $tests[] = ['name' => 'Secure Database Helper', 'status' => 'PASS', 'message' => 'Database operations work'];
        $passed++;
    } else {
        $tests[] = ['name' => 'Secure Database Helper', 'status' => 'FAIL', 'message' => 'Database query failed'];
    }
} catch (Exception $e) {
    $tests[] = ['name' => 'Secure Database Helper', 'status' => 'FAIL', 'message' => $e->getMessage()];
}

// Test 4: Input Sanitization
$total++;
try {
    $malicious_input = '<script>alert("xss")</script>';
    $sanitized = SecureDBHelper::sanitizeInput($malicious_input);
    if ($sanitized !== $malicious_input && strpos($sanitized, '<script>') === false) {
        $tests[] = ['name' => 'Input Sanitization', 'status' => 'PASS', 'message' => 'XSS protection works'];
        $passed++;
    } else {
        $tests[] = ['name' => 'Input Sanitization', 'status' => 'FAIL', 'message' => 'XSS protection failed'];
    }
} catch (Exception $e) {
    $tests[] = ['name' => 'Input Sanitization', 'status' => 'FAIL', 'message' => $e->getMessage()];
}

// Test 5: Session Security
$total++;
try {
    if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in'] === true) {
        $tests[] = ['name' => 'Session Security', 'status' => 'PASS', 'message' => 'Admin session is active'];
        $passed++;
    } else {
        $tests[] = ['name' => 'Session Security', 'status' => 'FAIL', 'message' => 'Admin session not found'];
    }
} catch (Exception $e) {
    $tests[] = ['name' => 'Session Security', 'status' => 'FAIL', 'message' => $e->getMessage()];
}

// Test 6: Rate Limiting
$total++;
try {
    if (isset($_SESSION['admin_request_count']) && $_SESSION['admin_request_count'] > 0) {
        $tests[] = ['name' => 'Rate Limiting', 'status' => 'PASS', 'message' => 'Rate limiting is active'];
        $passed++;
    } else {
        $tests[] = ['name' => 'Rate Limiting', 'status' => 'FAIL', 'message' => 'Rate limiting not working'];
    }
} catch (Exception $e) {
    $tests[] = ['name' => 'Rate Limiting', 'status' => 'FAIL', 'message' => $e->getMessage()];
}
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Security Test</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-100 p-8">
    <div class="max-w-4xl mx-auto">
        <h1 class="text-3xl font-bold mb-8">Admin Security Test Results</h1>
        
        <div class="bg-white rounded-lg shadow-lg p-6 mb-6">
            <h2 class="text-xl font-semibold mb-4">Test Summary</h2>
            <div class="grid grid-cols-3 gap-4">
                <div class="text-center">
                    <div class="text-3xl font-bold text-green-600"><?php echo $passed; ?></div>
                    <div class="text-sm text-gray-600">Passed</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold text-red-600"><?php echo $total - $passed; ?></div>
                    <div class="text-sm text-gray-600">Failed</div>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold text-blue-600"><?php echo $total; ?></div>
                    <div class="text-sm text-gray-600">Total</div>
                </div>
            </div>
        </div>

        <div class="space-y-4">
            <?php foreach ($tests as $test): ?>
            <div class="bg-white rounded-lg shadow p-4">
                <div class="flex items-center justify-between">
                    <h3 class="font-semibold"><?php echo htmlspecialchars($test['name']); ?></h3>
                    <span class="px-3 py-1 rounded-full text-sm font-medium <?php echo $test['status'] === 'PASS' ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800'; ?>">
                        <?php echo $test['status']; ?>
                    </span>
                </div>
                <p class="text-sm text-gray-600 mt-2"><?php echo htmlspecialchars($test['message']); ?></p>
            </div>
            <?php endforeach; ?>
        </div>

        <div class="mt-8 text-center">
            <a href="dashboard.php" class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700">
                Back to Dashboard
            </a>
        </div>
    </div>
</body>
</html>




