<?php
require_once '../includes/config.php';
require_once 'admin_auth.php';

$response = [
    'success' => false,
    'message' => '',
    'redirect' => 'sites.php'
];

$id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($id < 1) {
    $response['message'] = 'Geçersiz site ID sağlandı.';
} else {
    try {
        // Önce site bilgilerini al
        $stmt = $pdo->prepare('SELECT site_name, site_url FROM site_submissions WHERE id = ?');
        $stmt->execute([$id]);
        $site = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$site) {
            $response['message'] = 'Site bulunamadı.';
        } else {
            // Transaction başlat
            $pdo->beginTransaction();
            
            try {
                // Önce site_votes tablosundaki ilişkili kayıtları sil
                $stmt_votes = $pdo->prepare('DELETE FROM site_votes WHERE site_id = ?');
                $stmt_votes->execute([$id]);
                
                // Sonra site_submissions tablosundaki kaydı sil
                $stmt_site = $pdo->prepare('DELETE FROM site_submissions WHERE id = ?');
                if ($stmt_site->execute([$id])) {
                    // Transaction'ı commit et
                    $pdo->commit();
                    
                    $response['success'] = true;
                    $response['message'] = "Site '{$site['site_name']}' başarıyla silindi.";
                    $response['site_name'] = $site['site_name'];
                    $response['site_url'] = $site['site_url'];
                } else {
                    $pdo->rollback();
                    $response['message'] = 'Site silinirken hata oluştu.';
                }
            } catch (PDOException $e) {
                // Hata durumunda transaction'ı rollback et
                $pdo->rollback();
                $response['message'] = 'Veritabanı hatası: ' . $e->getMessage();
            }
        }
    } catch (PDOException $e) {
        $response['message'] = 'Veritabanı hatası: ' . $e->getMessage();
    }
}

// AJAX request ise JSON döndür
if (!empty($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) == 'xmlhttprequest') {
    header('Content-Type: application/json');
    echo json_encode($response);
    exit;
}

// Normal request ise HTML sayfası göster
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Deletion - Admin Panel</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet">
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'display': ['Plus Jakarta Sans', 'sans-serif']
                    },
                    colors: {
                        primary: '#13a4ec',
                        'background-light': '#f6f7f8',
                        'background-dark': '#101c22',
                    }
                }
            }
        }
    </script>
</head>
<body class="bg-background-light font-display min-h-screen flex items-center justify-center">
    <div class="bg-white rounded-lg shadow-lg p-8 max-w-md w-full mx-4">
        <?php if ($response['success']): ?>
            <!-- Success State -->
            <div class="text-center">
                <div class="mb-4">
                    <span class="material-symbols-outlined text-green-500 text-6xl">check_circle</span>
                </div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Site Deleted Successfully</h1>
                <p class="text-gray-600 mb-6"><?php echo htmlspecialchars($response['message']); ?></p>
                
                <div class="bg-gray-50 rounded-lg p-4 mb-6 text-left">
                    <h3 class="font-semibold text-gray-800 mb-2">Deleted Site Details:</h3>
                    <p class="text-sm text-gray-600">
                        <strong>Name:</strong> <?php echo htmlspecialchars($response['site_name']); ?><br>
                        <strong>URL:</strong> <?php echo htmlspecialchars($response['site_url']); ?>
                    </p>
                </div>
                
                <div class="flex gap-3">
                    <a href="sites.php" class="flex-1 bg-primary text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition-colors text-center">
                        <span class="material-symbols-outlined text-sm mr-1">arrow_back</span>
                        Back to Sites
                    </a>
                    <a href="dashboard.php" class="flex-1 bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition-colors text-center">
                        <span class="material-symbols-outlined text-sm mr-1">dashboard</span>
                        Dashboard
                    </a>
                </div>
            </div>
        <?php else: ?>
            <!-- Error State -->
            <div class="text-center">
                <div class="mb-4">
                    <span class="material-symbols-outlined text-red-500 text-6xl">error</span>
                </div>
                <h1 class="text-2xl font-bold text-gray-900 mb-2">Deletion Failed</h1>
                <p class="text-red-600 mb-6"><?php echo htmlspecialchars($response['message']); ?></p>
                
                <div class="flex gap-3">
                    <a href="sites.php" class="flex-1 bg-primary text-white px-4 py-2 rounded-lg hover:bg-blue-600 transition-colors text-center">
                        <span class="material-symbols-outlined text-sm mr-1">arrow_back</span>
                        Back to Sites
                    </a>
                    <a href="javascript:history.back()" class="flex-1 bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 transition-colors text-center">
                        <span class="material-symbols-outlined text-sm mr-1">refresh</span>
                        Try Again
                    </a>
                </div>
            </div>
        <?php endif; ?>
    </div>

    <!-- Auto redirect after success -->
    <?php if ($response['success']): ?>
    <script>
        // 3 saniye sonra otomatik olarak sites.php'ye yönlendir
        setTimeout(function() {
            window.location.href = 'sites.php';
        }, 3000);
        
        // Countdown göster
        let countdown = 3;
        const countdownElement = document.createElement('div');
        countdownElement.className = 'text-center mt-4 text-sm text-gray-500';
        countdownElement.innerHTML = `Redirecting in <span id="countdown">${countdown}</span> seconds...`;
        document.querySelector('.bg-white').appendChild(countdownElement);
        
        const timer = setInterval(function() {
            countdown--;
            document.getElementById('countdown').textContent = countdown;
            if (countdown <= 0) {
                clearInterval(timer);
            }
        }, 1000);
    </script>
    <?php endif; ?>
</body>
</html>


