<?php
require_once '../includes/config.php';
$id = isset($_POST['id']) ? intval($_POST['id']) : (isset($_GET['id']) ? intval($_GET['id']) : 0);
if ($id < 1) die('Geçersiz ID');
$stmt = $pdo->prepare('SELECT * FROM site_submissions WHERE id = ?');
$stmt->execute([$id]);
$site = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$site) die('Site bulunamadı');
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['site_name'] ?? '';
    $url = $_POST['site_url'] ?? '';
    $category = $_POST['category_id'] ?? '';
    $short = $_POST['short_description'] ?? '';
    $long = $_POST['long_description'] ?? '';
    $stmt = $pdo->prepare('UPDATE site_submissions SET site_name=?, site_url=?, category_id=?, short_description=?, long_description=? WHERE id=?');
    $stmt->execute([$name, $url, $category, $short, $long, $id]);
    $success = true;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <title>Site Düzenle</title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700;800&display=swap" rel="stylesheet"/>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
</head>
<body>
<div class="flex min-h-screen">
<main class="flex-1 p-10">
    <h1 class="text-3xl font-bold mb-6 text-primary">Site Düzenle</h1>
    <?php if (!empty($success)): ?>
        <div class="flex justify-center items-center min-h-[200px]">
            <div class="bg-green-100 border border-green-300 text-green-800 px-6 py-4 rounded-xl shadow-soft text-lg font-semibold text-center">
                <span class="material-symbols-outlined align-middle text-2xl mr-2" style="vertical-align:middle;">check_circle</span>
                Düzenleme başarılı! Yönlendiriliyorsunuz...
            </div>
        </div>
        <script>setTimeout(function(){ window.location.href='sites.php'; }, 2000);</script>
    <?php endif; ?>
    <form method="post" class="bg-surface p-6 rounded-xl border border-line-light shadow-soft max-w-xl mx-auto">
        <input type="hidden" name="id" value="<?php echo $id; ?>">
        <div class="mb-4">
            <label class="block mb-1 font-semibold text-text-secondary">Site Adı</label>
            <input name="site_name" value="<?php echo htmlspecialchars($site['site_name']); ?>" class="w-full px-4 py-2 rounded-lg border border-line-light focus:ring-2 focus:ring-primary" placeholder="Site Adı" required>
        </div>
        <div class="mb-4">
            <label class="block mb-1 font-semibold text-text-secondary">Kategori</label>
            <input name="category_id" value="<?php echo htmlspecialchars($site['category_id']); ?>" class="w-full px-4 py-2 rounded-lg border border-line-light focus:ring-2 focus:ring-primary" placeholder="Kategori" required>
        </div>
        <div class="mb-4">
            <label class="block mb-1 font-semibold text-text-secondary">Kısa Açıklama</label>
            <input name="short_description" value="<?php echo htmlspecialchars($site['short_description']); ?>" class="w-full px-4 py-2 rounded-lg border border-line-light focus:ring-2 focus:ring-primary" placeholder="Kısa Açıklama" required>
        </div>
        <div class="mb-4">
            <label class="block mb-1 font-semibold text-text-secondary">Uzun Açıklama</label>
            <textarea name="long_description" rows="4" class="w-full px-4 py-2 rounded-lg border border-line-light focus:ring-2 focus:ring-primary" placeholder="Uzun Açıklama" required><?php echo htmlspecialchars($site['long_description'] ?? ''); ?></textarea>
        </div>
        <div class="flex gap-4 mt-6">
            <button type="submit" class="bg-primary text-white font-bold py-3 px-6 rounded-lg hover:bg-primary/90 transition-colors flex items-center gap-2">
                <span class="material-symbols-outlined">save</span> Kaydet
            </button>
            <a href="sites.php" class="bg-gray-200 text-text-secondary font-bold py-3 px-6 rounded-lg hover:bg-gray-300 transition-colors flex items-center gap-2">
                <span class="material-symbols-outlined">arrow_back</span> Geri
            </a>
        </div>
    </form>
</main>
</div>
</body>
</html>


