<?php
include 'admin_auth.php';
include '../includes/config.php';

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: sites.php');
    exit();
}

$site_id = (int)$_GET['id'];
$errors = [];
$success = false;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $site_name = trim($_POST['site_name']);
    $site_url = trim($_POST['site_url']);
    $category_id = $_POST['category_id'];
    $short_description = trim($_POST['short_description']);
    $long_description = trim($_POST['long_description']);
    $contact_mail = trim($_POST['contact_mail']);
    
    if (empty($site_name)) {
        $errors[] = "Site adı gerekli.";
    }
    
    if (empty($site_url)) {
        $errors[] = "Site URL gerekli.";
    } elseif (!filter_var($site_url, FILTER_VALIDATE_URL)) {
        $errors[] = "Geçersiz URL formatı.";
    }
    
    if (empty($category_id) || !is_numeric($category_id)) {
        $errors[] = "Lütfen geçerli bir kategori seçin.";
    }
    
    if (!empty($contact_mail) && !filter_var($contact_mail, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Geçersiz e-posta formatı.";
    }
    
    $logo_update = "";
    $logo_filename = null;
    if (isset($_FILES['site_logo']) && $_FILES['site_logo']['error'] === UPLOAD_ERR_OK) {
        $allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
        $file_type = $_FILES['site_logo']['type'];
        
        if (!in_array($file_type, $allowed_types)) {
            $errors[] = "Geçersiz dosya türü. Sadece JPEG, PNG ve GIF dosyalarına izin verilir.";
        } elseif ($_FILES['site_logo']['size'] > 5 * 1024 * 1024) {
            $errors[] = "Dosya boyutu çok büyük. Maksimum 5MB izin verilir.";
        } else {
            $upload_dir = '../uploads/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0755, true);
            }
            
            $file_extension = pathinfo($_FILES['site_logo']['name'], PATHINFO_EXTENSION);
            $new_filename = 'site_logo_' . $site_id . '_' . time() . '.' . $file_extension;
            $upload_path = $upload_dir . $new_filename;
            
            if (move_uploaded_file($_FILES['site_logo']['tmp_name'], $upload_path)) {
                $logo_update = ", site_logo = ?";
                $logo_filename = $new_filename;
            } else {
                $errors[] = "Site logosu yüklenemedi.";
            }
        }
    }
    
    if (empty($errors)) {
        try {
            $sql = "UPDATE site_submissions SET site_name = ?, site_url = ?, category_id = ?, short_description = ?, long_description = ?, contact_mail = ?" . $logo_update . " WHERE id = ?";
            $params = [$site_name, $site_url, $category_id, $short_description, $long_description, $contact_mail];
            
            if ($logo_filename) {
                $params[] = $logo_filename;
            }
            
            $params[] = $site_id;
            
            $stmt = $pdo->prepare($sql);
            if ($stmt->execute($params)) {
                $success = true;
                header("refresh:2;url=sites.php");
            } else {
                $errors[] = "Site güncellenemedi.";
            }
        } catch (PDOException $e) {
            $errors[] = "Veritabanı hatası: " . $e->getMessage();
        }
    }
}

try {
    $stmt = $pdo->prepare("SELECT * FROM site_submissions WHERE id = ?");
    $stmt->execute([$site_id]);
    $site = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$site) {
        header('Location: sites.php');
        exit();
    }
} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

try {
    $categories = $pdo->query('SELECT id, name FROM categories ORDER BY name ASC')->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Düzenle - Admin Panel</title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet"/>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet"/>
    <style>
        body { font-family: 'Inter', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .card { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen bg-gray-50">
        <div class="gradient-bg text-white p-8">
            <div class="max-w-4xl mx-auto">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-4">
                        <a href="sites.php" class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center hover:bg-white/30 transition-all duration-200">
                            <span class="material-symbols-outlined">arrow_back</span>
                        </a>
                        <div>
                            <h1 class="text-3xl font-bold">Site Düzenle</h1>
                            <p class="text-white/80 mt-1">Site bilgilerini güncelle</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        <a href="site_view.php?id=<?php echo $site['id']; ?>" class="bg-white/20 hover:bg-white/30 px-4 py-2 rounded-xl transition-all duration-200 flex items-center gap-2">
                            <span class="material-symbols-outlined text-lg">visibility</span>
                            Detayları Görüntüle
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <div class="max-w-4xl mx-auto p-8 -mt-4">
            <?php if ($success): ?>
            <div class="mb-6 bg-green-50 border border-green-200 rounded-xl p-4">
                <div class="flex items-center gap-3">
                    <span class="material-symbols-outlined text-green-600 text-2xl">check_circle</span>
                    <div>
                        <h3 class="text-green-800 font-semibold">Site Başarıyla Güncellendi!</h3>
                        <p class="text-green-700 text-sm">Site listesine yönlendiriliyor...</p>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <?php if (!empty($errors)): ?>
            <div class="mb-6 bg-red-50 border border-red-200 rounded-xl p-4">
                <div class="flex items-start gap-3">
                    <span class="material-symbols-outlined text-red-600 text-2xl">error</span>
                    <div>
                        <h3 class="text-red-800 font-semibold mb-2">Lütfen aşağıdaki hataları düzeltin:</h3>
                        <ul class="text-red-700 text-sm space-y-1">
                            <?php foreach ($errors as $error): ?>
                            <li>• <?php echo htmlspecialchars($error); ?></li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="card rounded-2xl shadow-xl">
                <div class="p-8 border-b border-gray-200">
                    <h2 class="text-2xl font-bold text-gray-800 flex items-center gap-3">
                        <span class="material-symbols-outlined text-3xl text-blue-600">edit</span>
                        Site Bilgileri
                    </h2>
                    <p class="text-gray-600 mt-1">Aşağıdaki site detaylarını güncelleyin</p>
                </div>
                
                <form method="POST" enctype="multipart/form-data" class="p-8">
                    <div class="space-y-8">
                        <div class="bg-gray-50 rounded-xl p-6">
                            <h3 class="text-lg font-semibold text-gray-800 mb-4 flex items-center gap-2">
                                <span class="material-symbols-outlined text-xl text-purple-600">image</span>
                                Site Logosu
                            </h3>
                            
                            <div class="mb-4">
                                <label class="block text-sm font-medium text-gray-700 mb-2">Mevcut Logo</label>
                                <div class="flex items-center gap-4">
                                    <?php if (!empty($site['site_logo'])): ?>
                                        <?php
                                        $logo_path = $site['site_logo'];
                                        
                                        // Clean up any existing full URLs
                                        $logo_path = str_replace('https://usasportstvs.com/uploads/', '', $logo_path);
                                        $logo_path = str_replace('https://usasportstvs.com/', '', $logo_path);
                                        
                                        // Remove /admin/uploads/ prefix if exists
                                        if (str_starts_with($logo_path, '/admin/uploads/')) {
                                            $logo_path = str_replace('/admin/uploads/', '', $logo_path);
                                        }
                                        
                                        // Remove admin/uploads/ prefix if exists
                                        if (str_starts_with($logo_path, 'admin/uploads/')) {
                                            $logo_path = str_replace('admin/uploads/', '', $logo_path);
                                        }
                                        
                                        // Remove uploads/ prefix if exists
                                        if (str_starts_with($logo_path, 'uploads/')) {
                                            $logo_path = str_replace('uploads/', '', $logo_path);
                                        }
                                        
                                        // Remove /uploads/ prefix if exists
                                        if (str_starts_with($logo_path, '/uploads/')) {
                                            $logo_path = str_replace('/uploads/', '', $logo_path);
                                        }
                                        
                                        // Now add the correct relative path
                                        $logo_path = '../uploads/' . $logo_path;
                                        ?>
                                        <img src="<?php echo htmlspecialchars($logo_path); ?>" 
                                             alt="Site Logo" class="w-20 h-20 rounded-xl object-cover border-2 border-gray-200">
                                        <div>
                                            <p class="text-sm font-medium text-gray-700">Logo ayarlandı</p>
                                            <p class="text-xs text-gray-500">Değiştirmek için yeni bir tane yükleyin</p>
                                        </div>
                                    <?php else: ?>
                                        <div class="w-20 h-20 rounded-xl bg-gray-200 flex items-center justify-center border-2 border-gray-300">
                                            <span class="material-symbols-outlined text-gray-400 text-3xl">image</span>
                                        </div>
                                        <div>
                                            <p class="text-sm font-medium text-gray-700">Logo yüklenmedi</p>
                                            <p class="text-xs text-gray-500">Aşağıdan bir resim yükleyin</p>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div>
                                <label class="block text-sm font-medium text-gray-700 mb-2">Yeni Logo Yükle (İsteğe Bağlı)</label>
                                <input type="file" name="site_logo" accept="image/*" 
                                       class="block w-full text-sm text-gray-500 file:mr-4 file:py-3 file:px-6 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-blue-50 file:text-blue-700 hover:file:bg-blue-100 cursor-pointer">
                                <p class="text-xs text-gray-500 mt-2">Maksimum dosya boyutu: 5MB. Desteklenen formatlar: JPEG, PNG, GIF</p>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Site Adı *</label>
                                <input type="text" name="site_name" required 
                                       value="<?php echo htmlspecialchars($site['site_name']); ?>"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200"
                                       placeholder="Site adını girin">
                            </div>

                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Site URL *</label>
                                <input type="url" name="site_url" required 
                                       value="<?php echo htmlspecialchars($site['site_url']); ?>"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200"
                                       placeholder="https://example.com">
                            </div>
                        </div>

                        <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Kategori *</label>
                                <select name="category_id" required 
                                        class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200">
                                    <option value="">Kategori seçin</option>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?php echo $category['id']; ?>" 
                                                <?php echo ($site['category_id'] == $category['id']) ? 'selected' : ''; ?>>
                                            <?php echo htmlspecialchars($category['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">İletişim E-postası</label>
                                <input type="email" name="contact_mail" 
                                       value="<?php echo htmlspecialchars($site['contact_mail'] ?? ''); ?>"
                                       class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200"
                                       placeholder="contact@example.com">
                            </div>
                        </div>

                        <div class="space-y-6">
                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Kısa Açıklama</label>
                                <textarea name="short_description" rows="3" 
                                          class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200 resize-none"
                                          placeholder="Site hakkında kısa açıklama..."><?php echo htmlspecialchars($site['short_description'] ?? ''); ?></textarea>
                                <p class="text-xs text-gray-500 mt-1">Listelerde görüntülenecek kısa özet</p>
                            </div>

                            <div>
                                <label class="block text-sm font-semibold text-gray-700 mb-2">Uzun Açıklama</label>
                                <textarea name="long_description" rows="6" 
                                          class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:ring-2 focus:ring-blue-500 focus:border-transparent transition-all duration-200 resize-none"
                                          placeholder="Site hakkında detaylı açıklama..."><?php echo htmlspecialchars($site['long_description'] ?? ''); ?></textarea>
                                <p class="text-xs text-gray-500 mt-1">Site ve özellikleri hakkında detaylı bilgi</p>
                            </div>
                        </div>

                        <div class="flex items-center justify-between pt-8 border-t border-gray-200">
                            <a href="sites.php" class="text-gray-600 hover:text-gray-800 flex items-center gap-2 transition-colors duration-200">
                                <span class="material-symbols-outlined">arrow_back</span>
                                <span class="font-medium">Sitelere Dön</span>
                            </a>
                            
                            <div class="flex items-center gap-4">
                                <a href="site_view.php?id=<?php echo $site['id']; ?>" class="bg-gray-100 hover:bg-gray-200 text-gray-700 px-6 py-3 rounded-xl transition-all duration-200 flex items-center gap-2 font-medium">
                                    <span class="material-symbols-outlined">visibility</span>
                                    Önizleme
                                </a>
                                <button type="submit" class="bg-blue-600 hover:bg-blue-700 text-white px-8 py-3 rounded-xl transition-all duration-200 flex items-center gap-2 font-medium shadow-lg">
                                    <span class="material-symbols-outlined">save</span>
                                    Siteyi Güncelle
                                </button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</body>
</html>


