<?php
include 'admin_auth.php';
include '../includes/config.php';

// GET parametresinden site ID'sini al
$site_id = isset($_GET['id']) ? intval($_GET['id']) : 0;

if ($site_id <= 0) {
    header('Location: sites.php');
    exit;
}

try {
    // Site bilgilerini al (kategorisiyle birlikte)
    $stmt = $pdo->prepare("SELECT s.*, c.name as category_name, u.username as owner_username 
                          FROM site_submissions s 
                          LEFT JOIN categories c ON s.category_id = c.id 
                          LEFT JOIN user u ON s.user_id = u.id 
                          WHERE s.id = ?");
    $stmt->execute([$site_id]);
    $site = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$site) {
        header('Location: sites.php');
        exit;
    }
    
    // Site oy sayısını al
    $stmt = $pdo->prepare("SELECT COUNT(*) as vote_count FROM site_votes WHERE site_id = ?");
    $stmt->execute([$site_id]);
    $vote_data = $stmt->fetch(PDO::FETCH_ASSOC);
    $vote_count = $vote_data['vote_count'] ?? 0;
    
} catch (PDOException $e) {
    die("Veritabanı hatası: " . $e->getMessage());
}

// Slug oluşturma fonksiyonu
function createSlug($text) {
    $text = strtolower($text);
    $text = preg_replace('/[^a-z0-9\s-]/', '', $text);
    $text = preg_replace('/[\s-]+/', '-', $text);
    $text = trim($text, '-');
    return $text;
}

// Eğer slug yoksa, site adından oluştur
if (empty($site['slug'])) {
    $site['slug'] = createSlug($site['site_name']);
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Site Görüntüle - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/tailwindcss@2.2.19/dist/tailwind.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    typography: {
                        DEFAULT: {
                            css: {
                                maxWidth: 'none',
                                color: '#374151',
                                a: {
                                    color: '#3B82F6',
                                    textDecoration: 'underline',
                                },
                                strong: {
                                    fontWeight: '600',
                                },
                                code: {
                                    backgroundColor: '#F3F4F6',
                                    padding: '0.125rem 0.25rem',
                                    borderRadius: '0.25rem',
                                    fontSize: '0.875em',
                                },
                            },
                        },
                    },
                },
            },
        }
    </script>
    <style>
        body { font-family: 'Inter', sans-serif; }
        .gradient-bg { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); }
        .card { background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen bg-gray-50">
        <!-- Header -->
        <div class="gradient-bg text-white p-6">
            <div class="max-w-7xl mx-auto">
                <div class="flex items-center justify-between">
                    <div class="flex items-center gap-4">
                        <a href="sites.php" class="w-10 h-10 rounded-full bg-white/20 flex items-center justify-center hover:bg-white/30 transition-all duration-200">
                            <span class="material-symbols-outlined">arrow_back</span>
                        </a>
                        <div>
                            <h1 class="text-3xl font-bold"><?php echo htmlspecialchars($site['site_name']); ?></h1>
                            <p class="text-white/80 mt-1">Site Detayları ve Bilgileri</p>
                        </div>
                    </div>
                    <div class="flex items-center gap-3">
                        <a href="site_edit_form.php?id=<?php echo $site['id']; ?>" class="bg-white/20 hover:bg-white/30 px-4 py-2 rounded-xl transition-all duration-200 flex items-center gap-2">
                            <span class="material-symbols-outlined text-lg">edit</span>
                            Site Düzenle
                        </a>
                        <a href="/site/<?php echo htmlspecialchars($site['slug']); ?>" target="_blank" class="bg-white/20 hover:bg-white/30 px-4 py-2 rounded-xl transition-all duration-200 flex items-center gap-2">
                            <span class="material-symbols-outlined text-lg">open_in_new</span>
                            Canlı Görüntüle
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Status Messages -->
        <?php if (isset($_GET['success'])): ?>
            <div class="max-w-7xl mx-auto px-6 pt-4">
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded-lg" role="alert">
                    <span class="block sm:inline">
                        <?php 
                        switch($_GET['success']) {
                            case 'status_updated':
                                $status_text = isset($_GET['status']) ? ucfirst($_GET['status']) : 'updated';
                                echo "Site durumu başarıyla güncellendi: " . htmlspecialchars($status_text);
                                break;
                            default:
                                echo "İşlem başarıyla tamamlandı.";
                        }
                        ?>
                    </span>
                </div>
            </div>
        <?php endif; ?>
        
        <?php if (isset($_GET['error'])): ?>
            <div class="max-w-7xl mx-auto px-6 pt-4">
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded-lg" role="alert">
                    <span class="block sm:inline">
                        <?php 
                        switch($_GET['error']) {
                            case 'invalid_parameters':
                                echo "Geçersiz parametreler sağlandı.";
                                break;
                            case 'update_failed':
                                echo "Site durumu güncellenemedi.";
                                break;
                            case 'database_error':
                                echo "Veritabanı hatası oluştu.";
                                break;
                            default:
                                echo "Bir hata oluştu.";
                        }
                        ?>
                    </span>
                </div>
            </div>
        <?php endif; ?>

        <!-- Content -->
        <div class="max-w-7xl mx-auto p-6 -mt-6">
            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                <!-- Site Information -->
                <div class="lg:col-span-2">
                    <div class="card rounded-2xl shadow-xl p-8">
                        <h2 class="text-2xl font-bold text-gray-800 mb-6 flex items-center gap-3">
                            <span class="material-symbols-outlined text-3xl text-blue-600">info</span>
                            Site Bilgileri
                        </h2>
                        
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-semibold text-gray-600 mb-1">Site Adı</label>
                                    <p class="text-lg text-gray-800"><?php echo htmlspecialchars($site['site_name']); ?></p>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-600 mb-1">URL</label>
                                    <a href="<?php echo htmlspecialchars($site['site_url']); ?>" target="_blank" class="text-blue-600 hover:text-blue-800 text-lg break-all">
                                        <?php echo htmlspecialchars($site['site_url']); ?>
                                    </a>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-600 mb-1">Kategori</label>
                                    <p class="text-lg text-gray-800"><?php echo htmlspecialchars($site['category_name'] ?? 'Uncategorized'); ?></p>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-600 mb-1">Sahip</label>
                                    <p class="text-lg text-gray-800"><?php echo htmlspecialchars($site['username'] ?? 'Unknown'); ?></p>
                                </div>
                            </div>
                            
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-semibold text-gray-600 mb-1">Durum</label>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium <?php echo $site['status'] == 'approved' ? 'bg-green-100 text-green-800' : ($site['status'] == 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-red-100 text-red-800'); ?>">
                                        <?php echo ucfirst($site['status']); ?>
                                    </span>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-600 mb-1">Toplam Oylar</label>
                                    <div class="flex items-center gap-2">
                                        <span class="material-symbols-outlined text-green-600">thumb_up</span>
                                        <p class="text-lg font-semibold text-gray-800"><?php echo $vote_count; ?></p>
                                    </div>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-600 mb-1">Gönderim Tarihi</label>
                                    <p class="text-lg text-gray-800"><?php echo date('F j, Y', strtotime($site['olusturulma_tarihi'])); ?></p>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-600 mb-1">Site ID</label>
                                    <p class="text-lg text-gray-800 font-mono">#<?php echo $site['id']; ?></p>
                                </div>
                            </div>
                        </div>
                        
                        <?php if (!empty($site['short_description'])): ?>
                        <div class="mt-6 pt-6 border-t">
                            <label class="block text-sm font-semibold text-gray-600 mb-2">Kısa Açıklama</label>
                            <div class="bg-gray-50 rounded-xl p-4">
                                <p class="text-gray-700 leading-relaxed"><?php echo nl2br(htmlspecialchars($site['short_description'])); ?></p>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <?php if (!empty($site['long_description'])): ?>
                        <div class="mt-4">
                            <label class="block text-sm font-semibold text-gray-600 mb-2">Uzun Açıklama</label>
                            <div class="bg-gray-50 rounded-xl p-4">
                                <div class="text-gray-700 leading-relaxed prose prose-gray max-w-none">
                                    <?php 
                                    // HTML'i aktif göster ama güvenli hale getir
                                    $allowed_tags = '<p><br><strong><b><em><i><u><a><ul><ol><li><h1><h2><h3><h4><h5><h6><blockquote><code><pre>';
                                    echo strip_tags($site['long_description'], $allowed_tags); 
                                    ?>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Site Logo & Actions -->
                <div class="space-y-6">
                    <!-- Site Logo -->
                    <div class="card rounded-2xl shadow-xl p-6">
                        <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center gap-2">
                            <span class="material-symbols-outlined text-2xl text-purple-600">image</span>
                            Site Logosu
                        </h3>
                        <div class="flex items-center justify-center">
                            <?php if (!empty($site['site_logo'])): ?>
                                <?php
                                $logo_path = $site['site_logo'];
                                
                                // Clean up any existing full URLs
                                require_once '../utils/url_helper.php';
                                $logo_src = URLHelper::getLogoURL($site);
                                ?>
                                <div class="text-center">
                                    <img src="<?php echo htmlspecialchars($logo_src); ?>" alt="Site Logo" class="max-w-full h-32 object-contain rounded-lg border mx-auto">
                                    <p class="text-xs text-gray-500 mt-2">Path: <?php echo htmlspecialchars($logo_src); ?></p>
                                    <p class="text-xs text-gray-500">Original: <?php echo htmlspecialchars($site['site_logo']); ?></p>
                                </div>
                            <?php else: ?>
                                <div class="w-32 h-32 bg-gray-200 rounded-lg flex items-center justify-center">
                                    <span class="material-symbols-outlined text-4xl text-gray-400">image</span>
                                </div>
                                <p class="text-gray-500 text-sm mt-2">Logo yüklenmedi</p>
                            <?php endif; ?>
                        </div>
                    </div>
                    
                    <!-- Quick Actions -->
                    <div class="card rounded-2xl shadow-xl p-6">
                        <h3 class="text-xl font-bold text-gray-800 mb-4 flex items-center gap-2">
                            <span class="material-symbols-outlined text-2xl text-orange-600">settings</span>
                            Hızlı İşlemler
                        </h3>
                        <div class="space-y-3">
                            <a href="site_edit_form.php?id=<?php echo $site['id']; ?>" class="w-full bg-blue-100 hover:bg-blue-200 text-blue-700 py-3 px-4 rounded-xl transition-all duration-200 flex items-center gap-3">
                                <span class="material-symbols-outlined">edit</span>
                                Site Detaylarını Düzenle
                            </a>
                            <a href="/site/<?php echo htmlspecialchars($site['slug']); ?>" target="_blank" class="w-full bg-green-100 hover:bg-green-200 text-green-700 py-3 px-4 rounded-xl transition-all duration-200 flex items-center gap-3">
                                <span class="material-symbols-outlined">open_in_new</span>
                                Canlı Siteyi Görüntüle
                            </a>
                            <a href="update_site_status.php?id=<?php echo $site['id']; ?>&status=<?php echo $site['status'] == 'approved' ? 'pending' : 'approved'; ?>&redirect=site_view.php?id=<?php echo $site['id']; ?>" class="w-full bg-yellow-100 hover:bg-yellow-200 text-yellow-700 py-3 px-4 rounded-xl transition-all duration-200 flex items-center gap-3">
                                <span class="material-symbols-outlined"><?php echo $site['status'] == 'approved' ? 'pause' : 'play_arrow'; ?></span>
                                <?php echo $site['status'] == 'approved' ? 'Beklemede Olarak Ayarla' : 'Siteyi Onayla'; ?>
                            </a>
                            <a href="site_delete.php?id=<?php echo $site['id']; ?>" onclick="return confirm('Bu siteyi silmek istediğinizden emin misiniz? Bu işlem geri alınamaz.');" class="w-full bg-red-100 hover:bg-red-200 text-red-700 py-3 px-4 rounded-xl transition-all duration-200 flex items-center gap-3">
                                <span class="material-symbols-outlined">delete</span>
                                Siteyi Sil
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>


