<!DOCTYPE html>
<html>
<head>
    <title>Test Admin Status Update</title>
</head>
<body>
    <h2>Test Status Update</h2>
    <button onclick="testApprove()">Test Approve</button>
    <button onclick="testReject()">Test Reject</button>
    <div id="result"></div>

    <script>
    function testApprove() {
        testStatus(1, 'approved');
    }
    
    function testReject() {
        testStatus(1, 'rejected');
    }
    
    function testStatus(siteId, status) {
        document.getElementById('result').innerHTML = 'Testing...';
        
        fetch('debug_update.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'site_id=' + siteId + '&status=' + status
        })
        .then(response => response.text())
        .then(text => {
            document.getElementById('result').innerHTML = '<h3>Raw Response:</h3><pre>' + text + '</pre>';
            try {
                const data = JSON.parse(text);
                document.getElementById('result').innerHTML += '<h3>Parsed JSON:</h3><pre>' + JSON.stringify(data, null, 2) + '</pre>';
            } catch (e) {
                document.getElementById('result').innerHTML += '<h3>JSON Parse Error:</h3><pre>' + e.message + '</pre>';
            }
        })
        .catch(error => {
            document.getElementById('result').innerHTML = '<h3>Error:</h3><pre>' + error.message + '</pre>';
        });
    }
    </script>
</body>
</html>

