<?php
// update_site_status.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once '../includes/config.php';

// Admin authentication check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit;
}

// POST request only
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    $site_id = isset($_POST['site_id']) ? intval($_POST['site_id']) : 0;
    $status = isset($_POST['status']) ? trim($_POST['status']) : '';

    if ($site_id < 1 || !in_array($status, ['pending', 'approved', 'rejected'])) {
        header('Location: sites.php');
        exit;
    }

    try {
        // Check if site exists
        $stmt = $pdo->prepare('SELECT id, status, site_name FROM site_submissions WHERE id = ?');
        $stmt->execute([$site_id]);
        $site = $stmt->fetch();
        
        if (!$site) {
            header('Location: sites.php');
            exit;
        }
        
        // Update status
        $stmt = $pdo->prepare('UPDATE site_submissions SET status = ? WHERE id = ?');
        if ($stmt->execute([$status, $site_id])) {
            
            // Site onaylandığında sites tablosuna ekle
            if ($status === 'approved') {
                try {
                    // Site bilgilerini al
                    $stmt = $pdo->prepare('SELECT * FROM site_submissions WHERE id = ?');
                    $stmt->execute([$site_id]);
                    $submission = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    if ($submission) {
                        // Sites tablosuna ekle
                        $insertStmt = $pdo->prepare('
                            INSERT INTO sites (name, url, description, category_id, contact_email, logo_url, user_id, created_at, updated_at, status) 
                            VALUES (?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), "active")
                            ON DUPLICATE KEY UPDATE 
                            name = VALUES(name), 
                            description = VALUES(description), 
                            updated_at = NOW()
                        ');
                        
                        $insertStmt->execute([
                            $submission['site_name'],
                            $submission['site_url'],
                            $submission['long_description'] ?: $submission['short_description'],
                            $submission['category_id'],
                            $submission['contact_mail'],
                            $submission['site_logo'],
                            $submission['user_id']
                        ]);
                    }
                } catch (PDOException $e) {
                    // Sites tablosu yoksa veya farklı yapıdaysa ignore et
                    error_log("Sites table insert failed: " . $e->getMessage());
                }
            }
            
            // Site reddedildiğinde sites tablosundan kaldır
            if ($status === 'rejected') {
                try {
                    $stmt = $pdo->prepare('SELECT site_url FROM site_submissions WHERE id = ?');
                    $stmt->execute([$site_id]);
                    $submission = $stmt->fetch();
                    
                    if ($submission) {
                        $deleteStmt = $pdo->prepare('DELETE FROM sites WHERE url = ?');
                        $deleteStmt->execute([$submission['site_url']]);
                    }
                } catch (PDOException $e) {
                    error_log("Sites table delete failed: " . $e->getMessage());
                }
            }
        }
        
    } catch (PDOException $e) {
        error_log("Database error: " . $e->getMessage());
    }
    
    // Redirect back to sites page
    header('Location: sites.php');
    exit;
}

// GET request (direct links)
if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $site_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
    $status = isset($_GET['status']) ? $_GET['status'] : '';

    if ($site_id < 1 || !in_array($status, ['pending', 'approved', 'rejected'])) {
        header('Location: sites.php');
        exit;
    }

    try {
        // Update status
        $stmt = $pdo->prepare('UPDATE site_submissions SET status = ? WHERE id = ?');
        $stmt->execute([$status, $site_id]);
        
    } catch (PDOException $e) {
        error_log("Database error: " . $e->getMessage());
    }
    
    // Redirect back to sites page
    header('Location: sites.php');
    exit;
}

// Default redirect
header('Location: sites.php');
exit;
?>

