<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include '../includes/config.php';

// Admin kontrolü
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header('Location: login.php');
    exit();
}

// Kullanıcı ID kontrolü
if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    header('Location: users.php');
    exit();
}

$user_id = (int)$_GET['id'];

// Kullanıcı bilgilerini çek
$stmt = $pdo->prepare("SELECT * FROM user WHERE id = ?");
$stmt->execute([$user_id]);
$user = $stmt->fetch();

if (!$user) {
    header('Location: users.php?error=Kullanıcı bulunamadı');
    exit();
}

// Kullanıcının sitelerini çek
$stmt = $pdo->prepare("SELECT * FROM site_submissions WHERE username = (SELECT username FROM user WHERE id = ?) ORDER BY olusturulma_tarihi DESC");
$stmt->execute([$user_id]);
$user_sites = $stmt->fetchAll();

// Kullanıcının oylarını çek
$stmt = $pdo->prepare("SELECT COUNT(*) as vote_count FROM site_votes WHERE user_id = ?");
$stmt->execute([$user_id]);
$vote_count = $stmt->fetch()['vote_count'];
?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kullanıcı Detayları - Admin Panel</title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Manrope:wght@400;500;600;700;800&amp;display=swap" rel="stylesheet"/>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet"/>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    colors: {
                        primary: "#1877f2",
                        "primary-light": "#e7f3ff",
                        background: "#f0f2f5",
                        surface: "#ffffff",
                        "text-primary": "#1c1e21",
                        "text-secondary": "#606770",
                        "line-light": "#e0e0e0",
                    },
                    fontFamily: {
                        display: ["Manrope", "sans-serif"],
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        'soft': '0 4px 12px 0 rgb(0 0 0 / 0.07)',
                        'subtle': '0 1px 2px 0 rgb(0 0 0 / 0.05)',
                    }
                },
            },
        };
    </script>
    <style>
        .material-symbols-outlined {
            font-variation-settings: "FILL" 0, "wght" 400, "GRAD" 0, "opsz" 24;
        }
        .active .material-symbols-outlined {
            font-variation-settings: 'FILL' 1;
        }
    </style>
</head>
<body class="bg-background font-display text-text-primary">
<div class="flex min-h-screen">
<?php include 'menu.php'; ?>
<main class="flex-1 p-10">
    <div class="max-w-4xl mx-auto">
            <!-- Header -->
            <div class="flex items-center justify-between mb-6">
                <div>
                    <h1 class="text-2xl font-bold text-gray-800">Kullanıcı Detayları</h1>
                    <p class="text-gray-600">Kullanıcı bilgilerini ve aktivitelerini görüntüleyin</p>
                </div>
                <a href="users.php" class="bg-gray-500 text-white px-4 py-2 rounded-lg hover:bg-gray-600 flex items-center gap-2">
                    <span class="material-symbols-outlined">arrow_back</span>
                    Kullanıcılara Dön
                </a>
            </div>

            <div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <!-- User Info Card -->
                <div class="lg:col-span-2 bg-white rounded-lg shadow-sm border p-6">
                    <h2 class="text-xl font-semibold text-gray-800 mb-4">Kullanıcı Bilgileri</h2>
                    
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-1">Kullanıcı Adı</label>
                            <p class="text-gray-800"><?php echo htmlspecialchars($user['username']); ?></p>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-1">E-posta</label>
                            <p class="text-gray-800"><?php echo htmlspecialchars($user['email']); ?></p>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-1">Rol</label>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium <?php echo $user['role'] === 'admin' ? 'bg-purple-100 text-purple-800' : 'bg-blue-100 text-blue-800'; ?>">
                                <?php echo ucfirst($user['role']); ?>
                            </span>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-1">Kayıt Tarihi</label>
                            <p class="text-gray-800"><?php echo date('d.m.Y H:i', strtotime($user['kayit_tarihi'])); ?></p>
                        </div>
                        
                        <div>
                            <label class="block text-sm font-medium text-gray-600 mb-1">IP Adresi</label>
                            <p class="text-gray-800"><?php echo htmlspecialchars($user['ip'] ?? 'N/A'); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Profile Photo & Stats -->
                <div class="space-y-6">
                    <!-- Profile Photo -->
                    <div class="bg-white rounded-lg shadow-sm border p-6 text-center">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">Profil Fotoğrafı</h3>
                        <div class="flex justify-center mb-4">
                            <?php if (!empty($user['profile_photo'])): ?>
                                <?php
                                // Profil fotoğrafı yolunu düzenle
                                $photo_path = $user['profile_photo'];
                                // Eğer yol uploads/ ile başlamıyorsa, ../uploads/ ekle
                                if (!str_starts_with($photo_path, 'uploads/') && !str_starts_with($photo_path, '../uploads/')) {
                                    $photo_path = '../uploads/' . $photo_path;
                                }
                                // Eğer uploads/uploads/ gibi çift yol varsa düzelt
                                $photo_path = str_replace('uploads/uploads/', 'uploads/', $photo_path);
                                $photo_path = str_replace('../uploads/uploads/', '../uploads/', $photo_path);
                                ?>
                                <img src="<?php echo htmlspecialchars($photo_path); ?>" 
                                     alt="Profile Photo" class="w-24 h-24 rounded-full object-cover border-4 border-gray-200">
                            <?php else: ?>
                                <div class="w-24 h-24 rounded-full bg-gray-300 flex items-center justify-center border-4 border-gray-200">
                                    <span class="material-symbols-outlined text-gray-500 text-3xl">person</span>
                                </div>
                            <?php endif; ?>
                        </div>
                        <p class="text-sm text-gray-600">
                            <?php echo !empty($user['profile_photo']) ? 'Fotoğraf yüklendi' : 'Fotoğraf yüklenmedi'; ?>
                        </p>
                    </div>

                    <!-- Stats -->
                    <div class="bg-white rounded-lg shadow-sm border p-6">
                        <h3 class="text-lg font-semibold text-gray-800 mb-4">İstatistikler</h3>
                        <div class="space-y-3">
                            <div class="flex justify-between">
                                <span class="text-gray-600">Gönderilen Siteler:</span>
                                <span class="font-semibold text-gray-800"><?php echo count($user_sites); ?></span>
                            </div>
                            <div class="flex justify-between">
                                <span class="text-gray-600">Verilen Oylar:</span>
                                <span class="font-semibold text-gray-800"><?php echo $vote_count; ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- User Sites -->
            <?php if (!empty($user_sites)): ?>
            <div class="mt-8 bg-white rounded-lg shadow-sm border">
                <div class="p-6 border-b">
                    <h2 class="text-xl font-semibold text-gray-800">Gönderilen Siteler</h2>
                    <p class="text-gray-600">Bu kullanıcı tarafından gönderilen siteler</p>
                </div>
                
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="text-left p-4 font-medium text-gray-600">Site</th>
                                <th class="text-left p-4 font-medium text-gray-600">Category</th>
                                <th class="text-left p-4 font-medium text-gray-600">Status</th>
                                <th class="text-left p-4 font-medium text-gray-600">Votes</th>
                                <th class="text-left p-4 font-medium text-gray-600">Submitted</th>
                                <th class="text-left p-4 font-medium text-gray-600">Actions</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y">
                            <?php foreach ($user_sites as $site): ?>
                            <?php
                            // Site votes count
                            $stmt = $pdo->prepare("SELECT COUNT(*) as vote_count FROM site_votes WHERE site_id = ?");
                            $stmt->execute([$site['id']]);
                            $site_votes = $stmt->fetch()['vote_count'];
                            
                            // Category name
                            $stmt = $pdo->prepare("SELECT name FROM categories WHERE id = ?");
                            $stmt->execute([$site['category_id']]);
                            $category = $stmt->fetch();
                            ?>
                            <tr class="hover:bg-gray-50">
                                <td class="p-4">
                                    <div class="flex items-center gap-3">
                                        <?php if (!empty($site['site_logo'])): ?>
                                            <?php
                                            $site_logo_path = $site['site_logo'];
                                            
                                            // Clean up any existing full URLs
                                            $site_logo_path = str_replace('https://usasportstvs.com/uploads/', '', $site_logo_path);
                                            $site_logo_path = str_replace('https://usasportstvs.com/', '', $site_logo_path);
                                            
                                            // Remove admin/uploads/ prefix if exists
                                            if (str_starts_with($site_logo_path, 'admin/uploads/')) {
                                                $site_logo_path = str_replace('admin/uploads/', '', $site_logo_path);
                                            }
                                            
                                            // Remove /admin/uploads/ prefix if exists
                                            if (str_starts_with($site_logo_path, '/admin/uploads/')) {
                                                $site_logo_path = str_replace('/admin/uploads/', '', $site_logo_path);
                                            }
                                            
                                            // Remove uploads/ prefix if exists
                                            if (str_starts_with($site_logo_path, 'uploads/')) {
                                                $site_logo_path = str_replace('uploads/', '', $site_logo_path);
                                            }
                                            
                                            // Remove /uploads/ prefix if exists
                                            if (str_starts_with($site_logo_path, '/uploads/')) {
                                                $site_logo_path = str_replace('/uploads/', '', $site_logo_path);
                                            }
                                            
                                            // Create correct path for user_view.php (../uploads/ prefix)
                                            $site_logo_path = '../uploads/' . $site_logo_path;
                                            ?>
                                            <img src="<?php echo htmlspecialchars($site_logo_path); ?>" 
                                                 alt="Logo" class="w-8 h-8 rounded object-cover">
                                        <?php else: ?>
                                            <div class="w-8 h-8 rounded bg-gray-200 flex items-center justify-center">
                                                <span class="material-symbols-outlined text-gray-500 text-sm">language</span>
                                            </div>
                                        <?php endif; ?>
                                        <div>
                                            <p class="font-medium text-gray-800"><?php echo htmlspecialchars($site['site_name']); ?></p>
                                            <p class="text-sm text-gray-500"><?php echo htmlspecialchars($site['site_url']); ?></p>
                                        </div>
                                    </div>
                                </td>
                                <td class="p-4">
                                    <span class="text-gray-600"><?php echo htmlspecialchars($category['name'] ?? 'Unknown'); ?></span>
                                </td>
                                <td class="p-4">
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium 
                                        <?php echo $site['status'] === 'approved' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800'; ?>">
                                        <?php echo ucfirst($site['status']); ?>
                                    </span>
                                </td>
                                <td class="p-4">
                                    <span class="text-gray-800 font-medium"><?php echo $site_votes; ?></span>
                                </td>
                                <td class="p-4">
                                    <span class="text-gray-600"><?php echo date('d.m.Y', strtotime($site['olusturulma_tarihi'])); ?></span>
                                </td>
                                <td class="p-4">
                                    <a href="site_view.php?id=<?php echo $site['id']; ?>" class="text-blue-600 hover:text-blue-800">
                                        <span class="material-symbols-outlined text-lg">visibility</span>
                                    </a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php endif; ?>

            <!-- Action Buttons -->
            <div class="mt-8 flex gap-4">
                <a href="user_edit.php?id=<?php echo $user['id']; ?>" 
                   class="bg-blue-600 text-white px-6 py-2 rounded-lg hover:bg-blue-700 flex items-center gap-2">
                    <span class="material-symbols-outlined">edit</span>
                    Edit User
                </a>
                <a href="user_delete.php?id=<?php echo $user['id']; ?>" 
                   onclick="return confirm('Are you sure you want to delete this user? This action cannot be undone.');"
                   class="bg-red-600 text-white px-6 py-2 rounded-lg hover:bg-red-700 flex items-center gap-2">
                    <span class="material-symbols-outlined">delete</span>
                    Delete User
                </a>
            </div>
        </div>
    </div>
</main>
</div>
</body>
</html>

