<?php
// Debug mode - remove in production
error_reporting(E_ALL);
ini_set('display_errors', 1);

session_start();
header('Content-Type: application/json');
require_once 'includes/config.php';

$user_id = $_SESSION['user_id'] ?? null;
$site_id = isset($_POST['site_id']) ? intval($_POST['site_id']) : 0;
$action = isset($_POST['action']) ? $_POST['action'] : null;
$vote_type = isset($_POST['vote_type']) && in_array($_POST['vote_type'], ['upvote','downvote']) ? $_POST['vote_type'] : null;
$ip = $_SERVER['REMOTE_ADDR'] ?? '';

// Reklam istatistikleri için
$ad_id = isset($_POST['ad_id']) ? intval($_POST['ad_id']) : 0;

// Eğer sadece vote sayılarını almak istiyorsa
if ($action === 'get_votes') {
    if (!$site_id) {
        echo json_encode(['error' => 'Site ID required']);
        exit;
    }
    
    $voteStmt = $pdo->prepare('SELECT 
      SUM(vote_type = "upvote") AS upvotes,
      SUM(vote_type = "downvote") AS downvotes
      FROM site_votes WHERE site_id = ?');
    $voteStmt->execute([$site_id]);
    $votes = $voteStmt->fetch(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'upvotes' => intval($votes['upvotes'] ?? 0),
        'downvotes' => intval($votes['downvotes'] ?? 0)
    ]);
    exit;
}

// Oy verme işlemi için gerekli kontroller
if (!$user_id) {
    echo json_encode([
        'error' => 'Giriş yapmadan oy veremezsiniz.',
        'login_required' => true
    ]);
    exit;
}

if (!$site_id || !$vote_type) {
    $error = [
        'error' => 'Geçersiz istek',
        'details' => [
            'user_id' => $user_id ? 'OK' : 'Missing',
            'site_id' => $site_id ? 'OK' : 'Missing',
            'vote_type' => $vote_type ? 'OK' : 'Missing',
            'action' => $action
        ]
    ];
    echo json_encode($error);
    exit;
}

// Aynı user_id veya aynı IP'den bir kere oy verilebilir
$stmt = $pdo->prepare('SELECT id FROM site_votes WHERE (user_id = ? OR ip = ?) AND site_id = ?');
$stmt->execute([$user_id, $ip, $site_id]);
if ($stmt->fetch()) {
    // Zaten oy vermiş
    $voteStmt = $pdo->prepare('SELECT 
      SUM(vote_type = "upvote") AS upvotes,
      SUM(vote_type = "downvote") AS downvotes
      FROM site_votes WHERE site_id = ?');
    $voteStmt->execute([$site_id]);
    $votes = $voteStmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'upvotes' => intval($votes['upvotes'] ?? 0),
        'downvotes' => intval($votes['downvotes'] ?? 0),
        'message' => 'Zaten oy vermişsiniz.'
    ]);
    exit;
}

// Oy kaydet
$insert = $pdo->prepare('INSERT INTO site_votes (user_id, site_id, vote_type, ip) VALUES (?, ?, ?, ?)');
$insert->execute([$user_id, $site_id, $vote_type, $ip]);

// Toplam oyları çek
$voteStmt = $pdo->prepare('SELECT 
  SUM(vote_type = "upvote") AS upvotes,
  SUM(vote_type = "downvote") AS downvotes
  FROM site_votes WHERE site_id = ?');
$voteStmt->execute([$site_id]);
$votes = $voteStmt->fetch(PDO::FETCH_ASSOC);

echo json_encode([
    'upvotes' => intval($votes['upvotes'] ?? 0),
    'downvotes' => intval($votes['downvotes'] ?? 0),
    'message' => 'Oy başarıyla kaydedildi!'
]);

// Reklam istatistikleri işlemleri
if ($action === 'ad_view') {
    if (!$ad_id) {
        echo json_encode(['error' => 'Ad ID required']);
        exit;
    }
    
    try {
        $today = date('Y-m-d');
        
        // Reklam istatistiklerini güncelle veya ekle
        $stmt = $pdo->prepare("
            INSERT INTO ad_stats (ad_id, views, date) 
            VALUES (?, 1, ?) 
            ON DUPLICATE KEY UPDATE views = views + 1
        ");
        $stmt->execute([$ad_id, $today]);
        
        echo json_encode(['success' => true, 'message' => 'Ad view recorded']);
    } catch (Exception $e) {
        echo json_encode(['error' => 'Failed to record ad view: ' . $e->getMessage()]);
    }
    
} elseif ($action === 'ad_click') {
    if (!$ad_id) {
        echo json_encode(['error' => 'Ad ID required']);
        exit;
    }
    
    try {
        $today = date('Y-m-d');
        
        // Reklam istatistiklerini güncelle veya ekle
        $stmt = $pdo->prepare("
            INSERT INTO ad_stats (ad_id, clicks, date) 
            VALUES (?, 1, ?) 
            ON DUPLICATE KEY UPDATE clicks = clicks + 1
        ");
        $stmt->execute([$ad_id, $today]);
        
        echo json_encode(['success' => true, 'message' => 'Ad click recorded']);
    } catch (Exception $e) {
        echo json_encode(['error' => 'Failed to record ad click: ' . $e->getMessage()]);
    }
}
