<!DOCTYPE html>
<html lang="tr">
<head>
<?php 
require_once '../includes/config.php';
require_once '../utils/seo_title_helper.php';
require_once '../utils/recaptcha_helper.php';
require_once '../utils/ads_helper.php';
require_once '../utils/csrf_helper.php';
require_once '../utils/session_helper.php';

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Session başlatmadan önce ayarları yap
session_start();

// Eğer kullanıcı zaten giriş yapmışsa profile sayfasına yönlendir
if (isset($_SESSION['user_id'])) {
    header('Location: /profile');
    exit;
}

// Değişkenleri başlat
$login_message = '';
$message_type = '';

// Sayfa tipini tespit et
$current_page_type = detectPageType();

// URL'den gelen error parametresini kontrol et
if (isset($_GET['error']) && $_GET['error'] === 'registration_disabled') {
    $login_message = 'Kayıtlar şu anda devre dışı. Lütfen daha sonra tekrar deneyin.';
    $message_type = 'error';
}

// Add Site butonu için uyarı mesajı
if (isset($_GET['action']) && $_GET['action'] === 'add_site') {
    $login_message = 'Giriş yapmadan web sitesi ekleyemezsiniz.';
    $message_type = 'error';
}

// Form işleme
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // CSRF token kontrolü
    checkCSRFToken();
    
    $username = trim($_POST['email-username'] ?? '');
    $password = trim($_POST['password'] ?? '');
    
    // reCAPTCHA doğrulaması
    if (!verifyRecaptcha()) {
        $login_message = getRecaptchaError();
        $message_type = 'error';
    } else {
        try {
            $stmt = $pdo->prepare('SELECT id, username, password FROM user WHERE username = :username OR email = :username');
            $stmt->execute([':username' => $username]);
            $user = $stmt->fetch();
            
            if ($user && password_verify($password, $user['password'])) {
                startSecureSession();
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['username'] = $user['username'];
                $_SESSION['user_role'] = 'user'; // Default role
                refreshSession();
                header('Location: /profile');
                exit;
            } else {
                $login_message = 'Geçersiz kullanıcı adı veya şifre.';
                $message_type = 'error';
            }
        } catch (Exception $e) {
            $login_message = 'Veritabanı hatası oluştu.';
            $message_type = 'error';
        }
    }
}

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// SEO Title oluştur
$page_title = generatePageTitle('Giriş Yap', $settings);
?>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($page_title); ?></title>
<meta name="description" content="Profilinizi ve gönderdiğiniz web sitelerini yönetmek için hesabınıza giriş yapın.">
<?php
// Favicon
$favicon_url = $settings['favicon_url'] ?? '';
if (!empty($favicon_url)) {
    if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
        $favicon_url = '/' . ltrim($favicon_url, '/');
    }
    echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
}
?>
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@400;500;700;900&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#38BDF8",
                        "primary-light": "#7DD3FC",
                        "primary-dark": "#0EA5E9",
                        "background-light": "#F7FAFC",
                        "background-dark": "#0F172A",
                        "foreground-light": "#0F172A",
                        "foreground-dark": "#E2E8F0",
                        "subtle-light": "#E2E8F0",
                        "subtle-dark": "#1E293B",
                        "muted-light": "#64748B",
                        "muted-dark": "#94A3B8"
                    },
                    fontFamily: {
                        "display": ["Public Sans", "sans-serif"]
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        'soft': '0 4px 12px 0 rgb(0 0 0 / 0.07)',
                        'subtle': '0 1px 2px 0 rgb(0 0 0 / 0.05)',
                    }
                },
            },
        };
    </script>
<style>
        .material-symbols-outlined {
            font-variation-settings: "FILL" 0, "wght" 400, "GRAD" 0, "opsz" 24;
        }
        .active .material-symbols-outlined {
            font-variation-settings: 'FILL' 1;
        }
    </style>
    
    <?php echo getRecaptchaStyles(); ?>
    <?php echo getRecaptchaValidationJS(); ?>
</head>
<body class="bg-background-light dark:bg-background-dark font-display text-foreground-light dark:text-foreground-dark min-h-screen flex flex-col <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">

<?php include '../includes/header.php'; ?>

<main class="flex-1 flex justify-center items-center py-10 px-4 sm:px-6 lg:px-8">
<?php
// Content top reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
}
?>

<div class="w-full max-w-md space-y-8">
<div>
<div class="flex justify-center">
<div class="size-12 text-primary">
<svg fill="none" viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg"><path d="M44 4H30.6666V17.3334H17.3334V30.6666H4V44H44V4Z" fill="currentColor"></path></svg>
</div>
</div>
<h1 class="mt-6 text-3xl font-extrabold text-foreground-light dark:text-foreground-dark text-center">Hesabınıza Giriş Yapın</h1>
<p class="mt-2 text-center text-sm text-muted-light dark:text-muted-dark">Tekrar hoş geldiniz! Lütfen bilgilerinizi girin.</p>

<?php if ($login_message): ?>
<div class="mt-4 p-4 rounded-lg text-center font-medium <?php echo $message_type === 'error' ? 'bg-red-100 dark:bg-red-900/20 text-red-800 dark:text-red-200 border border-red-200 dark:border-red-800' : 'bg-green-100 dark:bg-green-900/20 text-green-800 dark:text-green-200 border border-green-200 dark:border-green-800'; ?>">
    <?php echo htmlspecialchars($login_message); ?>
</div>
<?php endif; ?>

</div>
<form class="mt-8 space-y-6 bg-white dark:bg-subtle-dark p-8 rounded-xl shadow-soft" method="POST" action="" <?php echo addRecaptchaAttribute(); ?>>
<?php echo csrfTokenField(); ?>
<div class="space-y-6">
<div>
<label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark" for="email-username">E-posta veya Kullanıcı Adı</label>
<div class="mt-1 relative rounded-md shadow-sm">
<div class="pointer-events-none absolute inset-y-0 left-0 pl-3 flex items-center">
<svg aria-hidden="true" class="h-5 w-5 text-muted-light dark:text-muted-dark" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
<path clip-rule="evenodd" d="M10 2a2 2 0 00-2 2v1.5a2 2 0 00-4 0V15a2 2 0 002 2h8a2 2 0 002-2V5.5a2 2 0 00-4 0V4a2 2 0 00-2-2zm-2 2.5V4a1 1 0 112 0v.5a.5.5 0 001 0V4a2 2 0 10-4 0v.5a.5.5 0 001 0zM12 10a2 2 0 11-4 0 2 2 0 014 0z" fill-rule="evenodd"></path>
</svg>
</div>
<input class="block w-full rounded-lg border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary pl-10" id="email-username" name="email-username" placeholder="ornek@email.com" type="text"/>
</div>
</div>
<div>
<label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark" for="password">Şifre</label>
<div class="mt-1 relative rounded-md shadow-sm">
<div class="pointer-events-none absolute inset-y-0 left-0 pl-3 flex items-center">
<svg aria-hidden="true" class="h-5 w-5 text-muted-light dark:text-muted-dark" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
<path clip-rule="evenodd" d="M10 1a4.5 4.5 0 00-4.5 4.5V9H5a2 2 0 00-2 2v6a2 2 0 002 2h10a2 2 0 002-2v-6a2 2 0 00-2-2h-.5V5.5A4.5 4.5 0 0010 1zm3 8V5.5a3 3 0 10-6 0V9h6z" fill-rule="evenodd"></path>
</svg>
</div>
<input class="block w-full rounded-lg border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary pl-10" id="password" name="password" placeholder="••••••••" type="password"/>
</div>
</div>
</div>
<div class="flex items-center justify-between text-sm">
<a class="font-medium text-primary hover:text-primary-dark" href="/forgot-password">Şifrenizi mi unuttunuz?</a>
</div>

<!-- reCAPTCHA -->
<div class="flex justify-center">
<?php echo renderRecaptcha(); ?>
</div>

<div>
<button class="group relative flex w-full justify-center rounded-lg border border-transparent bg-primary py-3 px-4 text-sm font-bold text-white hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-primary focus:ring-offset-2 dark:focus:ring-offset-background-dark" type="submit">
                  Giriş Yap
                </button>
</div>
<div class="text-center text-sm">
<p class="text-muted-light dark:text-muted-dark">
                  Hesabınız yok mu?
                  <a class="font-medium text-primary hover:text-primary-dark" href="/register">Kayıt ol</a>
</p>
</div>
</form>
</div>

<?php
// Content bottom reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
}
?>
</main>

<?php include '../includes/footer.php'; ?>
</body></html>