<!DOCTYPE html>
<html lang="tr" class="h-full">
<head>
<?php 
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include '../includes/config.php';
require_once '../utils/seo_title_helper.php';

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

if (!isset($_SESSION['user_id'])) {
    header('Location: /login');
    exit;
}

$user_id = $_SESSION['user_id'];
$sites_approved = 0;
$sites_pending = 0;
$comments = 0;
$recent_sites = [];
$pending_sites_list = [];
$success_message = '';
$error_message = '';

// Profil güncelleme işlemi
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['profile_edit'])) {
    $about = trim($_POST['about'] ?? '');
    $new_password = trim($_POST['new_password'] ?? '');
    $new_password_again = trim($_POST['new_password_again'] ?? '');
    $profile_photo_path = null;
    
    // Şifre kontrolü
    if (!empty($new_password)) {
        if ($new_password !== $new_password_again) {
            $error_message = 'Şifreler eşleşmiyor!';
        } elseif (strlen($new_password) < 6) {
            $error_message = 'Şifre en az 6 karakter olmalıdır!';
        }
    }
    
    // Profil fotoğrafı yükleme
    if (empty($error_message) && isset($_FILES['profile_photo']) && $_FILES['profile_photo']['error'] === UPLOAD_ERR_OK) {
        $tmp_name = $_FILES['profile_photo']['tmp_name'];
        $name = basename($_FILES['profile_photo']['name']);
        $ext = strtolower(pathinfo($name, PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];
        
        if (in_array($ext, $allowed)) {
            $new_name = 'profile_' . $user_id . '_' . time() . '.' . $ext;
            $upload_dir = '../uploads/profile_photos/';
            
            if (!is_dir($upload_dir)) {
                if (!mkdir($upload_dir, 0777, true)) {
                    $error_message = 'Profil fotoğrafı dizini oluşturulamadı!';
                }
            }
            
            if (empty($error_message)) {
                $dest = $upload_dir . $new_name;
                if (move_uploaded_file($tmp_name, $dest)) {
                    $profile_photo_path = 'uploads/profile_photos/' . $new_name;
                } else {
                    $error_message = 'Profil fotoğrafı yüklenemedi!';
                }
            }
        } else {
            $error_message = 'Geçersiz dosya formatı! Sadece JPG, PNG, GIF ve WebP dosyaları kabul edilir.';
        }
    } elseif (isset($_FILES['profile_photo']) && $_FILES['profile_photo']['error'] !== UPLOAD_ERR_NO_FILE) {
        $error_message = 'Dosya yükleme hatası: ' . $_FILES['profile_photo']['error'];
    }
    
    // Veritabanı güncelle
    if (empty($error_message)) {
        try {
            $pdo = new PDO("mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4", $DB_USER, $DB_PASS);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            $sql = "UPDATE user SET about = :about";
            $params = [':about' => $about, ':id' => $user_id];
            
            if ($profile_photo_path) {
                $sql .= ", profile_photo = :photo";
                $params[':photo'] = $profile_photo_path;
            }
            
            if (!empty($new_password)) {
                $sql .= ", password = :password";
                $params[':password'] = password_hash($new_password, PASSWORD_DEFAULT);
            }
            
            $sql .= " WHERE id = :id";
            
            $stmt = $pdo->prepare($sql);
            $stmt->execute($params);
            
            $success_message = 'Profil başarıyla güncellendi!';
        } catch (Exception $e) {
            $error_message = 'Veritabanı hatası: ' . htmlspecialchars($e->getMessage());
        }
    }
}

// Kullanıcı bilgilerini ve istatistikleri çek
try {
    $pdo = new PDO("mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4", $DB_USER, $DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Kullanıcı bilgileri
    $stmt = $pdo->prepare('SELECT username, email, kayit_tarihi, profile_photo, about FROM user WHERE id = ?');
    $stmt->execute([$user_id]);
    $user = $stmt->fetch();
    
    // Onaylanan site sayısı
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM site_submissions WHERE user_id = ? AND status = "approved"');
    $stmt->execute([$user_id]);
    $sites_approved = $stmt->fetchColumn();
    
    // Onayda bekleyen site sayısı
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM site_submissions WHERE user_id = ? AND status = "pending"');
    $stmt->execute([$user_id]);
    $sites_pending = $stmt->fetchColumn();
    
    // Son onaylanan siteler
    $stmt = $pdo->prepare('SELECT site_name, site_url, olusturulma_tarihi FROM site_submissions WHERE user_id = ? AND status = "approved" ORDER BY olusturulma_tarihi DESC LIMIT 5');
    $stmt->execute([$user_id]);
    $recent_sites = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Onayda bekleyen siteler
    $stmt = $pdo->prepare('SELECT site_name, site_url, olusturulma_tarihi FROM site_submissions WHERE user_id = ? AND status = "pending" ORDER BY olusturulma_tarihi DESC LIMIT 5');
    $stmt->execute([$user_id]);
    $pending_sites_list = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
} catch (Exception $e) {
    $error_message = 'Veritabanı hatası: ' . htmlspecialchars($e->getMessage());
}

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// SEO Title oluştur
$page_title = generatePageTitle('Profil', $settings);
?>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="Dizinimizde profilinizi ve gönderdiğiniz web sitelerini yönetin.">
    <?php
    // Favicon
    $favicon_url = $settings['favicon_url'] ?? '';
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
            $favicon_url = '/' . ltrim($favicon_url, '/');
        }
        echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    }
    ?>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet">
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#13a4ec",
                        "background-light": "#f6f7f8",
                        "background-dark": "#101c22",
                        "foreground-light": "#0d171b",
                        "foreground-dark": "#f6f7f8",
                        "card-light": "#ffffff",
                        "card-dark": "#192730",
                        "subtle-light": "#e7eff3",
                        "subtle-dark": "#2a3b47",
                        "border-light": "#cfdfe7",
                        "border-dark": "#2a3b47",
                        "muted-light": "#6b7280",
                        "muted-dark": "#9ca3af"
                    },
                    fontFamily: {
                        "display": ["Plus Jakarta Sans", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.75rem",
                        "lg": "1rem",
                        "xl": "1.5rem",
                        "full": "9999px"
                    },
                },
            },
        }
    </script>
    <style>
        .material-symbols-outlined {
            font-variation-settings: 'FILL' 0, 'wght' 400, 'GRAD' 0, 'opsz' 24;
        }
        .gradient-text {
            background: linear-gradient(to right, #38BDF8, #A78BFA);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        .tab-content { display: none; }
        .tab-content.active { display: block; }
    </style>
</head>
<body class="h-full bg-background-light dark:bg-background-dark text-foreground-light dark:text-foreground-dark font-display <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">
    <div class="min-h-full">
        <?php include '../includes/header.php'; ?>
        
        <main class="flex-1 px-4 sm:px-10 md:px-20 lg:px-40 py-8">
            <div class="mx-auto max-w-5xl">
                <!-- Flash Messages -->
                <?php if (!empty($success_message)): ?>
                    <div class="mb-6 p-4 rounded-lg bg-green-100 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-300 text-center font-medium">
                        <?php echo htmlspecialchars($success_message); ?>
                    </div>
                <?php endif; ?>
                
                <?php if (!empty($error_message)): ?>
                    <div class="mb-6 p-4 rounded-lg bg-red-100 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-300 text-center font-medium">
                        <?php echo htmlspecialchars($error_message); ?>
                    </div>
                <?php endif; ?>
                
                <!-- Profile Header -->
                <div class="flex flex-col items-center gap-6 rounded-xl bg-card-light dark:bg-card-dark p-8 shadow-sm border border-border-light dark:border-border-dark">
                    <div class="flex flex-col items-center gap-4 text-center">
                        <div class="relative">
                            <div class="size-32 rounded-full bg-cover bg-center border-4 border-primary shadow-lg" 
                                 style="background-image: url('<?php 
                                     $profile_photo = $user['profile_photo'] ?? '';
                                     if (!empty($profile_photo)) {
                                         if (filter_var($profile_photo, FILTER_VALIDATE_URL)) {
                                             echo htmlspecialchars($profile_photo);
                                         } else {
                                             echo htmlspecialchars('/' . ltrim($profile_photo, '/'));
                                         }
                                     } else {
                                         echo "/uploads/no-logo.png";
                                     }
                                 ?>');"></div>
                            <button onclick="document.getElementById('profileEditModal').classList.remove('hidden')" 
                                    class="absolute bottom-0 right-0 flex items-center justify-center size-9 rounded-full bg-primary text-white hover:bg-primary/90 transition-colors shadow-lg">
                                <span class="material-symbols-outlined text-lg">edit</span>
                            </button>
                        </div>
                        <div>
                            <h1 class="text-3xl font-bold text-foreground-light dark:text-foreground-dark"><?php echo htmlspecialchars($user['username'] ?? 'User'); ?></h1>
                            <p class="text-muted-light dark:text-muted-dark mt-1"><?php echo htmlspecialchars($user['email'] ?? ''); ?></p>
                            <p class="text-sm text-muted-light dark:text-muted-dark mt-1">
                                Üyelik tarihi: <?php echo isset($user['kayit_tarihi']) ? date('d.m.Y', strtotime($user['kayit_tarihi'])) : 'Bilinmiyor'; ?>
                            </p>
                        </div>
                        <button onclick="document.getElementById('profileEditModal').classList.remove('hidden')" 
                                class="mt-4 flex min-w-[120px] items-center justify-center rounded-lg h-10 px-6 bg-primary/10 dark:bg-primary/20 text-primary text-sm font-bold hover:bg-primary/20 dark:hover:bg-primary/30 transition-colors">
                            Profili Düzenle
                        </button>
                    </div>
                </div>
                
                <!-- Tab Navigation -->
                <div class="mt-8">
                    <div class="border-b border-border-light dark:border-border-dark">
                        <nav class="-mb-px flex space-x-8 px-4">
                            <button class="tab-link border-b-2 py-4 px-1 text-sm font-medium transition-colors" data-tab="overview">
                                Genel Bakış
                            </button>
                            <button class="tab-link border-b-2 py-4 px-1 text-sm font-medium transition-colors" data-tab="sites">
                                Sitelerim
                            </button>
                            <button class="tab-link border-b-2 py-4 px-1 text-sm font-medium transition-colors" data-tab="pending">
                                Bekleyen Siteler
                            </button>
                            <button class="tab-link border-b-2 py-4 px-1 text-sm font-medium transition-colors" data-tab="activity">
                                Aktivite
                            </button>
                        </nav>
                    </div>
                    
                    <!-- Tab Content -->
                    <div class="py-8">
                        <!-- Overview Tab -->
                        <div id="tab-overview" class="tab-content">
                            <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
                                <div class="lg:col-span-2 space-y-8">
                                    <!-- About Section -->
                                    <div class="rounded-xl bg-card-light dark:bg-card-dark p-6 shadow-sm border border-border-light dark:border-border-dark">
                                        <h2 class="text-xl font-bold text-foreground-light dark:text-foreground-dark">Hakkımda</h2>
                                        <div class="mt-4">
                                            <?php if (!empty($user['about'])): ?>
                                                <p class="text-foreground-light/80 dark:text-foreground-dark/80 leading-relaxed">
                                                    <?php echo nl2br(htmlspecialchars($user['about'])); ?>
                                                </p>
                                            <?php else: ?>
                                                <p class="text-muted-light dark:text-muted-dark italic">
                                                    Henüz açıklama eklenmemiş.
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    
                                    <!-- Recent Activity -->
                                    <div class="rounded-xl bg-card-light dark:bg-card-dark p-6 shadow-sm border border-border-light dark:border-border-dark">
                                        <h2 class="text-xl font-bold text-foreground-light dark:text-foreground-dark">Son Aktiviteler</h2>
                                        <div class="mt-4 space-y-4">
                                            <?php if (!empty($recent_sites)): ?>
                                                <?php foreach (array_slice($recent_sites, 0, 3) as $site): ?>
                                                    <div class="flex items-center space-x-3 p-3 rounded-lg bg-background-light dark:bg-background-dark border border-border-light dark:border-border-dark">
                                                        <div class="flex h-8 w-8 items-center justify-center rounded-full bg-green-100 dark:bg-green-900/20">
                                                            <span class="material-symbols-outlined text-green-600 dark:text-green-400 text-base">check_circle</span>
                                                        </div>
                                                        <div class="flex-1">
                                                            <p class="text-sm text-foreground-light dark:text-foreground-dark">
                                                                <span class="font-medium"><?php echo htmlspecialchars($site['site_name']); ?></span> sitesi onaylandı
                                                            </p>
                                                            <p class="text-xs text-muted-light dark:text-muted-dark">
                                                                <?php echo date('d.m.Y H:i', strtotime($site['olusturulma_tarihi'])); ?>
                                                            </p>
                                                        </div>
                                                    </div>
                                                <?php endforeach; ?>
                                            <?php else: ?>
                                                <p class="text-muted-light dark:text-muted-dark text-center py-8">
                                                    Henüz onaylanmış site yok.
                                                </p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Statistics Sidebar -->
                                <div class="space-y-6">
                                    <div class="rounded-xl bg-card-light dark:bg-card-dark p-6 shadow-sm border border-border-light dark:border-border-dark">
                                        <h2 class="text-xl font-bold text-foreground-light dark:text-foreground-dark mb-4">İstatistikler</h2>
                                        <div class="space-y-4">
                                            <div class="text-center p-4 rounded-lg bg-background-light dark:bg-background-dark border border-border-light dark:border-border-dark">
                                                <p class="text-3xl font-bold text-primary"><?php echo $sites_approved; ?></p>
                                                <p class="text-sm text-muted-light dark:text-muted-dark mt-1">Onaylanmış Siteler</p>
                                            </div>
                                            <div class="text-center p-4 rounded-lg bg-background-light dark:bg-background-dark border border-border-light dark:border-border-dark">
                                                <p class="text-3xl font-bold text-yellow-600 dark:text-yellow-400"><?php echo $sites_pending; ?></p>
                                                <p class="text-sm text-muted-light dark:text-muted-dark mt-1">Bekleyen Siteler</p>
                                            </div>
                                            <div class="text-center p-4 rounded-lg bg-background-light dark:bg-background-dark border border-border-light dark:border-border-dark">
                                                <p class="text-3xl font-bold text-blue-600 dark:text-blue-400"><?php echo $comments; ?></p>
                                                <p class="text-sm text-muted-light dark:text-muted-dark mt-1">Yorumlar</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Sites Tab -->
                        <div id="tab-sites" class="tab-content">
                            <div class="rounded-xl bg-card-light dark:bg-card-dark p-6 shadow-sm border border-border-light dark:border-border-dark">
                                <h2 class="text-xl font-bold text-foreground-light dark:text-foreground-dark mb-6">Onaylanmış Sitelerim</h2>
                                <?php if (!empty($recent_sites)): ?>
                                    <div class="space-y-4">
                                        <?php foreach ($recent_sites as $site): ?>
                                            <div class="flex items-center justify-between p-4 rounded-lg bg-background-light dark:bg-background-dark border border-border-light dark:border-border-dark">
                                                <div class="flex items-center space-x-3">
                                                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-green-100 dark:bg-green-900/20">
                                                        <span class="material-symbols-outlined text-green-600 dark:text-green-400">check_circle</span>
                                                    </div>
                                                    <div>
                                                        <h3 class="font-medium text-foreground-light dark:text-foreground-dark">
                                                            <?php echo htmlspecialchars($site['site_name']); ?>
                                                        </h3>
                                                        <p class="text-sm text-muted-light dark:text-muted-dark">
                                                            <?php echo date('d.m.Y H:i', strtotime($site['olusturulma_tarihi'])); ?>
                                                        </p>
                                                    </div>
                                                </div>
                                                <a href="<?php echo htmlspecialchars($site['site_url']); ?>" 
                                                   target="_blank" 
                                                   class="text-primary hover:text-primary/80 transition-colors">
                                                    <span class="material-symbols-outlined">open_in_new</span>
                                                </a>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php else: ?>
                                    <div class="text-center py-12">
                                        <span class="material-symbols-outlined text-6xl text-muted-light dark:text-muted-dark mb-4">web</span>
                                        <p class="text-muted-light dark:text-muted-dark">Henüz onaylanmış site yok.</p>
                                        <a href="/submit" class="mt-4 inline-flex items-center px-4 py-2 rounded-lg bg-primary text-white font-medium hover:bg-primary/90 transition-colors">
                                            İlk Sitenizi Ekleyin
                                        </a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Pending Sites Tab -->
                        <div id="tab-pending" class="tab-content">
                            <div class="rounded-xl bg-card-light dark:bg-card-dark p-6 shadow-sm border border-border-light dark:border-border-dark">
                                <h2 class="text-xl font-bold text-foreground-light dark:text-foreground-dark mb-6">Bekleyen Sitelerim</h2>
                                <?php if (!empty($pending_sites_list)): ?>
                                    <div class="space-y-4">
                                        <?php foreach ($pending_sites_list as $site): ?>
                                            <div class="flex items-center justify-between p-4 rounded-lg bg-background-light dark:bg-background-dark border border-border-light dark:border-border-dark">
                                                <div class="flex items-center space-x-3">
                                                    <div class="flex h-10 w-10 items-center justify-center rounded-full bg-yellow-100 dark:bg-yellow-900/20">
                                                        <span class="material-symbols-outlined text-yellow-600 dark:text-yellow-400">hourglass_top</span>
                                                    </div>
                                                    <div>
                                                        <h3 class="font-medium text-foreground-light dark:text-foreground-dark">
                                                            <?php echo htmlspecialchars($site['site_name']); ?>
                                                        </h3>
                                                        <p class="text-sm text-muted-light dark:text-muted-dark">
                                                            <?php echo date('d.m.Y H:i', strtotime($site['olusturulma_tarihi'])); ?>
                                                        </p>
                                                    </div>
                                                </div>
                                                <a href="<?php echo htmlspecialchars($site['site_url']); ?>" 
                                                   target="_blank" 
                                                   class="text-primary hover:text-primary/80 transition-colors">
                                                    <span class="material-symbols-outlined">open_in_new</span>
                                                </a>
                                            </div>
                                        <?php endforeach; ?>
                                    </div>
                                <?php else: ?>
                                    <div class="text-center py-12">
                                        <span class="material-symbols-outlined text-6xl text-muted-light dark:text-muted-dark mb-4">hourglass_empty</span>
                                        <p class="text-muted-light dark:text-muted-dark">Şu anda bekleyen site yok.</p>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <!-- Activity Tab -->
                        <div id="tab-activity" class="tab-content">
                            <div class="rounded-xl bg-card-light dark:bg-card-dark p-6 shadow-sm border border-border-light dark:border-border-dark">
                                <h2 class="text-xl font-bold text-foreground-light dark:text-foreground-dark mb-6">Aktivite Geçmişi</h2>
                                <div class="text-center py-12">
                                    <span class="material-symbols-outlined text-6xl text-muted-light dark:text-muted-dark mb-4">timeline</span>
                                    <p class="text-muted-light dark:text-muted-dark">Aktivite geçmişi yakında gelecek.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Profile Edit Modal -->
                <div id="profileEditModal" class="fixed inset-0 z-50 flex items-center justify-center bg-black/60 backdrop-blur-sm hidden">
                    <div class="bg-card-light dark:bg-card-dark rounded-2xl p-8 w-full max-w-lg shadow-2xl relative border border-border-light dark:border-border-dark mx-4 transform transition-all duration-300 scale-95 opacity-0" id="modalContent">
                        <button onclick="closeModal()" 
                                class="absolute top-4 right-4 text-muted-light dark:text-muted-dark hover:text-primary transition-colors p-2 rounded-full hover:bg-background-light dark:hover:bg-background-dark">
                            <span class="material-symbols-outlined text-xl">close</span>
                        </button>
                        
                        <div class="text-center mb-8">
                            <div class="inline-flex items-center justify-center w-16 h-16 bg-primary/10 dark:bg-primary/20 rounded-full mb-4">
                                <span class="material-symbols-outlined text-primary text-2xl">person_edit</span>
                            </div>
                            <h2 class="text-2xl font-bold text-foreground-light dark:text-foreground-dark">Profili Düzenle</h2>
                            <p class="text-muted-light dark:text-muted-dark mt-2">Profil bilgilerinizi ve ayarlarınızı güncelleyin</p>
                        </div>
                        
                        <form method="POST" enctype="multipart/form-data" class="space-y-6">
                            <input type="hidden" name="profile_edit" value="1" />
                            
                            <!-- Profile Photo -->
                            <div class="flex flex-col items-center gap-6">
                                <div class="relative">
                                    <div class="size-28 rounded-full bg-cover bg-center border-4 border-primary shadow-xl" 
                                         style="background-image: url('<?php 
                                             $profile_photo = $user['profile_photo'] ?? '';
                                             if (!empty($profile_photo)) {
                                                 if (filter_var($profile_photo, FILTER_VALIDATE_URL)) {
                                                     echo htmlspecialchars($profile_photo);
                                                 } else {
                                                     echo htmlspecialchars('/' . ltrim($profile_photo, '/'));
                                                 }
                                             } else {
                                                 echo "/uploads/no-logo.png";
                                             }
                                         ?>');"></div>
                                    <div class="absolute -bottom-2 -right-2 flex items-center justify-center w-8 h-8 bg-primary rounded-full shadow-lg">
                                        <span class="material-symbols-outlined text-white text-sm">camera_alt</span>
                                    </div>
                                </div>
                                <div class="w-full">
                                    <label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark mb-3">Profil Fotoğrafı</label>
                                    <div class="relative">
                                        <input type="file" 
                                               id="profile_photo" 
                                               name="profile_photo" 
                                               accept="image/*" 
                                               class="block w-full text-sm text-foreground-light dark:text-foreground-dark file:mr-4 file:py-3 file:px-6 file:rounded-lg file:border-0 file:text-sm file:font-medium file:bg-primary/10 file:text-primary hover:file:bg-primary/20 transition-colors cursor-pointer" 
                                               onchange="previewImage(this)" />
                                        <div class="mt-2 text-xs text-muted-light dark:text-muted-dark">
                                            Önerilen: JPG, PNG, GIF veya WebP (maks 5MB)
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- About -->
                            <div>
                                <label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark mb-3" for="about">Hakkımda</label>
                                <textarea id="about" 
                                          name="about" 
                                          rows="4" 
                                          placeholder="Kendinizden bahsedin..."
                                          class="w-full rounded-lg border border-border-light dark:border-border-dark bg-background-light dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-2 focus:ring-primary focus:border-primary transition-colors resize-none"><?php echo htmlspecialchars($user['about'] ?? ''); ?></textarea>
                                <div class="mt-2 text-xs text-muted-light dark:text-muted-dark">
                                    İlgi alanlarınızı, uzmanlığınızı veya başkalarının bilmesini istediğiniz herhangi bir şeyi paylaşın.
                                </div>
                            </div>
                            
                            <!-- New Password -->
                            <div>
                                <label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark mb-3" for="new_password">Yeni Şifre</label>
                                <div class="relative">
                                    <input type="password" 
                                           id="new_password" 
                                           name="new_password" 
                                           placeholder="Yeni şifre girin (isteğe bağlı)"
                                           class="w-full rounded-lg border border-border-light dark:border-border-dark bg-background-light dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-2 focus:ring-primary focus:border-primary transition-colors pr-12" />
                                    <button type="button" onclick="togglePassword('new_password')" class="absolute right-3 top-1/2 -translate-y-1/2 text-muted-light dark:text-muted-dark hover:text-primary transition-colors">
                                        <span class="material-symbols-outlined text-lg" id="new_password_icon">visibility</span>
                                    </button>
                                </div>
                                <div class="mt-2 text-xs text-muted-light dark:text-muted-dark">
                                    Mevcut şifreyi korumak için boş bırakın. Minimum 6 karakter.
                                </div>
                            </div>
                            
                            <!-- Confirm Password -->
                            <div>
                                <label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark mb-3" for="new_password_again">Şifreyi Onayla</label>
                                <div class="relative">
                                    <input type="password" 
                                           id="new_password_again" 
                                           name="new_password_again" 
                                           placeholder="Yeni şifreyi onayla"
                                           class="w-full rounded-lg border border-border-light dark:border-border-dark bg-background-light dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-2 focus:ring-primary focus:border-primary transition-colors pr-12" />
                                    <button type="button" onclick="togglePassword('new_password_again')" class="absolute right-3 top-1/2 -translate-y-1/2 text-muted-light dark:text-muted-dark hover:text-primary transition-colors">
                                        <span class="material-symbols-outlined text-lg" id="new_password_again_icon">visibility</span>
                                    </button>
                                </div>
                            </div>
                            
                            <!-- Submit Button -->
                            <div class="flex gap-3 pt-4">
                                <button type="button" onclick="closeModal()" 
                                        class="flex-1 rounded-lg border border-border-light dark:border-border-dark py-3 px-4 text-foreground-light dark:text-foreground-dark font-medium hover:bg-background-light dark:hover:bg-background-dark transition-colors">
                                    İptal
                                </button>
                                <button type="submit" 
                                        class="flex-1 rounded-lg bg-primary py-3 px-4 text-white font-medium hover:bg-primary/90 transition-colors shadow-lg hover:shadow-xl">
                                    <span class="flex items-center justify-center gap-2">
                                        <span class="material-symbols-outlined text-lg">save</span>
                                        Değişiklikleri Kaydet
                                    </span>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </main>
        
        <?php include '../includes/footer.php'; ?>
    </div>
    
    <script>
        // Tab functionality
        document.addEventListener('DOMContentLoaded', function() {
            const tabs = document.querySelectorAll('.tab-link');
            const contents = document.querySelectorAll('.tab-content');
            
            function showTab(targetTab) {
                // Hide all content
                contents.forEach(content => {
                    content.classList.remove('active');
                });
                
                // Remove active styles from all tabs
                tabs.forEach(tab => {
                    tab.classList.remove('border-primary', 'text-primary');
                    tab.classList.add('border-transparent', 'text-muted-light', 'dark:text-muted-dark');
                });
                
                // Show target content
                const targetContent = document.getElementById('tab-' + targetTab);
                if (targetContent) {
                    targetContent.classList.add('active');
                }
                
                // Style active tab
                const activeTab = document.querySelector(`[data-tab="${targetTab}"]`);
                if (activeTab) {
                    activeTab.classList.remove('border-transparent', 'text-muted-light', 'dark:text-muted-dark');
                    activeTab.classList.add('border-primary', 'text-primary');
                }
            }
            
            // Add click listeners
            tabs.forEach(tab => {
                tab.addEventListener('click', function(e) {
                    e.preventDefault();
                    const targetTab = this.getAttribute('data-tab');
                    showTab(targetTab);
                });
            });
            
            // Show default tab
            showTab('overview');
            
            // Close modal when clicking outside
            document.getElementById('profileEditModal').addEventListener('click', function(e) {
                if (e.target === this) {
                    closeModal();
                }
            });
        });

        // Modal functions
        function openModal() {
            const modal = document.getElementById('profileEditModal');
            const modalContent = document.getElementById('modalContent');
            modal.classList.remove('hidden');
            
            // Trigger animation
            setTimeout(() => {
                modalContent.classList.remove('scale-95', 'opacity-0');
                modalContent.classList.add('scale-100', 'opacity-100');
            }, 10);
        }

        function closeModal() {
            const modal = document.getElementById('profileEditModal');
            const modalContent = document.getElementById('modalContent');
            
            modalContent.classList.remove('scale-100', 'opacity-100');
            modalContent.classList.add('scale-95', 'opacity-0');
            
            setTimeout(() => {
                modal.classList.add('hidden');
            }, 300);
        }

        // Password toggle function
        function togglePassword(inputId) {
            const input = document.getElementById(inputId);
            const icon = document.getElementById(inputId + '_icon');
            
            if (input.type === 'password') {
                input.type = 'text';
                icon.textContent = 'visibility_off';
            } else {
                input.type = 'password';
                icon.textContent = 'visibility';
            }
        }

        // Image preview function
        function previewImage(input) {
            if (input.files && input.files[0]) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const profilePhoto = document.querySelector('.size-28');
                    if (profilePhoto) {
                        profilePhoto.style.backgroundImage = `url(${e.target.result})`;
                    }
                };
                reader.readAsDataURL(input.files[0]);
            }
        }

        // Update modal open buttons
        document.addEventListener('DOMContentLoaded', function() {
            const editButtons = document.querySelectorAll('[onclick*="profileEditModal"]');
            editButtons.forEach(button => {
                button.setAttribute('onclick', 'openModal()');
            });
        });
    </script>
</body>
</html>