<?php
require_once "../includes/config.php";
require_once "../includes/ban_check.php";
require_once "../utils/recaptcha_helper.php";
require_once "../utils/email_verification_helper.php";
require_once "../utils/ads_helper.php";
require_once "../utils/csrf_helper.php";
require_once "../utils/session_helper.php";

// Site settings'lerini al
$settings = [];
$stmt = $pdo->query("SELECT setting_key, setting_value FROM settings");
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row["setting_key"]] = $row["setting_value"];
}

// Kullanıcı kaydı kontrolü
$registration_disabled = false;
if (($settings['user_registration'] ?? '1') !== '1') {
    $registration_disabled = true;
}

// Add Site butonu için uyarı mesajı
$add_site_message = '';
if (isset($_GET['action']) && $_GET['action'] === 'add_site') {
    $add_site_message = 'Giriş yapmadan web sitesi ekleyemezsiniz.';
}

$site_title_base = $settings["site_title"] ?? "Web Dizini";

// Admin panelinden Terms of Service ve Privacy Policy linklerini çek
$terms_url = $settings['terms_of_service_url'] ?? '/terms-of-service';
$privacy_url = $settings['privacy_policy_url'] ?? '/privacy-policy';

// Sayfa tipini tespit et
$current_page_type = detectPageType();

// SEO Title oluştur
require_once "../utils/seo_title_helper.php";
$page_title = generatePageTitle("Kayıt Ol", $settings);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($settings["meta_register"] ?? "Yeni bir hesap oluşturun ve topluluğumuza katılın."); ?>">
    <?php
    // Favicon
    $favicon_url = $settings["favicon_url"] ?? "";
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, "http") && !str_starts_with($favicon_url, "//")) {
            $favicon_url = "/" . ltrim($favicon_url, "/");
        }
        echo "<link rel=\"icon\" type=\"image/x-icon\" href=\"" . htmlspecialchars($favicon_url) . "\">\n";
        echo "<link rel=\"shortcut icon\" href=\"" . htmlspecialchars($favicon_url) . "\">\n";
        echo "<link rel=\"apple-touch-icon\" href=\"" . htmlspecialchars($favicon_url) . "\">\n";
    }
    ?>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com?plugins=forms"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#38BDF8",
                        "primary-light": "#7DD3FC",
                        "primary-dark": "#0EA5E9",
                        "background-light": "#F7FAFC",
                        "background-dark": "#0F172A",
                        "foreground-light": "#0F172A",
                        "foreground-dark": "#E2E8F0",
                        "subtle-light": "#E2E8F0",
                        "subtle-dark": "#1E293B",
                        "muted-light": "#64748B",
                        "muted-dark": "#94A3B8"
                    },
                    fontFamily: {
                        "display": ["Public Sans", "sans-serif"]
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        "soft": "0 4px 12px 0 rgb(0 0 0 / 0.07)",
                        "subtle": "0 1px 2px 0 rgb(0 0 0 / 0.05)",
                    }
                },
            },
        };
    </script>
    <style>
        .material-symbols-outlined {
            font-variation-settings: "FILL" 0, "wght" 400, "GRAD" 0, "opsz" 24;
        }
        .active .material-symbols-outlined {
            font-variation-settings: "FILL" 1;
        }
    </style>
    
    <?php echo getRecaptchaStyles(); ?>
    <?php echo getRecaptchaValidationJS(); ?>
</head>
<body class="bg-background-light dark:bg-background-dark font-display text-foreground-light dark:text-foreground-dark min-h-screen flex flex-col <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">

<?php include "../includes/header.php"; ?>

<main class="flex-1 flex justify-center items-center py-10 px-4 sm:px-6 lg:px-8">
<?php
// Content top reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
}
?>

<div class="w-full max-w-md space-y-8">
<div>
<div class="flex justify-center">
<div class="size-12 text-primary">
<svg class="w-full h-full" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
<path d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
</div>
<h1 class="mt-6 text-3xl font-extrabold text-foreground-light dark:text-foreground-dark text-center">Hesabınızı Oluşturun</h1>
<p class="mt-2 text-center text-sm text-muted-light dark:text-muted-dark">
        Veya <a class="font-medium text-primary hover:text-primary-dark" href="/login">mevcut hesabınızla giriş yapın</a>
</p>
</div>

<?php
// Kayıt başarılı mesajı ve yönlendirme
$success = false;
$error = "";
if ($_SERVER["REQUEST_METHOD"] === "POST") {
  // CSRF token kontrolü
  checkCSRFToken();
  
  // Basit validation
  $username = trim($_POST["username"] ?? "");
  $email = trim($_POST["email"] ?? "");
  $password = $_POST["password"] ?? "";
  $password_again = $_POST["password_again"] ?? "";
  $terms = isset($_POST["terms"]);

  // Admin username kısıtlaması
  $restricted_usernames = [
    'admin', 'administrator', 'moderator', 'mod', 'root', 'superadmin', 'super', 'owner', 'founder',
    'ceo', 'manager', 'staff', 'support', 'help', 'system', 'bot', 'api', 'test', 'demo',
    'guest', 'user', 'member', 'visitor', 'anonymous', 'null', 'undefined', 'www', 'mail',
    'ftp', 'news', 'info', 'contact', 'about', 'privacy', 'terms', 'legal', 'security',
    'webmaster', 'hostmaster', 'postmaster', 'noreply', 'no-reply', 'donotreply',
    'sofi', 'sofia', 'sofie', 'sophie', 'sophia', 'sofya', 'sofija', 'sofia', 'sofie',
    'admin123', 'admin1', 'admin2', 'admin3', 'admin4', 'admin5', 'root123', 'root1',
    'moderator123', 'mod123', 'superadmin123', 'super123', 'owner123', 'founder123',
    'ceo123', 'manager123', 'staff123', 'support123', 'help123', 'system123', 'bot123',
    'api123', 'test123', 'demo123', 'guest123', 'user123', 'member123', 'visitor123',
    'anonymous123', 'null123', 'undefined123', 'www123', 'mail123', 'ftp123', 'news123',
    'info123', 'contact123', 'about123', 'privacy123', 'terms123', 'legal123', 'security123',
    'webmaster123', 'hostmaster123', 'postmaster123', 'noreply123', 'no-reply123', 'donotreply123'
  ];
  
  $username_lower = strtolower($username);
  if (in_array($username_lower, $restricted_usernames)) {
    $error = "Bu kullanıcı adı kullanılamaz. Lütfen farklı bir kullanıcı adı seçin.";
  } elseif (strlen($username) < 3) {
    $error = "Kullanıcı adı en az 3 karakter olmalıdır.";
  } elseif (strlen($username) > 20) {
    $error = "Kullanıcı adı en fazla 20 karakter olabilir.";
  } elseif (!preg_match('/^[a-zA-Z0-9_]+$/', $username)) {
    $error = "Kullanıcı adı sadece harf, rakam ve alt çizgi içerebilir.";
  } elseif (strpos($username_lower, 'admin') !== false || strpos($username_lower, 'mod') !== false || 
           strpos($username_lower, 'root') !== false || strpos($username_lower, 'super') !== false) {
    $error = "Kullanıcı adında admin, mod, root, super gibi yetkili kelimeler kullanılamaz.";
  } elseif (!verifyRecaptcha()) {
    $error = getRecaptchaError();
  } elseif (!$username || !$email || !$password || !$password_again) {
    $error = "Lütfen tüm alanları doldurun.";
  } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $error = "Geçerli bir e-posta adresi girin.";
  } elseif ($password !== $password_again) {
    $error = "Şifreler eşleşmiyor.";
  } elseif (!$terms) {
    $error = "Kullanım koşullarını kabul etmelisiniz.";
  } else {
    // IP ban kontrolü
    $user_ip = getUserIP();
    $ban_status = checkBanStatus($pdo, null, $user_ip);
    
    if ($ban_status["is_banned"]) {
      $error = $ban_status["message"];
    } else {
      // Kullanıcı var mı kontrolü
      $stmt = $pdo->prepare("SELECT id FROM user WHERE username = ? OR email = ?");
      $stmt->execute([$username, $email]);
      if ($stmt->fetch()) {
        $error = "Bu kullanıcı adı veya e-posta zaten kayıtlı.";
      } else {
        $hash = password_hash($password, PASSWORD_DEFAULT);
        $ip = $_SERVER["REMOTE_ADDR"] ?? "";
        $default_avatar = "/uploads/no-logo.png";
        $stmt = $pdo->prepare("INSERT INTO user (username, email, password, ip, email_verified, profile_photo) VALUES (?, ?, ?, ?, ?, ?)");
        $emailVerified = ($settings['require_email_verification'] ?? '0') === '0' ? 1 : 0;
        $stmt->execute([$username, $email, $hash, $ip, $emailVerified, $default_avatar]);
        $userId = $pdo->lastInsertId();
        
        // E-posta doğrulama gerekli mi?
        if (($settings['require_email_verification'] ?? '0') === '1') {
            // E-posta doğrulama maili gönder
            if (sendVerificationEmail($userId, $email, $username, $settings)) {
                $success = true;
                echo "<div class=\"mb-4 p-3 rounded bg-blue-100 text-blue-800 text-center font-bold\">Kayıt başarılı! E-posta adresinize doğrulama e-postası gönderildi. Lütfen e-postanızı kontrol edin.</div>";
            } else {
                $error = "Kayıt başarılı ancak doğrulama e-postası gönderilemedi. Lütfen daha sonra tekrar deneyin.";
            }
        } else {
            // E-posta doğrulama gerekmiyor, direkt giriş yap
            $success = true;
            startSecureSession();
            $_SESSION["user_id"] = $userId;
            $_SESSION["username"] = $username;
            $_SESSION["user_role"] = "user";
            refreshSession();
            $_SESSION["username"] = $username;
            echo "<div class=\"mb-4 p-3 rounded bg-green-100 text-green-800 text-center font-bold\">Kayıt başarılı! Yönlendiriliyor...</div>";
            echo "<script>setTimeout(function(){ window.location.href = \"/profile\"; }, 2000);</script>";
        }
      }
    }
  }
}
?>

<?php if ($add_site_message): ?>
  <div class="mb-4 p-4 rounded-lg bg-red-100 border border-red-200 text-red-800 text-center font-medium"><?php echo $add_site_message; ?></div>
<?php elseif ($registration_disabled): ?>
  <div class="mb-4 p-4 rounded-lg bg-red-100 border border-red-200 text-red-800 text-center font-medium">Kayıtlar şu anda devre dışı. Lütfen daha sonra tekrar deneyin.</div>
<?php elseif ($error): ?>
  <div class="mb-4 p-4 rounded-lg bg-red-100 border border-red-200 text-red-800 text-center font-medium"><?php echo $error; ?></div>
<?php endif; ?>

<?php if (!$success && !$registration_disabled): ?>
<form class="mt-8 space-y-6 bg-white dark:bg-subtle-dark p-8 rounded-xl shadow-soft" method="POST" action="" <?php echo addRecaptchaAttribute(); ?>>
<?php echo csrfTokenField(); ?>
<div class="space-y-6">
<div>
<label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark mb-2" for="username">Kullanıcı Adı</label>
<div class="relative rounded-md shadow-sm">
<div class="pointer-events-none absolute inset-y-0 left-0 pl-3 flex items-center">
<svg aria-hidden="true" class="h-5 w-5 text-muted-light dark:text-muted-dark" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
<path d="M10 2a2 2 0 00-2 2v1.5a2 2 0 00-4 0V15a2 2 0 002 2h8a2 2 0 002-2V5.5a2 2 0 00-4 0V4a2 2 0 00-2-2zm-2 2.5V4a1 1 0 112 0v.5a.5.5 0 001 0V4a2 2 0 10-4 0v.5a.5.5 0 001 0zM12 10a2 2 0 11-4 0 2 2 0 014 0z" fill-rule="evenodd"></path>
</svg>
</div>
<input autocomplete="username" class="block w-full rounded-lg border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary pl-10" id="username" name="username" placeholder="Kullanıcı adınızı girin" required type="text" value="<?php echo htmlspecialchars($_POST["username"] ?? ""); ?>"/>
</div>
</div>

<div>
<label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark mb-2" for="email-address">E-posta Adresi</label>
<div class="relative rounded-md shadow-sm">
<div class="pointer-events-none absolute inset-y-0 left-0 pl-3 flex items-center">
<svg aria-hidden="true" class="h-5 w-5 text-muted-light dark:text-muted-dark" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
<path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"></path>
<path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"></path>
</svg>
</div>
<input autocomplete="email" class="block w-full rounded-lg border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary pl-10" id="email-address" name="email" placeholder="ornek@email.com" required type="email" value="<?php echo htmlspecialchars($_POST["email"] ?? ""); ?>"/>
</div>
</div>

<div>
<label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark mb-2" for="password">Şifre</label>
<div class="relative rounded-md shadow-sm">
<div class="pointer-events-none absolute inset-y-0 left-0 pl-3 flex items-center">
<svg aria-hidden="true" class="h-5 w-5 text-muted-light dark:text-muted-dark" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
<path clip-rule="evenodd" d="M10 1a4.5 4.5 0 00-4.5 4.5V9H5a2 2 0 00-2 2v6a2 2 0 002 2h10a2 2 0 002-2v-6a2 2 0 00-2-2h-.5V5.5A4.5 4.5 0 0010 1zm3 8V5.5a3 3 0 10-6 0V9h6z" fill-rule="evenodd"></path>
</svg>
</div>
<input autocomplete="new-password" class="block w-full rounded-lg border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary pl-10" id="password" name="password" placeholder="••••••••" required type="password"/>
</div>
</div>

<div>
<label class="block text-sm font-medium text-foreground-light dark:text-foreground-dark mb-2" for="password-again">Şifreyi Onayla</label>
<div class="relative rounded-md shadow-sm">
<div class="pointer-events-none absolute inset-y-0 left-0 pl-3 flex items-center">
<svg aria-hidden="true" class="h-5 w-5 text-muted-light dark:text-muted-dark" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
<path clip-rule="evenodd" d="M10 1a4.5 4.5 0 00-4.5 4.5V9H5a2 2 0 00-2 2v6a2 2 0 002 2h10a2 2 0 002-2v-6a2 2 0 00-2-2h-.5V5.5A4.5 4.5 0 0010 1zm3 8V5.5a3 3 0 10-6 0V9h6z" fill-rule="evenodd"></path>
</svg>
</div>
<input autocomplete="new-password" class="block w-full rounded-lg border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary pl-10" id="password-again" name="password_again" placeholder="••••••••" required type="password"/>
</div>
</div>

<div class="flex items-start">
<div class="flex items-center h-5">
<input class="h-4 w-4 text-primary focus:ring-primary border-subtle-light dark:border-subtle-dark rounded" id="terms" name="terms" type="checkbox" <?php if (!empty($_POST["terms"])) echo "checked"; ?>/>
</div>
<div class="ml-3 text-sm">
<label class="font-medium text-foreground-light dark:text-foreground-dark" for="terms">
          <a class="text-primary hover:text-primary-dark" href="<?php echo htmlspecialchars($terms_url); ?>">Kullanım Koşulları</a> ve
          <a class="text-primary hover:text-primary-dark" href="<?php echo htmlspecialchars($privacy_url); ?>">Gizlilik Politikası</a>'nı kabul ediyorum
</label>
</div>
</div>
</div>

<!-- reCAPTCHA -->
<div class="flex justify-center">
<?php echo renderRecaptcha(); ?>
</div>

<div>
<button class="group relative flex w-full justify-center rounded-lg border border-transparent bg-primary py-3 px-4 text-sm font-bold text-white hover:bg-primary-dark focus:outline-none focus:ring-2 focus:ring-primary focus:ring-offset-2 dark:focus:ring-offset-background-dark" type="submit">
                  Kayıt Ol
                </button>
</div>
<div class="text-center text-sm">
<p class="text-muted-light dark:text-muted-dark">
                  Zaten hesabınız var mı?
                  <a class="font-medium text-primary hover:text-primary-dark" href="/login">Giriş yap</a>
</p>
</div>
</form>
<?php endif; ?>
</div>
</main>

<?php include "../includes/footer.php"; ?>

<script>
// Admin username kısıtlaması
const restrictedUsernames = [
    'admin', 'administrator', 'moderator', 'mod', 'root', 'superadmin', 'super', 'owner', 'founder',
    'ceo', 'manager', 'staff', 'support', 'help', 'system', 'bot', 'api', 'test', 'demo',
    'guest', 'user', 'member', 'visitor', 'anonymous', 'null', 'undefined', 'www', 'mail',
    'ftp', 'news', 'info', 'contact', 'about', 'privacy', 'terms', 'legal', 'security',
    'webmaster', 'hostmaster', 'postmaster', 'noreply', 'no-reply', 'donotreply',
    'sofi', 'sofia', 'sofie', 'sophie', 'sophia', 'sofya', 'sofija', 'sofia', 'sofie',
    'admin123', 'admin1', 'admin2', 'admin3', 'admin4', 'admin5', 'root123', 'root1',
    'moderator123', 'mod123', 'superadmin123', 'super123', 'owner123', 'founder123',
    'ceo123', 'manager123', 'staff123', 'support123', 'help123', 'system123', 'bot123',
    'api123', 'test123', 'demo123', 'guest123', 'user123', 'member123', 'visitor123',
    'anonymous123', 'null123', 'undefined123', 'www123', 'mail123', 'ftp123', 'news123',
    'info123', 'contact123', 'about123', 'privacy123', 'terms123', 'legal123', 'security123',
    'webmaster123', 'hostmaster123', 'postmaster123', 'noreply123', 'no-reply123', 'donotreply123'
];

function validateUsername(username) {
    const usernameLower = username.toLowerCase();
    
    // Boş kontrolü
    if (!username || username.trim() === '') {
        return 'Kullanıcı adı gereklidir';
    }
    
    // Kısıtlı kullanıcı adları kontrolü
    if (restrictedUsernames.includes(usernameLower)) {
        return 'Bu kullanıcı adı kısıtlı ve kullanılamaz';
    }
    
    // Uzunluk kontrolü
    if (username.length < 3) {
        return 'Kullanıcı adı en az 3 karakter olmalıdır';
    }
    
    if (username.length > 20) {
        return 'Kullanıcı adı en fazla 20 karakter olabilir';
    }
    
    // Karakter kontrolü
    if (!/^[a-zA-Z0-9_]+$/.test(username)) {
        return 'Kullanıcı adı sadece harf, rakam ve alt çizgi içerebilir';
    }
    
    // Yetkili kelime kontrolü
    if (usernameLower.includes('admin') || usernameLower.includes('mod') || 
        usernameLower.includes('root') || usernameLower.includes('super')) {
        return 'Kullanıcı adı admin, mod, root, super gibi yetkili kelimeler içeremez';
    }
    
    return null; // Geçerli
}

// Form submit validasyonu
document.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form');
    const usernameInput = document.getElementById('username');
    
    if (form && usernameInput) {
        // Real-time username validation
        usernameInput.addEventListener('input', function() {
            const username = this.value.trim();
            const error = validateUsername(username);
            
            // Remove existing error styling
            this.classList.remove('border-red-500', 'border-green-500');
            
            if (error) {
                this.classList.add('border-red-500');
                // Show error tooltip or message
                showUsernameError(error);
            } else if (username.length > 0) {
                this.classList.add('border-green-500');
                hideUsernameError();
            }
        });
        
        // Form submit validation
        form.addEventListener('submit', function(e) {
            const username = usernameInput.value.trim();
            const error = validateUsername(username);
            
            if (error) {
                e.preventDefault();
                showUsernameError(error);
                usernameInput.focus();
                return false;
            }
        });
    }
});

function showUsernameError(message) {
    // Remove existing error message
    hideUsernameError();
    
    // Create error message element
    const errorDiv = document.createElement('div');
    errorDiv.id = 'username-error';
    errorDiv.className = 'mt-2 text-sm text-red-600 dark:text-red-400';
    errorDiv.textContent = message;
    
    // Insert after username input
    const usernameInput = document.getElementById('username');
    const parentDiv = usernameInput.closest('div');
    parentDiv.appendChild(errorDiv);
}

function hideUsernameError() {
    const errorDiv = document.getElementById('username-error');
    if (errorDiv) {
        errorDiv.remove();
    }
}
</script>

<?php
// Content bottom reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
}
?>

</body>
</html>
