<?php
require_once '../includes/config.php';
require_once '../includes/ban_check.php';
require_once '../utils/recaptcha_helper.php';

// Site settings'lerini al
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$site_title_base = $settings['site_title'] ?? 'Web Directory';

// SEO Title oluştur
require_once '../utils/seo_title_helper.php';
$page_title = generatePageTitle('Kayıt Ol', $settings);
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($settings['meta_register'] ?? 'Create a new account and join our community.'); ?>">
    <?php
    // Favicon
    $favicon_url = $settings['favicon_url'] ?? '';
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
            $favicon_url = '/' . ltrim($favicon_url, '/');
        }
        echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    }
    ?>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com?plugins=forms"></script>
    <script>
    tailwind.config = {
      darkMode: "class",
      theme: {
        extend: {
          colors: {
            primary: "#13a4ec",
            "background-light": "#f6f7f8",
            "background-dark": "#101c22",
            "foreground-light": "#0d171b",
            "foreground-dark": "#e7eff3",
            "subtle-light": "#e7eff3",
            "subtle-dark": "#2c3a42",
            "muted-light": "#4c809a",
            "muted-dark": "#9cb3c1",
          },
          fontFamily: {
            display: ["Plus Jakarta Sans", "sans-serif"],
          },
          borderRadius: {
            DEFAULT: "0.5rem",
            lg: "1rem",
            xl: "1.5rem",
            full: "9999px"
          },
        },
      },
    };
  </script>
  <style>
    .gradient-text {
      background: linear-gradient(to right, #13a4ec, #9F7AEA);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }
    
    .material-symbols-outlined {
      font-variation-settings:
      'FILL' 0,
      'wght' 400,
      'GRAD' 0,
      'opsz' 24
    }
  </style>
  
  <?php echo getRecaptchaStyles(); ?>
  <?php echo getRecaptchaValidationJS(); ?>
</head>
<body class="bg-background-light dark:bg-background-dark font-display text-foreground-light dark:text-foreground-dark">

<div class="flex flex-col min-h-screen">
<?php include '../includes/header.php'; ?>
<main class="flex flex-1 justify-center py-10 px-4 sm:px-6 lg:px-8">
<div class="w-full max-w-md space-y-8">
<?php
// Kayıt başarılı mesajı ve yönlendirme
$success = false;
$error = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  // Basit validation
  $username = trim($_POST['username'] ?? '');
  $email = trim($_POST['email'] ?? '');
  $password = $_POST['password'] ?? '';
  $password_again = $_POST['password_again'] ?? '';
  $terms = isset($_POST['terms']);

  // reCAPTCHA doğrulaması
  if (!verifyRecaptcha()) {
    $error = getRecaptchaError();
  } elseif (!$username || !$email || !$password || !$password_again) {
    $error = "Lütfen tüm alanları doldurun.";
  } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $error = "Geçerli bir e-posta adresi girin.";
  } elseif ($password !== $password_again) {
    $error = "Şifreler eşleşmiyor.";
  } elseif (!$terms) {
    $error = "Kullanım koşullarını kabul etmelisiniz.";
  } else {
    // IP ban kontrolü
    $user_ip = getUserIP();
    $ban_status = checkBanStatus($pdo, null, $user_ip);
    
    if ($ban_status['is_banned']) {
      $error = $ban_status['message'];
    } else {
  // Veritabanı ayarlarını config.php'den çek
  include '../includes/config.php';
  try {
    $pdo = new PDO("mysql:host=$DB_HOST;dbname=$DB_NAME;charset=utf8mb4", $DB_USER, $DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
      // Kullanıcı var mı kontrolü
      $stmt = $pdo->prepare('SELECT id FROM user WHERE username = ? OR email = ?');
      $stmt->execute([$username, $email]);
      if ($stmt->fetch()) {
        $error = "Bu kullanıcı adı veya e-posta zaten kayıtlı.";
      } else {
  $hash = password_hash($password, PASSWORD_DEFAULT);
  $ip = $_SERVER['REMOTE_ADDR'] ?? '';
  $stmt = $pdo->prepare('INSERT INTO user (username, email, password, ip) VALUES (?, ?, ?, ?)');
  $stmt->execute([$username, $email, $hash, $ip]);
        $success = true;
        // Oturum aç
    if (session_status() === PHP_SESSION_NONE) {
      session_start();
    }
        $_SESSION['user_id'] = $pdo->lastInsertId();
        $_SESSION['username'] = $username;
        // Yönlendir
        echo '<div class="mb-4 p-3 rounded bg-green-100 text-green-800 text-center font-bold">Kayıt başarılı! Yönlendiriliyorsunuz...</div>';
        echo '<script>setTimeout(function(){ window.location.href = "/profile"; }, 2000);</script>';
      }
    } catch (Exception $e) {
  $error = "Kayıt sırasında bir hata oluştu: " . $e->getMessage();
    }
    } // Ban kontrolü kapanışı
  }
}
?>
<div>
<div class="mx-auto h-16 w-16 text-primary flex items-center justify-center rounded-full bg-primary/10">
<svg class="h-10 w-10" fill="none" stroke="currentColor" stroke-width="2" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
<path d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z" stroke-linecap="round" stroke-linejoin="round"></path>
</svg>
</div>
<h1 class="mt-6 text-3xl font-extrabold text-foreground-light dark:text-foreground-dark text-center">Create your account</h1>
<p class="mt-2 text-center text-sm text-muted-light dark:text-muted-dark">
        Or <a class="font-medium text-primary hover:text-primary/80" href="/login">sign in to your existing account</a>
</p>
</div>
<?php if ($error): ?>
  <div class="mb-4 p-3 rounded bg-red-100 text-red-800 text-center font-bold"><?php echo $error; ?></div>
<?php endif; ?>
<?php if (!$success): ?>
<form action="" class="mt-8 space-y-6" method="POST" <?php echo addRecaptchaAttribute(); ?>>
<div class="rounded-lg bg-white dark:bg-subtle-dark p-8 shadow-md space-y-6">
<div>
<label class="sr-only" for="username">Username</label>
<input autocomplete="username" class="block w-full rounded border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary" id="username" name="username" placeholder="Username" required type="text" value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>"/>
</div>
<div>
<label class="sr-only" for="email-address">Email address</label>
<input autocomplete="email" class="block w-full rounded border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary" id="email-address" name="email" placeholder="Email address" required type="email" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>"/>
</div>
<div>
<label class="sr-only" for="password">Password</label>
<input autocomplete="new-password" class="block w-full rounded border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary" id="password" name="password" placeholder="Password" required type="password"/>
</div>
<div>
<label class="sr-only" for="password-again">Confirm Password</label>
<input autocomplete="new-password" class="block w-full rounded border-subtle-light dark:border-subtle-dark bg-white dark:bg-background-dark text-foreground-light dark:text-foreground-dark placeholder-muted-light dark:placeholder-muted-dark focus:ring-primary focus:border-primary" id="password-again" name="password_again" placeholder="Confirm Password" required type="password"/>
</div>
<div class="flex items-start">
<div class="flex items-center h-5">
<input class="h-4 w-4 text-primary focus:ring-primary border-subtle-light dark:border-subtle-dark rounded" id="terms" name="terms" type="checkbox" <?php if (!empty($_POST['terms'])) echo 'checked'; ?>/>
</div>
<div class="ml-3 text-sm">
<label class="font-medium text-foreground-light dark:text-foreground-dark" for="terms">I agree to the
          <a class="text-primary hover:text-primary/80" href="#">Terms of Service</a> and
          <a class="text-primary hover:text-primary/80" href="#">Privacy Policy</a>
</label>
</div>
</div>
</div>

<!-- reCAPTCHA -->
<div class="flex justify-center">
<?php echo renderRecaptcha(); ?>
</div>

<div>
<button class="group relative flex w-full justify-center rounded-lg border border-transparent bg-primary py-3 px-4 text-sm font-bold text-white hover:bg-primary/90 focus:outline-none focus:ring-2 focus:ring-primary focus:ring-offset-2 dark:focus:ring-offset-background-dark" type="submit">
<span class="absolute left-0 inset-y-0 flex items-center pl-3">
<svg aria-hidden="true" class="h-5 w-5 text-primary-300 group-hover:text-primary-400" fill="currentColor" viewBox="0 0 20 20" xmlns="http://www.w3.org/2000/svg">
<path clip-rule="evenodd" d="M5 9V7a5 5 0 0110 0v2a2 2 0 012 2v5a2 2 0 01-2 2H5a2 2 0 01-2-2v-5a2 2 0 012-2zm8-2v2H7V7a3 3 0 016 0z" fill-rule="evenodd"></path>
</svg>
</span>
        Sign Up
        </button>
</div>
</form>
<?php endif; ?>
</div>
</main>
<?php include '../includes/footer.php'; ?>
</div>

</body>
</html>