<?php
/**
 * Email verification page
 * URL: /auth/verify-email/?token=...
 */

require_once "../includes/config.php";
require_once "../utils/email_verification_helper.php";

// Get site settings
$settings = [];
$stmt = $pdo->query("SELECT setting_key, setting_value FROM settings");
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row["setting_key"]] = $row["setting_value"];
}

$site_title_base = $settings["site_title"] ?? "Web Directory";
$message = '';
$message_type = '';

// Token check
if (isset($_GET['token']) && !empty($_GET['token'])) {
    $token = $_GET['token'];
    
    // Verify token
    $result = verifyEmailToken($token);
    
    if ($result['success']) {
        $message = $result['message'];
        $message_type = 'success';
    } else {
        $message = $result['message'];
        $message_type = 'error';
    }
} else {
    $message = 'Invalid verification link.';
    $message_type = 'error';
}

// SEO Title oluştur
require_once "../utils/seo_title_helper.php";
$page_title = generatePageTitle("Email Verification", $settings);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($settings["meta_register"] ?? "Verify your email address."); ?>">
    <?php
    // Favicon
    $favicon_url = $settings["favicon_url"] ?? "";
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, "http") && !str_starts_with($favicon_url, "//")) {
            $favicon_url = "/" . ltrim($favicon_url, "/");
        }
        echo "<link rel=\"icon\" type=\"image/x-icon\" href=\"" . htmlspecialchars($favicon_url) . "\">\n";
        echo "<link rel=\"shortcut icon\" href=\"" . htmlspecialchars($favicon_url) . "\">\n";
        echo "<link rel=\"apple-touch-icon\" href=\"" . htmlspecialchars($favicon_url) . "\">\n";
    }
    ?>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com?plugins=forms"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#38BDF8",
                        "primary-light": "#7DD3FC",
                        "primary-dark": "#0EA5E9",
                        "background-light": "#F7FAFC",
                        "background-dark": "#0F172A",
                        "foreground-light": "#0F172A",
                        "foreground-dark": "#E2E8F0",
                        "subtle-light": "#E2E8F0",
                        "subtle-dark": "#1E293B",
                        "muted-light": "#64748B",
                        "muted-dark": "#94A3B8"
                    },
                    fontFamily: {
                        "display": ["Public Sans", "sans-serif"]
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        "soft": "0 4px 12px 0 rgb(0 0 0 / 0.07)",
                        "subtle": "0 1px 2px 0 rgb(0 0 0 / 0.05)",
                    }
                },
            },
        };
    </script>
    <style>
        .material-symbols-outlined {
            font-variation-settings: "FILL" 0, "wght" 400, "GRAD" 0, "opsz" 24;
        }
    </style>
</head>
<body class="bg-background-light dark:bg-background-dark font-display">
    <?php include '../includes/header.php'; ?>
    
    <!-- Reklam Container - Content Top -->
    <?php renderAdContainer($current_page_type, 'content_top'); ?>

    <div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
        <div class="max-w-md w-full space-y-8">
            <div class="text-center">
                <div class="mx-auto h-16 w-16 bg-primary-light dark:bg-primary rounded-full flex items-center justify-center mb-6">
                    <span class="material-symbols-outlined text-3xl text-primary-dark dark:text-primary-light">
                        <?php echo $message_type === 'success' ? 'check_circle' : 'error'; ?>
                    </span>
                </div>
                <h2 class="text-3xl font-bold text-foreground-light dark:text-foreground-dark">
                    Email Verification
                </h2>
                <p class="mt-2 text-sm text-muted-light dark:text-muted-dark">
                    Verify your email address
                </p>
            </div>

            <div class="bg-white dark:bg-subtle-dark p-8 rounded-xl shadow-soft">
                <?php if ($message_type === 'success'): ?>
                    <div class="mb-6 p-4 rounded-lg bg-green-100 border border-green-200 text-green-800 text-center font-medium">
                        <?php echo htmlspecialchars($message); ?>
                    </div>
                    <div class="text-center">
                        <a href="/login" class="inline-flex items-center gap-2 bg-primary text-white font-bold py-3 px-6 rounded-lg hover:bg-primary-dark transition-colors">
                            <span class="material-symbols-outlined">login</span>
                            Log In
                        </a>
                    </div>
                <?php else: ?>
                    <div class="mb-6 p-4 rounded-lg bg-red-100 border border-red-200 text-red-800 text-center font-medium">
                        <?php echo htmlspecialchars($message); ?>
                    </div>
                    <div class="text-center space-y-3">
                        <a href="/register" class="inline-flex items-center gap-2 bg-primary text-white font-bold py-3 px-6 rounded-lg hover:bg-primary-dark transition-colors">
                            <span class="material-symbols-outlined">person_add</span>
                            Register Again
                        </a>
                        <div>
                            <a href="/" class="text-primary hover:text-primary-dark text-sm font-medium">
                                Back to Homepage
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <!-- Reklam Container - Content Bottom -->
    <?php renderAdContainer($current_page_type, 'content_bottom'); ?>

    <?php include '../includes/footer.php'; ?>
</body>
</html>
