<?php
// Error reporting'i kapat
error_reporting(0);
ini_set('display_errors', 0);

require_once 'includes/config.php';
require_once 'utils/ads_helper.php';

// Sayfalama ayarları
$perPage = 6;
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $perPage;

// Arama ve filtreleme
$search = $_GET['search'] ?? '';
$category = $_GET['category'] ?? '';

// SQL sorgusu oluştur
$whereConditions = ["bp.status = 'published'"];
$params = [];

if (!empty($search)) {
    $whereConditions[] = "(bp.title LIKE ? OR bp.excerpt LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if (!empty($category)) {
    $whereConditions[] = "bc.slug = ?";
    $params[] = $category;
}

$whereClause = 'WHERE ' . implode(' AND ', $whereConditions);

// Toplam kayıt sayısını al
$countSql = "SELECT COUNT(DISTINCT bp.id) 
             FROM blog_posts bp 
             LEFT JOIN blog_post_categories bpc ON bp.id = bpc.post_id 
             LEFT JOIN blog_categories bc ON bpc.category_id = bc.id 
             $whereClause";
$countStmt = $pdo->prepare($countSql);
$countStmt->execute($params);
$totalRecords = $countStmt->fetchColumn();

// Sayfalama bilgileri
$totalPages = ceil($totalRecords / $perPage);

// Blog yazılarını al
$sql = "SELECT bp.*, u.username as author_name,
        GROUP_CONCAT(DISTINCT bc.name) as categories,
        GROUP_CONCAT(DISTINCT bc.color) as category_colors
        FROM blog_posts bp 
        LEFT JOIN user u ON bp.author_id = u.id
        LEFT JOIN blog_post_categories bpc ON bp.id = bpc.post_id 
        LEFT JOIN blog_categories bc ON bpc.category_id = bc.id 
        $whereClause 
        GROUP BY bp.id
        ORDER BY bp.published_at DESC 
        LIMIT $perPage OFFSET $offset";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$posts = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Kategorileri al
$categoriesStmt = $pdo->query("SELECT * FROM blog_categories ORDER BY name");
$allCategories = $categoriesStmt->fetchAll(PDO::FETCH_ASSOC);

// SEO Meta
$pageTitle = "Blog - " . ($search ? "Arama: $search" : "Son Yazılar");
$pageDescription = "Platformumuzda en son blog yazıları, içgörüler ve makaleleri keşfedin.";
$pageKeywords = "blog, makaleler, yazılar, içgörüler, son haberler";

// Sayfa tipini tespit et
$current_page_type = detectPageType();

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($pageDescription); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($pageKeywords); ?>">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: '<?php echo htmlspecialchars($settings['primary_color'] ?? '#3b82f6'); ?>',
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" />
    
    <!-- Dark Mode Toggle Script -->
    <script>
        // Dark mode toggle functionality
        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.classList.contains('dark');
            
            if (isDark) {
                html.classList.remove('dark');
                localStorage.setItem('darkMode', 'false');
            } else {
                html.classList.add('dark');
                localStorage.setItem('darkMode', 'true');
            }
        }
        
        // Initialize dark mode from localStorage
        document.addEventListener('DOMContentLoaded', function() {
            const darkMode = localStorage.getItem('darkMode');
            if (darkMode === 'true') {
                document.documentElement.classList.add('dark');
            }
        });
    </script>
    
    <style>
        .blog-card {
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .blog-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
        }
        .dark .blog-card:hover {
            box-shadow: 0 20px 25px -5px rgba(255, 255, 255, 0.1), 0 10px 10px -5px rgba(255, 255, 255, 0.04);
        }
        .category-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            color: white;
            margin-right: 8px;
            margin-bottom: 8px;
        }
    </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900 min-h-full flex flex-col">
    <?php include 'includes/header.php'; ?>

    <main class="flex-1 pt-20">
        <!-- Hero Section -->
        <div class="bg-gradient-to-r from-blue-600 to-purple-600 dark:from-blue-800 dark:to-purple-800 text-white py-16">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center">
                    <h1 class="text-4xl md:text-5xl font-bold mb-4">Blogumuz</h1>
                    <p class="text-xl md:text-2xl text-blue-100 mb-8">İçgörüler, ipuçları ve son güncellemeleri keşfedin</p>
                    
                    <!-- Search Bar -->
                    <form method="GET" class="max-w-2xl mx-auto">
                        <div class="relative">
                            <input type="text" name="search" value="<?php echo htmlspecialchars($search); ?>" 
                                   placeholder="Blog yazılarını ara..." 
                                   class="w-full px-6 py-4 pr-16 rounded-full text-gray-900 text-lg focus:outline-none focus:ring-4 focus:ring-blue-300">
                            <button type="submit" class="absolute right-2 top-2 bg-blue-600 hover:bg-blue-700 text-white p-2 rounded-full transition-colors">
                                <span class="material-symbols-outlined">search</span>
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <?php
            // Content top reklamları
            if (($settings['ads_enabled'] ?? '1') === '1') {
                echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
            }
            ?>
            
            <div class="flex flex-col lg:flex-row gap-8">
                <!-- Main Content -->
                <div class="lg:w-3/4">
                    <!-- Category Filter -->
                    <?php if (!empty($allCategories)): ?>
                    <div class="mb-8">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Kategoriler</h3>
                        <div class="flex flex-wrap gap-2">
                            <a href="blog.php" class="px-4 py-2 rounded-full text-sm font-medium transition-colors <?php echo empty($category) ? 'bg-blue-600 text-white' : 'bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-300 dark:hover:bg-gray-600'; ?>">
                                Tümü
                            </a>
                            <?php foreach ($allCategories as $cat): ?>
                                <a href="blog.php?category=<?php echo urlencode($cat['slug']); ?>" 
                                   class="px-4 py-2 rounded-full text-sm font-medium transition-colors <?php echo $category === $cat['slug'] ? 'bg-blue-600 text-white' : 'bg-gray-200 dark:bg-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-300 dark:hover:bg-gray-600'; ?>"
                                   style="<?php echo $category === $cat['slug'] ? "background-color: {$cat['color']};" : ''; ?>">
                                    <?php echo htmlspecialchars($cat['name']); ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>

                    <!-- Blog Posts Grid -->
                    <?php if (empty($posts)): ?>
                        <div class="text-center py-16">
                            <span class="material-symbols-outlined text-6xl text-gray-400 dark:text-gray-600 mb-4 block">article</span>
                            <h3 class="text-xl font-semibold text-gray-900 dark:text-gray-100 mb-2">Yazı bulunamadı</h3>
                            <p class="text-gray-600 dark:text-gray-400">Arama veya filtre kriterlerinizi ayarlamayı deneyin.</p>
                        </div>
                    <?php else: ?>
                        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                            <?php foreach ($posts as $post): ?>
                                <article class="blog-card bg-white dark:bg-gray-800 rounded-xl shadow-lg dark:shadow-gray-900/20 overflow-hidden">
                                    <!-- Featured Image -->
                                    <?php if (!empty($post['featured_image'])): ?>
                                        <div class="aspect-w-16 aspect-h-9">
                                            <img src="<?php echo htmlspecialchars($post['featured_image']); ?>" 
                                                 alt="<?php echo htmlspecialchars($post['title']); ?>"
                                                 class="w-full h-48 object-cover">
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="p-6">
                                        <!-- Categories -->
                                        <?php if (!empty($post['categories'])): ?>
                                            <div class="mb-3">
                                                <?php 
                                                $categories = explode(',', $post['categories']);
                                                $colors = explode(',', $post['category_colors']);
                                                foreach ($categories as $index => $catName): 
                                                    $color = isset($colors[$index]) ? trim($colors[$index]) : '#6366f1';
                                                ?>
                                                    <span class="category-badge" style="background-color: <?php echo htmlspecialchars($color); ?>">
                                                        <?php echo htmlspecialchars(trim($catName)); ?>
                                                    </span>
                                                <?php endforeach; ?>
                                            </div>
                                        <?php endif; ?>
                                        
                                        <!-- Title -->
                                        <h2 class="text-xl font-bold text-gray-900 dark:text-gray-100 mb-3 line-clamp-2">
                                            <a href="blog/<?php echo htmlspecialchars($post['slug']); ?>" 
                                               class="hover:text-blue-600 dark:hover:text-blue-400 transition-colors">
                                                <?php echo htmlspecialchars($post['title']); ?>
                                            </a>
                                        </h2>
                                        
                                        <!-- Excerpt -->
                                        <?php if (!empty($post['excerpt'])): ?>
                                            <p class="text-gray-600 dark:text-gray-400 mb-4 line-clamp-3">
                                                <?php echo htmlspecialchars($post['excerpt']); ?>
                                            </p>
                                        <?php endif; ?>
                                        
                                        <!-- Meta Info -->
                                        <div class="flex items-center justify-between text-sm text-gray-500 dark:text-gray-400">
                                            <div class="flex items-center">
                                                <span class="material-symbols-outlined text-base mr-1">person</span>
                                                <?php echo htmlspecialchars($post['author_name'] ?? 'Admin'); ?>
                                            </div>
                                            <div class="flex items-center">
                                                <span class="material-symbols-outlined text-base mr-1">schedule</span>
                                                <?php echo date('M j, Y', strtotime($post['published_at'])); ?>
                                            </div>
                                        </div>
                                        
                                        <!-- Read More -->
                                        <div class="mt-4">
                                            <a href="blog/<?php echo htmlspecialchars($post['slug']); ?>" 
                                               class="inline-flex items-center text-blue-600 dark:text-blue-400 hover:text-blue-700 dark:hover:text-blue-300 font-medium transition-colors">
                                                Devamını Oku
                                                <span class="material-symbols-outlined ml-1 text-sm">arrow_forward</span>
                                            </a>
                                        </div>
                                    </div>
                                </article>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                    <!-- Pagination -->
                    <?php if ($totalPages > 1): ?>
                        <div class="flex justify-center mt-12">
                            <nav class="flex items-center space-x-2">
                                <?php if ($page > 1): ?>
                                    <a href="?page=<?php echo $page - 1; ?>&search=<?php echo urlencode($search); ?>&category=<?php echo urlencode($category); ?>" 
                                       class="px-3 py-2 rounded-lg bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                                        <span class="material-symbols-outlined text-sm">chevron_left</span>
                                    </a>
                                <?php endif; ?>
                                
                                <?php for ($i = max(1, $page - 2); $i <= min($totalPages, $page + 2); $i++): ?>
                                    <a href="?page=<?php echo $i; ?>&search=<?php echo urlencode($search); ?>&category=<?php echo urlencode($category); ?>" 
                                       class="px-4 py-2 rounded-lg transition-colors <?php echo $i === $page ? 'bg-blue-600 text-white' : 'bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700'; ?>">
                                        <?php echo $i; ?>
                                    </a>
                                <?php endfor; ?>
                                
                                <?php if ($page < $totalPages): ?>
                                    <a href="?page=<?php echo $page + 1; ?>&search=<?php echo urlencode($search); ?>&category=<?php echo urlencode($category); ?>" 
                                       class="px-3 py-2 rounded-lg bg-white dark:bg-gray-800 border border-gray-300 dark:border-gray-600 text-gray-700 dark:text-gray-300 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                                        <span class="material-symbols-outlined text-sm">chevron_right</span>
                                    </a>
                                <?php endif; ?>
                            </nav>
                        </div>
                    <?php endif; ?>
                </div>

                <!-- Sidebar -->
                <div class="lg:w-1/4">
                    <?php
                    // Sidebar reklamları
                    if (($settings['ads_enabled'] ?? '1') === '1') {
                        echo renderAdContainer($current_page_type, 'sidebar', 'ad-sidebar mb-6');
                    }
                    ?>
                    
                    <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg dark:shadow-gray-900/20 p-6 sticky top-24">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Son Yazılar</h3>
                        <?php
                        // Recent posts
                        $recentStmt = $pdo->query("SELECT title, slug, published_at FROM blog_posts WHERE status = 'published' ORDER BY published_at DESC LIMIT 5");
                        $recentPosts = $recentStmt->fetchAll(PDO::FETCH_ASSOC);
                        ?>
                        <div class="space-y-4">
                            <?php foreach ($recentPosts as $recent): ?>
                                <div class="border-b border-gray-200 dark:border-gray-700 pb-3 last:border-b-0">
                                    <a href="blog/<?php echo htmlspecialchars($recent['slug']); ?>" 
                                       class="text-sm font-medium text-gray-900 dark:text-gray-100 hover:text-blue-600 dark:hover:text-blue-400 transition-colors line-clamp-2">
                                        <?php echo htmlspecialchars($recent['title']); ?>
                                    </a>
                                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">
                                        <?php echo date('M j, Y', strtotime($recent['published_at'])); ?>
                                    </p>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <?php
            // Content bottom reklamları
            if (($settings['ads_enabled'] ?? '1') === '1') {
                echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
            }
            ?>
        </div>
    </main>

    <?php include 'includes/footer.php'; ?>
</body>
</html>
