<?php
// Error reporting'i kapat
error_reporting(0);
ini_set('display_errors', 0);

require_once 'includes/config.php';

// Slug'u al
$slug = $_GET['slug'] ?? '';

if (empty($slug)) {
    header('HTTP/1.0 404 Not Found');
    include '404.php';
    exit;
}

// Blog yazısını çek
try {
    $stmt = $pdo->prepare("SELECT bp.*, u.username as author_name, u.profile_photo as author_avatar
                          FROM blog_posts bp 
                          LEFT JOIN user u ON bp.author_id = u.id
                          WHERE bp.slug = ? AND bp.status = 'published'");
    $stmt->execute([$slug]);
    $post = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$post) {
        header('HTTP/1.0 404 Not Found');
        include '404.php';
        exit;
    }
    
    // View sayısını artır
    $updateViews = $pdo->prepare("UPDATE blog_posts SET views = views + 1 WHERE id = ?");
    $updateViews->execute([$post['id']]);
    
    // Blog yazısının kategorilerini çek
    $stmt = $pdo->prepare("SELECT bc.* FROM blog_post_categories bpc 
                          JOIN blog_categories bc ON bpc.category_id = bc.id 
                          WHERE bpc.post_id = ?");
    $stmt->execute([$post['id']]);
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Categories array'ini güvenli hale getir
    if (!is_array($categories)) {
        $categories = [];
    }
    
    // Blog yazısının etiketlerini çek
    $stmt = $pdo->prepare("SELECT bt.* FROM blog_post_tags bpt 
                          JOIN blog_tags bt ON bpt.tag_id = bt.id 
                          WHERE bpt.post_id = ?");
    $stmt->execute([$post['id']]);
    $tags = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Tags array'ini güvenli hale getir
    if (!is_array($tags)) {
        $tags = [];
    }
    
    // İlgili yazıları çek
    $relatedStmt = $pdo->prepare("SELECT bp.*, u.username as author_name
                                 FROM blog_posts bp 
                                 LEFT JOIN user u ON bp.author_id = u.id
                                 LEFT JOIN blog_post_categories bpc ON bp.id = bpc.post_id
                                 WHERE bp.status = 'published' 
                                 AND bp.id != ? 
                                 AND bpc.category_id IN (
                                     SELECT category_id FROM blog_post_categories WHERE post_id = ?
                                 )
                                 ORDER BY bp.published_at DESC 
                                 LIMIT 3");
    $relatedStmt->execute([$post['id'], $post['id']]);
    $relatedPosts = $relatedStmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Related posts array'ini güvenli hale getir
    if (!is_array($relatedPosts)) {
        $relatedPosts = [];
    }
    
} catch (Exception $e) {
    header('HTTP/1.0 500 Internal Server Error');
    exit;
}

// SEO Meta
$pageTitle = $post['meta_title'] ?: $post['title'];
$pageDescription = $post['meta_description'] ?: $post['excerpt'] ?: substr(strip_tags($post['description']), 0, 160);
$pageKeywords = $post['keywords'] ?: implode(', ', array_column($tags, 'name'));
?>

<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($pageDescription); ?>">
    <meta name="keywords" content="<?php echo htmlspecialchars($pageKeywords); ?>">
    
    <!-- Open Graph Meta Tags -->
    <meta property="og:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
    <meta property="og:description" content="<?php echo htmlspecialchars($pageDescription); ?>">
    <meta property="og:type" content="article">
    <meta property="og:url" content="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . '/blog/' . $post['slug']; ?>">
    <?php if (!empty($post['featured_image'])): ?>
    <meta property="og:image" content="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $post['featured_image']; ?>">
    <?php endif; ?>
    
    <!-- Twitter Card Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
    <meta name="twitter:description" content="<?php echo htmlspecialchars($pageDescription); ?>">
    <?php if (!empty($post['featured_image'])): ?>
    <meta name="twitter:image" content="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . $post['featured_image']; ?>">
    <?php endif; ?>
    
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    colors: {
                        primary: '<?php echo htmlspecialchars($settings['primary_color'] ?? '#3b82f6'); ?>',
                    }
                }
            }
        }
    </script>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" />
    
    <!-- Dark Mode Toggle Script -->
    <script>
        // Dark mode toggle functionality
        function toggleDarkMode() {
            const html = document.documentElement;
            const isDark = html.classList.contains('dark');
            
            if (isDark) {
                html.classList.remove('dark');
                localStorage.setItem('darkMode', 'false');
            } else {
                html.classList.add('dark');
                localStorage.setItem('darkMode', 'true');
            }
        }
        
        // Initialize dark mode from localStorage
        document.addEventListener('DOMContentLoaded', function() {
            const darkMode = localStorage.getItem('darkMode');
            if (darkMode === 'true') {
                document.documentElement.classList.add('dark');
            }
        });
    </script>
    
    <style>
        .article-content {
            line-height: 1.8;
        }
        .article-content h1, .article-content h2, .article-content h3, .article-content h4, .article-content h5, .article-content h6 {
            margin-top: 2rem;
            margin-bottom: 1rem;
            font-weight: 700;
            color: #1f2937;
        }
        .dark .article-content h1, .dark .article-content h2, .dark .article-content h3, .dark .article-content h4, .dark .article-content h5, .dark .article-content h6 {
            color: #f9fafb;
        }
        .article-content h1 { font-size: 2.25rem; }
        .article-content h2 { font-size: 1.875rem; }
        .article-content h3 { font-size: 1.5rem; }
        .article-content h4 { font-size: 1.25rem; }
        .article-content h5 { font-size: 1.125rem; }
        .article-content h6 { font-size: 1rem; }
        .article-content p {
            margin-bottom: 1.5rem;
            color: #374151;
        }
        .dark .article-content p {
            color: #d1d5db;
        }
        .article-content ul, .article-content ol {
            margin-bottom: 1.5rem;
            padding-left: 2rem;
        }
        .article-content li {
            margin-bottom: 0.5rem;
            color: #374151;
        }
        .dark .article-content li {
            color: #d1d5db;
        }
        .article-content blockquote {
            border-left: 4px solid #3b82f6;
            padding-left: 1.5rem;
            margin: 2rem 0;
            font-style: italic;
            color: #6b7280;
        }
        .dark .article-content blockquote {
            color: #9ca3af;
        }
        .article-content img {
            max-width: 100%;
            height: auto;
            border-radius: 0.5rem;
            margin: 2rem 0;
        }
        .article-content a {
            color: #3b82f6;
            text-decoration: underline;
        }
        .article-content a:hover {
            color: #1d4ed8;
        }
        .dark .article-content a {
            color: #60a5fa;
        }
        .dark .article-content a:hover {
            color: #93c5fd;
        }
        .category-badge {
            display: inline-block;
            padding: 6px 16px;
            border-radius: 25px;
            font-size: 14px;
            font-weight: 600;
            color: white;
            margin-right: 8px;
            margin-bottom: 8px;
        }
        .tag-badge {
            display: inline-block;
            padding: 4px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 500;
            background-color: #f3f4f6;
            color: #374151;
            margin-right: 8px;
            margin-bottom: 8px;
            transition: background-color 0.2s;
        }
        .tag-badge:hover {
            background-color: #e5e7eb;
        }
        .dark .tag-badge {
            background-color: #374151;
            color: #d1d5db;
        }
        .dark .tag-badge:hover {
            background-color: #4b5563;
        }
    </style>
</head>
<body class="bg-gray-50 dark:bg-gray-900 min-h-full flex flex-col">
    <?php include 'includes/header.php'; ?>

    <main class="flex-1 pt-20">
        <!-- Article Header -->
        <div class="bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
                <!-- Breadcrumb -->
                <nav class="mb-6">
                    <ol class="flex items-center space-x-2 text-sm text-gray-500 dark:text-gray-400">
                        <li><a href="/" class="hover:text-blue-600 dark:hover:text-blue-400 transition-colors">Ana Sayfa</a></li>
                        <li><span class="material-symbols-outlined text-base">chevron_right</span></li>
                        <li><a href="/blog.php" class="hover:text-blue-600 dark:hover:text-blue-400 transition-colors">Blog</a></li>
                        <li><span class="material-symbols-outlined text-base">chevron_right</span></li>
                        <li class="text-gray-900 dark:text-gray-100"><?php echo htmlspecialchars($post['title']); ?></li>
                    </ol>
                </nav>


                <!-- Title -->
                <h1 class="text-4xl md:text-5xl font-bold text-gray-900 dark:text-gray-100 mb-6 leading-tight">
                    <?php echo htmlspecialchars($post['title']); ?>
                </h1>

                <!-- Excerpt -->
                <?php if (!empty($post['excerpt'])): ?>
                    <p class="text-xl text-gray-600 dark:text-gray-300 mb-8 leading-relaxed">
                        <?php echo htmlspecialchars($post['excerpt']); ?>
                    </p>
                <?php endif; ?>

                <!-- Meta Info -->
                <div class="flex flex-wrap items-center gap-6 text-sm text-gray-500 dark:text-gray-400">
                    <div class="flex items-center">
                        <img src="<?php echo htmlspecialchars($post['author_avatar'] ?: '/uploads/no-logo.png'); ?>" 
                             alt="<?php echo htmlspecialchars($post['author_name']); ?>"
                             class="w-10 h-10 rounded-full mr-3 object-cover">
                        <div>
                            <p class="font-medium text-gray-900 dark:text-gray-100"><?php echo htmlspecialchars($post['author_name'] ?? 'Admin'); ?></p>
                            <p class="text-sm text-gray-500 dark:text-gray-400">Yazar</p>
                        </div>
                    </div>
                    <div class="flex items-center">
                        <span class="material-symbols-outlined text-base mr-2">schedule</span>
                        <?php echo date('F j, Y', strtotime($post['published_at'])); ?>
                    </div>
                    <div class="flex items-center">
                        <span class="material-symbols-outlined text-base mr-2">visibility</span>
                        <?php echo number_format($post['views'] + 1); ?> görüntüleme
                    </div>
                </div>
            </div>
        </div>

        <!-- Featured Image -->
        <?php if (!empty($post['featured_image'])): ?>
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
                <img src="<?php echo htmlspecialchars($post['featured_image']); ?>" 
                     alt="<?php echo htmlspecialchars($post['title']); ?>"
                     class="w-full h-64 md:h-96 object-cover rounded-xl shadow-lg">
            </div>
        <?php endif; ?>

        <!-- Article Content -->
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 pb-12">
            <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg dark:shadow-gray-900/20 p-8 md:p-12">
                <div class="article-content prose prose-lg max-w-none">
                    <?php echo $post['description']; ?>
                </div>

                <!-- Tags -->
                <?php if (!empty($tags)): ?>
                    <div class="mt-12 pt-8 border-t border-gray-200 dark:border-gray-700">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Etiketler</h3>
                        <div>
                            <?php foreach ($tags as $tag): ?>
                                <a href="blog.php?search=<?php echo urlencode($tag['name']); ?>" 
                                   class="tag-badge hover:bg-gray-200 dark:hover:bg-gray-600 transition-colors">
                                    <?php echo htmlspecialchars($tag['name']); ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Share Buttons -->
                <div class="mt-8 pt-8 border-t border-gray-200 dark:border-gray-700">
                    <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100 mb-4">Bu makaleyi paylaş</h3>
                    <div class="flex space-x-4">
                        <a href="https://twitter.com/intent/tweet?url=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . '/blog/' . $post['slug']); ?>&text=<?php echo urlencode($post['title']); ?>" 
                           target="_blank" 
                           class="flex items-center px-4 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600 transition-colors">
                            <i class="fab fa-twitter mr-2"></i>
                            Twitter
                        </a>
                        <a href="https://www.facebook.com/sharer/sharer.php?u=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . '/blog/' . $post['slug']); ?>" 
                           target="_blank" 
                           class="flex items-center px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                            <i class="fab fa-facebook mr-2"></i>
                            Facebook
                        </a>
                        <a href="https://www.linkedin.com/sharing/share-offsite/?url=<?php echo urlencode('https://' . $_SERVER['HTTP_HOST'] . '/blog/' . $post['slug']); ?>" 
                           target="_blank" 
                           class="flex items-center px-4 py-2 bg-blue-700 text-white rounded-lg hover:bg-blue-800 transition-colors">
                            <i class="fab fa-linkedin mr-2"></i>
                            LinkedIn
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Related Posts -->
        <?php if (!empty($relatedPosts)): ?>
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 pb-16">
                <h2 class="text-3xl font-bold text-gray-900 dark:text-gray-100 mb-8 text-center">İlgili Makaleler</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <?php foreach ($relatedPosts as $related): ?>
                        <article class="bg-white dark:bg-gray-800 rounded-xl shadow-lg dark:shadow-gray-900/20 overflow-hidden hover:shadow-xl dark:hover:shadow-gray-900/30 transition-shadow">
                            <?php if (!empty($related['featured_image'])): ?>
                                <img src="<?php echo htmlspecialchars($related['featured_image']); ?>" 
                                     alt="<?php echo htmlspecialchars($related['title']); ?>"
                                     class="w-full h-48 object-cover">
                            <?php endif; ?>
                            <div class="p-6">
                                <h3 class="text-lg font-bold text-gray-900 dark:text-gray-100 mb-3 line-clamp-2">
                                    <a href="blog/<?php echo htmlspecialchars($related['slug']); ?>" 
                                       class="hover:text-blue-600 dark:hover:text-blue-400 transition-colors">
                                        <?php echo htmlspecialchars($related['title']); ?>
                                    </a>
                                </h3>
                                <?php if (!empty($related['excerpt'])): ?>
                                    <p class="text-gray-600 dark:text-gray-400 mb-4 line-clamp-3">
                                        <?php echo htmlspecialchars($related['excerpt']); ?>
                                    </p>
                                <?php endif; ?>
                                <div class="flex items-center justify-between text-sm text-gray-500 dark:text-gray-400">
                                    <span><?php echo htmlspecialchars($related['author_name'] ?? 'Admin'); ?></span>
                                    <span><?php echo date('M j, Y', strtotime($related['published_at'])); ?></span>
                                </div>
                            </div>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </main>

    <?php include 'includes/footer.php'; ?>
</body>
</html>
