# 🤖 AI Bot Sistemi

Bu klasör, yapay zeka destekli otomatik içerik oluşturucu bot sistemini içerir.

## 🎯 Özellikler

### ✅ Otomatik Site Bulma
- Google Custom Search API ile rastgele web siteleri bulur
- Spam ve zararlı siteleri filtreler
- Daha önce eklenen siteleri kontrol eder

### ✅ AI İçerik Üretimi
- OpenAI GPT-3.5-turbo ile Türkçe içerik üretir
- Kısa açıklama (40 kelimeye kadar)
- Uzun açıklama (200-500 kelime arası)
- SEO uyumlu ve doğal dil

### ✅ Site Analizi
- URL'den başlık ve meta description çıkarır
- Site logosunu otomatik bulur
- Domain'den e-posta adresi oluşturur
- Rastgele kategori ataması

### ✅ Kontrol Paneli
- Bot başlatma/durdurma
- Gerçek zamanlı durum takibi
- Detaylı log sistemi
- Ayarlar yönetimi

## 📁 Dosya Yapısı

```
/bot/
├── index.php              # Ana kontrol paneli
├── settings.php           # Bot ayarları
├── logs.php              # Log görüntüleme
├── run_bot.php           # Bot çalıştırıcı
├── website_analyzer.php   # Site analiz sınıfı
├── google_search_bot.php # Arama ve işleme sınıfı
└── README.md             # Bu dosya
```

## ⚙️ Kurulum

### 1. API Anahtarları
Bot ayarlarından aşağıdaki API anahtarlarını girin:

**OpenAI API Key:**
- https://platform.openai.com/ adresinden API key alın
- `sk-...` formatında olmalı

**Google Custom Search API:**
- https://developers.google.com/custom-search/v1/introduction
- API Key: `AIza...` formatında
- Search Engine ID: `cx:...` formatında

### 2. Google Custom Search Engine Oluşturma
1. https://cse.google.com/cse/ adresine gidin
2. "Add" butonuna tıklayın
3. "Sites to search" kısmına `*` yazın (tüm web)
4. "Create" butonuna tıklayın
5. "Control Panel" → "Setup" → "Search engine ID" kopyalayın

### 3. Bot Ayarları
- **Çalıştırma Aralığı:** Bot'un tekrar çalışma süresi (saniye)
- **Site Sayısı:** Her çalıştırmada işlenecek site sayısı (1-20)
- **Arama Kelimeleri:** Virgülle ayrılmış anahtar kelimeler
- **Açıklama Uzunluğu:** Minimum ve maksimum kelime sayısı

## 🚀 Kullanım

### Bot Başlatma
1. Bot ayarlarını yapılandırın
2. Ana panelden "Bot'u Başlat" butonuna tıklayın
3. Bot otomatik olarak çalışacak ve durdu

### İzleme
- **Ana Panel:** Bot durumu ve istatistikleri
- **Loglar:** Detaylı çalışma geçmişi
- **Hata Durumu:** Bot otomatik olarak durur

## 📊 Çalışma Süreci

1. **Arama:** Google'dan rastgele siteler bulur
2. **Filtreleme:** Spam ve zararlı siteleri eler
3. **Analiz:** Her site için meta bilgileri çıkarır
4. **AI İçerik:** OpenAI ile açıklamalar üretir
5. **Kayıt:** Siteyi veritabanına ekler
6. **Log:** Tüm işlemleri loglar

## 🛡️ Güvenlik

### Rate Limiting
- Google API: 0.5 saniye bekleme
- Site analizi: 2 saniye bekleme
- Günlük quota koruması

### Content Filtering
- Kara liste kontrolü
- Adult content filtresi
- Duplicate site kontrolü
- Broken link kontrolü

## 🔧 Sorun Giderme

### Bot Çalışmıyor
1. API anahtarlarını kontrol edin
2. Bot loglarını kontrol edin
3. Veritabanı bağlantısını kontrol edin

### API Quota Hatası
1. Google Console'da quota kontrol edin
2. OpenAI usage sayfasını kontrol edin
3. Çalıştırma aralığını artırın

### İçerik Kalitesi
1. OpenAI prompt'unu günceleyin
2. Minimum/maksimum kelime sayısını ayarlayın
3. Arama kelimelerini daha spesifik yapın

## 📈 İstatistikler

Bot aşağıdaki metrikleri takip eder:
- Toplam eklenen site sayısı
- Son çalıştırma tarihi
- Başarı/hata oranları
- Log türlerine göre dağılım

## 🎛️ Gelişmiş Ayarlar

### Fallback Sistemi
API'ler çalışmazsa fallback içerik üretir:
- Test siteleri listesi
- Template açıklamalar
- Güvenli kategoriler

### Kategori Yönetimi
- Rastgele kategori ataması
- Hedef kategori seçimi
- Akıllı kategori eşleştirme

## 📝 Log Türleri

- **Info:** Genel bilgi mesajları
- **Success:** Başarılı site eklemeleri  
- **Warning:** Uyarı mesajları
- **Error:** Hata durumları

## 🔄 Bakım

### Log Temizleme
- Manuel log temizleme
- Tür bazında temizleme
- Otomatik eski log silme

### Performans
- Database indexleri
- Memory optimization
- Connection pooling

---

Bot sistemi tamamen otomatik çalışır ve minimal müdahale gerektirir. 
Herhangi bir sorun durumunda logları kontrol edin.