<?php
require_once '../includes/config.php';
require_once '../includes/turkish_fix.php';

// Bot işlemlerini durdurma fonksiyonu
function killAllBotProcesses() {
    try {
        // Windows için
        if (strtoupper(substr(PHP_OS, 0, 3)) === 'WIN') {
            // PHP bot işlemlerini durdur
            exec('taskkill /f /im php.exe /fi "WINDOWTITLE eq *bot*" 2>nul');
            exec('taskkill /f /im php.exe /fi "COMMANDLINE eq *run_bot*" 2>nul');
            exec('taskkill /f /im php.exe /fi "COMMANDLINE eq *run_category_bot*" 2>nul');
        } else {
            // Linux/Unix için
            exec('pkill -f "run_bot.php" 2>/dev/null');
            exec('pkill -f "run_category_bot.php" 2>/dev/null');
            exec('pkill -f "run_category_bot_batch.php" 2>/dev/null');
        }
        
        // Bot işlem dosyalarını temizle
        $bot_files = [
            'bot_running.lock',
            'bot_process.pid', 
            'current_bot_job.txt',
            'bot_stop.lock'
        ];
        
        foreach ($bot_files as $file) {
            if (file_exists($file)) {
                unlink($file);
            }
        }
        
        error_log("Bot işlemleri durduruldu");
        
    } catch (Exception $e) {
        error_log("Bot işlem durdurma hatası: " . $e->getMessage());
    }
}

// Bot işlemi durumu
$bot_status = 'stopped';
$last_run = '';
$total_sites_added = 0;

try {
    // Bot durumunu kontrol et
    $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
    $stmt->execute(['bot_status']);
    $bot_status = $stmt->fetchColumn() ?: 'stopped';
    
    $stmt->execute(['bot_last_run']);
    $last_run = $stmt->fetchColumn() ?: 'Hiç çalıştırılmamış';
    
    $stmt->execute(['bot_total_sites']);
    $total_sites_added = intval($stmt->fetchColumn() ?: 0);
} catch (Exception $e) {
    // Settings tablosu yoksa oluştur
}

// POST işlemleri
if ($_POST) {
    if (isset($_POST['start_bot'])) {
        // Bot başlat - sadece durumu aktif yap
        $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->execute(['bot_status', 'running', 'running']);
        $stmt->execute(['bot_force_stop', '0', '0']); // Durdurma sinyalini sıfırla
        $bot_status = 'running';
        
        // Başlatma zamanını kaydet
        $stmt->execute(['bot_last_started', date('Y-m-d H:i:s'), date('Y-m-d H:i:s')]);
        
        // Stop lock dosyasını temizle
        if (file_exists('bot_stop.lock')) {
            unlink('bot_stop.lock');
        }
        
        // Bot başlatma logu
        try {
            $stmt = $pdo->prepare("INSERT INTO bot_logs (message, level, created_at) VALUES (?, ?, NOW())");
            $stmt->execute(['Bot başlatıldı - Tüm işlemler aktif', 'info']);
        } catch (Exception $e) {
            // Log hatası - sessizce geç
        }
        
        // Sayfayı yenile (redirect etme)
        header('Location: index.php?started=1');
        exit;
    } elseif (isset($_POST['stop_bot'])) {
        // Bot durdur - tüm işlemleri durdur
        $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
        $stmt->execute(['bot_status', 'stopped', 'stopped']);
        $stmt->execute(['bot_force_stop', '1', '1']);
        $stmt->execute(['bot_stop_time', date('Y-m-d H:i:s'), date('Y-m-d H:i:s')]);
        $bot_status = 'stopped';
        
        // Çalışan bot işlemlerini durdur
        try {
            // Bot durdurma lock dosyası oluştur
            $stop_lock_content = json_encode([
                'stop_time' => date('Y-m-d H:i:s'),
                'reason' => 'Manual stop by user',
                'status' => 'stopped'
            ]);
            file_put_contents('bot_stop.lock', $stop_lock_content, LOCK_EX);
            
            // Bot log dosyasına durdurma mesajı yaz
            $log_message = "[" . date('Y-m-d H:i:s') . "] 🛑 BOT DURDURULDU - Tüm işlemler durduruldu\n";
            file_put_contents('bot_logs.txt', $log_message, FILE_APPEND | LOCK_EX);
            
            // Veritabanına durdurma logu ekle
            $stmt = $pdo->prepare("INSERT INTO bot_logs (message, level, created_at) VALUES (?, ?, NOW())");
            $stmt->execute(['🛑 Bot durduruldu - Tüm işlemler durduruldu', 'warning']);
            
            // Bot işlem dosyalarını temizle (eğer varsa)
            $bot_files = ['bot_running.lock', 'bot_process.pid', 'current_bot_job.txt'];
            foreach ($bot_files as $file) {
                if (file_exists($file)) {
                    unlink($file);
                }
            }
            
            // Tüm çalışan bot işlemlerini durdur
            killAllBotProcesses();
            
        } catch (Exception $e) {
            error_log("Bot durdurma hatası: " . $e->getMessage());
        }
        
        // Başarı mesajı ile yönlendir
        header('Location: index.php?stopped=1');
        exit;
    } elseif (isset($_POST['set_language'])) {
        // Dil ayarını kaydet
        $language = $_POST['language'];
        if (in_array($language, ['tr', 'en'])) {
            $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
            $stmt->execute(['bot_content_language', $language, $language]);
            header('Location: index.php?language_updated=1');
            exit;
        }
    } elseif (isset($_POST['clear_logs'])) {
        // Logları temizle
        try {
            // Veritabanından logları sil
            $pdo->exec("DELETE FROM bot_logs");
            
            // Log dosyasını temizle
            if (file_exists('bot_logs.txt')) {
                file_put_contents('bot_logs.txt', '');
            }
            
            // Başarı mesajı ile yönlendir
            header('Location: index.php?logs_cleared=1');
            exit;
        } catch (Exception $e) {
            // Hata mesajı ile yönlendir
            header('Location: index.php?clear_error=1');
            exit;
        }
    }
}

// Bot ayarlarını al
function getBotSetting($pdo, $key, $default = '') {
    try {
        $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
        $stmt->execute(['bot_' . $key]);
        $result = $stmt->fetchColumn();
        return $result !== false ? $result : $default;
    } catch (Exception $e) {
        return $default;
    }
}

// Site ayarlarını al
$stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'site_name'");
$stmt->execute();
$site_name = $stmt->fetchColumn() ?: 'Site Directory';
?>
<!DOCTYPE html>
<html lang="tr" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>AI Bot Kontrol Paneli | <?php echo htmlspecialchars($site_name); ?></title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Inter', 'ui-sans-serif', 'system-ui'],
                    },
                    colors: {
                        primary: '#6366f1',
                        secondary: '#8b5cf6',
                        success: '#10b981',
                        danger: '#ef4444',
                        warning: '#f59e0b',
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .card-hover {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .card-hover:hover {
            transform: translateY(-8px) scale(1.02);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        }
        
        .bot-card {
            background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
            border: 1px solid rgba(99, 102, 241, 0.1);
        }
        
        .dark .bot-card {
            background: linear-gradient(145deg, #1f2937 0%, #111827 100%);
            border: 1px solid rgba(99, 102, 241, 0.2);
        }
        
        .status-running {
            background: linear-gradient(135deg, #10b981, #059669);
            animation: pulse 2s infinite;
        }
        
        .status-stopped {
            background: linear-gradient(135deg, #6b7280, #4b5563);
        }
        
        @keyframes pulse {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.8; }
        }
        
        .btn-primary {
            background: linear-gradient(135deg, #6366f1, #4f46e5);
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(99, 102, 241, 0.4);
        }
        
        .btn-success {
            background: linear-gradient(135deg, #10b981, #059669);
            transition: all 0.3s ease;
        }
        
        .btn-success:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(16, 185, 129, 0.4);
        }
        
        .btn-danger {
            background: linear-gradient(135deg, #ef4444, #dc2626);
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .btn-danger:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(239, 68, 68, 0.4);
        }
        
        .btn-danger::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }
        
        .btn-danger:hover::before {
            left: 100%;
        }
        
        .btn-danger.stop-animation {
            animation: stopPulse 1s infinite;
        }
        
        @keyframes stopPulse {
            0%, 100% { 
                box-shadow: 0 0 0 0 rgba(239, 68, 68, 0.7);
            }
            50% { 
                box-shadow: 0 0 0 10px rgba(239, 68, 68, 0);
            }
        }
        
        .floating-animation {
            animation: float 6s ease-in-out infinite;
        }
        
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        
        .text-gradient {
            background: linear-gradient(135deg, #6366f1, #8b5cf6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        /* Font Awesome icons */
        .fa {
            font-family: "Font Awesome 6 Free";
            font-weight: 900;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 dark:from-slate-900 dark:via-slate-800 dark:to-slate-900 min-h-screen">
    <div class="max-w-6xl mx-auto p-6">
        <!-- Header -->
        <div class="text-center mb-12">
            <div class="inline-flex items-center justify-center w-20 h-20 rounded-full bg-gradient-to-r from-indigo-500 to-purple-600 mb-6 floating-animation">
                <i class="fas fa-robot text-4xl text-white"></i>
            </div>
            <h1 class="text-5xl font-black text-gradient mb-4">AI Bot Kontrol Paneli</h1>
            <p class="text-xl text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Yapay zeka destekli otomatik içerik oluşturucu bot ile sitenizi büyütün
            </p>
        </div>

        <!-- Success Message -->
        <?php if (isset($_GET['started'])): ?>
        <div class="bg-green-50 border border-green-200 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                        <span class="text-green-600 text-sm font-bold">✓</span>
                    </div>
                </div>
                <div class="ml-3">
                    <p class="text-green-800 font-medium">Bot başarıyla başlatıldı!</p>
                    <p class="text-green-700 text-sm">Bot şu anda aktif durumda. "Hemen Çalıştır" veya "Kategori Bazlı Çalıştır" butonları ile içerik toplama işlemini başlatabilirsiniz.</p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Bot Stopped Message -->
        <?php if (isset($_GET['stopped'])): ?>
        <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                        <span class="text-red-600 text-sm font-bold">🛑</span>
                    </div>
                </div>
                <div class="ml-3">
                    <p class="text-red-800 font-medium">Bot başarıyla durduruldu!</p>
                    <p class="text-red-700 text-sm">Tüm çalışan bot işlemleri durduruldu ve mevcut işlemler kesildi.</p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Language Updated Message -->
        <?php if (isset($_GET['language_updated'])): ?>
        <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-blue-100 rounded-lg flex items-center justify-center">
                        <span class="text-blue-600 text-sm font-bold">🌍</span>
                    </div>
                </div>
                <div class="ml-3">
                    <p class="text-blue-800 font-medium">Dil ayarı güncellendi!</p>
                    <p class="text-blue-700 text-sm">Bot artık seçtiğiniz dilde içerik çekecek.</p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Logs Cleared Message -->
        <?php if (isset($_GET['logs_cleared'])): ?>
        <div class="bg-green-50 border border-green-200 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-green-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-check-circle text-green-600"></i>
                    </div>
                </div>
                <div class="ml-3">
                    <p class="text-green-800 font-medium">Loglar başarıyla temizlendi!</p>
                    <p class="text-green-700 text-sm">Tüm bot logları silindi.</p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Clear Error Message -->
        <?php if (isset($_GET['clear_error'])): ?>
        <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <div class="flex-shrink-0">
                    <div class="w-8 h-8 bg-red-100 rounded-lg flex items-center justify-center">
                        <i class="fas fa-exclamation-circle text-red-600"></i>
                    </div>
                </div>
                <div class="ml-3">
                    <p class="text-red-800 font-medium">Log temizleme hatası!</p>
                    <p class="text-red-700 text-sm">Loglar temizlenirken bir hata oluştu.</p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Bot Status -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <div class="bot-card rounded-2xl shadow-lg p-6 card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Bot Durumu</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white">
                            <?php echo $bot_status === 'running' ? 'Çalışıyor' : 'Durduruldu'; ?>
                        </p>
                    </div>
                    <div class="flex-shrink-0">
                        <?php if ($bot_status === 'running'): ?>
                            <div class="w-4 h-4 bg-green-500 rounded-full animate-pulse shadow-lg"></div>
                        <?php else: ?>
                            <div class="w-4 h-4 bg-red-500 rounded-full shadow-lg"></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="bot-card rounded-2xl shadow-lg p-6 card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Eklenen Site</p>
                        <p class="text-2xl font-bold text-gray-900 dark:text-white"><?php echo number_format($total_sites_added); ?></p>
                    </div>
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl flex items-center justify-center shadow-lg">
                            <i class="fas fa-globe text-white text-xl"></i>
                        </div>
                    </div>
                </div>
            </div>

            <div class="bot-card rounded-2xl shadow-lg p-6 card-hover">
                <div class="flex items-center justify-between">
                    <div>
                        <p class="text-sm font-medium text-gray-500 dark:text-gray-400 mb-1">Son Çalıştırma</p>
                        <p class="text-lg font-bold text-gray-900 dark:text-white"><?php echo htmlspecialchars($last_run); ?></p>
                    </div>
                    <div class="flex-shrink-0">
                        <div class="w-12 h-12 bg-gradient-to-r from-purple-500 to-purple-600 rounded-xl flex items-center justify-center shadow-lg">
                            <i class="fas fa-clock text-white text-xl"></i>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Language Selection -->
        <div class="bot-card rounded-2xl shadow-lg p-6 mb-8">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">🌍 İçerik Dili Seçimi</h3>
                    <p class="text-gray-600 dark:text-gray-300">Bot hangi dilde içerik çekeceğini seçin</p>
                    <p class="text-sm text-blue-600 dark:text-blue-400 mt-1">
                        <strong>Seçili dil:</strong> 
                        <?php 
                        $currentLang = getBotSetting($pdo, 'content_language', 'tr');
                        echo $currentLang === 'en' ? '🇺🇸 English' : '🇹🇷 Türkçe';
                        ?>
                    </p>
                </div>
                <div class="flex gap-3">
                    <button type="button" onclick="setLanguage('tr')" 
                            class="language-btn px-6 py-3 rounded-xl font-semibold transition-all <?php echo (getBotSetting($pdo, 'content_language', 'tr') === 'tr') ? 'bg-blue-600 text-white shadow-lg' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'; ?>">
                        🇹🇷 Türkçe
                    </button>
                    <button type="button" onclick="setLanguage('en')" 
                            class="language-btn px-6 py-3 rounded-xl font-semibold transition-all <?php echo (getBotSetting($pdo, 'content_language', 'tr') === 'en') ? 'bg-blue-600 text-white shadow-lg' : 'bg-gray-200 text-gray-700 hover:bg-gray-300'; ?>">
                        🇺🇸 English
                    </button>
                </div>
            </div>
        </div>

        <!-- Bot Controls -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
            <!-- Normal Bot -->
            <div class="bot-card rounded-2xl shadow-lg p-8 card-hover">
                <div class="flex items-center mb-6">
                    <div class="w-16 h-16 bg-gradient-to-r from-blue-500 to-blue-600 rounded-2xl flex items-center justify-center mr-4 shadow-lg">
                        <i class="fas fa-robot text-white text-2xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 dark:text-white">Normal Bot</h3>
                        <p class="text-gray-600 dark:text-gray-300">Rastgele arama anahtar kelimeleri ile site bulur ve ekler</p>
                    </div>
                </div>
                
                <form method="POST" class="space-y-4">
                    <?php if ($bot_status === 'stopped'): ?>
                        <button type="submit" name="start_bot" 
                                class="btn-primary w-full text-white px-6 py-4 rounded-xl text-lg font-semibold flex items-center justify-center gap-3 shadow-lg">
                            <i class="fas fa-rocket"></i>
                            Normal Bot'u Başlat
                        </button>
                        <p class="text-sm text-gray-500 dark:text-gray-400 text-center">
                            Bot'u başlattıktan sonra "Rastgele kategorilerden içerik çek" butonu görünecek
                        </p>
                    <?php else: ?>
                        <div class="space-y-3">
                            <button type="submit" name="stop_bot" 
                                    class="bg-red-600 hover:bg-red-700 stop-animation w-full text-white px-6 py-4 rounded-xl text-lg font-bold flex items-center justify-center gap-3 shadow-lg border-2 border-red-500 animate-pulse"
                                    onclick="return confirmStopBot()">
                                <i class="fas fa-stop-circle text-2xl"></i>
                                🛑 BOT'U DURDUR (TÜM İŞLEMLER)
                            </button>
                            <a href="run_bot.php" 
                               class="btn-success w-full text-white px-6 py-4 rounded-xl text-lg font-semibold flex items-center justify-center gap-3 shadow-lg">
                                <i class="fas fa-play"></i>
                                Rastgele kategorilerden içerik çek
                            </a>
                        </div>
                    <?php endif; ?>
                </form>
            </div>
            
            <!-- Kategori Bazlı Bot -->
            <div class="bot-card rounded-2xl shadow-lg p-8 card-hover">
                <div class="flex items-center mb-6">
                    <div class="w-16 h-16 bg-gradient-to-r from-purple-500 to-purple-600 rounded-2xl flex items-center justify-center mr-4 shadow-lg">
                        <i class="fas fa-tags text-white text-2xl"></i>
                    </div>
                    <div>
                        <h3 class="text-2xl font-bold text-gray-900 dark:text-white">Kategori Bazlı Bot</h3>
                        <p class="text-gray-600 dark:text-gray-300">Birden fazla kategori seçip toplu olarak site ekleyin</p>
                    </div>
                </div>
                
                <div class="space-y-3">
                    <a href="category_selector.php" 
                       class="btn-primary w-full text-white px-6 py-4 rounded-xl text-lg font-semibold flex items-center justify-center gap-3 shadow-lg">
                        <i class="fas fa-crosshairs"></i>
                        Gelişmiş Kategori Seçici
                    </a>
                    <a href="run_category_bot.php" 
                       class="w-full bg-gray-500 hover:bg-gray-600 text-white px-6 py-3 rounded-xl text-sm font-medium flex items-center justify-center gap-2 shadow-lg transition-all">
                        <i class="fas fa-play"></i>
                        Kategori Botunu başlat
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Additional Controls -->
        <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
            <a href="settings.php" 
               class="bot-card rounded-2xl shadow-lg p-6 card-hover flex items-center justify-between group">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-r from-gray-500 to-gray-600 rounded-xl flex items-center justify-center mr-4 shadow-lg">
                        <i class="fas fa-cog text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white">Bot Ayarları</h3>
                        <p class="text-gray-600 dark:text-gray-300 text-sm">Bot konfigürasyonunu yönetin</p>
                    </div>
                </div>
                <i class="fas fa-arrow-right text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-200 transition-colors"></i>
            </a>
            
            <a href="logs.php" 
               class="bot-card rounded-2xl shadow-lg p-6 card-hover flex items-center justify-between group">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-r from-blue-500 to-blue-600 rounded-xl flex items-center justify-center mr-4 shadow-lg">
                        <i class="fas fa-file-alt text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white">Bot Logları</h3>
                        <p class="text-gray-600 dark:text-gray-300 text-sm">Bot aktivitelerini görüntüleyin</p>
                    </div>
                </div>
                <i class="fas fa-arrow-right text-gray-400 group-hover:text-gray-600 dark:group-hover:text-gray-200 transition-colors"></i>
            </a>
            
            <form method="POST" class="bot-card rounded-2xl shadow-lg p-6 card-hover flex items-center justify-between group">
                <div class="flex items-center">
                    <div class="w-12 h-12 bg-gradient-to-r from-red-500 to-red-600 rounded-xl flex items-center justify-center mr-4 shadow-lg">
                        <i class="fas fa-trash-alt text-white text-xl"></i>
                    </div>
                    <div>
                        <h3 class="text-lg font-bold text-gray-900 dark:text-white">Logları Temizle</h3>
                        <p class="text-gray-600 dark:text-gray-300 text-sm">Tüm bot loglarını sil</p>
                    </div>
                </div>
                <button type="submit" name="clear_logs" 
                        class="text-red-400 group-hover:text-red-600 dark:group-hover:text-red-300 transition-colors"
                        onclick="return confirm('Tüm bot logları silinecek. Emin misiniz?')">
                    <i class="fas fa-trash-alt text-xl"></i>
                </button>
            </form>
        </div>

        <!-- How it works -->
        <div class="bot-card rounded-2xl shadow-lg p-8">
            <div class="text-center mb-8">
                <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">🔧 Bot Nasıl Çalışır?</h2>
                <p class="text-gray-600 dark:text-gray-300">Yapay zeka destekli otomatik süreç</p>
            </div>
            
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-blue-500 to-blue-600 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <i class="fas fa-search text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">1. Site Keşfi</h3>
                    <p class="text-gray-600 dark:text-gray-300 text-sm">Google üzerinden rastgele web siteleri bulur</p>
                </div>
                
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-purple-500 to-purple-600 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <i class="fas fa-magic text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">2. AI Açıklama</h3>
                    <p class="text-gray-600 dark:text-gray-300 text-sm">Her site için AI ile kısa ve uzun açıklama üretir</p>
                </div>
                
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-green-500 to-green-600 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <i class="fas fa-image text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">3. Logo Çıkarma</h3>
                    <p class="text-gray-600 dark:text-gray-300 text-sm">Site logosu ve meta bilgilerini otomatik çıkarır</p>
                </div>
                
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-orange-500 to-orange-600 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <i class="fas fa-tags text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">4. Kategori Seçimi</h3>
                    <p class="text-gray-600 dark:text-gray-300 text-sm">Uygun kategori seçer ve otomatik e-posta adresi oluşturur</p>
                </div>
                
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-red-500 to-red-600 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <i class="fas fa-save text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">5. Veritabanı</h3>
                    <p class="text-gray-600 dark:text-gray-300 text-sm">Siteyi otomatik olarak veritabanına ekler</p>
                </div>
                
                <div class="text-center">
                    <div class="w-16 h-16 bg-gradient-to-r from-indigo-500 to-indigo-600 rounded-2xl flex items-center justify-center mx-auto mb-4 shadow-lg">
                        <i class="fas fa-check-circle text-white text-2xl"></i>
                    </div>
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2">6. Tamamlandı</h3>
                    <p class="text-gray-600 dark:text-gray-300 text-sm">Site başarıyla dizine eklenir</p>
                </div>
            </div>
        </div>

        <!-- Back to site -->
        <div class="text-center mt-8">
            <a href="../" class="text-blue-600 hover:text-blue-800 font-medium">
                ← Ana Siteye Dön
            </a>
        </div>
    </div>

    <script>
        // Dil değiştirme fonksiyonu
        function setLanguage(language) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.style.display = 'none';
            
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'language';
            input.value = language;
            
            const actionInput = document.createElement('input');
            actionInput.type = 'hidden';
            actionInput.name = 'set_language';
            actionInput.value = '1';
            
            form.appendChild(input);
            form.appendChild(actionInput);
            document.body.appendChild(form);
            form.submit();
        }
        
        // Bot durdurma onay fonksiyonu
        function confirmStopBot() {
            const confirmed = confirm('⚠️ BOT DURDURULACAK!\n\n' +
                'Tüm çalışan bot işlemleri durdurulacak ve mevcut işlemler kesilecek.\n\n' +
                'Bu işlem geri alınamaz!\n\n' +
                'Emin misiniz?');
            
            if (confirmed) {
                // Buton metnini değiştir
                const button = event.target;
                const originalText = button.innerHTML;
                button.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Durduruluyor...';
                button.disabled = true;
                
                // AJAX ile hızlı durdurma
                fetch('index.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: 'stop_bot=1'
                })
                .then(response => {
                    if (response.ok) {
                        // Başarılı - sayfayı yenile
                        setTimeout(() => {
                            location.reload();
                        }, 1000);
                    } else {
                        // Hata - butonu eski haline getir
                        button.innerHTML = originalText;
                        button.disabled = false;
                        alert('Bot durdurma işlemi başarısız oldu!');
                    }
                })
                .catch(error => {
                    // Hata - butonu eski haline getir
                    button.innerHTML = originalText;
                    button.disabled = false;
                    alert('Bot durdurma işlemi başarısız oldu: ' + error.message);
                });
                
                return false; // Form gönderimini engelle
            }
            
            return false;
        }
        
        // Auto refresh when bot is running
        <?php if ($bot_status === 'running'): ?>
        setTimeout(function() {
            location.reload();
        }, 10000); // 10 saniyede bir yenile
        <?php endif; ?>
    </script>
</body>
</html>