<?php
require_once '../includes/config.php';

// Bot ayarlarını kaydet
if ($_POST) {
    $settings = [
        'bot_openai_api_key' => $_POST['openai_api_key'] ?? '',
        'bot_google_search_api_key' => $_POST['google_search_api_key'] ?? '',
        'bot_google_search_engine_id' => $_POST['google_search_engine_id'] ?? '',
        'bot_sites_per_run' => intval($_POST['sites_per_run'] ?? 5),
        'bot_search_keywords' => $_POST['search_keywords'] ?? 'blog, website, tool, app, service',
        'bot_min_description_length' => intval($_POST['min_description_length'] ?? 200),
        'bot_max_description_length' => intval($_POST['max_description_length'] ?? 500),
        'bot_target_categories' => $_POST['target_categories'] ?? '',
        'bot_content_language' => $_POST['content_language'] ?? 'tr'
    ];
    
    foreach ($settings as $key => $value) {
        try {
            $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) ON DUPLICATE KEY UPDATE setting_value = ?");
            $stmt->execute([$key, $value, $value]);
        } catch (Exception $e) {
            $error = "Ayar kaydedilemedi: " . $e->getMessage();
        }
    }
    
    if (!isset($error)) {
        $success = "Bot ayarları başarıyla kaydedildi!";
    }
}

// Mevcut ayarları al
function getBotSetting($pdo, $key, $default = '') {
    try {
        $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
        $stmt->execute(['bot_' . $key]);
        $result = $stmt->fetchColumn();
        return $result !== false ? $result : $default;
    } catch (Exception $e) {
        return $default;
    }
}

$currentSettings = [
    'openai_api_key' => getBotSetting($pdo, 'openai_api_key'),
    'google_search_api_key' => getBotSetting($pdo, 'google_search_api_key'),
    'google_search_engine_id' => getBotSetting($pdo, 'google_search_engine_id'),
    'sites_per_run' => getBotSetting($pdo, 'sites_per_run', '5'),
    'search_keywords' => getBotSetting($pdo, 'search_keywords', 'Foreign Language: language learning, translation, english course, spanish lessons, french tutor, german class, italian language, portuguese course, russian lessons, chinese mandarin, japanese learning, korean language, arabic course, turkish lessons, dutch language, Transport: airline booking, flight tickets, bus schedule, train tickets, shipping company, logistics service, cargo transport, delivery service, taxi booking, car rental, motorcycle rental, truck rental, boat rental, yacht charter, cruise booking, Tourism & Travel: hotel booking, vacation rental, travel agency, destination guide, adventure tourism, beach resort, mountain lodge, city tour, cultural tour, food tour, wine tasting, hiking trail, camping site, backpacking, luxury travel, Sports & Teams: football team, basketball club, soccer league, tennis academy, swimming pool, gym membership, fitness center, sports equipment, athletic wear, sports news, olympic games, world cup, championship, tournament, sports betting, Industry: manufacturing company, industrial equipment, construction company, engineering firm, factory automation, production line, quality control, safety equipment, industrial design, machinery repair, metalworking, plastic molding, textile production, chemical industry, automotive parts, Health & Life: healthcare provider, medical clinic, hospital services, wellness center, fitness program, nutrition advice, mental health, dental care, eye care, pharmacy, medical equipment, health insurance, life insurance, personal trainer, yoga instructor, Culture & Art: museum exhibition, art gallery, cultural center, music venue, theater show, dance performance, art workshop, photography studio, design agency, creative writing, poetry reading, book club, film festival, art auction, cultural heritage, Business: corporate website, professional service, consulting firm, startup company, business directory, marketing agency, accounting service, legal advice, financial planning, investment firm, insurance company, real estate agency, property management, business coaching, entrepreneurship, Internet & Tech: technology company, software development, IT service, web design, mobile app, cloud computing, cybersecurity, data analytics, artificial intelligence, machine learning, blockchain, cryptocurrency, fintech, e-commerce, digital marketing, Law & Consulting: law firm, legal service, attorney, lawyer, court case, legal advice, business law, criminal law, family law, immigration law, tax law, contract law, intellectual property, legal consultation, mediation service, Food & Agri: restaurant booking, food delivery, agricultural company, farming equipment, organic food, local produce, food truck, catering service, cooking class, wine production, coffee shop, bakery, butcher shop, fish market, grocery store, Real Estate: property listing, real estate agent, home buying, apartment rental, house sale, property investment, mortgage broker, home insurance, property management, construction company, interior design, home renovation, landscaping, property valuation, rental property, Entertainment: movie theater, gaming platform, music streaming, concert venue, comedy club, nightclub, casino, theme park, arcade, board game, video game, streaming service, podcast, radio station, live show, Education: online course, university, school, learning platform, educational resource, tutoring service, language school, driving school, music lesson, art class, cooking school, computer training, business course, certification program, skill development, Religion & Ethics: religious organization, spiritual community, church service, mosque, temple, synagogue, prayer group, meditation center, ethical foundation, charity organization, volunteer work, community service, religious education, spiritual guidance, faith-based counseling, Government: government agency, public service, municipal website, official institution, tax office, passport office, driver license, social security, health department, education department, police station, fire department, emergency service, public transportation, city planning, Press & Media: news outlet, journalist, media company, broadcasting, radio station, television channel, newspaper, magazine, online news, press release, media kit, advertising agency, public relations, social media, content creation, Shopping: e-commerce store, online shopping, retail website, marketplace, fashion store, electronics shop, home decor, beauty products, sports gear, book store, music store, toy store, jewelry shop, gift shop, discount store, Other Websites: miscellaneous website, useful tool, productivity app, utility service, reference site, directory listing, comparison tool, review site, forum, community, social network, dating site, job board, classified ads, auction site'),
    'min_description_length' => getBotSetting($pdo, 'min_description_length', '200'),
    'max_description_length' => getBotSetting($pdo, 'max_description_length', '500'),
    'target_categories' => getBotSetting($pdo, 'target_categories'),
    'content_language' => getBotSetting($pdo, 'content_language', 'tr')
];

// Kategorileri al
try {
    $stmt = $pdo->query("SELECT id, name FROM categories ORDER BY name");
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $categories = [];
}
?>
<!DOCTYPE html>
<html lang="tr" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bot Ayarları | AI Bot Kontrol Paneli</title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Inter', 'ui-sans-serif', 'system-ui'],
                    },
                    colors: {
                        primary: '#6366f1',
                        secondary: '#8b5cf6',
                        success: '#10b981',
                        danger: '#ef4444',
                        warning: '#f59e0b',
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .card-hover {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .card-hover:hover {
            transform: translateY(-8px) scale(1.02);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        }
        
        .bot-card {
            background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
            border: 1px solid rgba(99, 102, 241, 0.1);
        }
        
        .dark .bot-card {
            background: linear-gradient(145deg, #1f2937 0%, #111827 100%);
            border: 1px solid rgba(99, 102, 241, 0.2);
        }
        
        .text-gradient {
            background: linear-gradient(135deg, #6366f1, #8b5cf6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 dark:from-slate-900 dark:via-slate-800 dark:to-slate-900 min-h-screen">
    <div class="max-w-4xl mx-auto p-6">
        <!-- Header -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-gradient-to-r from-indigo-500 to-purple-600 mb-4">
                <i class="fas fa-cog text-3xl text-white"></i>
            </div>
            <h1 class="text-4xl font-black text-gradient mb-2">Bot Ayarları</h1>
            <p class="text-lg text-gray-600 dark:text-gray-300">Bot konfigürasyonunu yönetin</p>
        </div>

        <!-- Success/Error Messages -->
        <?php if (isset($success)): ?>
        <div class="bg-green-50 border border-green-200 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-check-circle text-green-600 mr-3"></i>
                <div>
                    <p class="text-green-800 font-medium">Başarılı!</p>
                    <p class="text-green-700 text-sm"><?php echo htmlspecialchars($success); ?></p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <?php if (isset($error)): ?>
        <div class="bg-red-50 border border-red-200 rounded-lg p-4 mb-6">
            <div class="flex items-center">
                <i class="fas fa-exclamation-circle text-red-600 mr-3"></i>
                <div>
                    <p class="text-red-800 font-medium">Hata!</p>
                    <p class="text-red-700 text-sm"><?php echo htmlspecialchars($error); ?></p>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- Settings Form -->
        <div class="bot-card rounded-2xl shadow-lg p-8 card-hover">
            <form method="POST" class="space-y-6">
                <!-- API Keys -->
                <div class="space-y-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white flex items-center">
                        <i class="fas fa-key text-primary mr-2"></i>
                        API Anahtarları
                    </h3>
                    
                    <div>
                        <label for="openai_api_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            OpenAI API Key <span class="text-red-500">*</span>
                        </label>
                        <input type="password" id="openai_api_key" name="openai_api_key" 
                               value="<?php echo htmlspecialchars($currentSettings['openai_api_key']); ?>"
                               class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-colors"
                               placeholder="sk-...">
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                            OpenAI API anahtarı gerekli. <a href="https://platform.openai.com/api-keys" target="_blank" class="text-primary hover:underline">Buradan alabilirsiniz</a>
                        </p>
                    </div>
                    
                    <div>
                        <label for="google_search_api_key" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Google Search API Key <span class="text-red-500">*</span>
                        </label>
                        <input type="password" id="google_search_api_key" name="google_search_api_key" 
                               value="<?php echo htmlspecialchars($currentSettings['google_search_api_key']); ?>"
                               class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-colors"
                               placeholder="AIza...">
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                            Google Custom Search API anahtarı gerekli. <a href="https://console.developers.google.com/" target="_blank" class="text-primary hover:underline">Buradan alabilirsiniz</a>
                        </p>
                    </div>
                    
                    <div>
                        <label for="google_search_engine_id" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Google Search Engine ID <span class="text-red-500">*</span>
                        </label>
                        <input type="text" id="google_search_engine_id" name="google_search_engine_id" 
                               value="<?php echo htmlspecialchars($currentSettings['google_search_engine_id']); ?>"
                               class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-colors"
                               placeholder="012345678901234567890:abcdefghijk">
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                            Google Custom Search Engine ID gerekli. <a href="https://cse.google.com/" target="_blank" class="text-primary hover:underline">Buradan oluşturabilirsiniz</a>
                        </p>
                    </div>
                </div>

                <!-- Bot Settings -->
                <div class="space-y-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white flex items-center">
                        <i class="fas fa-robot text-primary mr-2"></i>
                        Bot Ayarları
                    </h3>
                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label for="sites_per_run" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Çalıştırma Başına Site Sayısı
                            </label>
                            <input type="number" id="sites_per_run" name="sites_per_run" 
                                   value="<?php echo htmlspecialchars($currentSettings['sites_per_run']); ?>"
                                   min="1" max="20"
                                   class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-colors">
                        </div>
                        
                        <div>
                            <label for="min_description_length" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                Minimum Açıklama Uzunluğu
                            </label>
                            <input type="number" id="min_description_length" name="min_description_length" 
                                   value="<?php echo htmlspecialchars($currentSettings['min_description_length']); ?>"
                                   min="50" max="1000"
                                   class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-colors">
                        </div>
                        
                        <div>
                            <label for="content_language" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                                🌍 İçerik Dili
                            </label>
                            <select id="content_language" name="content_language" 
                                    class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-colors">
                                <option value="tr" <?php echo $currentSettings['content_language'] === 'tr' ? 'selected' : ''; ?>>🇹🇷 Türkçe</option>
                                <option value="en" <?php echo $currentSettings['content_language'] === 'en' ? 'selected' : ''; ?>>🇺🇸 English</option>
                            </select>
                            <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                                Bot hangi dilde içerik üretecek
                            </p>
                        </div>
                    </div>
                    
                    <div>
                        <label for="search_keywords" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Arama Anahtar Kelimeleri
                        </label>
                        <input type="text" id="search_keywords" name="search_keywords" 
                               value="<?php echo htmlspecialchars($currentSettings['search_keywords']); ?>"
                               class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-colors"
                               placeholder="Foreign Language: language learning, translation, english course... Transport: airline booking, flight tickets...">
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                            Virgülle ayrılmış anahtar kelimeler
                        </p>
                    </div>
                </div>

                <!-- Category Settings -->
                <div class="space-y-4">
                    <h3 class="text-xl font-bold text-gray-900 dark:text-white flex items-center">
                        <i class="fas fa-tags text-primary mr-2"></i>
                        Kategori Ayarları
                    </h3>
                    
                    <div>
                        <label for="target_categories" class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Hedef Kategoriler (ID'ler)
                        </label>
                        <input type="text" id="target_categories" name="target_categories" 
                               value="<?php echo htmlspecialchars($currentSettings['target_categories']); ?>"
                               class="w-full px-4 py-3 border border-gray-300 dark:border-gray-600 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent dark:bg-gray-700 dark:text-white transition-colors"
                               placeholder="1,2,3">
                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">
                            Virgülle ayrılmış kategori ID'leri. Boş bırakılırsa rastgele kategoriler seçilir.
                        </p>
                    </div>
                    
                    <?php if (!empty($categories)): ?>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-2">
                            Mevcut Kategoriler
                        </label>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-2">
                            <?php foreach ($categories as $category): ?>
                            <div class="bg-gray-100 dark:bg-gray-700 rounded-lg p-2 text-sm">
                                <span class="font-medium">ID: <?php echo $category['id']; ?></span>
                                <br>
                                <span class="text-gray-600 dark:text-gray-300"><?php echo htmlspecialchars($category['name']); ?></span>
                            </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>

                <!-- Submit Button -->
                <div class="pt-4">
                    <button type="submit" 
                            class="w-full bg-primary hover:bg-primary-dark text-white font-semibold py-4 px-6 rounded-xl transition-all duration-200 transform hover:scale-105 shadow-lg">
                        <i class="fas fa-save mr-2"></i>
                        Ayarları Kaydet
                    </button>
                </div>
            </form>
        </div>

        <!-- Test Button -->
        <div class="mt-6 text-center">
            <a href="test_bot_settings.php" 
               class="inline-flex items-center gap-2 bg-gray-500 hover:bg-gray-600 text-white font-semibold px-6 py-3 rounded-xl transition-all duration-200">
                <i class="fas fa-vial"></i>
                Bot Ayarlarını Test Et
            </a>
        </div>

        <!-- Back Button -->
        <div class="mt-4 text-center">
            <a href="index.php" 
               class="inline-flex items-center gap-2 text-gray-600 dark:text-gray-300 hover:text-primary transition-colors">
                <i class="fas fa-arrow-left"></i>
                Bot Ana Sayfasına Dön
            </a>
        </div>
    </div>
</body>
</html>