<!DOCTYPE html>
<html lang="tr" class="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bot Ayarları Test | AI Bot Kontrol Paneli</title>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'sans': ['Inter', 'ui-sans-serif', 'system-ui'],
                    },
                    colors: {
                        primary: '#6366f1',
                        secondary: '#8b5cf6',
                        success: '#10b981',
                        danger: '#ef4444',
                        warning: '#f59e0b',
                    }
                }
            }
        }
    </script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        
        .glass-effect {
            background: rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.2);
        }
        
        .card-hover {
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .card-hover:hover {
            transform: translateY(-8px) scale(1.02);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        }
        
        .bot-card {
            background: linear-gradient(145deg, #ffffff 0%, #f8fafc 100%);
            border: 1px solid rgba(99, 102, 241, 0.1);
        }
        
        .dark .bot-card {
            background: linear-gradient(145deg, #1f2937 0%, #111827 100%);
            border: 1px solid rgba(99, 102, 241, 0.2);
        }
        
        .text-gradient {
            background: linear-gradient(135deg, #6366f1, #8b5cf6);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="bg-gradient-to-br from-slate-50 via-blue-50 to-indigo-100 dark:from-slate-900 dark:via-slate-800 dark:to-slate-900 min-h-screen">
    <div class="max-w-4xl mx-auto p-6">
        <!-- Header -->
        <div class="text-center mb-8">
            <div class="inline-flex items-center justify-center w-16 h-16 rounded-full bg-gradient-to-r from-indigo-500 to-purple-600 mb-4">
                <i class="fas fa-vial text-3xl text-white"></i>
            </div>
            <h1 class="text-4xl font-black text-gradient mb-2">Bot Ayarları Test</h1>
            <p class="text-lg text-gray-600 dark:text-gray-300">Bot konfigürasyonunu kontrol edin</p>
        </div>

        <div class="bot-card rounded-2xl shadow-lg p-8 card-hover">
<?php
require_once '../includes/config.php';

// Bot ayarlarını kontrol et
$requiredSettings = [
    'bot_openai_api_key' => 'OpenAI API Key',
    'bot_google_search_api_key' => 'Google Search API Key',
    'bot_google_search_engine_id' => 'Google Search Engine ID',
    'bot_sites_per_run' => 'Sites Per Run',
    'bot_search_keywords' => 'Search Keywords'
];

echo "<h3 class='text-xl font-bold text-gray-900 dark:text-white mb-4 flex items-center'>";
echo "<i class='fas fa-cog text-primary mr-2'></i>";
echo "Gerekli Ayarlar</h3>";
echo "<div class='space-y-3'>";

foreach ($requiredSettings as $key => $label) {
    try {
        $stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = ?");
        $stmt->execute([$key]);
        $value = $stmt->fetchColumn();
        
        if ($value !== false && !empty($value)) {
            echo "<div class='flex items-center p-3 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-700'>";
            echo "<i class='fas fa-check-circle text-green-600 mr-3'></i>";
            echo "<span class='text-green-800 dark:text-green-300 font-medium'>$label: VAR</span>";
            echo "</div>";
        } else {
            echo "<div class='flex items-center p-3 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-700'>";
            echo "<i class='fas fa-times-circle text-red-600 mr-3'></i>";
            echo "<span class='text-red-800 dark:text-red-300 font-medium'>$label: YOK</span>";
            echo "</div>";
        }
    } catch (Exception $e) {
        echo "<div class='flex items-center p-3 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-700'>";
        echo "<i class='fas fa-exclamation-triangle text-red-600 mr-3'></i>";
        echo "<span class='text-red-800 dark:text-red-300 font-medium'>$label: HATA - " . htmlspecialchars($e->getMessage()) . "</span>";
        echo "</div>";
    }
}

echo "</div>";

// Kategorileri kontrol et
echo "<h3 class='text-xl font-bold text-gray-900 dark:text-white mb-4 flex items-center mt-8'>";
echo "<i class='fas fa-tags text-primary mr-2'></i>";
echo "Kategoriler</h3>";

try {
    $stmt = $pdo->query("SELECT id, name FROM categories ORDER BY name");
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (empty($categories)) {
        echo "<div class='flex items-center p-3 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-700'>";
        echo "<i class='fas fa-times-circle text-red-600 mr-3'></i>";
        echo "<span class='text-red-800 dark:text-red-300 font-medium'>Hiç kategori bulunamadı!</span>";
        echo "</div>";
    } else {
        echo "<div class='flex items-center p-3 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-700 mb-4'>";
        echo "<i class='fas fa-check-circle text-green-600 mr-3'></i>";
        echo "<span class='text-green-800 dark:text-green-300 font-medium'>" . count($categories) . " kategori bulundu</span>";
        echo "</div>";
        
        echo "<div class='grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3'>";
        foreach ($categories as $category) {
            echo "<div class='bg-gray-100 dark:bg-gray-700 rounded-lg p-3 border border-gray-200 dark:border-gray-600'>";
            echo "<div class='font-medium text-gray-900 dark:text-white'>ID: {$category['id']}</div>";
            echo "<div class='text-sm text-gray-600 dark:text-gray-300'>" . htmlspecialchars($category['name']) . "</div>";
            echo "</div>";
        }
        echo "</div>";
    }
} catch (Exception $e) {
    echo "<div class='flex items-center p-3 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-700'>";
    echo "<i class='fas fa-exclamation-triangle text-red-600 mr-3'></i>";
    echo "<span class='text-red-800 dark:text-red-300 font-medium'>Kategori alma hatası: " . htmlspecialchars($e->getMessage()) . "</span>";
    echo "</div>";
}

// Veritabanı tablolarını kontrol et
echo "<h3 class='text-xl font-bold text-gray-900 dark:text-white mb-4 flex items-center mt-8'>";
echo "<i class='fas fa-database text-primary mr-2'></i>";
echo "Veritabanı Tabloları</h3>";

$requiredTables = ['site_submissions', 'categories', 'settings'];
echo "<div class='space-y-3'>";

foreach ($requiredTables as $table) {
    try {
        $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
        if ($stmt->rowCount() > 0) {
            echo "<div class='flex items-center p-3 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-700'>";
            echo "<i class='fas fa-check-circle text-green-600 mr-3'></i>";
            echo "<span class='text-green-800 dark:text-green-300 font-medium'>$table tablosu mevcut</span>";
            echo "</div>";
        } else {
            echo "<div class='flex items-center p-3 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-700'>";
            echo "<i class='fas fa-times-circle text-red-600 mr-3'></i>";
            echo "<span class='text-red-800 dark:text-red-300 font-medium'>$table tablosu bulunamadı</span>";
            echo "</div>";
        }
    } catch (Exception $e) {
        echo "<div class='flex items-center p-3 bg-red-50 dark:bg-red-900/20 rounded-lg border border-red-200 dark:border-red-700'>";
        echo "<i class='fas fa-exclamation-triangle text-red-600 mr-3'></i>";
        echo "<span class='text-red-800 dark:text-red-300 font-medium'>$table tablosu kontrol hatası: " . htmlspecialchars($e->getMessage()) . "</span>";
        echo "</div>";
    }
}

echo "</div>";

// Bot log dosyasını kontrol et
echo "<h3 class='text-xl font-bold text-gray-900 dark:text-white mb-4 flex items-center mt-8'>";
echo "<i class='fas fa-file-alt text-primary mr-2'></i>";
echo "Bot Log Dosyası</h3>";

if (file_exists('bot_logs.txt')) {
    $logSize = filesize('bot_logs.txt');
    echo "<div class='flex items-center p-3 bg-green-50 dark:bg-green-900/20 rounded-lg border border-green-200 dark:border-green-700 mb-4'>";
    echo "<i class='fas fa-check-circle text-green-600 mr-3'></i>";
    echo "<span class='text-green-800 dark:text-green-300 font-medium'>bot_logs.txt mevcut (Boyut: " . number_format($logSize) . " bytes)</span>";
    echo "</div>";
    
    // Son 5 satırı göster
    $lines = file('bot_logs.txt');
    $lastLines = array_slice($lines, -5);
    echo "<h4 class='text-lg font-semibold text-gray-900 dark:text-white mb-3'>Son 5 Log Satırı:</h4>";
    echo "<div class='bg-gray-900 dark:bg-gray-800 rounded-lg p-4 max-h-48 overflow-y-auto'>";
    foreach ($lastLines as $line) {
        echo "<div class='text-sm text-gray-300 font-mono mb-1'>" . htmlspecialchars($line) . "</div>";
    }
    echo "</div>";
} else {
    echo "<div class='flex items-center p-3 bg-yellow-50 dark:bg-yellow-900/20 rounded-lg border border-yellow-200 dark:border-yellow-700'>";
    echo "<i class='fas fa-exclamation-triangle text-yellow-600 mr-3'></i>";
    echo "<span class='text-yellow-800 dark:text-yellow-300 font-medium'>bot_logs.txt dosyası henüz oluşturulmamış</span>";
    echo "</div>";
}

echo "<h3 class='text-xl font-bold text-gray-900 dark:text-white mb-4 mt-8'>Test Tamamlandı</h3>";
echo "<div class='text-center'>";
echo "<a href='index.php' class='inline-flex items-center gap-2 bg-primary hover:bg-primary-dark text-white font-semibold px-6 py-3 rounded-xl transition-all duration-200'>";
echo "<i class='fas fa-arrow-left'></i>";
echo "Bot Ana Sayfasına Dön";
echo "</a>";
echo "</div>";
?>
        </div>
    </div>
</body>
</html>
