<?php
require_once '../includes/config.php';
require_once 'website_analyzer.php';

// Test logo extraction
$analyzer = new WebsiteAnalyzer();

// Test URL'ler
$testUrls = [
    'https://www.google.com',
    'https://www.microsoft.com',
    'https://www.apple.com',
    'https://www.amazon.com',
    'https://www.netflix.com'
];

echo "<h2>Logo URL Extraction Test</h2>";
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr><th>Website</th><th>Found Logo</th><th>Logo URL</th></tr>";

foreach ($testUrls as $url) {
    echo "<tr>";
    echo "<td>" . htmlspecialchars($url) . "</td>";
    
    $siteInfo = $analyzer->analyzeSite($url);
    
    if ($siteInfo['success'] && !empty($siteInfo['logo'])) {
        echo "<td style='color: green;'>✓ Found</td>";
        echo "<td><a href='" . htmlspecialchars($siteInfo['logo']) . "' target='_blank'>" . htmlspecialchars($siteInfo['logo']) . "</a></td>";
    } else {
        echo "<td style='color: red;'>✗ Not Found</td>";
        echo "<td>-</td>";
    }
    
    echo "</tr>";
}

echo "</table>";
?>