<?php
// Footer için gereken settings'leri yükle
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/../utils/ads_helper.php';

$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Sayfa tipini tespit et
$current_page_type = detectPageType();
?>

<footer class="bg-white dark:bg-gray-900 border-t border-gray-200 dark:border-gray-700 mt-auto w-full">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex flex-col sm:flex-row items-center justify-between py-6">
            <div class="flex items-center gap-3 mb-4 sm:mb-0">
                <a class="flex items-center gap-3 text-2xl font-black" href="/">
                    <?php if (($settings['logo_type'] ?? 'text') === 'image' && !empty($settings['logo_url'] ?? '')): ?>
                        <img src="<?php echo htmlspecialchars($settings['logo_url']); ?>" alt="<?php echo htmlspecialchars($settings['site_title'] ?? 'Site'); ?>" class="h-8 w-auto">
                    <?php else: ?>
                        <span class="gradient-text"><?php echo htmlspecialchars(($settings['logo_text'] ?? '') ?: ($settings['site_title'] ?? 'Site Dizini')); ?></span>
                    <?php endif; ?>
                </a>
            </div>
            <p class="text-sm text-gray-600 dark:text-gray-400"><?php echo htmlspecialchars($settings['footer_text'] ?? '© ' . date('Y') . ' ' . ($settings['site_title'] ?? 'Site Dizini') . '. Tüm hakları saklıdır.'); ?></p>
            <?php if (($settings['footer_menu_enabled'] ?? '1') === '1'): ?>
                <?php
                // Get footer menu items from database
                $footer_menu_items = [];
                try {
                    $stmt = $pdo->query("SELECT title, url, target FROM menu_items WHERE menu_type = 'footer' ORDER BY sort_order ASC, id ASC");
                    $footer_menu_items = $stmt->fetchAll(PDO::FETCH_ASSOC);
                } catch (Exception $e) {
                    // If menu_items table doesn't exist, use default menu
                    $footer_menu_items = [
                        ['title' => 'İletişim', 'url' => '/contact', 'target' => '_self'],
                        ['title' => 'Hakkımızda', 'url' => '/about-us', 'target' => '_self'],
                        ['title' => 'Gizlilik Politikası', 'url' => '/privacy-policy', 'target' => '_self']
                    ];
                }
                ?>
                <?php if (!empty($footer_menu_items)): ?>
                    <nav class="flex items-center gap-6">
                        <?php foreach ($footer_menu_items as $item): ?>
                            <a class="text-base font-medium text-gray-600 dark:text-gray-300 hover:text-blue-600 dark:hover:text-blue-400 transition-colors" 
                               href="<?php echo htmlspecialchars($item['url']); ?>" 
                               target="<?php echo htmlspecialchars($item['target']); ?>">
                                <?php echo htmlspecialchars($item['title']); ?>
                            </a>
                        <?php endforeach; ?>
                    </nav>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>
</footer>

<?php
// Footer reklamları (sadece reklamlar aktifse)
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'footer', 'ad-footer');
}

// Reklam stilleri
echo getAdStyles();
?>