<?php
// Türkçe karakter desteği için encoding ayarı
if (!headers_sent()) {
    header('Content-Type: text/html; charset=utf-8');
}
mb_internal_encoding('UTF-8');

// Sadece logo için gereken settings'leri yükle
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/../utils/url_helper.php';
require_once __DIR__ . '/../utils/ads_helper.php';
require_once __DIR__ . '/turkish_fix.php';

// PDO charset ayarı ekle
$pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_turkish_ci");

$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Sayfa tipini tespit et
$current_page_type = detectPageType();

// Kategorileri çek
$categories = [];
try {
    $stmt = $pdo->query('SELECT id, name, slug FROM categories ORDER BY name LIMIT 8');
    $categories = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (Exception $e) {
    $categories = [];
    // Debug için hata mesajını logla
    error_log("Categories query error: " . $e->getMessage());
}
?>

<!-- Font Awesome -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
:root {
    --primary-color: <?php echo htmlspecialchars($settings['primary_color'] ?? '#3b82f6'); ?>;
    --gradient-start-color: <?php echo htmlspecialchars($settings['gradient_start_color'] ?? '#3b82f6'); ?>;
    --gradient-end-color: <?php echo htmlspecialchars($settings['gradient_end_color'] ?? '#8b5cf6'); ?>;
}

.gradient-text {
    background: linear-gradient(135deg, var(--gradient-start-color), var(--gradient-end-color));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

.gradient-bg {
    background: linear-gradient(135deg, var(--gradient-start-color), var(--gradient-end-color));
}

.glass-effect {
    background: rgba(255, 255, 255, 0.1);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255, 255, 255, 0.2);
}

.dark .glass-effect {
    background: rgba(0, 0, 0, 0.2);
    border: 1px solid rgba(255, 255, 255, 0.1);
}

.text-primary { color: var(--primary-color) !important; }
.bg-primary { background-color: var(--primary-color) !important; }
.border-primary { border-color: var(--primary-color) !important; }
.hover\:bg-primary:hover { background-color: var(--primary-color) !important; }
.hover\:text-primary:hover { color: var(--primary-color) !important; }

.fa {
    font-family: "Font Awesome 6 Free" !important;
    font-weight: 900;
}

.fa-solid {
    font-family: "Font Awesome 6 Free" !important;
    font-weight: 900;
}

.fa-regular {
    font-family: "Font Awesome 6 Free" !important;
    font-weight: 400;
}

.fa-brands {
    font-family: "Font Awesome 6 Brands" !important;
    font-weight: 400;
}

/* Mobile menu link styles */
#mobile-menu-content a {
    position: relative;
    z-index: 10;
    display: block;
    text-decoration: none;
}

#mobile-menu-content a:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
}

#mobile-menu-content .gradient-bg {
    background: linear-gradient(135deg, var(--gradient-start-color), var(--gradient-end-color));
}
</style>

<?php 
// Theme ayarını al ve body class'ına ekle
$theme = $settings['theme'] ?? 'light';
?>
<script>
// Theme ayarını body'ye uygula
document.documentElement.classList.toggle('dark', '<?php echo $theme; ?>' === 'dark');
</script>

<header class="sticky top-0 z-50 bg-white/80 dark:bg-gray-900/80 backdrop-blur-xl border-b border-gray-200/50 dark:border-gray-700/50 shadow-lg">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex items-center justify-between h-20">
            <div class="flex items-center gap-8">
                <a href="/" class="flex items-center gap-3 text-2xl font-black">
                    <?php if (($settings['logo_type'] ?? 'text') === 'image' && !empty($settings['logo_url'] ?? '')): ?>
                        <img src="<?php echo htmlspecialchars($settings['logo_url']); ?>" alt="<?php echo htmlspecialchars($settings['site_title'] ?? 'Site'); ?>" class="h-10 w-auto">
                    <?php else: ?>
                        <span class="gradient-text text-3xl font-bold"><?php echo htmlspecialchars(($settings['logo_text'] ?? '') ?: ($settings['site_title'] ?? 'UsaTVS')); ?></span>
                    <?php endif; ?>
                </a>
                <nav class="hidden md:flex items-center gap-6">
                    <a class="text-base font-semibold text-primary bg-primary/10 dark:bg-primary/20 px-4 py-2 rounded-full hover:bg-primary/20 dark:hover:bg-primary/30 transition-all duration-300 hover:scale-105" href="/newly-added">
                        <i class="fas fa-trophy mr-2"></i>Yeni
                    </a>
                    <a class="text-base font-semibold text-primary bg-primary/10 dark:bg-primary/20 px-4 py-2 rounded-full hover:bg-primary/20 dark:hover:bg-primary/30 transition-all duration-300 hover:scale-105" href="/topvoted">
                        <i class="fas fa-fire mr-2"></i>Popüler
                    </a>
                    <a class="text-base font-semibold text-primary bg-primary/10 dark:bg-primary/20 px-4 py-2 rounded-full hover:bg-primary/20 dark:hover:bg-primary/30 transition-all duration-300 hover:scale-105" href="/categories">
                        <i class="fas fa-th-large mr-2"></i>Kategoriler
                    </a>
                    <a class="text-base font-semibold text-primary bg-primary/10 dark:bg-primary/20 px-4 py-2 rounded-full hover:bg-primary/20 dark:hover:bg-primary/30 transition-all duration-300 hover:scale-105" href="/blog">
                        <i class="fas fa-blog mr-2"></i>Blog
                    </a>
                </nav>
            </div>
            <div class="flex items-center gap-4">
                <!-- Desktop Search -->
                <form action="/search" method="GET" class="relative hidden lg:block">
                    <i class="fas fa-search absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500"></i>
                    <input name="q" class="w-80 pl-12 pr-4 py-3 rounded-full bg-gray-100/80 dark:bg-gray-800/80 backdrop-blur-sm border-2 border-transparent focus:ring-4 focus:ring-primary/20 focus:border-primary transition-all duration-300 placeholder:text-gray-400 dark:placeholder:text-gray-500 shadow-lg hover:shadow-xl" placeholder="Web sitelerini ara..." type="search" value="<?php echo htmlspecialchars($_GET['q'] ?? ''); ?>"/>
                </form>
                
                <!-- Desktop Actions -->
                <div class="hidden lg:flex items-center gap-4">
                    <?php if (($settings['site_submission'] ?? '1') === '1'): ?>
                        <?php if (isset($_SESSION['user_id'])): ?>
                            <a href="/submit" class="gradient-bg hover:shadow-lg text-white px-6 py-3 rounded-full text-base font-bold flex items-center gap-2 transition-all duration-300 transform hover:scale-105 shadow-xl">
                                <i class="fas fa-plus"></i>
                                Site Ekle
                            </a>
                        <?php else: ?>
                            <a href="/login?action=add_site" class="gradient-bg hover:shadow-lg text-white px-6 py-3 rounded-full text-base font-bold flex items-center gap-2 transition-all duration-300 transform hover:scale-105 shadow-xl">
                                <i class="fas fa-plus"></i>
                                Site Ekle
                            </a>
                        <?php endif; ?>
                    <?php endif; ?>
                    <?php
                    if (session_status() === PHP_SESSION_NONE) {
                        session_start();
                    }
                    if (isset($_SESSION['user_id'])): ?>
                        <a href="/profile" class="text-base font-semibold text-primary bg-primary/10 dark:bg-primary/20 px-4 py-2 rounded-full hover:bg-primary/20 dark:hover:bg-primary/30 transition-all duration-300 flex items-center gap-2 hover:scale-105">
                            <i class="fas fa-user-circle"></i>
                            Profil
                        </a>
                        <a href="/logout" class="bg-white dark:bg-gray-800 border-2 border-red-500 text-red-500 hover:bg-red-500 hover:text-white dark:hover:bg-red-500 dark:hover:text-white px-5 py-3 rounded-full text-base font-bold flex items-center gap-2 transition-all duration-300 transform hover:scale-105 shadow-lg">
                            <i class="fas fa-sign-out-alt"></i>
                            Çıkış
                        </a>
                    <?php else: ?>
                        <a href="/login" class="text-base font-semibold text-primary bg-primary/10 dark:bg-primary/20 px-4 py-2 rounded-full hover:bg-primary/20 dark:hover:bg-primary/30 transition-all duration-300 flex items-center gap-2 hover:scale-105">
                            <i class="fas fa-sign-in-alt"></i>
                            Giriş
                        </a>
                        <a href="/register" class="text-base font-semibold text-primary bg-primary/10 dark:bg-primary/20 px-4 py-2 rounded-full hover:bg-primary/20 dark:hover:bg-primary/30 transition-all duration-300 flex items-center gap-2 hover:scale-105">
                            <i class="fas fa-user-plus"></i>
                            Kayıt
                        </a>
                    <?php endif; ?>
                </div>
                
                <!-- Mobile Search Button -->
                <button onclick="toggleMobileSearch()" class="lg:hidden p-3 rounded-full bg-gray-100/80 dark:bg-gray-800/80 backdrop-blur-sm hover:bg-primary hover:text-white transition-all duration-300 shadow-lg">
                    <i class="fas fa-search"></i>
                </button>
                
                <!-- Mobile Menu Button -->
                <button onclick="toggleMobileMenu()" class="lg:hidden p-3 rounded-full bg-gray-100/80 dark:bg-gray-800/80 backdrop-blur-sm hover:bg-primary hover:text-white transition-all duration-300 shadow-lg">
                    <i class="fas fa-bars"></i>
                </button>
            </div>
        </div>
    </div>
    
    <!-- Mobile Search Overlay -->
    <div id="mobile-search-overlay" class="fixed inset-0 bg-black/50 z-50 hidden lg:hidden">
        <div class="bg-white/95 dark:bg-gray-900/95 backdrop-blur-xl p-6">
            <div class="flex items-center gap-4 mb-6">
                <form action="/search" method="GET" class="flex-1 relative">
                    <i class="fas fa-search absolute left-4 top-1/2 -translate-y-1/2 text-gray-400 dark:text-gray-500"></i>
                    <input name="q" 
                           class="w-full pl-12 pr-4 py-4 rounded-2xl bg-gray-100/80 dark:bg-gray-800/80 backdrop-blur-sm border-2 border-transparent focus:ring-4 focus:ring-primary/20 focus:border-primary transition-all duration-300 placeholder:text-gray-400 dark:placeholder:text-gray-500 text-lg shadow-xl" 
                           placeholder="Web sitelerini ara..." 
                           type="search" 
                           value="<?php echo htmlspecialchars($_GET['q'] ?? ''); ?>"
                           autofocus>
                </form>
                <button onclick="toggleMobileSearch()" class="p-3 rounded-full bg-gray-100/80 dark:bg-gray-800/80 backdrop-blur-sm hover:bg-red-500 hover:text-white transition-all duration-300 shadow-lg">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
        </div>
    </div>
    
    <!-- Simple Mobile Menu -->
    <div id="mobile-menu" class="fixed top-20 left-0 right-0 bg-white dark:bg-gray-800 border-t border-gray-200 dark:border-gray-700 shadow-lg z-40 hidden lg:hidden">
        <div class="p-4 space-y-3">
            <!-- Navigation Links -->
            <a href="/newly-added" class="block px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                <i class="fas fa-trophy mr-3 text-primary"></i>Yeni
            </a>
            <a href="/topvoted" class="block px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                <i class="fas fa-fire mr-3 text-primary"></i>Popüler
            </a>
            <a href="/categories" class="block px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                <i class="fas fa-th-large mr-3 text-primary"></i>Kategoriler
            </a>
            <a href="/blog" class="block px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                <i class="fas fa-blog mr-3 text-primary"></i>Blog
            </a>
            
            
            <!-- User Actions -->
            <div class="border-t border-gray-200 dark:border-gray-700 pt-3 mt-3">
                <?php if (isset($_SESSION['user_id'])): ?>
                    <?php if (($settings['site_submission'] ?? '1') === '1'): ?>
                        <a href="/submit" class="block px-4 py-3 bg-primary text-white hover:bg-blue-600 rounded-lg transition-colors mb-2">
                            <i class="fas fa-plus mr-3"></i>Site Ekle
                        </a>
                    <?php endif; ?>
                    <a href="/profile" class="block px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                        <i class="fas fa-user-circle mr-3 text-primary"></i>Profil
                    </a>
                    <a href="/logout" class="block px-4 py-3 text-red-600 dark:text-red-400 hover:bg-red-50 dark:hover:bg-red-900/20 rounded-lg transition-colors">
                        <i class="fas fa-sign-out-alt mr-3"></i>Çıkış
                    </a>
                <?php else: ?>
                    <?php if (($settings['site_submission'] ?? '1') === '1'): ?>
                        <a href="/login?action=add_site" class="block px-4 py-3 bg-primary text-white hover:bg-blue-600 rounded-lg transition-colors mb-2">
                            <i class="fas fa-plus mr-3"></i>Site Ekle
                        </a>
                    <?php endif; ?>
                    <a href="/login" class="block px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                        <i class="fas fa-sign-in-alt mr-3 text-primary"></i>Giriş
                    </a>
                    <a href="/register" class="block px-4 py-3 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg transition-colors">
                        <i class="fas fa-user-plus mr-3 text-primary"></i>Kayıt
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</header>

<?php
// Header reklamları (sadece reklamlar aktifse)
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'header', 'ad-header');
}
?>

<script>
function toggleMobileSearch() {
    const overlay = document.getElementById('mobile-search-overlay');
    overlay.classList.toggle('hidden');
    
    if (!overlay.classList.contains('hidden')) {
        // Focus on search input when opened
        setTimeout(() => {
            const input = overlay.querySelector('input[name="q"]');
            if (input) input.focus();
        }, 100);
    }
}

function toggleMobileMenu() {
    const menu = document.getElementById('mobile-menu');
    menu.classList.toggle('hidden');
}

// Close mobile search when clicking outside
document.getElementById('mobile-search-overlay').addEventListener('click', function(e) {
    if (e.target === this) {
        toggleMobileSearch();
    }
});

// Close mobile menu when clicking outside
document.addEventListener('click', function(e) {
    const menu = document.getElementById('mobile-menu');
    const menuButton = e.target.closest('[onclick="toggleMobileMenu()"]');
    
    if (!menuButton && !menu.contains(e.target) && !menu.classList.contains('hidden')) {
        menu.classList.add('hidden');
    }
});

// Close mobile overlays when pressing escape
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        const searchOverlay = document.getElementById('mobile-search-overlay');
        const menu = document.getElementById('mobile-menu');
        
        if (!searchOverlay.classList.contains('hidden')) {
            toggleMobileSearch();
        }
        if (!menu.classList.contains('hidden')) {
            menu.classList.add('hidden');
        }
    }
});
</script>
