<?php
/**
 * Global Meta Head Include
 * Tüm sayfalarda kullanılacak meta tagları ve favicon
 */

// Fonksiyonun tekrar tanımlanmasını önle
if (!function_exists('generateMetaHead')) {
    /**
     * Meta head oluşturur
     */
    function generateMetaHead($page_meta = []) {
        // Config ve settings'i dahil et
        if (!class_exists('PDO')) {
            require_once __DIR__ . '/config.php';
        }
        
        global $pdo;
        static $settings = null;
        
        // Settings cache
        if ($settings === null) {
            $settings = [];
            try {
                $stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
                foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
                    $settings[$row['setting_key']] = $row['setting_value'];
                }
            } catch (Exception $e) {
                $settings = [];
            }
        }

        // SEO helper'ı include et (varsa)
        if (file_exists(__DIR__ . '/seo_helper.php') && !function_exists('generatePageTitle')) {
            require_once __DIR__ . '/seo_helper.php';
        }
        
        // SEO Title helper'ı include et
        if (file_exists(__DIR__ . '/seo_title_helper.php') && !function_exists('generateSEOTitle')) {
            require_once __DIR__ . '/seo_title_helper.php';
        }
        
        // Default değerler
        $pageTitle = $page_meta['title'] ?? ($settings['site_title'] ?? 'Web Dizini');
        $metaDescription = $page_meta['description'] ?? ($settings['site_description'] ?? '');
        $metaRobots = $page_meta['robots'] ?? 'index, follow';
        $canonicalUrl = $page_meta['url'] ?? '';
        
        // Canonical URL'i düzelt
        if (empty($canonicalUrl)) {
            $canonicalUrl = 'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
        } else {
            // Relative URL'leri absolute yap
            if (!preg_match('#^https?://#', $canonicalUrl)) {
                $canonicalUrl = 'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER['HTTP_HOST'] . '/' . ltrim($canonicalUrl, '/');
            }
        }
        
        // Structured data
        $structuredData = '';
        if (!empty($settings['site_title'])) {
            $structuredDataArray = [
                "@context" => "https://schema.org",
                "@type" => "WebSite",
                "name" => $settings['site_title'],
                "url" => 'http' . (isset($_SERVER['HTTPS']) ? 's' : '') . '://' . $_SERVER['HTTP_HOST'],
                "description" => $metaDescription
            ];
            $structuredData = json_encode($structuredDataArray, JSON_UNESCAPED_UNICODE);
        }

        // Meta head HTML'i oluştur
        ob_start();
        ?>
<!-- Meta Tags -->
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($pageTitle); ?></title>
<meta name="description" content="<?php echo htmlspecialchars($metaDescription); ?>">
<meta name="keywords" content="<?php echo htmlspecialchars($settings['site_keywords'] ?? ''); ?>">
<meta name="robots" content="<?php echo htmlspecialchars($metaRobots); ?>">
<link rel="canonical" href="<?php echo htmlspecialchars($canonicalUrl); ?>">

<!-- Favicon -->
<?php 
$favicon_url = $settings['favicon_url'] ?? '';
if (!empty($favicon_url)): 
    // Relative path'i absolute yap
    if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
        $favicon_url = '/' . ltrim($favicon_url, '/');
    }
?>
<link rel="icon" type="image/x-icon" href="<?php echo htmlspecialchars($favicon_url); ?>">
<link rel="shortcut icon" type="image/x-icon" href="<?php echo htmlspecialchars($favicon_url); ?>">
<link rel="apple-touch-icon" href="<?php echo htmlspecialchars($favicon_url); ?>">
<!-- Favicon Debug: <?php echo htmlspecialchars($favicon_url); ?> -->
<?php else: ?>
<!-- No favicon configured in settings -->
<?php endif; ?>

<!-- Theme Color -->
<?php if (!empty($settings['primary_color'] ?? '')): ?>
<meta name="theme-color" content="<?php echo htmlspecialchars($settings['primary_color']); ?>">
<meta name="msapplication-TileColor" content="<?php echo htmlspecialchars($settings['primary_color']); ?>">
<?php endif; ?>

<!-- Open Graph Tags -->
<meta property="og:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
<meta property="og:description" content="<?php echo htmlspecialchars($metaDescription); ?>">
<meta property="og:url" content="<?php echo htmlspecialchars($canonicalUrl); ?>">
<meta property="og:type" content="website">
<meta property="og:site_name" content="<?php echo htmlspecialchars($settings['site_title'] ?? ''); ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary">
<meta name="twitter:title" content="<?php echo htmlspecialchars($pageTitle); ?>">
<meta name="twitter:description" content="<?php echo htmlspecialchars($metaDescription); ?>">

<!-- Structured Data -->
<?php if (!empty($structuredData)): ?>
<script type="application/ld+json">
<?php echo $structuredData; ?>
</script>
<?php endif; ?>
        <?php
        return ob_get_clean();
    }
}

// Backward compatibility - include settings and meta
if (!isset($settings)) {
    require_once __DIR__ . '/config.php';
    $settings = [];
    try {
        $stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
        foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
            $settings[$row['setting_key']] = $row['setting_value'];
        }
    } catch (Exception $e) {
        $settings = [];
    }
}

// Set page title and other SEO
$site_title = $settings['site_title'] ?? 'Web Dizini';
$site_keywords = $settings['site_keywords'] ?? '';
$site_description = $settings['site_description'] ?? '';

// Generate meta head if needed
if (!isset($meta_head_generated)) {
    $page_meta_data = $page_meta ?? [];
    echo generateMetaHead($page_meta_data);
    $meta_head_generated = true;
}
?>