<?php
/**
 * Turkish Character Encoding Fix
 * 
 * Bu dosya, Windows-1254 kodlamasından kaynaklanan
 * türkçe karakter bozulmalarını düzeltir.
 */

function fixTurkishEncoding($text) {
    if (!$text) return $text;
    
    // Basit karakter değişimleri
    $replacements = [
        'Ä±' => 'ı',  // ı corruption
        'Äü' => 'ğ',  // ğ corruption
        'Å' => 'ş',   // ş corruption
        'Ã§' => 'ç',  // ç corruption
        'Ã¼' => 'ü',  // ü corruption
        'Ã¶' => 'ö',  // ö corruption
        'Ä°' => 'İ',  // İ corruption
        'Ä' => 'Ğ',   // Ğ corruption
        'Ã‡' => 'Ç',  // Ç corruption
        'Ãœ' => 'Ü',  // Ü corruption
        'Ã–' => 'Ö',  // Ö corruption
        'Åž' => 'ş',  // ş corruption
        'ÅŸ' => 'ş',  // ş corruption
        'Ä±Å' => 'ış', // ış corruption
    ];
    
    return str_replace(array_keys($replacements), array_values($replacements), $text);
}

/**
 * Güvenli echo fonksiyonu
 * XSS koruması ile birlikte türkçe karakter düzeltmesi yapar
 */
function safeEcho($text) {
    echo htmlspecialchars(fixTurkishEncoding($text), ENT_QUOTES, 'UTF-8');
}

/**
 * Türkçe karakter düzeltmesi ile güvenli string döndürme
 */
function safeTurkish($text) {
    return htmlspecialchars(fixTurkishEncoding($text), ENT_QUOTES, 'UTF-8');
}

?>