<!DOCTYPE html>
<html lang="tr">
<head>
<?php 
// Türkçe karakter desteği için encoding ayarı
header('Content-Type: text/html; charset=utf-8');
if (function_exists('mb_internal_encoding')) {
    mb_internal_encoding('UTF-8');
}

require_once 'includes/config.php';
require_once 'utils/url_helper.php';
require_once 'utils/seo_title_helper.php';
require_once 'utils/view_count_helper.php';
require_once 'utils/ads_helper.php';
require_once 'includes/turkish_fix.php';

// PDO charset ayarı ekle
$pdo->exec("SET NAMES utf8mb4 COLLATE utf8mb4_turkish_ci");

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$site_title_base = $settings['site_title'] ?? 'Web Dizini';
$site_keywords = $settings['site_keywords'] ?? '';
$site_description = $settings['site_description'] ?? '';

// Sayfa tipini tespit et
$current_page_type = detectPageType();
?>
<meta charset="UTF-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($site_title_base); ?></title>
<meta name="description" content="<?php echo htmlspecialchars($site_description); ?>">
<meta name="keywords" content="<?php echo htmlspecialchars($site_keywords); ?>" />
<?php
// Favicon
$favicon_url = $settings['favicon_url'] ?? '';
if (!empty($favicon_url)) {
    if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
        $favicon_url = '/' . ltrim($favicon_url, '/');
    }
    echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
}
?>
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@400;500;700;900&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "<?php echo htmlspecialchars($settings['primary_color'] ?? '#38BDF8'); ?>",
                        "primary-light": "<?php echo htmlspecialchars($settings['primary_color'] ?? '#38BDF8'); ?>",
                        "primary-dark": "<?php echo htmlspecialchars($settings['primary_color'] ?? '#38BDF8'); ?>",
                        "background-light": "#F7FAFC",
                        "background-dark": "#0F172A",
                        "foreground-light": "#0F172A",
                        "foreground-dark": "#E2E8F0",
                        "subtle-light": "#E2E8F0",
                        "subtle-dark": "#1E293B",
                        "muted-light": "#64748B",
                        "muted-dark": "#94A3B8"
                    },
                    fontFamily: {
                        "display": ["Public Sans", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.75rem",
                        "lg": "1rem",
                        "xl": "1.25rem",
                        "full": "9999px"
                    },
                },
            },
        }
    </script>
<style type="text/tailwindcss">
        .gradient-text {
            background: linear-gradient(to right, <?php echo htmlspecialchars($settings['gradient_start_color'] ?? '#38BDF8'); ?>, <?php echo htmlspecialchars($settings['gradient_end_color'] ?? '#A78BFA'); ?>);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }
        .card-hover-glow {
            transition: box-shadow 0.3s ease, transform 0.3s ease;
        }
        .card-hover-glow:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 30px -10px <?php echo htmlspecialchars($settings['primary_color'] ?? '#38BDF8'); ?>40;
        }
        .dark .card-hover-glow:hover {
            box-shadow: 0 10px 30px -10px <?php echo htmlspecialchars($settings['primary_color'] ?? '#38BDF8'); ?>20;
        }
    </style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" />
</head>
<body class="font-display bg-background-light dark:bg-background-dark text-foreground-light dark:text-foreground-dark <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">
<div class="flex flex-col min-h-screen">
<?php include 'includes/header.php'; ?>
<main class="flex-grow container mx-auto px-4 sm:px-6 lg:px-8 py-12 md:py-16">
<div class="max-w-7xl mx-auto">
<section class="mb-16 md:mb-24 text-center">
<h1 class="text-5xl md:text-7xl font-black mb-4"><span class="gradient-text"><?php echo htmlspecialchars($settings['hero_title'] ?? 'İnternetin En İyilerini Keşfedin'); ?></span></h1>
<p class="text-lg md:text-xl text-muted-light dark:text-muted-dark max-w-3xl mx-auto"><?php echo htmlspecialchars($settings['hero_subtitle'] ?? 'Modern bir dizin platformu olarak en kaliteli ve güvenilir web sitelerini bir araya getiriyoruz.'); ?></p>
</section>

<?php
// Content top reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
}
?>
<section id="categories" class="mb-16 md:mb-20">
<div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 lg:grid-cols-5 xl:grid-cols-6 gap-4 sm:gap-6">
<?php
$stmt = $pdo->query('SELECT * FROM categories');
while ($cat = $stmt->fetch()) {
    $categoryColor = $cat['color'] ?? '#3b82f6';
    echo '<a class="flex flex-col items-center justify-center gap-3 p-4 bg-white dark:bg-subtle-dark rounded-xl text-center group card-hover-glow" href="' . URLHelper::getCategoryURL($cat["name"]) . '">';
    if (!empty($cat["icon"])) {
        if (str_starts_with($cat["icon"], "fa-")) {
            echo '<span class="text-4xl sm:text-5xl group-hover:scale-110 transition-transform"><i class="' . htmlspecialchars($cat["icon"]) . '" style="color: ' . htmlspecialchars($categoryColor) . '"></i></span>';
        } else {
            echo '<span class="material-symbols-outlined text-4xl sm:text-5xl group-hover:scale-110 transition-transform" style="color: ' . htmlspecialchars($categoryColor) . '">' . htmlspecialchars($cat["icon"]) . '</span>';
        }
    } else {
        // Default icon if no icon is set
        echo '<span class="material-symbols-outlined text-4xl sm:text-5xl group-hover:scale-110 transition-transform" style="color: ' . htmlspecialchars($categoryColor) . '">folder</span>';
    }
    echo '<span class="font-bold text-sm sm:text-base">' . htmlspecialchars($cat["name"]) . '</span>';
    echo '</a>';
}
?>
</div>
</section>
<section class="mb-16 md:mb-20">
<div class="grid lg:grid-cols-2 gap-8">
</section>
<?php
// Ayarları çek
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
$show_newly_added = isset($settings['show_newly_added']) ? $settings['show_newly_added'] : '1';
$newly_added_count = isset($settings['newly_added_count']) ? intval($settings['newly_added_count']) : 4;
$show_top_voted = isset($settings['show_top_voted']) ? $settings['show_top_voted'] : '1';
$top_voted_count = isset($settings['top_voted_count']) ? intval($settings['top_voted_count']) : 6;
if ($show_newly_added == '1') {
?>
<section id="newly-added" class="mb-16 md:mb-20">
</h2>
</h2>
</h2>
<h2 class="text-4xl font-bold mb-8 flex items-center gap-4">
<span class="material-symbols-outlined text-primary text-5xl ml-2 animate-bounce" style="vertical-align:middle;">trending_up</span>
    Yeni Eklenen Siteler
</h2>
</h2>
</h2>
</h2>
<div class="grid lg:grid-cols-2 gap-8">
<?php
    $stmt = $pdo->prepare('SELECT s.*, c.name as category_name, COALESCE(s.view_count, 0) as view_count FROM site_submissions s LEFT JOIN categories c ON s.category_id = c.id WHERE s.status = "approved" ORDER BY s.olusturulma_tarihi DESC LIMIT ?');
    $stmt->bindValue(1, $newly_added_count, PDO::PARAM_INT);
    $stmt->execute();
    while ($site = $stmt->fetch(PDO::FETCH_ASSOC)) {
?>
<div class="bg-white dark:bg-subtle-dark rounded-xl overflow-hidden flex flex-col sm:flex-row gap-6 p-6 card-hover-glow">
    <div class="sm:w-2/5 h-48 sm:h-auto flex items-center justify-center bg-cover bg-center rounded-lg" style="background-color:#f3f4f6;">
        <?php 
        // Logo kontrolü yaparak direkt çözüm
        $has_logo = false;
        $logo_src = '/uploads/no-logo.png'; // Varsayılan (absolute path)
        
        if (!empty($site['logo_url'])) {
            if (filter_var($site['logo_url'], FILTER_VALIDATE_URL)) {
                $logo_src = $site['logo_url'];
            } else {
                $logo_path = ltrim($site['logo_url'], '/');
                if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
                    $logo_src = '/' . $logo_path;
                }
            }
            $has_logo = true;
        } elseif (!empty($site['site_logo'])) {
            $logo_path = $site['site_logo'];
            
            // URL ise doğrudan kullan
            if (filter_var($logo_path, FILTER_VALIDATE_URL)) {
                $logo_src = $logo_path;
                $has_logo = true;
            } else {
                // Yerel dosya yolu işleme
                $logo_path = str_replace(['https://usasportstvs.com/uploads/', 'https://usasportstvs.com/', 'admin/uploads/', '/admin/uploads/', 'uploads/', '/uploads/'], '', $logo_path);
                
                // Boş değilse ve geçerliyse kullan
                if (!empty(trim($logo_path)) && trim($logo_path) !== '/' && trim($logo_path) !== 'uploads/') {
                    $logo_src = '/uploads/' . trim($logo_path);
                    $has_logo = true;
                }
            }
        } elseif (!empty($site['favicon_url'])) {
            // Favicon'u logo olarak kullan
            if (filter_var($site['favicon_url'], FILTER_VALIDATE_URL)) {
                $logo_src = $site['favicon_url'];
            } else {
                $logo_src = '/' . ltrim($site['favicon_url'], '/');
            }
            $has_logo = true;
        }
        ?>
        <?php if ($has_logo): ?>
        <img src="<?php echo htmlspecialchars($logo_src); ?>" alt="Site Logo" class="object-contain w-full h-full p-4" onerror="this.src='/uploads/no-logo.png'; this.onerror=null;" />
        <?php else: ?>
        <img src="/uploads/no-logo.png" alt="Site Logo" class="object-contain w-full h-full p-4" />
        <?php endif; ?>
    </div>
    <div class="flex-1 flex flex-col justify-between">
        <div>
            <div class="flex items-center justify-between mb-3">
                <a href="<?php echo URLHelper::getCategoryURL($site['category_name']); ?>" class="text-sm font-bold text-primary bg-primary/10 dark:bg-primary/20 px-3 py-1 rounded-full hover:underline">
                    <?php echo htmlspecialchars($site['category_name']); ?>
                </a>
                <?php
                // 5 üzerinden puan hesapla
                $voteStmt = $pdo->prepare('SELECT 
                  SUM(vote_type = "upvote") AS upvotes,
                  SUM(vote_type = "downvote") AS downvotes
                  FROM site_votes WHERE site_id = ?');
                $voteStmt->execute([$site['id']]);
                $votes = $voteStmt->fetch(PDO::FETCH_ASSOC);
                $upvotes = intval($votes['upvotes'] ?? 0);
                $downvotes = intval($votes['downvotes'] ?? 0);
                $totalVotes = $upvotes + $downvotes;
                $rating = $totalVotes > 0 ? round(($upvotes / $totalVotes) * 5, 1) : 0.0;
                ?>
                <div class="flex items-center gap-1" style="color:#fbbf24;">
                    <span class="material-symbols-outlined text-lg" style="color:#fbbf24;">star</span>
                    <span class="text-base font-bold" style="color:#fbbf24;"><?php echo $rating; ?></span>
                    <span class="text-xs font-bold" style="color:#fbbf24;">/ 5</span>
                </div>
            </div>
            <h3 class="text-2xl font-bold mb-2"><?php echo htmlspecialchars($site['site_name']); ?></h3>
            <p class="text-muted-light dark:text-muted-dark text-base mb-6">
                <?php echo htmlspecialchars($site['short_description']); ?>
            </p>
        </div>
        <a class="bg-gradient-to-r from-primary to-primary-dark text-white px-6 py-3 rounded-xl text-base font-bold flex items-center gap-3 self-start hover:from-primary-dark hover:to-primary shadow-lg hover:shadow-primary/25 transition-all duration-300 group" href="<?php echo URLHelper::getSiteURL($site['site_name']); ?>">
            <span class="material-symbols-outlined text-lg">launch</span>
            <span>Siteyi Ziyaret Et</span>
            <span class="material-symbols-outlined text-lg transform group-hover:translate-x-1 transition-transform duration-300">arrow_forward</span>
        </a>
    </div>
</div>
<?php } ?>
</div>
</section>
<?php } ?>
</div>
</section>
<?php if ($show_top_voted == '1'): ?>
<section id="popular" class="mb-16 md:mb-20">
<h2 class="text-4xl font-bold mb-8 flex items-center gap-4">
<span class="material-symbols-outlined text-primary text-5xl ml-2 animate-bounce" style="vertical-align:middle;">trending_up</span>
    En Çok Oy Alan Siteler
</h2>
<div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
<?php
    // En çok oy alanları (upvote-downvote tabanlı) getir
    $stmt = $pdo->query('SELECT s.*, c.name as category_name, COALESCE(s.view_count, 0) as view_count FROM site_submissions s LEFT JOIN categories c ON s.category_id = c.id WHERE s.status = "approved"');
    $sites = [];
    while ($site = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $voteStmt = $pdo->prepare('SELECT SUM(vote_type = "upvote") AS upvotes, SUM(vote_type = "downvote") AS downvotes FROM site_votes WHERE site_id = ?');
        $voteStmt->execute([$site['id']]);
        $votes = $voteStmt->fetch(PDO::FETCH_ASSOC);
        $upvotes = intval($votes['upvotes'] ?? 0);
        $downvotes = intval($votes['downvotes'] ?? 0);
        $totalVotes = $upvotes + $downvotes;
        $rating = $totalVotes > 0 ? ($upvotes / $totalVotes) * 5 : 0.0;
        $site['rating'] = $rating;
        $site['totalVotes'] = $totalVotes;
        $site['upvotes'] = $upvotes;
        $site['downvotes'] = $downvotes;
        $sites[] = $site;
    }
    // En yüksek rating'e göre sırala
    usort($sites, function($a, $b) {
        return $b['rating'] <=> $a['rating'];
    });
    $sites = array_slice($sites, 0, $top_voted_count);
    foreach ($sites as $site):
?>
<div class="bg-white dark:bg-subtle-dark rounded-xl overflow-hidden flex flex-col p-6 card-hover-glow">
    <div class="h-40 bg-cover bg-center rounded-lg mb-4" style='background-color:#f3f4f6;'>
        <?php 
        // Logo URL'i belirle - logo_url kolonu öncelikli, yoksa site_logo'yu kullan
        $logo_src = 'uploads/no-logo.png'; // Varsayılan fallback
        
        if (!empty($site['logo_url'])) {
            if (filter_var($site['logo_url'], FILTER_VALIDATE_URL)) {
                $logo_src = $site['logo_url'];
            } else {
                $logo_path = ltrim($site['logo_url'], '/');
                if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
                    $logo_src = $logo_path;
                }
            }
        } elseif (!empty($site['site_logo'])) {
            $logo_path = $site['site_logo'];
            
            // URL ise doğrudan kullan
            if (filter_var($logo_path, FILTER_VALIDATE_URL)) {
                $logo_src = $logo_path;
            } else {
                // Clean up any existing full URLs
                $logo_path = str_replace(['https://usasportstvs.com/uploads/', 'https://usasportstvs.com/', 'admin/uploads/', '/admin/uploads/', 'uploads/', '/uploads/'], '', $logo_path);
                
                // Create correct path for index.php (uploads/ prefix)
                if (!empty(trim($logo_path)) && trim($logo_path) !== '/' && trim($logo_path) !== 'uploads/') {
                    $logo_src = 'uploads/' . trim($logo_path);
                }
            }
        } elseif (!empty($site['favicon_url'])) {
            // Favicon'u logo olarak kullan
            if (filter_var($site['favicon_url'], FILTER_VALIDATE_URL)) {
                $logo_src = $site['favicon_url'];
            } else {
                $logo_src = ltrim($site['favicon_url'], '/');
            }
        }
        ?>
        <img src="<?php echo htmlspecialchars($logo_src); ?>" alt="Site Logo" class="object-contain w-full h-full p-4" onerror="this.src='uploads/no-logo.png';" />
    </div>
    <div class="flex-1 flex flex-col justify-between">
        <div>
            <div class="flex items-center justify-between mb-3">
                <p class="text-sm font-bold text-primary bg-primary/10 dark:bg-primary/20 px-3 py-1 rounded-full"><?php safeEcho($site['category_name']); ?></p>
                <div class="flex items-center gap-1" style="color:#fbbf24;">
                    <span class="material-symbols-outlined text-lg" style="color:#fbbf24;">star</span>
                    <span class="text-base font-bold" style="color:#fbbf24;"><?php echo round($site['rating'], 1); ?></span>
                    <span class="text-xs font-bold" style="color:#fbbf24;">/ 5</span>
                </div>
            </div>
            <h3 class="text-xl font-bold mb-2"><?php safeEcho($site['site_name']); ?></h3>
            <p class="text-muted-light dark:text-muted-dark text-base mb-6 flex-grow">
                <?php safeEcho($site['short_description']); ?>
            </p>
        </div>
        <a class="bg-gradient-to-r from-primary to-primary-dark text-white w-full mt-auto px-6 py-3 rounded-xl text-base font-bold flex items-center justify-center gap-3 hover:from-primary-dark hover:to-primary shadow-lg hover:shadow-primary/25 transition-all duration-300 group" href="<?php echo URLHelper::getSiteURL($site['site_name']); ?>">
            <span class="material-symbols-outlined text-lg">launch</span>
            <span>Siteyi Ziyaret Et</span>
            <span class="material-symbols-outlined text-lg transform group-hover:translate-x-1 transition-transform duration-300">arrow_forward</span>
        </a>
    </div>
</div>
<?php endforeach; ?>
</div>
</section>
<?php endif; ?>

<?php
// Content bottom reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
}
?>

</div>
</main>
<?php include 'includes/footer.php'; ?>
</div>

</body></html>
