<?php
require_once '../includes/config.php';
require_once '../utils/url_helper.php';
require_once '../utils/ads_helper.php';
require_once '../includes/turkish_fix.php';

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Sayfa tipini tespit et
$current_page_type = detectPageType();

// URL parametrelerini işle
$cat_id = 0;
$category = null;

// Yeni URL formatı: /category/category-slug
if (isset($_GET['category_slug'])) {
    $category_slug = $_GET['category_slug'];
    $category = URLHelper::getCategoryBySlug($category_slug, $pdo);
    
    if ($category) {
        $cat_id = $category['id'];
    } else {
        // Kategori bulunamadı - 404
        header("HTTP/1.0 404 Not Found");
        include '404.php';
        exit;
    }
} else {
    // Eski format desteği: ?cat_id=1 - sadece parametre varsa redirect yap
    if (isset($_GET['cat_id'])) {
        $cat_id = intval($_GET['cat_id']);
        
        if ($cat_id > 0) {
            $stmt = $pdo->prepare('SELECT * FROM categories WHERE id = ?');
            $stmt->execute([$cat_id]);
            $category = $stmt->fetch();
            
            if ($category) {
                // Eski URL'den yeni URL'e redirect
                $new_url = URLHelper::getCategoryURL($category['name']);
                header("Location: $new_url", true, 301);
                exit;
            } else {
                // Kategori bulunamadı - 404
                header("HTTP/1.0 404 Not Found");
                include '404.php';
                exit;
            }
        }
    }
    
    // Hiçbir parametre yoksa tüm kategorileri göster veya ana sayfaya yönlendir
    header("Location: /", true, 302);
    exit;
}
// Ayarları oku
$site_count = 10;
$stmt = $pdo->prepare('SELECT setting_value FROM settings WHERE setting_key = "site_count"');
$stmt->execute();
$site_count_db = $stmt->fetchColumn();
if ($site_count_db !== false && is_numeric($site_count_db)) {
    $site_count = (int)$site_count_db;
}
if ($cat_id > 0) {
    $stmt = $pdo->prepare('SELECT * FROM categories WHERE id = ?');
    $stmt->execute([$cat_id]);
    $category = $stmt->fetch();
}

require_once '../utils/seo_helper.php';
require_once '../utils/seo_title_helper.php';

// Site settings'lerini al
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$site_title_base = $settings['site_title'] ?? 'Web Dizini';

// SEO Title oluştur
$page_title = $category ? generateCategoryTitle($category['name'], $settings) : generatePageTitle('Categories', $settings);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<?php 
// SEO Title burada tekrar oluşturulacak
$page_title = $category ? generateCategoryTitle($category['name'], $settings) : generatePageTitle('Categories', $settings);
?>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="<?php echo $category ? htmlspecialchars($category['description'] ?? '') : 'Tüm kategorileri göz atın'; ?>">
    <?php
    // Favicon
    $favicon_url = $settings['favicon_url'] ?? '';
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
            $favicon_url = '/' . ltrim($favicon_url, '/');
        }
        echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    }
    ?>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
      tailwind.config = {
        darkMode: "class",
        theme: {
          extend: {
            colors: {
              "primary": "#13a4ec",
              "background-light": "#f6f7f8",
              "background-dark": "#101c22",
              "foreground-light": "#0d171b",
              "foreground-dark": "#e7eff3",
              "subtle-light": "#e7eff3",
              "subtle-dark": "#2c3a42",
              "muted-light": "#4c809a",
              "muted-dark": "#9cb3c1",
            },
            fontFamily: {
              "display": ["Plus Jakarta Sans", "sans-serif"]
            },
            borderRadius: {"DEFAULT": "0.5rem", "lg": "1rem", "xl": "1.5rem", "full": "9999px"},
          },
        },
      }
    </script>
    <style>
      .gradient-text {
        background: linear-gradient(to right, #13a4ec, #9F7AEA);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
      }
      
      .material-symbols-outlined {
        font-variation-settings:
        'FILL' 0,
        'wght' 400,
        'GRAD' 0,
        'opsz' 24
      }
    </style>
</head>
<body class="bg-background-light dark:bg-background-dark font-display text-foreground-light dark:text-foreground-dark <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">

<div class="flex flex-col min-h-screen">
<?php include '../includes/header.php'; ?>
<main class="container mx-auto px-4 sm:px-6 lg:px-8 py-8 flex-grow">
<div class="max-w-4xl mx-auto">
<?php if ($category): ?>
<?php
// Content top reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
}
?>

<div class="flex flex-col sm:flex-row justify-between items-start sm:items-center gap-4 mb-8">
<h1 class="text-3xl sm:text-4xl font-bold text-foreground-light dark:text-foreground-dark"><?php safeEcho($category['name']); ?></h1>
<a class="inline-flex items-center gap-2 px-4 py-2 bg-subtle-light dark:bg-subtle-dark hover:bg-muted-light dark:hover:bg-muted-dark text-foreground-light dark:text-foreground-dark rounded-full text-sm font-medium transition-colors" href="/">
<span class="material-symbols-outlined text-lg">arrow_back</span>
<span>Tüm Kategoriler</span>
</a>
</div>
<?php
    // Sayfalama
    $page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
    $offset = ($page - 1) * $site_count;
    // Toplam site sayısı
    $countStmt = $pdo->prepare('SELECT COUNT(*) FROM site_submissions WHERE category_id = ? AND status = "approved"');
    $countStmt->execute([$cat_id]);
    $totalSites = $countStmt->fetchColumn();
    $totalPages = ceil($totalSites / $site_count);
    // Site verileri
    $stmt = $pdo->prepare('
        SELECT s.*, c.name as category_name,
            (SELECT COUNT(*) FROM site_votes v WHERE v.site_id = s.id AND v.vote_type = "upvote") AS upvotes,
            (SELECT COUNT(*) FROM site_votes v WHERE v.site_id = s.id) AS total_votes
        FROM site_submissions s 
        LEFT JOIN categories c ON s.category_id = c.id 
        WHERE s.category_id = ? AND s.status = "approved" 
        ORDER BY s.id DESC 
        LIMIT ? OFFSET ?
    ');
    $stmt->bindValue(1, $cat_id, PDO::PARAM_INT);
    $stmt->bindValue(2, $site_count, PDO::PARAM_INT);
    $stmt->bindValue(3, $offset, PDO::PARAM_INT);
    $stmt->execute();
    $sites = $stmt->fetchAll();
?>
<div class="grid gap-6">
<?php foreach ($sites as $site): ?>
<div class="bg-white dark:bg-subtle-dark p-4 rounded-lg shadow-sm hover:shadow-lg transition-shadow duration-300 flex flex-col sm:flex-row items-center gap-6">
    <div class="flex-grow flex flex-col justify-between">
        <div>
            <div class="flex items-center justify-between mb-2">
                <h3 class="text-xl font-bold text-foreground-light dark:text-foreground-dark"><?php safeEcho($site['site_name']); ?></h3>
                <div class="flex items-center gap-1 text-amber-500">
                    <?php
                    $upvotes = (int)$site['upvotes'];
                    $total_votes = (int)$site['total_votes'];
                    $star = 0;
                    if ($total_votes > 0) {
                        $star = round(($upvotes / $total_votes) * 5, 1);
                    }
                    ?>
                    <span class="font-bold text-sm"><?php echo number_format($star, 1); ?></span>
                    <span class="material-symbols-outlined text-lg">star</span>
                    <span class="ml-1 text-xs text-muted-light dark:text-muted-dark">(<?php echo $total_votes; ?>)</span>
                </div>
            </div>
            <p class="text-muted-light dark:text-muted-dark mb-3 text-sm"><?php safeEcho($site['short_description']); ?></p>
        </div>
        <div class="flex items-center gap-4 mt-auto">
            <span class="text-xs font-medium bg-primary/10 text-primary px-2 py-1 rounded-full"><?php safeEcho($category['name']); ?></span>
            <a class="inline-flex items-center gap-2 text-sm font-bold text-primary hover:underline" href="<?php echo URLHelper::getSiteURL($site['site_name']); ?>">
                <span>Siteyi Ziyaret Et</span>
                <span class="material-symbols-outlined text-lg">arrow_forward</span>
            </a>
        </div>
    </div>
    <?php 
    // Logo URL'i belirle - logo kontrolü yaparak direkt çözüm
    $has_logo = false;
    $logo_src = '/uploads/no-logo.png'; // Varsayılan (absolute path)
    
    if (!empty($site['logo_url'])) {
        if (filter_var($site['logo_url'], FILTER_VALIDATE_URL)) {
            $logo_src = $site['logo_url'];
        } else {
            $logo_path = ltrim($site['logo_url'], '/');
            if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
                $logo_src = '/' . $logo_path;
            }
        }
        $has_logo = true;
    } elseif (!empty($site['site_logo'])) {
        $logo_path = $site['site_logo'];
        
        // URL ise doğrudan kullan
        if (filter_var($logo_path, FILTER_VALIDATE_URL)) {
            $logo_src = $logo_path;
            $has_logo = true;
        } else {
            // Yerel dosya yolu işleme
            $logo_path = str_replace(['https://usasportstvs.com/uploads/', 'https://usasportstvs.com/', 'admin/uploads/', '/admin/uploads/', 'uploads/', '/uploads/'], '', $logo_path);
            
            // Boş değilse ve geçerliyse kullan
            if (!empty(trim($logo_path)) && trim($logo_path) !== '/' && trim($logo_path) !== 'uploads/') {
                $logo_src = '/uploads/' . trim($logo_path);
                $has_logo = true;
            }
        }
    } elseif (!empty($site['favicon_url'])) {
        // Favicon'u logo olarak kullan
        if (filter_var($site['favicon_url'], FILTER_VALIDATE_URL)) {
            $logo_src = $site['favicon_url'];
        } else {
            $logo_src = '/' . ltrim($site['favicon_url'], '/');
        }
        $has_logo = true;
    }
    ?>
    <div class="w-32 h-20 sm:w-48 sm:h-32 flex-shrink-0 bg-white dark:bg-slate-800 border border-line-light rounded-lg flex items-center justify-center overflow-hidden">
        <?php if ($has_logo): ?>
        <img src="<?php echo htmlspecialchars($logo_src); ?>" alt="<?php echo htmlspecialchars($site['site_name']); ?> Logo" class="object-contain w-full h-full" onerror="this.src='/uploads/no-logo.png'; this.onerror=null;" />
        <?php else: ?>
        <img src="/uploads/no-logo.png" alt="<?php echo htmlspecialchars($site['site_name']); ?> Logo" class="object-contain w-full h-full" />
        <?php endif; ?>
    </div>
</div>
<?php endforeach; ?>
</div>
<?php if ($totalPages > 1): ?>
<div class="flex justify-center mt-8">
    <nav class="inline-flex gap-2">
        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
            <a href="<?php echo URLHelper::getCategoryURL($category['name']) . '?page=' . $i; ?>" class="px-4 py-2 rounded-lg border <?php echo ($i == $page ? 'bg-primary text-white border-primary' : 'bg-white dark:bg-subtle-dark text-primary border-subtle-light dark:border-subtle-dark'); ?> font-bold hover:bg-primary/80 hover:text-white transition-colors">
                <?php echo $i; ?>
            </a>
        <?php endfor; ?>
    </nav>
</div>
<?php endif; ?>
<?php else: ?>
<p class="text-center text-lg text-muted-light dark:text-muted-dark">Kategori bulunamadı.</p>
<?php endif; ?>

<?php
// Content bottom reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
}
?>

</div>
</main>
<?php include '../includes/footer.php'; ?>
</div>

</body>
</html>