<!DOCTYPE html>
<html lang="tr">
<head>
<?php 
// Türkçe karakter desteği için encoding ayarı
if (!headers_sent()) {
    header('Content-Type: text/html; charset=utf-8');
}
mb_internal_encoding('UTF-8');

require_once '../includes/config.php';
require_once '../utils/url_helper.php';
require_once '../utils/seo_title_helper.php';
require_once '../utils/view_count_helper.php';
require_once '../utils/ads_helper.php';
require_once '../includes/turkish_fix.php';

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// SEO Title oluştur
$page_title = generatePageTitle('Yeni Eklenen Siteler', $settings);

// Sayfa tipini tespit et
$current_page_type = detectPageType();
?>
<meta charset="UTF-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title><?php echo htmlspecialchars($page_title); ?></title>
<meta name="description" content="Dizinimize eklenen en son web sitelerini keşfedin">
<?php
// Favicon
$favicon_url = $settings['favicon_url'] ?? '';
if (!empty($favicon_url)) {
    if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
        $favicon_url = '/' . ltrim($favicon_url, '/');
    }
    echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
}
?>
<meta name="keywords" content="yeni siteler, yeni eklenen siteler, site dizini" />
<link href="https://fonts.googleapis.com" rel="preconnect"/>
<link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
<link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@400;500;700;900&amp;display=swap" rel="stylesheet"/>
<link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet"/>
<script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
<script id="tailwind-config">
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#38BDF8",
                        "primary-light": "#7DD3FC",
                        "primary-dark": "#0EA5E9",
                        "background-light": "#F7FAFC",
                        "background-dark": "#0F172A",
                        "foreground-light": "#0F172A",
                        "foreground-dark": "#E2E8F0",
                        "subtle-light": "#E2E8F0",
                        "subtle-dark": "#1E293B",
                        "muted-light": "#64748B",
                        "muted-dark": "#94A3B8"
                    },
                    fontFamily: {
                        "display": ["Public Sans", "sans-serif"]
                    },
                    borderRadius: {
                        DEFAULT: "0.75rem",
                        lg: "1rem",
                        xl: "1.5rem",
                        full: "9999px"
                    },
                    boxShadow: {
                        'soft': '0 4px 12px 0 rgb(0 0 0 / 0.07)',
                        'subtle': '0 1px 2px 0 rgb(0 0 0 / 0.05)',
                    }
                },
            },
        };
    </script>
<style>
        .material-symbols-outlined {
            font-variation-settings: "FILL" 0, "wght" 400, "GRAD" 0, "opsz" 24;
        }
        .active .material-symbols-outlined {
            font-variation-settings: 'FILL' 1;
        }
    </style>
</head>
<body class="bg-background-light dark:bg-background-dark font-display text-foreground-light dark:text-foreground-dark min-h-screen <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">

<?php include '../includes/header.php'; ?>

<?php
require_once '../includes/config.php';
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Sayfalama ayarları
$items_per_page = (int)($settings['newly_added_page_count'] ?? $settings['site_count'] ?? 12);
$current_page = max(1, (int)($_GET['page'] ?? 1));
$offset = ($current_page - 1) * $items_per_page;

// Toplam site sayısını al
$count_stmt = $pdo->prepare('
    SELECT COUNT(*) FROM site_submissions 
    WHERE status = "approved"
');
$count_stmt->execute();
$total_sites = $count_stmt->fetchColumn();
$total_pages = ceil($total_sites / $items_per_page);

// Yeni eklenen siteleri çek
$sql = '
    SELECT 
        s.*, 
        c.name as category_name,
        COALESCE(s.view_count, 0) as view_count,
        COALESCE(v.upvotes, 0) as upvotes,
        COALESCE(v.downvotes, 0) as downvotes,
        COALESCE(v.total_votes, 0) as total_votes,
        CASE 
            WHEN COALESCE(v.total_votes, 0) = 0 THEN 0 
            ELSE ROUND((COALESCE(v.upvotes, 0) * 5.0) / COALESCE(v.total_votes, 0), 1) 
        END as rating
    FROM site_submissions s
    LEFT JOIN categories c ON s.category_id = c.id
    LEFT JOIN (
        SELECT 
            site_id,
            SUM(CASE WHEN vote_type = "upvote" THEN 1 ELSE 0 END) as upvotes,
            SUM(CASE WHEN vote_type = "downvote" THEN 1 ELSE 0 END) as downvotes,
            COUNT(*) as total_votes
        FROM site_votes 
        GROUP BY site_id
    ) v ON s.id = v.site_id
    WHERE s.status = "approved"
    ORDER BY s.olusturulma_tarihi DESC
    LIMIT ' . (int)$offset . ', ' . (int)$items_per_page;

$stmt = $pdo->prepare($sql);
$stmt->execute();
$sites = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Rating yıldızlarını oluşturan fonksiyon
function generateStars($rating, $total_votes) {
    $stars = '';
    $rating = floatval($rating); // Float'a çevir
    
    for ($i = 1; $i <= 5; $i++) {
        if ($rating >= $i) {
            // Tam dolu yıldız
            $stars .= '<span class="material-symbols-outlined text-yellow-400" style="font-variation-settings: \'FILL\' 1, \'wght\' 400, \'GRAD\' 0, \'opsz\' 20;">star</span>';
        } elseif ($rating >= ($i - 0.5)) {
            // Yarım yıldız
            $stars .= '<span class="material-symbols-outlined text-yellow-400" style="font-variation-settings: \'FILL\' 0, \'wght\' 400, \'GRAD\' 0, \'opsz\' 20;">star_half</span>';
        } else {
            // Boş yıldız
            $stars .= '<span class="material-symbols-outlined text-gray-300" style="font-variation-settings: \'FILL\' 0, \'wght\' 400, \'GRAD\' 0, \'opsz\' 20;">star</span>';
        }
    }
    return $stars;
}
?>

<main class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <?php
    // Content top reklamları
    if (($settings['ads_enabled'] ?? '1') === '1') {
        echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
    }
    ?>
    
    <!-- Hero Section -->
    <div class="text-center mb-16">
        <div class="inline-flex items-center gap-3 bg-primary/10 dark:bg-primary/20 text-primary px-6 py-3 rounded-full mb-6">
            <span class="material-symbols-outlined">new_releases</span>
            <span class="font-semibold">Yeni Eklenen Siteler</span>
        </div>
        <h1 class="text-4xl md:text-5xl font-black text-foreground-light dark:text-foreground-dark mb-6">
            <span class="bg-gradient-to-r from-primary to-primary-light bg-clip-text text-transparent"><?php echo htmlspecialchars($settings['newly_added_title'] ?? 'Son Eklenen Siteler'); ?></span>
        </h1>
        <p class="text-xl text-muted-light dark:text-muted-dark max-w-2xl mx-auto leading-relaxed">
            <?php echo htmlspecialchars($settings['newly_added_subtitle'] ?? 'Topluluğumuzun yakın zamanda keşfettiği ve eklediği harika web sitelerini keşfedin.'); ?>
        </p>
        
        <!-- Statistics -->
        <div class="flex justify-center gap-8 mt-8">
            <div class="text-center">
                <div class="text-2xl font-bold text-primary"><?php echo number_format($total_sites); ?></div>
                <div class="text-sm text-muted-light dark:text-muted-dark">Toplam Site</div>
            </div>
            <div class="text-center">
                <div class="text-2xl font-bold text-primary"><?php echo $current_page; ?></div>
                <div class="text-sm text-muted-light dark:text-muted-dark">Sayfa</div>
            </div>
            <div class="text-center">
                <div class="text-2xl font-bold text-primary"><?php echo $total_pages; ?></div>
                <div class="text-sm text-muted-light dark:text-muted-dark">Toplam Sayfa</div>
            </div>
        </div>
    </div>

    <?php if (empty($sites)): ?>
        <!-- Empty State -->
        <div class="text-center py-20">
            <div class="w-24 h-24 bg-subtle-light dark:bg-subtle-dark rounded-full flex items-center justify-center mx-auto mb-6">
                <span class="material-symbols-outlined text-4xl text-muted-light dark:text-muted-dark">web_stories</span>
            </div>
            <h3 class="text-2xl font-bold text-foreground-light dark:text-foreground-dark mb-3">Henüz Site Eklenmemiş</h3>
            <p class="text-muted-light dark:text-muted-dark mb-8">İlk site ekleyen olun ve topluluğa katkıda bulunun!</p>
            <a href="/submit" class="inline-flex items-center gap-2 bg-primary hover:bg-primary-dark text-white px-6 py-3 rounded-xl font-semibold transition-colors">
                <span class="material-symbols-outlined">add</span>
                Site Ekle
            </a>
        </div>
    <?php else: ?>
        <!-- Sites Grid -->
        <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6">
            <?php foreach ($sites as $site): ?>
                <div class="bg-white dark:bg-subtle-dark border border-subtle-light dark:border-subtle-dark rounded-xl p-6 hover:shadow-lg transition-all duration-300 group h-auto md:h-[420px] flex flex-col">
                    <!-- Site Logo & Header -->
                    <div class="flex items-start gap-4 mb-4">
                        <?php 
                        // Logo kontrolü yaparak direkt çözüm
                        $has_logo = false;
                        $logo_src = '/uploads/no-logo.png'; // Varsayılan (absolute path)
                        
                        if (!empty($site['logo_url'])) {
                            if (filter_var($site['logo_url'], FILTER_VALIDATE_URL)) {
                                $logo_src = $site['logo_url'];
                            } else {
                                $logo_path = ltrim($site['logo_url'], '/');
                                if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
                                    $logo_src = '/' . $logo_path;
                                }
                            }
                            $has_logo = true;
                        } elseif (!empty($site['site_logo'])) {
                            $logo_path = $site['site_logo'];
                            
                            // URL ise doğrudan kullan
                            if (filter_var($logo_path, FILTER_VALIDATE_URL)) {
                                $logo_src = $logo_path;
                                $has_logo = true;
                            } else {
                                // Yerel dosya yolu işleme
                                $logo_path = str_replace(['https://usasportstvs.com/uploads/', 'https://usasportstvs.com/', 'admin/uploads/', '/admin/uploads/', 'uploads/', '/uploads/'], '', $logo_path);
                                
                                // Boş değilse ve geçerliyse kullan
                                if (!empty(trim($logo_path)) && trim($logo_path) !== '/' && trim($logo_path) !== 'uploads/') {
                                    $logo_src = '/uploads/' . trim($logo_path);
                                    $has_logo = true;
                                }
                            }
                        } elseif (!empty($site['favicon_url'])) {
                            // Favicon'u logo olarak kullan
                            if (filter_var($site['favicon_url'], FILTER_VALIDATE_URL)) {
                                $logo_src = $site['favicon_url'];
                            } else {
                                $logo_src = '/' . ltrim($site['favicon_url'], '/');
                            }
                            $has_logo = true;
                        }
                        ?>
                        <?php if ($has_logo): ?>
                        <img src="<?php echo htmlspecialchars($logo_src); ?>" 
                             alt="<?php echo htmlspecialchars($site['site_name']); ?>" 
                             class="w-20 h-20 object-contain rounded-lg border-2 border-subtle-light dark:border-subtle-dark flex-shrink-0 bg-white p-1" 
                             onerror="this.src='/uploads/no-logo.png'; this.onerror=null;" />
                        <?php else: ?>
                        <img src="/uploads/no-logo.png" 
                             alt="<?php echo htmlspecialchars($site['site_name']); ?>" 
                             class="w-20 h-20 object-contain rounded-lg border-2 border-subtle-light dark:border-subtle-dark flex-shrink-0 bg-white p-1" />
                        <?php endif; ?>
                        
                        <div class="flex-1 min-w-0">
                            <h3 class="text-lg font-bold text-foreground-light dark:text-foreground-dark mb-2 leading-tight">
                                <?php safeEcho($site['site_name']); ?>
                            </h3>
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary/10 text-primary">
                                <?php safeEcho($site['category_name'] ?? 'General'); ?>
                            </span>
                            <!-- NEW Badge -->
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-green-100 text-green-800 ml-2">
                                NEW
                            </span>
                        </div>
                    </div>
                    
                    <!-- Description -->
                    <div class="flex-1 mb-4">
                        <p class="text-muted-light dark:text-muted-dark text-sm leading-relaxed overflow-hidden" style="display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical;">
                            <?php 
                            $description = $site['short_description'] ?: strip_tags($site['long_description']);
                            echo htmlspecialchars(strlen($description) > 150 ? substr($description, 0, 150) . '...' : $description); 
                            ?>
                        </p>
                    </div>
                    
                    <!-- Rating Section -->
                    <div class="flex items-center justify-between mb-4 p-3 bg-background-light dark:bg-background-dark rounded-lg mt-auto">
                        <div class="flex items-center gap-2">
                            <div class="flex items-center">
                                <?php echo generateStars($site['rating'], $site['total_votes']); ?>
                            </div>
                            <span class="text-sm font-semibold text-foreground-light dark:text-foreground-dark">
                                <?php echo number_format($site['rating'], 1); ?>
                            </span>
                        </div>
                        
                        <div class="flex items-center gap-3 text-xs text-muted-light dark:text-muted-dark">
                            <div class="flex items-center gap-1">
                                <span class="text-green-600">👍</span>
                                <span><?php echo $site['upvotes']; ?></span>
                            </div>
                            <div class="flex items-center gap-1">
                                <span class="text-red-600">👎</span>
                                <span><?php echo $site['downvotes']; ?></span>
                            </div>
                            <div class="flex items-center gap-1 text-blue-600 dark:text-blue-400">
                                <span class="material-symbols-outlined text-sm">visibility</span>
                                <span>Views: <?php echo number_format($site['view_count']); ?></span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Action Buttons -->
                    <div class="flex gap-2">
                        <a href="<?php echo URLHelper::getSiteURL($site['site_name']); ?>" 
                           class="flex-1 inline-flex items-center justify-center gap-2 px-4 py-3 bg-primary text-white rounded-lg font-medium hover:bg-primary/90 transition-all duration-300 group-hover:scale-[1.02]">
                            <span>Detayları Gör</span>
                            <span class="material-symbols-outlined text-lg transform group-hover:translate-x-1 transition-transform">arrow_forward</span>
                        </a>
                        <a href="<?php echo htmlspecialchars($site['site_url']); ?>" 
                           target="_blank" 
                           class="inline-flex items-center justify-center gap-2 px-4 py-3 text-white rounded-lg font-medium transition-all duration-300 shadow-lg"
                           style="background: linear-gradient(to right, <?php echo htmlspecialchars($settings['primary_color'] ?? '#3b82f6'); ?>, <?php echo htmlspecialchars($settings['primary_color'] ?? '#3b82f6'); ?>);">
                            <span class="material-symbols-outlined text-lg">launch</span>
                        </a>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
        
        <!-- Sayfalama -->
        <?php if ($total_pages > 1): ?>
        <div class="flex justify-center mt-16">
            <nav class="flex items-center gap-2">
                <!-- Önceki Sayfa -->
                <?php if ($current_page > 1): ?>
                    <a href="?page=<?php echo $current_page - 1; ?>" 
                       class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark">
                        <span class="material-symbols-outlined">chevron_left</span>
                    </a>
                <?php endif; ?>
                
                <!-- Sayfa Numaraları -->
                <?php
                $start_page = max(1, $current_page - 2);
                $end_page = min($total_pages, $current_page + 2);
                
                if ($start_page > 1): ?>
                    <a href="?page=1" class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark">1</a>
                    <?php if ($start_page > 2): ?>
                        <span class="px-2 text-muted-light dark:text-muted-dark">...</span>
                    <?php endif; ?>
                <?php endif; ?>
                
                <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                    <?php if ($i == $current_page): ?>
                        <span class="flex items-center justify-center w-10 h-10 rounded-lg bg-primary text-white font-semibold">
                            <?php echo $i; ?>
                        </span>
                    <?php else: ?>
                        <a href="?page=<?php echo $i; ?>" 
                           class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark">
                            <?php echo $i; ?>
                        </a>
                    <?php endif; ?>
                <?php endfor; ?>
                
                <?php if ($end_page < $total_pages): ?>
                    <?php if ($end_page < $total_pages - 1): ?>
                        <span class="px-2 text-muted-light dark:text-muted-dark">...</span>
                    <?php endif; ?>
                    <a href="?page=<?php echo $total_pages; ?>" class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark"><?php echo $total_pages; ?></a>
                <?php endif; ?>
                
                <!-- Sonraki Sayfa -->
                <?php if ($current_page < $total_pages): ?>
                    <a href="?page=<?php echo $current_page + 1; ?>" 
                       class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark">
                        <span class="material-symbols-outlined">chevron_right</span>
                    </a>
                <?php endif; ?>
            </nav>
        </div>
        
        <!-- Page Info -->
        <div class="text-center mt-6 text-sm text-muted-light dark:text-muted-dark">
            Sayfa <?php echo $current_page; ?> / <?php echo $total_pages; ?> 
            (Toplam <?php echo number_format($total_sites); ?> site)
        </div>
        <?php endif; ?>
    <?php endif; ?>
    
    <?php
    // Content bottom reklamları
    if (($settings['ads_enabled'] ?? '1') === '1') {
        echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
    }
    ?>
</main>

<?php include '../includes/footer.php'; ?>

</body>
</html>