<?php
require_once '../includes/config.php';
require_once '../includes/turkish_fix.php';

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Get page slug from URL
$slug = isset($_GET['slug']) ? trim($_GET['slug']) : '';

if (empty($slug)) {
    header("Location: /");
    exit();
}

// Fetch page data
$stmt = $pdo->prepare("SELECT * FROM pages WHERE slug = ? AND status = 'published'");
$stmt->execute([$slug]);
$page = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$page) {
    header("Location: /");
    exit();
}

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php safeEcho($page['title']); ?> - <?php safeEcho($settings['site_title'] ?? 'Site'); ?></title>
    
    <?php if (!empty($page['meta_description'])): ?>
        <meta name="description" content="<?php echo htmlspecialchars($page['meta_description']); ?>">
    <?php endif; ?>
    
    <?php if (!empty($page['meta_keywords'])): ?>
        <meta name="keywords" content="<?php echo htmlspecialchars($page['meta_keywords']); ?>">
    <?php endif; ?>
    
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@400;500;700;900&amp;display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet"/>
    <script src="https://cdn.tailwindcss.com?plugins=forms,container-queries"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#38BDF8",
                        "primary-light": "#7DD3FC",
                        "primary-dark": "#0EA5E9",
                        "background-light": "#F7FAFC",
                        "background-dark": "#0F172A",
                        "foreground-light": "#0F172A",
                        "foreground-dark": "#E2E8F0",
                        "subtle-light": "#E2E8F0",
                        "subtle-dark": "#1E293B",
                        "muted-light": "#64748B",
                        "muted-dark": "#94A3B8"
                    },
                    fontFamily: {
                        "display": ["Public Sans", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.75rem",
                        "lg": "1rem",
                        "full": "9999px"
                    },
                },
            },
        }
    </script>
    <style type="text/tailwindcss">
        .content-page h1 {
            @apply text-4xl font-bold text-foreground-light dark:text-foreground-dark mb-6;
        }
        .content-page h2 {
            @apply text-2xl font-semibold text-foreground-light dark:text-foreground-dark mb-4 mt-8;
        }
        .content-page h3 {
            @apply text-xl font-semibold text-foreground-light dark:text-foreground-dark mb-3 mt-6;
        }
        .content-page p {
            @apply text-foreground-light dark:text-foreground-dark mb-4 leading-relaxed;
        }
        .content-page ul, .content-page ol {
            @apply text-foreground-light dark:text-foreground-dark mb-4 ml-6;
        }
        .content-page li {
            @apply mb-2;
        }
        .content-page ul li {
            @apply list-disc;
        }
        .content-page ol li {
            @apply list-decimal;
        }
        .content-page a {
            @apply text-primary hover:text-primary-dark underline;
        }
        .content-page blockquote {
            @apply border-l-4 border-primary bg-background-light dark:bg-background-dark pl-4 py-2 mb-4 italic;
        }
        .content-page code {
            @apply bg-subtle-light dark:bg-subtle-dark px-2 py-1 rounded text-sm;
        }
        .content-page pre {
            @apply bg-subtle-light dark:bg-subtle-dark p-4 rounded-lg mb-4 overflow-x-auto;
        }
    </style>
</head>

<body class="bg-background-light dark:bg-background-dark min-h-screen <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">
    <?php include '../includes/header.php'; ?>
    
    <main class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
        <div class="max-w-4xl mx-auto">
            <!-- Breadcrumb -->
            <nav class="mb-8">
                <ol class="flex items-center space-x-2 text-sm text-muted-light dark:text-muted-dark">
                    <li><a href="/" class="hover:text-primary">Home</a></li>
                    <li><span class="material-symbols-outlined text-xs">chevron_right</span></li>
                    <li class="text-foreground-light dark:text-foreground-dark font-medium"><?php safeEcho($page['title']); ?></li>
                </ol>
            </nav>
            <!-- Page Content -->
            <article class="content-page">
                <header class="mb-8">
                    <h1><?php safeEcho($page['title']); ?></h1>
                    <div class="flex items-center text-sm text-muted-light dark:text-muted-dark">
                        <span class="material-symbols-outlined text-base mr-1">schedule</span>
                        Published on <?php echo date('F j, Y', strtotime($page['created_at'])); ?>
                        <?php if ($page['updated_at'] != $page['created_at']): ?>
                            • Updated on <?php echo date('F j, Y', strtotime($page['updated_at'])); ?>
                        <?php endif; ?>
                    </div>
                </header>
                <div class="prose prose-lg max-w-none">
                    <?php echo fixTurkishEncoding($page['content']); ?>
                </div>
            </article>
        </div>
    </main>
    <?php include '../includes/footer.php'; ?>
</body>
</html>