<?php
require_once '../includes/config.php';
require_once '../utils/seo_helper.php';
require_once '../utils/seo_title_helper.php';

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Arama sayfası için meta bilgileri
$search_term = $_GET['q'] ?? '';
$page_title = $search_term ? 
    generatePageTitle('Search Results for "' . $search_term . '"', $settings) : 
    generatePageTitle('Search', $settings);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="Dizinimizde web siteleri ve kaynakları arayın. Aradığınızı tam olarak bulun.">
    <?php
    // Favicon
    $favicon_url = $settings['favicon_url'] ?? '';
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
            $favicon_url = '/' . ltrim($favicon_url, '/');
        }
        echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    }
    ?>
<script>
      tailwind.config = {
        darkMode: "class",
        theme: {
          extend: {
            colors: {
              primary: "#13a4ec",
              "background-light": "#f6f7f8",
              "background-dark": "#101c22",
            },
            fontFamily: {
              display: ["Manrope"],
            },
            borderRadius: {
              DEFAULT: "0.5rem",
              lg: "1rem",
              xl: "1.5rem",
              full: "9999px",
            },
          },
        },
      };
    </script>
<title>Kanka - Arama Sonuçları</title>
</head>
<body class="font-display bg-background-light dark:bg-background-dark">
<div class="flex flex-col min-h-screen">
<?php include 'header.php'; ?>
<main class="flex-grow container mx-auto px-4 sm:px-6 lg:px-8 py-8 lg:py-12">
<div class="max-w-4xl mx-auto">
<div class="mb-8">
<h2 class="text-3xl font-bold text-slate-900 dark:text-white mb-2">"Tasarım" için Arama Sonuçları</h2>
<div class="relative group">
<span class="material-symbols-outlined absolute left-4 top-1/2 -translate-y-1/2 text-slate-500 dark:text-slate-400 group-focus-within:text-primary">search</span>
<input class="w-full h-14 pl-12 pr-16 text-lg bg-background-light dark:bg-background-dark border-2 border-slate-200 dark:border-slate-800 rounded-xl focus:ring-2 focus:ring-primary focus:border-transparent outline-none transition-all text-slate-900 dark:text-white" type="text" value="Design"/>
<button class="absolute right-4 top-1/2 -translate-y-1/2 text-slate-500 dark:text-slate-400 hover:text-primary dark:hover:text-primary">
<span class="material-symbols-outlined">close</span>
</button>
</div>
</div>
<div class="flex flex-wrap items-center gap-4 mb-8">
<button class="flex items-center gap-2 px-4 py-2 bg-slate-200 dark:bg-slate-800 text-slate-700 dark:text-slate-300 rounded-full text-sm font-medium hover:bg-slate-300 dark:hover:bg-slate-700 transition-colors">
<span>Kategori</span>
<span class="material-symbols-outlined text-base">expand_more</span>
</button>
<button class="flex items-center gap-2 px-4 py-2 bg-slate-200 dark:bg-slate-800 text-slate-700 dark:text-slate-300 rounded-full text-sm font-medium hover:bg-slate-300 dark:hover:bg-slate-700 transition-colors">
<span>Sırala</span>
<span class="material-symbols-outlined text-base">expand_more</span>
</button>
<button class="flex items-center gap-2 px-4 py-2 bg-slate-200 dark:bg-slate-800 text-slate-700 dark:text-slate-300 rounded-full text-sm font-medium hover:bg-slate-300 dark:hover:bg-slate-700 transition-colors">
<span>Tarih</span>
<span class="material-symbols-outlined text-base">expand_more</span>
</button>
</div>
<div class="grid gap-6">
<div class="bg-background-light dark:bg-background-dark p-4 rounded-xl border border-slate-200 dark:border-slate-800 flex flex-col md:flex-row items-center gap-6 transition-shadow hover:shadow-xl hover:border-primary/30">
<div class="w-full md:w-1/3 h-48 md:h-full rounded-lg bg-cover bg-center" style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuDBtQXlcobg_E3GT4H5a24qcoaAkgKj5NNbW-yT4OZVr4MgI0hVH-KJddD9Y06ELAUhebwN3nk6VCD-E9CCUA4OyaAnB2bk7Ywtfk95SeWN4mCKTIWd3jeVr8Y1GLPxPhj4vW0XRkjWXEODJQdXgR1JliVqaRTDrV1vTK25ez18flalohX0hmWQmvK3wrNKTugKlEqUVRfv5E8oKZmct28EqhTaHqwSQ-z9ydtYjNQahjbsl2EfNA0ktOr0QI_hp8k3RuH8q4KtIw");'></div>
<div class="flex-1">
<div class="flex items-center justify-between mb-2">
<h3 class="text-xl font-bold text-slate-900 dark:text-white">TechCrunch</h3>
<div class="flex items-center gap-1 text-slate-500 dark:text-slate-400 font-medium">
<span class="material-symbols-outlined text-lg text-primary">thumb_up</span>
<span>1.2k</span>
</div>
</div>
<p class="text-slate-600 dark:text-slate-400 mb-4 text-sm leading-relaxed">TechCrunch is a leading technology media property, dedicated to obsessively profiling startups, reviewing new Internet products, and breaking tech news.</p>
<div class="flex items-center gap-4">
<a class="px-5 py-2 text-sm font-bold text-white bg-primary rounded-full hover:bg-primary/90 transition-colors flex items-center gap-2" href="#">
<span>Siteyi Ziyaret Et</span>
<span class="material-symbols-outlined text-base">arrow_forward</span>
</a>
<span class="text-xs font-medium text-slate-500 dark:text-slate-400 bg-slate-100 dark:bg-slate-800/50 px-2 py-1 rounded">Technology</span>
</div>
</div>
</div>
<div class="bg-background-light dark:bg-background-dark p-4 rounded-xl border border-slate-200 dark:border-slate-800 flex flex-col md:flex-row items-center gap-6 transition-shadow hover:shadow-xl hover:border-primary/30">
<div class="w-full md:w-1/3 h-48 md:h-full rounded-lg bg-cover bg-center" style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuBzrGNoBFmf1JCnzZMV-b3Qoaup2bzivcltCVG36q9auu_jcrF5LbYKic9Y57j_ZDfwiEVCXAdQK3lMsSbBh0Qwe21qEAX8U2CzEWJ6QWOeuDtPYYmoFpyqQTVOpYp23fdUyQ4WGl6AfetAQsF7B-hopSoeNoAEKqlJbdAF7F1TR0RmUIYuXypU5RPgeM8B_pFS7ui-hWQOxJEXEVlB9qADwDL654FSSPFWRVulzAOGAIjQQ_FC80ZMH12xY3lu3bXfJagvCaNDhw");'></div>
<div class="flex-1">
<div class="flex items-center justify-between mb-2">
<h3 class="text-xl font-bold text-slate-900 dark:text-white">The Verge</h3>
<div class="flex items-center gap-1 text-slate-500 dark:text-slate-400 font-medium">
<span class="material-symbols-outlined text-lg text-primary">thumb_up</span>
<span>980</span>
</div>
</div>
<p class="text-slate-600 dark:text-slate-400 mb-4 text-sm leading-relaxed">The Verge was founded in 2011 in partnership with Vox Media, and covers the intersection of technology, science, art, and culture.</p>
<div class="flex items-center gap-4">
<a class="px-5 py-2 text-sm font-bold text-white bg-primary rounded-full hover:bg-primary/90 transition-colors flex items-center gap-2" href="#">
<span>Siteyi Ziyaret Et</span>
<span class="material-symbols-outlined text-base">arrow_forward</span>
</a>
<span class="text-xs font-medium text-slate-500 dark:text-slate-400 bg-slate-100 dark:bg-slate-800/50 px-2 py-1 rounded">Science</span>
</div>
</div>
</div>
<div class="bg-background-light dark:bg-background-dark p-4 rounded-xl border border-slate-200 dark:border-slate-800 flex flex-col md:flex-row items-center gap-6 transition-shadow hover:shadow-xl hover:border-primary/30">
<div class="w-full md:w-1/3 h-48 md:h-full rounded-lg bg-cover bg-center" style='background-image: url("https://lh3.googleusercontent.com/aida-public/AB6AXuDEYmf3V9Ee3AkChRd361TkSlXpU8A2NZvUrJvK_CR5zYkZyMv1mFqFgjyFQ9bwXQ6mgWchm_2jAzDJ4fVrsKSD0e5w2T3FHEBtANeLJFPlmLUm9_Im8tuBNjD1l8gEvv8Xq2BfiJqNFpkIrx1eUHx9PGd_8H3S1Vp3Rw-5QN6lqNq9cM7rqPEpnu5FnmUMeLlf7waYSpHcitu6AHC10-caRU3hLcs6dTm8gqdILobkObsWdebYl2F8CYIxbbN6cXiUQPjk5lzOVQ");'></div>
<div class="flex-1">
<div class="flex items-center justify-between mb-2">
<h3 class="text-xl font-bold text-slate-900 dark:text-white">Wired</h3>
<div class="flex items-center gap-1 text-slate-500 dark:text-slate-400 font-medium">
<span class="material-symbols-outlined text-lg text-primary">thumb_up</span>
<span>850</span>
</div>
</div>
<p class="text-slate-600 dark:text-slate-400 mb-4 text-sm leading-relaxed">Wired is a monthly American magazine, published in print and online editions, that focuses on how emerging technologies affect culture, the economy, and politics.</p>
<div class="flex items-center gap-4">
<a class="px-5 py-2 text-sm font-bold text-white bg-primary rounded-full hover:bg-primary/90 transition-colors flex items-center gap-2" href="#">
<span>Siteyi Ziyaret Et</span>
<span class="material-symbols-outlined text-base">arrow_forward</span>
</a>
<span class="text-xs font-medium text-slate-500 dark:text-slate-400 bg-slate-100 dark:bg-slate-800/50 px-2 py-1 rounded">Culture</span>
</div>
</div>
</div>
</div>
<div class="flex items-center justify-center mt-12 space-x-1">
<a class="flex items-center justify-center w-10 h-10 rounded-full text-slate-600 dark:text-slate-400 hover:bg-slate-200 dark:hover:bg-slate-800 transition-colors" href="#">
<span class="material-symbols-outlined">chevron_left</span>
</a>
<a class="flex items-center justify-center w-10 h-10 rounded-full text-white bg-primary text-sm font-bold" href="#">1</a>
<a class="flex items-center justify-center w-10 h-10 rounded-full text-slate-600 dark:text-slate-400 hover:bg-slate-200 dark:hover:bg-slate-800 transition-colors text-sm font-medium" href="#">2</a>
<a class="flex items-center justify-center w-10 h-10 rounded-full text-slate-600 dark:text-slate-400 hover:bg-slate-200 dark:hover:bg-slate-800 transition-colors text-sm font-medium" href="#">3</a>
<span class="flex items-center justify-center w-10 h-10 rounded-full text-slate-600 dark:text-slate-400 text-sm font-medium">...</span>
<a class="flex items-center justify-center w-10 h-10 rounded-full text-slate-600 dark:text-slate-400 hover:bg-slate-200 dark:hover:bg-slate-800 transition-colors text-sm font-medium" href="#">10</a>
<a class="flex items-center justify-center w-10 h-10 rounded-full text-slate-600 dark:text-slate-400 hover:bg-slate-200 dark:hover:bg-slate-800 transition-colors" href="#">
<span class="material-symbols-outlined">chevron_right</span>
</a>
</div>
</div>
</main>
<?php include 'footer.php'; ?>
</div>

</body></html>