<?php
// Türkçe karakter desteği için encoding ayarı
if (!headers_sent()) {
    header('Content-Type: text/html; charset=utf-8');
}
mb_internal_encoding('UTF-8');

// Session'u en başta başlat
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

require_once '../includes/config.php';
require_once '../utils/url_helper.php';
require_once '../utils/seo_helper.php';
require_once '../utils/seo_title_helper.php';
require_once '../utils/view_count_helper.php';
require_once '../utils/ads_helper.php';
require_once '../includes/turkish_fix.php';

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Sayfa tipini tespit et
$current_page_type = detectPageType();

// URL parametrelerini işle
$site_id = 0;
$site = null;
$site_name = '';
$category_name = '';

// Yeni URL formatı: /site/site-slug
if (isset($_GET['site_slug'])) {
    $site_slug = $_GET['site_slug'];
    $site = URLHelper::getSiteBySlug($site_slug, $pdo);
    
    if ($site) {
        $site_id = $site['id'];
        $site_name = $site['site_name'];
        
        // View count tracking ve değer alma
        ViewCountHelper::trackView($pdo, $site_id, null, $_SERVER['REMOTE_ADDR'] ?? '', $_SERVER['HTTP_USER_AGENT'] ?? '', $_SERVER['HTTP_REFERER'] ?? '');
        $view_count = ViewCountHelper::getViewCount($pdo, $site_id);
        
        // Kategori bilgisini al
        if ($site['category_id']) {
            $stmt = $pdo->prepare("SELECT name FROM categories WHERE id = ?");
            $stmt->execute([$site['category_id']]);
            $category_name = $stmt->fetchColumn() ?: '';
        }
    } else {
        // Site bulunamadı - 404
        header("HTTP/1.0 404 Not Found");
        include '404.php'; // 404 sayfası oluşturulacak
        exit;
    }
} else {
    // Eski format desteği: ?site_id=1
    $site_id = $_GET['site_id'] ?? 0;
    
    if ($site_id) {
        $stmt = $pdo->prepare("SELECT s.*, c.name as category_name FROM site_submissions s LEFT JOIN categories c ON s.category_id = c.id WHERE s.id = ? AND s.status = 'approved'");
        $stmt->execute([$site_id]);
        $site = $stmt->fetch();
        
        if ($site) {
            $site_name = $site['site_name'];
            $category_name = $site['category_name'] ?? '';
            
            // View count tracking ve değer alma
            ViewCountHelper::trackView($pdo, $site_id, null, $_SERVER['REMOTE_ADDR'] ?? '', $_SERVER['HTTP_USER_AGENT'] ?? '', $_SERVER['HTTP_REFERER'] ?? '');
            $view_count = ViewCountHelper::getViewCount($pdo, $site_id);
            
            // Eski URL'den yeni URL'e redirect
            $new_url = URLHelper::getSiteURL($site['site_name']);
            header("Location: $new_url", true, 301);
            exit;
        }
    }
}

// Site bulunamadıysa view_count'u 0 olarak tanımla
if (!isset($view_count)) {
    $view_count = 0;
}

// Site settings'lerini al
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$site_title_base = $settings['site_title'] ?? 'Web Directory';

// SEO Title oluştur
$page_title = $site_name ? generateSiteTitle($site_name, $category_name, $settings) : generatePageTitle('Site Details', $settings);

// Meta description için HTML etiketlerini temizle ve kısalt
$clean_description = '';
$site_desc = isset($site['long_description']) ? $site['long_description'] : '';
if (!empty($site_desc)) {
    // HTML etiketlerini kaldır
    $clean_description = strip_tags($site_desc);
    // Fazla boşlukları temizle
    $clean_description = preg_replace('/\s+/', ' ', trim($clean_description));
    // 160 karakterle sınırla (SEO için optimal)
    if (strlen($clean_description) > 160) {
        $clean_description = substr($clean_description, 0, 157) . '...';
    }
}

$page_meta = [
    'title' => $site_name ? $site_name . ' | ' . $site_title_base : $site_title_base,
    'description' => $clean_description ?: 'Bu web sitesi hakkında dizinimizde detaylı bilgileri görüntüleyin.',
    'url' => $site && isset($site['site_name']) ? URLHelper::getSiteURL($site['site_name']) : '',
    'type' => 'website'
];

// Link rel type ayarını al
$stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'link_rel_type'");
$stmt->execute();
$relType = $stmt->fetchColumn() ?: 'nofollow';

// Description linkler için ayrı rel type ayarını al
$stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'description_link_rel_type'");
$stmt->execute();
$descriptionRelType = $stmt->fetchColumn() ?: 'nofollow';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
<?php 
// SEO Title burada tekrar oluşturulacak - kategori olmadan
$page_title = $site_name ? generateSEOTitle($site_name, '', $settings) : generatePageTitle('Site Details', $settings);
?>
<meta charset="UTF-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="<?php echo htmlspecialchars($clean_description ?: 'Bu web sitesi hakkında dizinimizde detaylı bilgileri görüntüleyin.'); ?>">
    
    <?php
    // Open Graph Meta Tags for WhatsApp, Facebook, Twitter etc.
    if ($site) {
        $og_title = htmlspecialchars($site_name . ' | ' . $site_title_base);
        $og_description = htmlspecialchars($clean_description ?: ($site_name . ' web dizinimizde keşfedin. Detaylı bilgiler, puanlar ve yorumları görüntüleyin.'));
        $og_url = 'https://' . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
        
        // Site logo for OG image
        $og_image = '';
        if (!empty($site['logo_url'])) {
            if (filter_var($site['logo_url'], FILTER_VALIDATE_URL)) {
                $og_image = $site['logo_url'];
            }
        } elseif (!empty($site['site_logo'])) {
            $logo_path = $site['site_logo'];
            if (filter_var($logo_path, FILTER_VALIDATE_URL)) {
                $og_image = $logo_path;
            } else {
                // Clean path and create absolute URL
                $logo_path = str_replace(['admin/uploads/', '/admin/uploads/', 'uploads/', '/uploads/'], '', $logo_path);
                if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
                    $og_image = 'https://' . $_SERVER['HTTP_HOST'] . '/uploads/' . trim($logo_path);
                }
            }
        }
        
        // Fallback to favicon if no logo
        $favicon_url = $settings['favicon_url'] ?? '';
        if (empty($og_image) && !empty($favicon_url)) {
            if (str_starts_with($favicon_url, 'http')) {
                $og_image = $favicon_url;
            } else {
                $og_image = 'https://' . $_SERVER['HTTP_HOST'] . '/' . ltrim($favicon_url, '/');
            }
        }
        
        // Output Open Graph tags
        echo "\n<!-- Open Graph / Facebook -->\n";
        echo '<meta property="og:type" content="website">' . "\n";
        echo '<meta property="og:url" content="' . $og_url . '">' . "\n";
        echo '<meta property="og:title" content="' . $og_title . '">' . "\n";
        echo '<meta property="og:description" content="' . $og_description . '">' . "\n";
        echo '<meta property="og:site_name" content="' . htmlspecialchars($site_title_base) . '">' . "\n";
        
        if (!empty($og_image)) {
            echo '<meta property="og:image" content="' . htmlspecialchars($og_image) . '">' . "\n";
            echo '<meta property="og:image:width" content="1200">' . "\n";
            echo '<meta property="og:image:height" content="630">' . "\n";
            echo '<meta property="og:image:alt" content="' . htmlspecialchars($site_name) . ' Logo">' . "\n";
        }
        
        echo "\n<!-- Twitter -->\n";
        echo '<meta property="twitter:card" content="summary_large_image">' . "\n";
        echo '<meta property="twitter:url" content="' . $og_url . '">' . "\n";
        echo '<meta property="twitter:title" content="' . $og_title . '">' . "\n";
        echo '<meta property="twitter:description" content="' . $og_description . '">' . "\n";
        
        if (!empty($og_image)) {
            echo '<meta property="twitter:image" content="' . htmlspecialchars($og_image) . '">' . "\n";
        }
        
        echo "\n<!-- Additional Meta -->\n";
        echo '<meta property="og:locale" content="en_US">' . "\n";
        echo '<meta name="theme-color" content="#13a4ec">' . "\n";
    }
    
    // Favicon
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
            $favicon_url = '/' . ltrim($favicon_url, '/');
        }
        echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    }
    ?>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@24,400,0,0" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
      tailwind.config = {
        darkMode: "class",
        theme: {
          extend: {
            colors: {
              "primary": "#13a4ec",
              "background-light": "#f6f7f8",
              "background-dark": "#101c22",
              "foreground-light": "#0d171b",
              "foreground-dark": "#e7eff3",
              "subtle-light": "#e7eff3",
              "subtle-dark": "#2c3a42",
              "muted-light": "#4c809a",
              "muted-dark": "#9cb3c1",
            },
            fontFamily: {
              "display": ["Plus Jakarta Sans", "sans-serif"]
            },
            borderRadius: {"DEFAULT": "0.5rem", "lg": "1rem", "xl": "1.5rem", "full": "9999px"},
          },
        },
      }
    </script>
<style>
      .gradient-text {
        background: linear-gradient(to right, #13a4ec, #9F7AEA);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
      }
      
      .material-symbols-outlined {
        font-variation-settings:
        'FILL' 0,
        'wght' 400,
        'GRAD' 0,
        'opsz' 24
      }
    </style>
</head>
<body class="bg-background-light dark:bg-background-dark font-display text-foreground-light dark:text-foreground-dark <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">

<?php
// Site bilgileri zaten yukarıda alındı
if ($site) {
    $category = $category_name;
    
    // Meta bilgileri güncelle
    $site_desc = $site['long_description'] ?? '';
    $clean_description = '';
    if (!empty($site_desc)) {
        // HTML etiketlerini kaldır
        $clean_description = strip_tags($site_desc);
        // Fazla boşlukları temizle
        $clean_description = preg_replace('/\s+/', ' ', trim($clean_description));
        // 160 karakterle sınırla (SEO için optimal)
        if (strlen($clean_description) > 160) {
            $clean_description = substr($clean_description, 0, 157) . '...';
        }
    }
    
    $page_meta = [
        'title' => $site_name ? $site_name . ' | ' . $site_title_base : $site_title_base,
        'description' => $clean_description ?: 'Bu web sitesi hakkında dizinimizde detaylı bilgileri görüntüleyin.',
        'url' => URLHelper::getSiteURL($site['site_name']),
        'type' => 'website'
    ];
}
?>
<div class="flex flex-col min-h-screen">
<?php include '../includes/header.php'; ?>
<main class="flex-grow container mx-auto px-4 sm:px-6 lg:px-8 py-8">
<div class="max-w-4xl mx-auto">
<?php if ($site): ?>
<?php
// Content top reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
}
?>

<div class="grid grid-cols-1 md:grid-cols-3 gap-8">
<div class="md:col-span-2 space-y-6">
<div class="flex items-start gap-6">
  <?php 
  // Logo URL'i belirle - kapsamlı logo kontrolü
  $logo_src = '/uploads/no-logo.png'; // Default fallback
  
  if (!empty($site['logo_url'])) {
      if (filter_var($site['logo_url'], FILTER_VALIDATE_URL)) {
          $logo_src = $site['logo_url'];
      } else {
          // Relative path ise absolute URL'e çevir
          $logo_path = ltrim($site['logo_url'], '/');
          if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
              $logo_src = '/' . $logo_path;
          }
      }
  } elseif (!empty($site['site_logo'])) {
      $logo_path = $site['site_logo'];
      if (filter_var($logo_path, FILTER_VALIDATE_URL)) {
          $logo_src = $logo_path;
      } else {
          // Clean path and create absolute URL
          $logo_path = str_replace(['admin/uploads/', '/admin/uploads/', 'uploads/', '/uploads/'], '', $logo_path);
          if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
              $logo_src = '/uploads/' . trim($logo_path);
          }
      }
  } elseif (!empty($site['favicon_url'])) {
      // Favicon'u logo olarak kullan
      if (filter_var($site['favicon_url'], FILTER_VALIDATE_URL)) {
          $logo_src = $site['favicon_url'];
      } else {
          $logo_src = '/' . ltrim($site['favicon_url'], '/');
      }
  }
  ?>
  <div class="w-32 h-32 flex items-center justify-center rounded-xl bg-white shadow" style="overflow:hidden;">
  <img src="<?php echo htmlspecialchars($logo_src); ?>" alt="Site Logo" class="object-contain w-28 h-28 mx-auto" onerror="this.src='/uploads/no-logo.png'; this.onerror=null;" />
  </div>
  <div class="flex-grow">
    <h1 class="text-3xl font-bold"><?php safeEcho($site['site_name']); ?></h1>
    <p class="text-base text-muted-light dark:text-muted-dark mt-2">Kategori: <?php safeEcho($category); ?></p>
    <div class="flex items-center gap-2 mt-2" style="color:#fbbf24;">
      <span class="material-symbols-outlined" style="color:#fbbf24;">star</span>
      <?php
        // 5 üzerinden puan hesapla
        $voteStmt = $pdo->prepare('SELECT 
          SUM(vote_type = "upvote") AS upvotes,
          SUM(vote_type = "downvote") AS downvotes
          FROM site_votes WHERE site_id = ?');
        $voteStmt->execute([$site_id]);
        $votes = $voteStmt->fetch(PDO::FETCH_ASSOC);
        $upvotes = intval($votes['upvotes'] ?? 0);
        $downvotes = intval($votes['downvotes'] ?? 0);
        $totalVotes = $upvotes + $downvotes;
        $rating = $totalVotes > 0 ? round(($upvotes / $totalVotes) * 5, 1) : 0.0;
      ?>
      <span class="text-base font-bold" style="color:#fbbf24;"><?php echo $rating; ?> / 5</span>
      <span class="text-sm font-bold" style="color:#fbbf24;">(<?php echo $totalVotes; ?> oy)</span>
    </div>
  </div>
</div>
<div class="prose dark:prose-invert max-w-none text-foreground-light dark:text-foreground-dark">
  <!-- Sadece long_description gösterilecek -->
  <?php
    // long_description içindeki <a> etiketlerine rel ekle (Quill editor uyumlu)
    $desc = $site['long_description'];
    
    // Quill editor ve diğer HTML editörlere uygun gelişmiş link işleme
    function processLinksForSEO($html, $relType) {
        if (empty($html)) return $html;
        
        try {
            // libxml errors'ı bastır
            $oldSetting = libxml_use_internal_errors(true);
            libxml_clear_errors();
            
            $dom = new DOMDocument('1.0', 'UTF-8');
            $dom->preserveWhiteSpace = true;
            $dom->formatOutput = false;
            
            // HTML fragment olarak yükle
            $htmlWithEncoding = '<div>' . $html . '</div>';
            
            if (!$dom->loadHTML('<?xml encoding="UTF-8">' . $htmlWithEncoding, LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD)) {
                // HTML yüklenemezse, basit regex kullan
                libxml_use_internal_errors($oldSetting);
                return preg_replace('/<a(\s[^>]*?)?>/i', '<a$1 rel="' . htmlspecialchars($relType) . '">', $html);
            }
            
            // Tüm <a> etiketlerini bul
            $links = $dom->getElementsByTagName('a');
            
            foreach ($links as $link) {
                // Mevcut rel attribute'ları temizle
                if ($link->hasAttribute('rel')) {
                    $link->removeAttribute('rel');
                }
                
                // Yeni rel attribute ekle
                $link->setAttribute('rel', $relType);
                
                // External linkler için target="_blank" ekle (güvenlik için)
                if ($link->hasAttribute('href')) {
                    $href = $link->getAttribute('href');
                    if (preg_match('/^https?:\/\//', $href)) {
                        $currentHost = $_SERVER['HTTP_HOST'] ?? '';
                        if (!empty($currentHost) && strpos($href, $currentHost) === false) {
                            $link->setAttribute('target', '_blank');
                            // External linkler için ek güvenlik
                            if ($relType === 'nofollow') {
                                $link->setAttribute('rel', 'nofollow noopener noreferrer');
                            }
                        }
                    }
                }
            }
            
            // İçeriği çıkar (div wrapper'ı kaldır)
            $result = '';
            $container = $dom->getElementsByTagName('div')->item(0);
            if ($container) {
                foreach ($container->childNodes as $child) {
                    $result .= $dom->saveHTML($child);
                }
            }
            
            libxml_use_internal_errors($oldSetting);
            return $result;
            
        } catch (Exception $e) {
            // Hata durumunda basit regex kullan
            return preg_replace('/<a(\s[^>]*?)?>/i', '<a$1 rel="' . htmlspecialchars($relType) . '">', $html);
        }
    }
    
    $desc = processLinksForSEO($desc, $descriptionRelType);
  ?>
  <div><?php echo $desc; ?></div>
</div>

<!-- View Count Display and Tracking -->
<div class="flex items-center mt-4 gap-2">
    <span class="material-symbols-outlined text-gray-600 dark:text-gray-400" style="font-size: 20px;">visibility</span>
    <span class="text-sm text-gray-600 dark:text-gray-400">
        Görüntüleme: <?php echo number_format($view_count); ?>
    </span>
</div>

<div class="bg-white dark:bg-gray-800 rounded-lg p-6 shadow border border-gray-200 dark:border-gray-700">
  <h2 class="text-xl font-semibold mb-4">Bu site için oy ver</h2>
  <div class="flex flex-col gap-4">
    <div class="flex items-center justify-between">
      <div class="flex items-center gap-2">
        <button id="upvote-btn" class="vote-btn upvote flex items-center gap-2 px-4 py-2 rounded-lg border border-green-200 hover:bg-green-50 dark:border-green-800 dark:hover:bg-green-900 transition-colors">
          <span class="material-symbols-outlined text-green-600" style="font-size: 20px;">thumb_up</span>
          <span class="upvote-count"><?php echo $upvotes; ?></span>
        </button>
        <button id="downvote-btn" class="vote-btn downvote flex items-center gap-2 px-4 py-2 rounded-lg border border-red-200 hover:bg-red-50 dark:border-red-800 dark:hover:bg-red-900 transition-colors">
          <span class="material-symbols-outlined text-red-600" style="font-size: 20px;">thumb_down</span>
          <span class="downvote-count"><?php echo $downvotes; ?></span>
        </button>
      </div>
      <div class="text-sm text-gray-600 dark:text-gray-400">
        Toplam Oy: <span id="total-votes"><?php echo $totalVotes; ?></span>
      </div>
    </div>
    <div id="vote-message" class="hidden text-center py-2 rounded-lg"></div>
  </div>
</div>

<div class="bg-white dark:bg-gray-800 rounded-lg p-6 shadow border border-gray-200 dark:border-gray-700" style="min-height: auto; overflow: visible;">
  <h2 class="text-xl font-semibold mb-4">Bu siteyi ziyaret et</h2>
  
  <?php if (!empty($site['site_url'])): ?>
    <!-- Active Website Button -->
    <a href="<?php echo htmlspecialchars($site['site_url']); ?>" target="_blank" rel="nofollow noopener noreferrer" 
       class="group inline-flex items-center justify-center w-full px-6 py-4 text-white font-bold rounded-xl shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 transition-all duration-200 ease-in-out"
       style="background: linear-gradient(to right, <?php echo htmlspecialchars($settings['primary_color'] ?? '#3b82f6'); ?>, <?php echo htmlspecialchars($settings['primary_color'] ?? '#3b82f6'); ?>); opacity: 1 !important; visibility: visible !important; display: inline-flex !important;">
      <span class="material-symbols-outlined text-xl mr-3 group-hover:scale-110 transition-transform duration-200">open_in_new</span>
      <span class="text-lg">Web Sitesini Ziyaret Et</span>
      <span class="ml-2 opacity-75 group-hover:opacity-100 transition-opacity duration-200">→</span>
    </a>
  <?php else: ?>
    <!-- Disabled/Placeholder Button -->
    <div class="group inline-flex items-center justify-center w-full px-6 py-4 bg-gradient-to-r from-gray-400 to-gray-500 text-white font-bold rounded-xl shadow-lg cursor-not-allowed opacity-75"
         style="opacity: 0.75 !important; visibility: visible !important; display: inline-flex !important;">
      <span class="material-symbols-outlined text-xl mr-3">link_off</span>
      <span class="text-lg">Web Sitesi URL'si Mevcut Değil</span>
    </div>
    <p class="text-sm text-gray-500 dark:text-gray-400 mt-3 text-center">
      <span class="material-symbols-outlined text-sm mr-1">info</span>
      Web sitesi URL'sini güncellemek için site sahibiyle iletişime geçin
    </p>
  <?php endif; ?>
  
</div>
</div>

<!-- Sidebar -->
<div class="space-y-6">
  <!-- Site Information -->
  <div class="bg-white dark:bg-gray-800 rounded-lg p-6 shadow border border-gray-200 dark:border-gray-700">
    <h3 class="text-lg font-semibold mb-4">Site Bilgileri</h3>
    <div class="space-y-3">
      <div>
        <span class="text-sm font-medium text-gray-600 dark:text-gray-400">Kategori:</span>
        <p class="text-sm"><?php safeEcho($category); ?></p>
      </div>
      <?php if (!empty($site['short_description'])): ?>
      <div>
        <span class="text-sm font-medium text-gray-600 dark:text-gray-400">Kısa Açıklama:</span>
        <p class="text-sm"><?php safeEcho($site['short_description']); ?></p>
      </div>
      <?php endif; ?>
      <?php if (!empty($site['created_at'])): ?>
      <div>
        <span class="text-sm font-medium text-gray-600 dark:text-gray-400">Eklenme Tarihi:</span>
        <p class="text-sm"><?php echo date('F j, Y', strtotime($site['created_at'])); ?></p>
      </div>
      <?php endif; ?>
      <?php if (!empty($site['updated_at']) && $site['updated_at'] != $site['created_at']): ?>
      <div>
        <span class="text-sm font-medium text-gray-600 dark:text-gray-400">Son güncelleme:</span>
        <p class="text-sm"><?php echo date('F j, Y', strtotime($site['updated_at'])); ?></p>
      </div>
      <?php endif; ?>
    </div>
  </div>

  <!-- User Information -->
  <?php if (!empty($site['user_id']) && $site['user_id'] > 0): ?>
  <?php
    // Kullanıcı bilgilerini çek
    $userStmt = $pdo->prepare('SELECT username, kayit_tarihi FROM user WHERE id = ?');
    $userStmt->execute([$site['user_id']]);
    $user = $userStmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user):
  ?>
  <div class="bg-white dark:bg-gray-800 rounded-lg p-6 shadow border border-gray-200 dark:border-gray-700">
    <h3 class="text-lg font-semibold mb-4">Gönderen</h3>
    <div class="flex items-center gap-3">
      <div class="w-10 h-10 bg-primary-light dark:bg-primary-dark rounded-full flex items-center justify-center">
        <span class="material-symbols-outlined text-white text-sm">person</span>
      </div>
      <div>
        <p class="font-medium"><?php echo htmlspecialchars($user['username']); ?></p>
        <?php if (!empty($user['created_at'])): ?>
        <p class="text-sm text-gray-600 dark:text-gray-400">Üye olma tarihi <?php echo date('M Y', strtotime($user['created_at'])); ?></p>
        <?php endif; ?>
      </div>
    </div>
  </div>
  <?php endif; ?>
  <?php endif; ?>
  
  <!-- Related Sites -->
  <?php
    // Aynı kategorideki diğer siteler
    $relatedStmt = $pdo->prepare('
      SELECT s.*, c.name as category_name,
        COALESCE(s.view_count, 0) as view_count,
        COALESCE(
          (SELECT SUM(CASE WHEN sv.vote_type = "upvote" THEN 1 ELSE 0 END) 
           FROM site_votes sv WHERE sv.site_id = s.id), 0
        ) as upvotes
      FROM site_submissions s 
      LEFT JOIN categories c ON s.category_id = c.id
      WHERE s.category_id = ? AND s.id != ? AND s.status = "approved"
      ORDER BY upvotes DESC, s.view_count DESC
      LIMIT 5
    ');
    $relatedStmt->execute([$site['category_id'], $site_id]);
    $relatedSites = $relatedStmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (!empty($relatedSites)):
  ?>
  <div class="bg-white dark:bg-gray-800 rounded-lg p-6 shadow border border-gray-200 dark:border-gray-700">
    <h3 class="text-lg font-semibold mb-4">İlgili Siteler</h3>
    <div class="space-y-3">
      <?php foreach ($relatedSites as $related): ?>
      <div class="flex items-center gap-3 p-3 rounded-lg border border-gray-100 dark:border-gray-700 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
        <div class="w-8 h-8 flex items-center justify-center bg-gray-100 dark:bg-gray-600 rounded">
          <?php 
            $related_logo = '/uploads/no-logo.png'; // Default fallback
            
            if (!empty($related['logo_url'])) {
                if (filter_var($related['logo_url'], FILTER_VALIDATE_URL)) {
                    $related_logo = $related['logo_url'];
                } else {
                    $logo_path = ltrim($related['logo_url'], '/');
                    if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
                        $related_logo = '/' . $logo_path;
                    }
                }
            } elseif (!empty($related['site_logo'])) {
                $logo_path = $related['site_logo'];
                if (filter_var($logo_path, FILTER_VALIDATE_URL)) {
                    $related_logo = $logo_path;
                } else {
                    $logo_path = str_replace(['https://usasportstvs.com/uploads/', 'https://usasportstvs.com/', 'admin/uploads/', '/admin/uploads/', 'uploads/', '/uploads/'], '', $logo_path);
                    if (!empty(trim($logo_path)) && trim($logo_path) !== '/' && trim($logo_path) !== 'uploads/') {
                        $related_logo = '/uploads/' . trim($logo_path);
                    }
                }
            } elseif (!empty($related['favicon_url'])) {
                if (filter_var($related['favicon_url'], FILTER_VALIDATE_URL)) {
                    $related_logo = $related['favicon_url'];
                } else {
                    $related_logo = '/' . ltrim($related['favicon_url'], '/');
                }
            }
          ?>
          <img src="<?php echo htmlspecialchars($related_logo); ?>" alt="<?php echo htmlspecialchars($related['site_name']); ?>" 
               class="w-6 h-6 object-contain" onerror="this.src='/uploads/no-logo.png'; this.onerror=null;" />
        </div>
        <div class="flex-grow min-w-0">
          <a href="<?php echo URLHelper::getSiteURL($related['site_name']); ?>" 
             class="block font-medium text-sm hover:text-primary-light dark:hover:text-primary-dark transition-colors truncate">
            <?php echo htmlspecialchars($related['site_name']); ?>
          </a>
          <div class="flex items-center gap-2 mt-1">
            <span class="text-xs text-gray-600 dark:text-gray-400">
              <?php echo $related['upvotes']; ?> oy
            </span>
            <span class="text-xs text-gray-600 dark:text-gray-400">•</span>
            <span class="text-xs text-gray-600 dark:text-gray-400">
              <?php echo number_format($related['view_count']); ?> görüntüleme
            </span>
          </div>
        </div>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
  <?php endif; ?>
</div>
</div>

<?php else: ?>
<!-- Site not found -->
<div class="text-center py-12">
  <span class="material-symbols-outlined text-6xl text-gray-400 dark:text-gray-600 mb-4 block">search_off</span>
  <h1 class="text-2xl font-bold mb-2">Site Bulunamadı</h1>
  <p class="text-gray-600 dark:text-gray-400 mb-6">Aradığınız site mevcut değil veya kaldırılmış.</p>
  <a href="/" class="inline-flex items-center px-6 py-3 bg-primary-light dark:bg-primary-dark text-white font-semibold rounded-lg hover:bg-blue-600 dark:hover:bg-blue-500 transition-colors">
    <span class="material-symbols-outlined mr-2">home</span>
    Ana Sayfaya Dön
  </a>
</div>
<?php endif; ?>

</div>
</main>
<?php include '../includes/footer.php'; ?>
</div>

<script>
// Voting functionality
document.addEventListener('DOMContentLoaded', function() {
    const siteId = <?php echo json_encode($site_id); ?>;
    const upvoteBtn = document.getElementById('upvote-btn');
    const downvoteBtn = document.getElementById('downvote-btn');
    const voteMessage = document.getElementById('vote-message');
    
    function updateVoteDisplay(data) {
        document.querySelector('.upvote-count').textContent = data.upvotes;
        document.querySelector('.downvote-count').textContent = data.downvotes;
        document.getElementById('total-votes').textContent = data.total_votes;
        
        // Update rating
        const rating = data.total_votes > 0 ? ((data.upvotes / data.total_votes) * 5).toFixed(1) : '0.0';
        document.querySelector('.text-base.font-bold').textContent = rating + ' / 5';
        document.querySelector('.text-sm.font-bold').textContent = '(' + data.total_votes + ' votes)';
    }
    
    function showMessage(message, type) {
        voteMessage.className = `text-center py-2 rounded-lg ${type === 'success' ? 'bg-green-100 text-green-800 dark:bg-green-900 dark:text-green-200' : 'bg-red-100 text-red-800 dark:bg-red-900 dark:text-red-200'}`;
        voteMessage.textContent = message;
        voteMessage.classList.remove('hidden');
        
        setTimeout(() => {
            voteMessage.classList.add('hidden');
        }, 3000);
    }
    
    function handleVote(voteType) {
        fetch('/vote_site.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                site_id: siteId,
                vote_type: voteType
            })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                updateVoteDisplay(data);
                showMessage(data.message || 'Oy başarıyla kaydedildi!', 'success');
            } else {
                // Login required durumunda özel mesaj göster
                if (data.login_required) {
                    showMessage(data.error || 'Giriş yapmadan oy veremezsiniz.', 'error');
                } else {
                    showMessage(data.error || data.message || 'Oy kaydedilemedi.', 'error');
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showMessage('Oy verirken bir hata oluştu.', 'error');
        });
    }
    
    upvoteBtn?.addEventListener('click', () => handleVote('upvote'));
    downvoteBtn?.addEventListener('click', () => handleVote('downvote'));
});
</script>

<?php
// Content bottom reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
}
?>

</body>
</html>