<?php
require_once '../includes/config.php';
require_once '../utils/seo_title_helper.php';
require_once '../includes/ban_check.php';
require_once '../utils/recaptcha_helper.php';
require_once '../utils/ads_helper.php';
require_once '../utils/csrf_helper.php';
require_once '../utils/session_helper.php';

// Settings'i yükle
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$link_rel_type = $settings['link_rel_type'] ?? 'nofollow';

// SEO Title oluştur
$page_title = generatePageTitle('Submit Site', $settings);

// Sayfa tipini tespit et
$current_page_type = detectPageType();
?>
<!DOCTYPE html>
<html lang="tr" class="h-full">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="Web sitenizi dizinimize gönderin. Sitenizi ücretsiz ekleyin ve daha fazla görünürlük elde edin.">
    <?php
    // Favicon
    $favicon_url = $settings['favicon_url'] ?? '';
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
            $favicon_url = '/' . ltrim($favicon_url, '/');
        }
        echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    }
    ?>
    <link href="https://fonts.googleapis.com" rel="preconnect"/>
    <link crossorigin="" href="https://fonts.gstatic.com" rel="preconnect"/>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;700;800&display=swap" rel="stylesheet"/>
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com?plugins=forms"></script>
    <!-- Quill CSS & JS -->
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">
    <script src="https://cdn.quilljs.com/1.3.6/quill.min.js"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#13a4ec",
                        "background-light": "#f6f7f8",
                        "background-dark": "#101c22",
                        "foreground-light": "#0d171b",
                        "foreground-dark": "#f6f7f8",
                        "card-light": "#ffffff",
                        "card-dark": "#192730",
                        "subtle-light": "#e7eff3",
                        "subtle-dark": "#2a3b47",
                        "border-light": "#cfdfe7",
                        "border-dark": "#2a3b47",
                        "muted-light": "#6b7280",
                        "muted-dark": "#9ca3af"
                    },
                    fontFamily: {
                        "display": ["Plus Jakarta Sans", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.75rem",
                        "lg": "1rem",
                        "xl": "1.5rem",
                        "full": "9999px"
                    },
                },
            },
        }
    </script>
    <style>
        .material-symbols-outlined {
            font-variation-settings: 'FILL' 0, 'wght' 400, 'GRAD' 0, 'opsz' 24;
        }
        .gradient-text {
            background: linear-gradient(to right, #38BDF8, #A78BFA);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
<?php
$site_description = '';
$stmt = $pdo->prepare("SELECT setting_key, setting_value FROM settings WHERE setting_key IN ('site_title','site_description')");
$stmt->execute();
while ($row = $stmt->fetch()) {
    if ($row['setting_key'] === 'site_title') $site_title = $row['setting_value'];
    if ($row['setting_key'] === 'site_description') $site_description = $row['setting_value'];
}
?>
<title><?php echo htmlspecialchars($site_title . ' | Site Gönder'); ?></title>
<?php
$meta_submitsite = '';
$stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'meta_submitsite'");
$stmt->execute();
$meta_submitsite = $stmt->fetchColumn();
?>
<meta name="description" content="<?php echo htmlspecialchars($meta_submitsite ?: $site_description); ?>" />
<?php
$site_keywords = '';
$stmt = $pdo->prepare("SELECT setting_value FROM settings WHERE setting_key = 'site_keywords'");
$stmt->execute();
$site_keywords = $stmt->fetchColumn();
?>
<meta name="keywords" content="<?php echo htmlspecialchars($site_keywords); ?>" />

<?php echo getRecaptchaStyles(); ?>
<?php echo getRecaptchaValidationJS(); ?>
</head>
<body class="h-full bg-background-light dark:bg-background-dark text-foreground-light dark:text-foreground-dark font-display <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">
    <div class="min-h-full">
        <?php
        if (session_status() === PHP_SESSION_NONE) {
            session_start();
        }
        if (!isset($_SESSION['username']) || empty($_SESSION['username'])) {
            header('Location: login.php');
            exit;
        }
        if (!isset($error)) $error = '';
        $success = '';
        $site_name = $site_url = $short_desc = $long_desc = $category = $contact_email = '';
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            // CSRF token kontrolü
            checkCSRFToken();
            
            // reCAPTCHA doğrulaması
            if (!verifyRecaptcha()) {
                $error = getRecaptchaError();
            } else {
                // Ban kontrolü
                $user_id = $_SESSION['user_id'] ?? null;
                $user_ip = getUserIP();
                $ban_status = checkBanStatus($pdo, $user_id, $user_ip);
                
                if ($ban_status['is_banned']) {
                    $error = $ban_status['message'];
                } else {
            // Helper function to count words
            function word_count($str) {
                return str_word_count(trim($str));
            }
    $site_name = trim($_POST['site-name'] ?? '');
    $site_url = trim($_POST['site-url'] ?? '');
    $short_desc = trim($_POST['short-description'] ?? '');
    $long_desc = trim($_POST['long-description'] ?? '');
    $category = $_POST['category'] ?? '';
    $contact_email = trim($_POST['contact-email'] ?? '');
    $has_error = false;
    
    // Boş alan kontrolü - HTML tag'leri temizlenmiş içerik kontrolü
    $long_desc_clean = strip_tags($long_desc);
    $long_desc_clean = trim($long_desc_clean);
    
    if (!$site_name || !$site_url || !$short_desc || !$long_desc_clean || !$category || !$contact_email) {
        $error = 'Lütfen tüm alanları doldurun.';
        $has_error = true;
    }
    if (word_count($site_name) > 20) {
        $error = 'Site adı en fazla 20 kelime olabilir.';
        $has_error = true;
    }
  if (word_count($short_desc) > 40) {
    $error = 'Kısa açıklama en fazla 40 kelime içerebilir.';
    $has_error = true;
  }
  if (word_count(strip_tags($long_desc)) > 500) {
    $error = 'Uzun açıklama en fazla 500 kelime içerebilir.';
    $has_error = true;
  }
    $site_logo_url = '';
  if (isset($_FILES['file-upload']) && $_FILES['file-upload']['error'] === UPLOAD_ERR_OK) {
    // Dosya boyutu kontrolü (1MB)
    if ($_FILES['file-upload']['size'] > 1024 * 1024) {
      $error = 'Yüklenen dosya en fazla 1MB olabilir.';
      $has_error = true;
    } else {
      // Dosya türü kontrolü
      $ext = strtolower(pathinfo($_FILES['file-upload']['name'], PATHINFO_EXTENSION));
      $allowed = ['jpg','jpeg','png','gif','webp'];
      
      // MIME type kontrolü
      $finfo = finfo_open(FILEINFO_MIME_TYPE);
      $mime_type = finfo_file($finfo, $_FILES['file-upload']['tmp_name']);
      finfo_close($finfo);
      
      $allowed_mimes = [
        'image/jpeg',
        'image/jpg', 
        'image/png',
        'image/gif',
        'image/webp'
      ];
      
      if (!in_array($ext, $allowed) || !in_array($mime_type, $allowed_mimes)) {
        $error = 'Sadece PNG, JPG, GIF, WebP dosyaları yüklenebilir.';
        $has_error = true;
      } else {
        // Güvenli dosya adı oluştur
        $upload_dir = __DIR__ . '/../uploads/';
        if (!is_dir($upload_dir)) {
          mkdir($upload_dir, 0755, true);
        }
        
        // Dosya adını güvenli hale getir
        $filename = uniqid('site_logo_', true) . '.' . $ext;
        $target = $upload_dir . $filename;
        
        // Dosya yükleme
        if (move_uploaded_file($_FILES['file-upload']['tmp_name'], $target)) {
          // Dosya izinlerini güvenli hale getir
          chmod($target, 0644);
          
          // Dosya varlığını kontrol et
          if (file_exists($target)) {
            $site_logo_url = 'uploads/' . $filename;
          } else {
            $error = 'Dosya sunucuya kaydedilemedi.';
            $has_error = true;
          }
        } else {
          $error = 'Dosya yüklenemedi.';
          $has_error = true;
        }
      }
    }
  }
  // Eğer logo yüklenmediyse veya boşsa default logo ata
  if (empty($site_logo_url)) {
    $site_logo_url = 'uploads/no-logo.png';
  }
    // Check for duplicate site URL (case-insensitive, ignore protocol)
    if (!$has_error) {
        $normalized_url = preg_replace('/^https?:\/\//i', '', strtolower(trim($site_url)));
        $stmt = $pdo->prepare('SELECT COUNT(*) FROM site_submissions WHERE LOWER(REPLACE(site_url, "http://", "")) = ? OR LOWER(REPLACE(site_url, "https://", "")) = ?');
        $stmt->execute([$normalized_url, $normalized_url]);
        if ($stmt->fetchColumn() > 0) {
            $error = 'Bu site zaten kayıtlı.';
            $has_error = true;
        }
    }
    if (!$has_error) {
    // Kullanıcı oturumundan user_id al
    if (session_status() === PHP_SESSION_NONE) {
      session_start();
    }
    $user_id = isset($_SESSION['user_id']) ? intval($_SESSION['user_id']) : null;
    $username = isset($_SESSION['username']) ? $_SESSION['username'] : '';
    
    // Maksimum site kontrolü
    $max_sites = intval($settings['max_sites_per_user'] ?? 10);
    $stmt = $pdo->prepare('SELECT COUNT(*) FROM site_submissions WHERE user_id = ?');
    $stmt->execute([$user_id]);
    $user_site_count = $stmt->fetchColumn();
    
    if ($user_site_count >= $max_sites) {
        $error = "Maksimum $max_sites site ekleyebilirsiniz. Mevcut site sayınız: $user_site_count";
        $has_error = true;
    }
    
    if (!$has_error) {
        require_once '../utils/url_helper.php';
        $slug = URLHelper::createSlug($site_name);
        // logo_url: use $site_logo_url (relative path)
        $logo_url = $site_logo_url;
        
        // Site onayı gerekli mi kontrol et
        $status = ($settings['require_approval'] ?? '1') === '1' ? 'pending' : 'approved';
        
        $stmt = $pdo->prepare('INSERT INTO site_submissions (site_name, site_url, category_id, short_description, long_description, contact_mail, site_logo, logo_url, slug, ip, status, user_id, username) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
        $stmt->execute([
          $site_name,
          $site_url,
          $category,
          $short_desc,
          $long_desc,
          $contact_email,
          $site_logo_url,
          $logo_url,
          $slug,
          $ip,
          $status,
          $user_id,
          $username
        ]);
        $error = '';
        if ($status === 'approved') {
            $success = 'Site başarıyla eklendi ve yayınlandı.';
        } else {
            $success = 'Site başarıyla gönderildi, onay bekliyor.';
        }
        echo '<script>setTimeout(function(){ window.location.href = "index.php"; }, 2000);</script>';
    }
    }
    } // Ban kontrolü kapanışı
    } // reCAPTCHA kontrolü kapanışı
}
?>
        
        <?php include '../includes/header.php'; ?>
        
        <main class="flex flex-1 justify-center py-10 px-4 sm:px-6 lg:px-8">
            <?php
            // Content top reklamları
            if (($settings['ads_enabled'] ?? '1') === '1') {
                echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
            }
            ?>
            
            <div class="w-full max-w-2xl space-y-8">
                <div>
                    <h1 class="text-3xl font-extrabold text-foreground-light dark:text-foreground-dark text-center">Site Gönder</h1>
                    <p class="mt-2 text-center text-sm text-muted-light dark:text-muted-dark">Yeni bir web sitesi ekleyerek dizinimizin büyümesine yardımcı olun.</p>
                    <?php if ($error): ?>
                        <div class="mt-4 text-center text-sm font-bold bg-red-100 dark:bg-red-900/20 border border-red-200 dark:border-red-800 text-red-800 dark:text-red-300 py-3 px-4 rounded-lg shadow flex items-center justify-center gap-2">
                            <span class="material-symbols-outlined" style="font-size:20px;">error</span>
                            <?php echo htmlspecialchars($error); ?>
</div>
<?php endif; ?>
<?php if ($success): ?>
<div class="mt-4 text-center text-sm bg-green-100 dark:bg-green-900/20 border border-green-200 dark:border-green-800 text-green-800 dark:text-green-300 py-3 px-4 rounded-lg shadow">
<?php echo htmlspecialchars($success); ?>
</div>
<?php endif; ?>
</div>
<form class="mt-8 space-y-6 bg-white dark:bg-background-dark p-8 rounded-lg shadow-md" method="POST" enctype="multipart/form-data" <?php echo addRecaptchaAttribute(); ?>>
<?php echo csrfTokenField(); ?>
<div class="grid grid-cols-1 gap-y-6 gap-x-4 sm:grid-cols-2">
<div class="sm:col-span-2">
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300" for="site-name">Site Adı</label>
<div class="mt-1">
<input class="block w-full rounded border-gray-300 dark:border-gray-600 bg-background-light dark:bg-gray-800 text-gray-900 dark:text-white placeholder-gray-400 dark:placeholder-gray-500 focus:ring-primary focus:border-primary" id="site-name" name="site-name" placeholder="örn., Harika Araçlar" type="text" value="<?php echo htmlspecialchars($site_name ?? ''); ?>"/>
</div>
<p class="mt-2 text-xs text-gray-500 dark:text-gray-400">Web sitesinin resmi adı.</p>
</div>
<div class="sm:col-span-2">
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300" for="site-url">URL</label>
<div class="mt-1">
<input class="block w-full rounded border-gray-300 dark:border-gray-600 bg-background-light dark:bg-gray-800 text-gray-900 dark:text-white placeholder-gray-400 dark:placeholder-gray-500 focus:ring-primary focus:border-primary" id="site-url" name="site-url" placeholder="https://example.com" type="url" value="<?php echo htmlspecialchars($site_url ?? ''); ?>"/>
</div>
<p class="mt-2 text-xs text-gray-500 dark:text-gray-400">Web sitesinin tam URL'si.</p>
</div>
<div class="sm:col-span-2">
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300" for="short-description">Kısa Açıklama (Maksimum 40 kelime)</label>
<div class="mt-1">
<textarea class="block w-full rounded border-gray-300 dark:border-gray-600 bg-background-light dark:bg-gray-800 text-gray-900 dark:text-white placeholder-gray-400 dark:placeholder-gray-500 focus:ring-primary focus:border-primary" id="short-description" name="short-description" placeholder="Kısa, tek cümlelik özet." rows="3"><?php echo htmlspecialchars($short_desc ?? ''); ?></textarea>
<div class="mt-2 text-sm">
  <span id="short-word-counter" class="text-gray-600 dark:text-gray-400">0 / 40 kelime</span>
</div>
</div>
</div>
<div class="sm:col-span-2">
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300" for="long-description">Uzun Açıklama (Maksimum 500 kelime)</label>
<div class="mt-1">
  <div id="quill-editor" style="height: 200px;" class="bg-white dark:bg-gray-800"></div>
  <textarea style="display:none;" id="long-description" name="long-description" rows="6"><?php echo htmlspecialchars($long_desc ?? ''); ?></textarea>
  <div class="mt-2 text-sm">
    <span id="word-counter" class="text-gray-600 dark:text-gray-400">0 / 500 kelime</span>
  </div>
</div>
</div>
<div class="sm:col-span-1">
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300" for="category">Kategori</label>
<select class="mt-1 block w-full rounded border-gray-300 dark:border-gray-600 bg-background-light dark:bg-gray-800 text-gray-900 dark:text-white focus:ring-primary focus:border-primary" id="category" name="category" required>
<option value="">Kategori seçin</option>
<?php
$stmt = $pdo->query('SELECT id, name FROM categories');
while ($cat = $stmt->fetch()) {
    $selected = (isset($category) && $category == $cat['id']) ? 'selected' : '';
    echo '<option value="' . $cat['id'] . '" ' . $selected . '>' . htmlspecialchars($cat['name']) . '</option>';
}
?>
</select>
</div>
<div class="sm:col-span-1">
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300" for="contact-email">İletişim E-postası</label>
<input class="mt-1 block w-full rounded border-gray-300 dark:border-gray-600 bg-background-light dark:bg-gray-800 text-gray-900 dark:text-white placeholder-gray-400 dark:placeholder-gray-500 focus:ring-primary focus:border-primary" id="contact-email" name="contact-email" placeholder="ornek@email.com" type="email" value="<?php echo htmlspecialchars($contact_email ?? ''); ?>"/>
</div>
<div class="sm:col-span-2">
<label class="block text-sm font-medium text-gray-700 dark:text-gray-300" for="file-upload">Site Logosu</label>
<div class="mt-2 flex justify-center rounded-lg border-2 border-dashed border-gray-300 dark:border-gray-600 px-6 pt-5 pb-6 file-drop-area">
<div class="space-y-1 text-center">
<svg aria-hidden="true" class="mx-auto h-12 w-12 text-gray-400 dark:text-gray-500" fill="none" stroke="currentColor" viewBox="0 0 48 48">
<path d="M28 8H12a4 4 0 00-4 4v20m32-12v8m0 0v8a4 4 0 01-4 4H12a4 4 0 01-4-4v-4m32-4l-3.172-3.172a4 4 0 00-5.656 0L28 28M8 32l9.172-9.172a4 4 0 015.656 0L28 28" stroke-linecap="round" stroke-linejoin="round" stroke-width="2"></path>
</svg>
<div class="flex text-sm text-gray-600 dark:text-gray-400">
<label class="relative cursor-pointer rounded-md bg-white dark:bg-background-dark font-medium text-primary hover:text-primary/80 focus-within:outline-none focus-within:ring-2 focus-within:ring-offset-2 focus-within:ring-primary dark:ring-offset-background-dark" for="file-upload">
<span>Dosya yükle</span>
<input class="sr-only" id="file-upload" multiple name="file-upload" type="file" />
</label>
<p class="pl-1">veya sürükle bırak</p>
</div>
<p class="text-xs text-gray-500 dark:text-gray-500">PNG, JPG, GIF up to 1MB</p>
</div>
</div>
</div>
</div>

<!-- reCAPTCHA -->
<div class="flex justify-center">
<?php echo renderRecaptcha(); ?>
</div>

<div>
<button class="group relative flex w-full justify-center rounded-lg border border-transparent bg-primary py-3 px-4 text-sm font-bold text-white hover:bg-primary/90 focus:outline-none focus:ring-2 focus:ring-primary focus:ring-offset-2 dark:focus:ring-offset-background-dark" type="submit">
                  Siteyi Gönder
                </button>
</div>
</form>
<script>
  var quill = new Quill('#quill-editor', {
    theme: 'snow',
    placeholder: 'Sitenin amacı ve özelliklerinin daha detaylı açıklaması.',
    modules: {
      toolbar: [
        ['bold', 'italic', 'underline'],
        ['link'],
        [{ 'list': 'ordered'}, { 'list': 'bullet' }],
        ['clean']
      ]
    }
  });
  
  // Admin ayarından rel type'ı al
  var relType = '<?php echo $link_rel_type; ?>';
  
  // Link oluşturulduğunda rel attribute ekle
  quill.on('text-change', function(delta, oldDelta, source) {
    if (source === 'user') {
      var html = quill.root.innerHTML;
      
      // Tüm linkleri bul ve rel attribute ekle
      var tempDiv = document.createElement('div');
      tempDiv.innerHTML = html;
      var links = tempDiv.querySelectorAll('a');
      
      links.forEach(function(link) {
        if (!link.hasAttribute('rel') || link.getAttribute('rel') !== relType) {
          link.setAttribute('rel', relType);
          
          // External linkler için target="_blank" ekle
          var href = link.getAttribute('href');
          if (href && (href.startsWith('http://') || href.startsWith('https://'))) {
            if (!href.includes(window.location.hostname)) {
              link.setAttribute('target', '_blank');
              if (relType === 'nofollow') {
                link.setAttribute('rel', 'nofollow noopener noreferrer');
              }
            }
          }
        }
      });
      
      // Güncellenmiş HTML'i geri yükle
      if (tempDiv.innerHTML !== html) {
        quill.root.innerHTML = tempDiv.innerHTML;
      }
    }
  });
  
  // Kelime sayacı fonksiyonu
  function updateWordCounter() {
    // HTML içeriğini al ve tag'leri temizle
    var htmlContent = quill.root.innerHTML;
    var tempDiv = document.createElement('div');
    tempDiv.innerHTML = htmlContent;
    var plainText = tempDiv.textContent || tempDiv.innerText || '';
    plainText = plainText.trim();
    
    // PHP str_word_count benzeri algoritma
    var wordCount = 0;
    if (plainText) {
      // Noktalama işaretlerini kaldır ve sadece harfleri ve sayıları bırak
      var words = plainText.match(/\b[\w]+\b/g);
      wordCount = words ? words.length : 0;
    }
    
    var counter = document.getElementById('word-counter');
    
    if (wordCount > 500) {
      counter.innerHTML = '<span class="text-red-600 dark:text-red-400 font-medium">' + wordCount + ' / 500 kelime (Limit aşıldı!)</span>';
    } else if (wordCount > 450) {
      counter.innerHTML = '<span class="text-yellow-600 dark:text-yellow-400">' + wordCount + ' / 500 kelime</span>';
    } else {
      counter.innerHTML = '<span class="text-gray-600 dark:text-gray-400">' + wordCount + ' / 500 kelime</span>';
    }
  }
  
  // Short Description kelime sayacı fonksiyonu
  function updateShortWordCounter() {
    var shortTextarea = document.getElementById('short-description');
    var plainText = shortTextarea.value.trim();
    
    // PHP str_word_count benzeri algoritma
    var wordCount = 0;
    if (plainText) {
      // Noktalama işaretlerini kaldır ve sadece harfleri ve sayıları bırak
      var words = plainText.match(/\b[\w]+\b/g);
      wordCount = words ? words.length : 0;
    }
    
    var counter = document.getElementById('short-word-counter');
    
    if (wordCount > 40) {
      counter.innerHTML = '<span class="text-red-600 dark:text-red-400 font-medium">' + wordCount + ' / 40 kelime (Limit aşıldı!)</span>';
    } else if (wordCount > 35) {
      counter.innerHTML = '<span class="text-yellow-600 dark:text-yellow-400">' + wordCount + ' / 40 kelime</span>';
    } else {
      counter.innerHTML = '<span class="text-gray-600 dark:text-gray-400">' + wordCount + ' / 40 kelime</span>';
    }
  }
  
  // Quill editör değişikliklerini dinle
  quill.on('text-change', function() {
    updateWordCounter();
  });
  
  // Short Description textarea değişikliklerini dinle
  var shortTextarea = document.getElementById('short-description');
  shortTextarea.addEventListener('input', function() {
    updateShortWordCounter();
  });
  
  // Sunulan eski veriyi Quill'e yükle
  var oldDesc = document.getElementById('long-description').value;
  if (oldDesc) {
    quill.root.innerHTML = oldDesc;
    updateWordCounter(); // İlk yüklemede kelime sayısını güncelle
  }
  
  // İlk yüklemede short description kelime sayısını güncelle
  updateShortWordCounter();
  
  // Quill içeriğini sürekli textarea'ya aktar
  function updateTextarea() {
    var html = quill.root.innerHTML;
    // Link rel ayarı
    var relType = '<?php echo $link_rel_type; ?>';
    html = html.replace(/<a\s+([^>]*?)>/gi, function(match, attrs) {
      // rel varsa güncelle, yoksa ekle
      if (/rel\s*=\s*['\"](.*?)['\"]/.test(attrs)) {
        return '<a ' + attrs.replace(/rel\s*=\s*['\"](.*?)['\"]/, 'rel="'+relType+'"') + '>';
      } else {
        return '<a ' + attrs + ' rel="'+relType+'">';
      }
    });
    document.getElementById('long-description').value = html;
  }
  
  // Quill değişikliklerini dinle ve textarea'yı güncelle
  quill.on('text-change', function() {
    updateTextarea();
  });
  
  // Form submit kontrolü
  var form = document.querySelector('form');
  form.addEventListener('submit', function(e) {
    // Son kez textarea'yı güncelle
    updateTextarea();
    
    // Short Description kelime kontrolü
    var shortTextarea = document.getElementById('short-description');
    var shortPlainText = shortTextarea.value.trim();
    var shortWordCount = 0;
    if (shortPlainText) {
      var shortWords = shortPlainText.match(/\b[\w]+\b/g);
      shortWordCount = shortWords ? shortWords.length : 0;
    }
    
    if (shortWordCount > 40) {
      alert('Kısa Açıklama alanı en fazla 40 kelime içerebilir. Mevcut: ' + shortWordCount + ' kelime');
      e.preventDefault();
      return false;
    }
    
    // Kelime sayısı kontrolü
    var htmlContent = quill.root.innerHTML;
    var tempDiv = document.createElement('div');
    tempDiv.innerHTML = htmlContent;
    var plainText = tempDiv.textContent || tempDiv.innerText || '';
    plainText = plainText.trim();
    
    var wordCount = 0;
    if (plainText) {
      var words = plainText.match(/\b[\w]+\b/g);
      wordCount = words ? words.length : 0;
    }
    
    if (wordCount > 500) {
      alert('Uzun Açıklama alanı en fazla 500 kelime içerebilir. Mevcut: ' + wordCount + ' kelime');
      e.preventDefault();
      return false;
    }
  });
</script>
</div>
</main>
</div>
<?php include '../includes/footer.php'; ?>
</div>
<script>
// Drag and drop for file upload
const dropArea = document.querySelector('.file-drop-area');
const fileInput = document.getElementById('file-upload');
const previewImg = document.createElement('img');
previewImg.style.maxWidth = '200px';
previewImg.style.marginTop = '16px';
previewImg.style.display = 'none';
if (dropArea) dropArea.appendChild(previewImg);
function showPreview(file) {
  if (file && file.type.startsWith('image/')) {
    const reader = new FileReader();
    reader.onload = function(e) {
      previewImg.src = e.target.result;
      previewImg.style.display = 'block';
    };
    reader.readAsDataURL(file);
  } else {
    previewImg.style.display = 'none';
  }
}
if (fileInput) {
  fileInput.addEventListener('change', function(e) {
    showPreview(fileInput.files[0]);
  });
}
if (dropArea) {
  dropArea.addEventListener('dragover', function(e) {
    e.preventDefault();
    dropArea.classList.add('bg-primary/10');
  });
  dropArea.addEventListener('dragleave', function(e) {
    dropArea.classList.remove('bg-primary/10');
  });
  dropArea.addEventListener('drop', function(e) {
    e.preventDefault();
    dropArea.classList.remove('bg-primary/10');
    if (e.dataTransfer.files.length) {
      fileInput.files = e.dataTransfer.files;
      showPreview(e.dataTransfer.files[0]);
    }
  });
}
</script>

<?php
// Content bottom reklamları
if (($settings['ads_enabled'] ?? '1') === '1') {
    echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
}
?>

</body></html>