<!DOCTYPE html>
<html lang="tr" class="h-full">
<head>
<?php
// Türkçe karakter desteği için encoding ayarı
if (!headers_sent()) {
    header('Content-Type: text/html; charset=utf-8');
}
mb_internal_encoding('UTF-8');

require_once '../includes/config.php';
require_once '../utils/url_helper.php';
require_once '../utils/seo_title_helper.php';
require_once '../utils/view_count_helper.php';
require_once '../utils/ads_helper.php';
require_once '../includes/turkish_fix.php';

// Site settings'lerini al
$settings = [];
$stmt = $pdo->query('SELECT setting_key, setting_value FROM settings');
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

$site_title_base = $settings['site_title'] ?? 'Web Dizini';

// SEO Title oluştur
$page_title = generatePageTitle('En Çok Oylananlar', $settings);

// Sayfa tipini tespit et
$current_page_type = detectPageType();

// Top voted sayfası için meta bilgileri
$page_meta = [
    'title' => $page_title,
    'description' => 'Dizinimizdeki en popüler ve yüksek puanlı web sitelerini keşfedin. Tüm kategorilerde en çok oy alan siteleri göz atın.',
    'url' => 'topvoted.php',
    'type' => 'website'
];

// Pagination ve sorting parametreleri
$perPage = isset($settings['topvoted_page_count']) ? (int)$settings['topvoted_page_count'] : ($settings['site_count'] ?? 12);
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$offset = ($page - 1) * $perPage;
$sort = isset($_GET['sort']) ? $_GET['sort'] : 'desc';
$selectedCat = isset($_GET['category']) ? intval($_GET['category']) : 0;

// Kategorileri çek
$categories = [];
$stmt = $pdo->query('SELECT id, name FROM categories ORDER BY name');
$categories = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Sites sorgusu
$orderVotes = ($sort == 'asc') ? 'ASC' : 'DESC';

if ($selectedCat > 0) {
    // Belirli kategori
    $stmt = $pdo->prepare('
        SELECT s.id, s.site_name, s.site_logo, s.short_description, s.long_description, s.site_url, s.category_id, c.name as category_name,
            COALESCE(s.view_count, 0) as view_count,
            (SELECT COUNT(*) FROM site_votes v WHERE v.site_id = s.id AND v.vote_type = "upvote") AS upvotes,
            (SELECT COUNT(*) FROM site_votes v WHERE v.site_id = s.id AND v.vote_type = "downvote") AS downvotes,
            (SELECT COUNT(*) FROM site_votes v WHERE v.site_id = s.id) AS total_votes
        FROM site_submissions s
        LEFT JOIN categories c ON s.category_id = c.id
        WHERE s.status = "approved" AND s.category_id = :catid
        ORDER BY upvotes ' . $orderVotes . ', s.id DESC
        LIMIT :limit OFFSET :offset
    ');
    $stmt->bindValue(':catid', $selectedCat, PDO::PARAM_INT);
    $stmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $sites = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Total count
    $countStmt = $pdo->prepare('SELECT COUNT(*) FROM site_submissions WHERE status = "approved" AND category_id = :catid');
    $countStmt->bindValue(':catid', $selectedCat, PDO::PARAM_INT);
    $countStmt->execute();
    $totalSites = $countStmt->fetchColumn();
} else {
    // Tüm kategoriler
    $stmt = $pdo->prepare('
        SELECT s.id, s.site_name, s.site_logo, s.short_description, s.long_description, s.site_url, s.category_id, c.name as category_name,
            COALESCE(s.view_count, 0) as view_count,
            (SELECT COUNT(*) FROM site_votes v WHERE v.site_id = s.id AND v.vote_type = "upvote") AS upvotes,
            (SELECT COUNT(*) FROM site_votes v WHERE v.site_id = s.id AND v.vote_type = "downvote") AS downvotes,
            (SELECT COUNT(*) FROM site_votes v WHERE v.site_id = s.id) AS total_votes
        FROM site_submissions s
        LEFT JOIN categories c ON s.category_id = c.id
        WHERE s.status = "approved"
        ORDER BY upvotes ' . $orderVotes . ', s.id DESC
        LIMIT :limit OFFSET :offset
    ');
    $stmt->bindValue(':limit', $perPage, PDO::PARAM_INT);
    $stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
    $stmt->execute();
    $sites = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Total count
    $countStmt = $pdo->prepare('SELECT COUNT(*) FROM site_submissions WHERE status = "approved"');
    $countStmt->execute();
    $totalSites = $countStmt->fetchColumn();
}

$totalPages = ceil($totalSites / $perPage);

// Rating hesaplama fonksiyonu
function calculateRating($upvotes, $downvotes, $total_votes) {
    if ($total_votes == 0) return 0;
    return round(($upvotes / $total_votes) * 5, 1);
}

// Star display fonksiyonu
function displayStars($rating) {
    $fullStars = floor($rating);
    $halfStar = ($rating - $fullStars) >= 0.5 ? 1 : 0;
    $emptyStars = 5 - $fullStars - $halfStar;
    
    $output = '';
    
    // Dolu yıldızlar
    for ($i = 0; $i < $fullStars; $i++) {
        $output .= '<span class="material-symbols-outlined text-yellow-500" style="font-size: 18px; font-variation-settings: \'FILL\' 1;">star</span>';
    }
    
    // Yarım yıldız
    if ($halfStar) {
        $output .= '<span class="material-symbols-outlined text-yellow-500" style="font-size: 18px; font-variation-settings: \'FILL\' 1;">star_half</span>';
    }
    
    // Boş yıldızlar
    for ($i = 0; $i < $emptyStars; $i++) {
        $output .= '<span class="material-symbols-outlined text-gray-300 dark:text-gray-600" style="font-size: 18px; font-variation-settings: \'FILL\' 0;">star</span>';
    }
    
    return $output;
}

// SEO Title oluştur
$page_title = generatePageTitle('Popüler', $settings);
?>
<meta charset="UTF-8">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title><?php echo htmlspecialchars($page_title); ?></title>
    <meta name="description" content="Dizinimizdeki en popüler ve yüksek puanlı web sitelerini keşfedin. Tüm kategorilerde en çok oy alan siteleri göz atın.">
    <?php
    // Favicon
    $favicon_url = $settings['favicon_url'] ?? '';
    if (!empty($favicon_url)) {
        if (!str_starts_with($favicon_url, 'http') && !str_starts_with($favicon_url, '//')) {
            $favicon_url = '/' . ltrim($favicon_url, '/');
        }
        echo '<link rel="icon" type="image/x-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="shortcut icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
        echo '<link rel="apple-touch-icon" href="' . htmlspecialchars($favicon_url) . '">' . "\n";
    }
    ?>
    <link href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Material+Symbols+Outlined:opsz,wght,FILL,GRAD@20..48,100..700,0..1,-50..200" rel="stylesheet">
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        tailwind.config = {
            darkMode: "class",
            theme: {
                extend: {
                    colors: {
                        "primary": "#13a4ec",
                        "background-light": "#f6f7f8",
                        "background-dark": "#101c22",
                        "foreground-light": "#0d171b",
                        "foreground-dark": "#f6f7f8",
                        "card-light": "#ffffff",
                        "card-dark": "#192730",
                        "subtle-light": "#e7eff3",
                        "subtle-dark": "#2a3b47",
                        "border-light": "#cfdfe7",
                        "border-dark": "#2a3b47",
                        "muted-light": "#6b7280",
                        "muted-dark": "#9ca3af"
                    },
                    fontFamily: {
                        "display": ["Plus Jakarta Sans", "sans-serif"]
                    },
                    borderRadius: {
                        "DEFAULT": "0.75rem",
                        "lg": "1rem", 
                        "xl": "1.5rem", 
                        "full": "9999px"
                    },
                },
            },
        }
    </script>
    <style>
        .material-symbols-outlined {
            font-variation-settings: 'FILL' 0, 'wght' 400, 'GRAD' 0, 'opsz' 24;
        }
        .gradient-text {
            background: linear-gradient(to right, #38BDF8, #A78BFA);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="h-full bg-background-light dark:bg-background-dark text-foreground-light dark:text-foreground-dark font-display <?php echo ($settings['theme'] ?? 'light') === 'dark' ? 'dark' : ''; ?>">
    <div class="min-h-full">
        <?php include '../includes/header.php'; ?>
        
        <main class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
            <!-- Header Section -->
            <div class="text-center mb-12">
                <h1 class="text-4xl sm:text-5xl font-bold text-foreground-light dark:text-foreground-dark mb-4">
                    <span class="gradient-text"><?php echo htmlspecialchars($settings['topvoted_title'] ?? 'En Çok Oy Alan Siteler'); ?></span>
                </h1>
                <p class="text-lg text-muted-light dark:text-muted-dark max-w-3xl mx-auto">
                    <?php echo htmlspecialchars($settings['topvoted_subtitle'] ?? 'Topluluk oylarına göre sıralanan dizinimizdeki en popüler ve yüksek puanlı web sitelerini keşfedin.'); ?>
                </p>
            </div>
            
            <?php
            // Content top reklamları
            if (($settings['ads_enabled'] ?? '1') === '1') {
                echo renderAdContainer($current_page_type, 'content_top', 'ad-content-top');
            }
            ?>
            
            <!-- Filters Section -->
            <div class="bg-card-light dark:bg-card-dark rounded-xl p-6 mb-8 border border-border-light dark:border-border-dark shadow-sm">
                <div class="flex flex-col sm:flex-row gap-4 items-center justify-between">
                    <!-- Category Filter -->
                    <div class="flex items-center gap-3">
                        <span class="text-sm font-medium text-foreground-light dark:text-foreground-dark">Kategori:</span>
                        <select onchange="window.location.href='?category=' + this.value + '&sort=<?php echo $sort; ?>'" 
                                class="appearance-none bg-background-light dark:bg-background-dark border border-border-light dark:border-border-dark rounded-lg px-4 py-2 text-sm font-medium text-foreground-light dark:text-foreground-dark focus:ring-2 focus:ring-primary focus:border-primary transition-colors">
                            <option value="0" <?php echo $selectedCat == 0 ? 'selected' : ''; ?>>Tüm Kategoriler</option>
                            <?php foreach ($categories as $cat): ?>
                                <option value="<?php echo $cat['id']; ?>" <?php echo $selectedCat == $cat['id'] ? 'selected' : ''; ?>>
                                    <?php echo htmlspecialchars($cat['name']); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <!-- Sort Filter -->
                    <div class="flex items-center gap-3">
                        <span class="text-sm font-medium text-foreground-light dark:text-foreground-dark">Sırala:</span>
                        <select onchange="window.location.href='?sort=' + this.value + '&category=<?php echo $selectedCat; ?>'" 
                                class="appearance-none bg-background-light dark:bg-background-dark border border-border-light dark:border-border-dark rounded-lg px-4 py-2 text-sm font-medium text-foreground-light dark:text-foreground-dark focus:ring-2 focus:ring-primary focus:border-primary transition-colors">
                            <option value="desc" <?php echo $sort == 'desc' ? 'selected' : ''; ?>>En Çok Oy Alan</option>
                            <option value="asc" <?php echo $sort == 'asc' ? 'selected' : ''; ?>>En Az Oy Alan</option>
                        </select>
                    </div>
                    
                    <!-- Results Count -->
                    <div class="text-sm text-muted-light dark:text-muted-dark">
                        <?php echo count($sites); ?> / <?php echo $totalSites; ?> site gösteriliyor
                    </div>
                </div>
            </div>
            
            <!-- Sites Grid -->
            <?php if (!empty($sites)): ?>
                <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-6 mb-12">
                    <?php foreach ($sites as $site): 
                        $upvotes = (int)$site['upvotes'];
                        $downvotes = (int)$site['downvotes'];
                        $total_votes = (int)$site['total_votes'];
                        $rating = calculateRating($upvotes, $downvotes, $total_votes);
                    ?>
                        <div class="bg-card-light dark:bg-card-dark border border-border-light dark:border-border-dark rounded-xl p-6 hover:shadow-lg transition-all duration-300 group h-auto md:h-[420px] flex flex-col">
                            <!-- Site Logo & Header -->
                            <div class="flex items-start gap-4 mb-4">
                                <?php 
                                // Logo kontrolü yaparak direkt çözüm
                                $has_logo = false;
                                $logo_src = '/uploads/no-logo.png'; // Varsayılan (absolute path)
                                
                                if (!empty($site['logo_url'])) {
                                    if (filter_var($site['logo_url'], FILTER_VALIDATE_URL)) {
                                        $logo_src = $site['logo_url'];
                                    } else {
                                        $logo_path = ltrim($site['logo_url'], '/');
                                        if (!empty(trim($logo_path)) && trim($logo_path) !== '/') {
                                            $logo_src = '/' . $logo_path;
                                        }
                                    }
                                    $has_logo = true;
                                } elseif (!empty($site['site_logo'])) {
                                    $logo_path = $site['site_logo'];
                                    
                                    // URL ise doğrudan kullan
                                    if (filter_var($logo_path, FILTER_VALIDATE_URL)) {
                                        $logo_src = $logo_path;
                                        $has_logo = true;
                                    } else {
                                        // Yerel dosya yolu işleme
                                        $logo_path = str_replace(['https://usasportstvs.com/uploads/', 'https://usasportstvs.com/', 'admin/uploads/', '/admin/uploads/', 'uploads/', '/uploads/'], '', $logo_path);
                                        
                                        // Boş değilse ve geçerliyse kullan
                                        if (!empty(trim($logo_path)) && trim($logo_path) !== '/' && trim($logo_path) !== 'uploads/') {
                                            $logo_src = '/uploads/' . trim($logo_path);
                                            $has_logo = true;
                                        }
                                    }
                                } elseif (!empty($site['favicon_url'])) {
                                    // Favicon'u logo olarak kullan
                                    if (filter_var($site['favicon_url'], FILTER_VALIDATE_URL)) {
                                        $logo_src = $site['favicon_url'];
                                    } else {
                                        $logo_src = '/' . ltrim($site['favicon_url'], '/');
                                    }
                                    $has_logo = true;
                                }
                                ?>
                                <?php if ($has_logo): ?>
                                <img src="<?php echo htmlspecialchars($logo_src); ?>" 
                                     alt="<?php echo htmlspecialchars($site['site_name']); ?>" 
                                     class="w-20 h-20 object-contain rounded-lg border-2 border-border-light dark:border-border-dark flex-shrink-0 bg-white p-1" 
                                     onerror="this.src='/uploads/no-logo.png'; this.onerror=null;" />
                                <?php else: ?>
                                <img src="/uploads/no-logo.png" 
                                     alt="<?php echo htmlspecialchars($site['site_name']); ?>" 
                                     class="w-20 h-20 object-contain rounded-lg border-2 border-border-light dark:border-border-dark flex-shrink-0 bg-white p-1" />
                                <?php endif; ?>
                                
                                <div class="flex-1 min-w-0">
                                    <h3 class="text-lg font-bold text-foreground-light dark:text-foreground-dark mb-2 leading-tight">
                                        <?php safeEcho($site['site_name']); ?>
                                    </h3>
                                    <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium bg-primary/10 text-primary">
                                        <?php safeEcho($site['category_name']); ?>
                                    </span>
                                </div>
                            </div>
                            
                            <!-- Description -->
                            <div class="flex-1 mb-4">
                                <p class="text-muted-light dark:text-muted-dark text-sm leading-relaxed overflow-hidden" style="display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical;">
                                    <?php 
                                    $description = $site['short_description'] ?: strip_tags($site['long_description']);
                                    echo htmlspecialchars(strlen($description) > 150 ? substr($description, 0, 150) . '...' : $description); 
                                    ?>
                                </p>
                            </div>
                            
                            <!-- Rating Section -->
                            <div class="flex items-center justify-between mb-4 p-3 bg-background-light dark:bg-background-dark rounded-lg mt-auto">
                                <div class="flex items-center gap-2">
                                    <div class="flex items-center">
                                        <?php echo displayStars($rating); ?>
                                    </div>
                                    <span class="text-sm font-semibold text-foreground-light dark:text-foreground-dark">
                                        <?php echo number_format($rating, 1); ?>
                                    </span>
                                </div>
                                
                                <div class="flex items-center gap-3 text-xs text-muted-light dark:text-muted-dark">
                                    <div class="flex items-center gap-1">
                                        <span class="text-green-600">👍</span>
                                        <span><?php echo $upvotes; ?></span>
                                    </div>
                                    <div class="flex items-center gap-1">
                                        <span class="text-red-600">👎</span>
                                        <span><?php echo $downvotes; ?></span>
                                    </div>
                                    <div class="flex items-center gap-1 text-blue-600 dark:text-blue-400">
                                        <span class="material-symbols-outlined text-sm">visibility</span>
                                        <span>Views: <?php echo number_format($site['view_count']); ?></span>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Action Button -->
                            <a href="<?php echo URLHelper::getSiteURL($site['site_name']); ?>" 
                               class="w-full inline-flex items-center justify-center gap-2 px-4 py-3 bg-primary text-white rounded-lg font-medium hover:bg-primary/90 transition-all duration-300 group-hover:scale-[1.02]">
                                <span>Detayları Gör</span>
                                <span class="material-symbols-outlined text-lg transform group-hover:translate-x-1 transition-transform">arrow_forward</span>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php else: ?>
                <!-- Empty State -->
                <div class="text-center py-16">
                    <div class="w-24 h-24 bg-subtle-light dark:bg-subtle-dark rounded-full flex items-center justify-center mx-auto mb-6">
                        <span class="material-symbols-outlined text-4xl text-muted-light dark:text-muted-dark">search_off</span>
                    </div>
                    <h3 class="text-xl font-semibold text-foreground-light dark:text-foreground-dark mb-2">Site bulunamadı</h3>
                    <p class="text-muted-light dark:text-muted-dark mb-6">Filtrelerinizi ayarlamayı deneyin veya tüm kategorileri göz atın.</p>
                    <a href="/topvoted" class="inline-flex items-center gap-2 px-6 py-3 bg-primary text-white rounded-lg font-medium hover:bg-primary/90 transition-colors">
                        <span class="material-symbols-outlined">refresh</span>
                        Tüm Siteleri Gör
                    </a>
                </div>
            <?php endif; ?>
            
            <!-- Pagination -->
            <?php if ($totalPages > 1): ?>
                <div class="flex justify-center mt-16">
                    <nav class="flex items-center gap-2">
                        <!-- Önceki Sayfa -->
                        <?php if ($page > 1): ?>
                            <a href="?page=<?php echo $page - 1; ?>&sort=<?php echo $sort; ?>&category=<?php echo $selectedCat; ?>" 
                               class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark">
                                <span class="material-symbols-outlined">chevron_left</span>
                            </a>
                        <?php endif; ?>
                        
                        <!-- Sayfa Numaraları -->
                        <?php
                        $start_page = max(1, $page - 2);
                        $end_page = min($totalPages, $page + 2);
                        
                        if ($start_page > 1): ?>
                            <a href="?page=1&sort=<?php echo $sort; ?>&category=<?php echo $selectedCat; ?>" 
                               class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark">1</a>
                            <?php if ($start_page > 2): ?>
                                <span class="px-2 text-muted-light dark:text-muted-dark">...</span>
                            <?php endif; ?>
                        <?php endif; ?>
                        
                        <?php for ($i = $start_page; $i <= $end_page; $i++): ?>
                            <?php if ($i == $page): ?>
                                <span class="flex items-center justify-center w-10 h-10 rounded-lg bg-primary text-white font-semibold">
                                    <?php echo $i; ?>
                                </span>
                            <?php else: ?>
                                <a href="?page=<?php echo $i; ?>&sort=<?php echo $sort; ?>&category=<?php echo $selectedCat; ?>" 
                                   class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark">
                                    <?php echo $i; ?>
                                </a>
                            <?php endif; ?>
                        <?php endfor; ?>
                        
                        <?php if ($end_page < $totalPages): ?>
                            <?php if ($end_page < $totalPages - 1): ?>
                                <span class="px-2 text-muted-light dark:text-muted-dark">...</span>
                            <?php endif; ?>
                            <a href="?page=<?php echo $totalPages; ?>&sort=<?php echo $sort; ?>&category=<?php echo $selectedCat; ?>" 
                               class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark"><?php echo $totalPages; ?></a>
                        <?php endif; ?>
                        
                        <!-- Sonraki Sayfa -->
                        <?php if ($page < $totalPages): ?>
                            <a href="?page=<?php echo $page + 1; ?>&sort=<?php echo $sort; ?>&category=<?php echo $selectedCat; ?>" 
                               class="flex items-center justify-center w-10 h-10 rounded-lg bg-white dark:bg-subtle-dark hover:bg-primary hover:text-white transition-colors border border-subtle-light dark:border-subtle-dark">
                                <span class="material-symbols-outlined">chevron_right</span>
                            </a>
                        <?php endif; ?>
                    </nav>
                </div>
                
                <!-- Sayfa Bilgisi -->
                <div class="text-center mt-6 text-sm text-muted-light dark:text-muted-dark">
                    Sayfa <?php echo $page; ?> / <?php echo $totalPages; ?> 
                    (Toplam <?php echo number_format($totalSites); ?> site)
                </div>
            <?php endif; ?>
            
            <?php
            // Content bottom reklamları
            if (($settings['ads_enabled'] ?? '1') === '1') {
                echo renderAdContainer($current_page_type, 'content_bottom', 'ad-content-bottom');
            }
            ?>
        </main>
        
        <?php include '../includes/footer.php'; ?>
    </div>
</body>
</html>