<?php
/**
 * SEO Title Helper
 * Generates SEO-friendly page titles with separator from settings
 */

if (!function_exists('generateSEOTitle')) {
    /**
     * SEO title oluşturur
     * @param string $pageTitle Sayfa başlığı
     * @param string $category Kategori adı (opsiyonel)
     * @param array $settings Settings array
     * @return string Formatted title
     */
    function generateSEOTitle($pageTitle = '', $category = '', $settings = []) {
        $site_title = $settings['site_title'] ?? 'Web Directory';
        $separator = ' ' . trim($settings['seo_title_separator'] ?? $settings['title_separator'] ?? '|') . ' ';
        
        $title_parts = [];
        
        // Sayfa başlığı varsa ekle
        if (!empty(trim($pageTitle))) {
            $title_parts[] = trim($pageTitle);
        }
        
        // Kategori varsa ekle
        if (!empty(trim($category))) {
            $title_parts[] = trim($category);
        }
        
        // Site adını her zaman en sona ekle
        $title_parts[] = $site_title;
        
        // Aynı değerleri kaldır (site adı tekrarını önle)
        $title_parts = array_unique($title_parts);
        
        return implode($separator, $title_parts);
    }
}

if (!function_exists('generateCategoryTitle')) {
    /**
     * Kategori sayfası için title oluşturur
     */
    function generateCategoryTitle($categoryName, $settings = []) {
        return generateSEOTitle($categoryName, '', $settings);
    }
}

if (!function_exists('generateSiteTitle')) {
    /**
     * Site detay sayfası için title oluşturur
     */
    function generateSiteTitle($siteName, $category = '', $settings = []) {
        return generateSEOTitle($siteName, $category, $settings);
    }
}

if (!function_exists('generatePageTitle')) {
    /**
     * Genel sayfa başlığı oluşturur
     */
    function generatePageTitle($pageName, $settings = []) {
        return generateSEOTitle($pageName, '', $settings);
    }
}
?>